/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.excel.util.StringUtils;
import com.tydic.fsc.bill.busi.api.FscDealCancelPaymentBusiService;
import com.tydic.fsc.bill.busi.bo.FscDealCancelPaymentBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscDealCancelPaymentBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscDealCancelPaymentBusiServiceImpl
implements FscDealCancelPaymentBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealCancelPaymentBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String BUSI_NAME = "\u53d6\u6d88\u4ed8\u6b3e";
    public static final String BUSI_CODE = "1215";

    @Override
    public FscDealCancelPaymentBusiRspBO dealCancelPayment(FscDealCancelPaymentBusiReqBO reqBO) {
        reqBO.getFscOrderIds().forEach(fscOrderId -> {
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(fscOrderId);
            FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
            this.var(fscOrder);
            if (!StringUtils.isEmpty((Object)fscOrder.getOrderFlowKey())) {
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
                FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                flowAtomReqBO.setOrderId(fscOrderId);
                flowAtomReqBO.setCurStatus(fscOrder.getOrderState());
                flowAtomReqBO.setBusiName(BUSI_NAME);
                flowAtomReqBO.setBusiCode(BUSI_CODE);
                flowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
                if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
                }
            }
        });
        FscDealCancelPaymentBusiRspBO rspBo = new FscDealCancelPaymentBusiRspBO();
        rspBo.setFscOrderIds(reqBO.getFscOrderIds());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void var(FscOrderPO fscOrder) {
        if (fscOrder == null) {
            throw new FscBusinessException("198888", "\u672a\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f");
        }
        if (!FscConstants.FscPayOrderState.TO_AUDIT.equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u4e0b\u624d\u80fd\u53d6\u6d88\u4ed8\u6b3e");
        }
    }
}

