/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceRedImportAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceRedImportAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceRedImportAbilityRspBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceRedImportAbilityService"})
public class FscBillInvoiceRedImportAbilityServiceImpl
implements FscBillInvoiceRedImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillInvoiceRedImportAbilityServiceImpl.class);
    public static final Map<Integer, String> INVOICE_MAP = new LinkedHashMap<Integer, String>(20);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Value(value="${fsc.telegraphic.ticket:\u5168\u7535\u7968}")
    private String telegraphicCategory;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    private static final Integer DOWN;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealRedInvoiceImport"})
    public FscBillInvoiceRedImportAbilityRspBO dealRedInvoiceImport(@RequestBody FscBillInvoiceRedImportAbilityReqBO reqBO) {
        List excelData;
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u4fe1\u606f\uff01");
        }
        File file = FileUtils.getExcelFileByUrl((String)reqBO.getFileUrl());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = ExcelUtils.getExcelData((MultipartFile)multipartFile, (Integer)2);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("191025", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)excelData)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCode("FSC_INVOICE_TYPE");
        Map invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCode("FSC_INVOICE_CATEGORY");
        int size = excelData.size();
        ArrayList<InvoiceBO> preItems = new ArrayList<InvoiceBO>(size);
        ArrayList<InvoiceBO> afterItems = new ArrayList<InvoiceBO>(size);
        ArrayList invoiceNoList = new ArrayList(size);
        log.info("\u5bfc\u5165\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)excelData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        for (int i = 0; i < size; ++i) {
            List rowData = (List)excelData.get(i);
            this.valExcelData(rowData, refundPO);
            if (!((String)rowData.get(16)).matches("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$")) {
                throw new FscBusinessException("191025", "\u7b2c" + (i + 3) + "\u884c\u7ea2\u7968\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
            }
            invoiceNoList.add(rowData.get(2));
            InvoiceBO preInvoice = new InvoiceBO();
            preInvoice.setInvoiceNo((String)rowData.get(2));
            preInvoice.setInvoiceCode((String)rowData.get(3));
            preInvoice.setBuyName((String)rowData.get(4));
            preInvoice.setInvoiceTypeStr((String)rowData.get(5));
            preInvoice.setInvoiceCategoryStr((String)rowData.get(6));
            preInvoice.setAmt(new BigDecimal((String)rowData.get(7)));
            preInvoice.setUntaxAmt(new BigDecimal((String)rowData.get(8)));
            preInvoice.setTaxAmt(new BigDecimal((String)rowData.get(9)));
            preInvoice.setBillDate((String)rowData.get(10));
            if (invoiceTypeMap.get(preInvoice.getInvoiceTypeStr()) == null) {
                throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u539f\u53d1\u7968\u7c7b\u578b!");
            }
            preInvoice.setInvoiceType((String)invoiceTypeMap.get(preInvoice.getInvoiceTypeStr()));
            if (invoiceCategoryMap.get(preInvoice.getInvoiceCategoryStr()) == null) {
                throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u539f\u53d1\u7968\u7c7b\u522b!");
            }
            preInvoice.setInvoiceCategory(Integer.valueOf((String)invoiceCategoryMap.get(preInvoice.getInvoiceCategoryStr())));
            if (FscConstants.InvoiceCategory.FULL_ELECTRON.equals(preInvoice.getInvoiceCategory())) {
                if (preInvoice.getInvoiceNo().length() != 20) {
                    throw new FscBusinessException("198888", "\u5168\u7535\u7968 \u53d1\u7968\u53f7\u7801\u4f4d\u6570\u9519\u8bef,\u8bf7\u91cd\u65b0\u66f4\u65b0\u6a21\u677f\u4e0a\u4f20!");
                }
                preInvoice.setInvoiceCode(null);
            } else if (preInvoice.getInvoiceNo().length() != 8) {
                throw new FscBusinessException("198888", "\u53d1\u7968\u53f7\u7801\u4f4d\u6570\u9519\u8bef,\u8bf7\u91cd\u65b0\u66f4\u65b0\u6a21\u677f\u4e0a\u4f20");
            }
            preItems.add(preInvoice);
            InvoiceBO afterInvoice = new InvoiceBO();
            afterInvoice.setInvoiceNo((String)rowData.get(11));
            afterInvoice.setInvoiceCode((String)rowData.get(12));
            afterInvoice.setAmt(new BigDecimal((String)rowData.get(13)));
            afterInvoice.setUntaxAmt(new BigDecimal((String)rowData.get(14)));
            afterInvoice.setTaxAmt(new BigDecimal((String)rowData.get(15)));
            afterInvoice.setBillDate((String)rowData.get(16));
            afterInvoice.setBuyName((String)rowData.get(17));
            afterInvoice.setInvoiceTypeStr((String)rowData.get(18));
            afterInvoice.setInvoiceCategoryStr((String)rowData.get(19));
            afterInvoice.setPreInvoiceNo(preInvoice.getInvoiceNo());
            if (StringUtils.isEmpty(rowData.get(17)) || "null".equals(rowData.get(17))) {
                afterInvoice.setBuyName((String)rowData.get(4));
            }
            if (StringUtils.isEmpty(rowData.get(18)) || "null".equals(rowData.get(18))) {
                afterInvoice.setInvoiceTypeStr(preInvoice.getInvoiceTypeStr());
                afterInvoice.setInvoiceType(preInvoice.getInvoiceType());
            } else {
                if (invoiceTypeMap.get(afterInvoice.getInvoiceTypeStr()) == null) {
                    throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u7ea2\u5b57\u53d1\u7968\u7c7b\u578b!");
                }
                afterInvoice.setInvoiceType((String)invoiceTypeMap.get(afterInvoice.getInvoiceTypeStr()));
            }
            if (StringUtils.isEmpty(rowData.get(19)) || "null".equals(rowData.get(19))) {
                afterInvoice.setInvoiceCategoryStr(preInvoice.getInvoiceCategoryStr());
                afterInvoice.setInvoiceCategory(preInvoice.getInvoiceCategory());
            } else {
                if (invoiceCategoryMap.get(afterInvoice.getInvoiceCategoryStr()) == null) {
                    throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u7ea2\u5b57\u53d1\u7968\u7c7b\u522b!");
                }
                afterInvoice.setInvoiceCategory(Integer.valueOf((String)invoiceCategoryMap.get(preInvoice.getInvoiceCategoryStr())));
            }
            if (FscConstants.InvoiceCategory.FULL_ELECTRON.equals(afterInvoice.getInvoiceCategory())) {
                if (afterInvoice.getInvoiceNo().length() != 20) {
                    throw new FscBusinessException("198888", "\u5168\u7535\u7968 \u53d1\u7968\u53f7\u7801\u4f4d\u6570\u9519\u8bef,\u8bf7\u91cd\u65b0\u66f4\u65b0\u6a21\u677f\u4e0a\u4f20!");
                }
                afterInvoice.setInvoiceCode(null);
            } else if (afterInvoice.getInvoiceNo().length() != 8) {
                throw new FscBusinessException("198888", "\u53d1\u7968\u53f7\u7801\u4f4d\u6570\u9519\u8bef,\u8bf7\u91cd\u65b0\u66f4\u65b0\u6a21\u677f\u4e0a\u4f20");
            }
            afterItems.add(afterInvoice);
            if (afterInvoice.getUntaxAmt().add(afterInvoice.getTaxAmt()).compareTo(afterInvoice.getAmt()) == 0) continue;
            throw new FscBusinessException("198888", "\u7b2c[" + (i + 2) + "]\u884c\u7ea2\u5b57\u53d1\u7968\u7a0e\u989d\u52a0\u4e0a\u4e0d\u542b\u7a0e\u989d\u4e0d\u7b49\u4e8e\u53d1\u7968\u91d1\u989d!\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5f00\u7968\u91d1\u989d\u3002");
        }
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderId(refundPO.getFscOrderId());
        Integer oldInvoiceCategory = ((InvoiceBO)preItems.get(0)).getInvoiceCategory();
        if (FscConstants.InvoiceCategory.FULL_ELECTRON.equals(oldInvoiceCategory)) {
            invoicePO.setFullElecNoList(invoiceNoList);
        } else {
            invoicePO.setInvoiceNoList(invoiceNoList);
        }
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        List invoiceIds = fscInvoiceRefundRelationPOS.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
        invoicePO.setInvoiceIds(invoiceIds);
        List list = this.fscInvoiceMapper.getListNoStatus(invoicePO);
        if (list.size() != size) {
            throw new FscBusinessException("198888", "\u539f\u53d1\u7968\u6a21\u677f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u53d1\u7968\u6a21\u677f\uff01");
        }
        if (list.size() != invoiceIds.size()) {
            throw new FscBusinessException("198888", "\u539f\u53d1\u7968\u6a21\u677f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u53d1\u7968\u6a21\u677f\uff01");
        }
        this.dealRedInvoiceInfo(afterItems, list, preItems, oldInvoiceCategory);
        Map<Long, BigDecimal> invoiceIdRefundAmtMap = fscInvoiceRefundRelationPOS.stream().collect(Collectors.toMap(FscInvoiceRefundRelationPO::getInvoiceId, FscInvoiceRefundRelationPO::getRefundAmt));
        for (InvoiceBO afterItem : afterItems) {
            if (afterItem.getAmt() == null) {
                throw new FscBusinessException("198888", "\u7ea2\u51b2\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal refundAmt = invoiceIdRefundAmtMap.get(afterItem.getInvoiceId());
            if (afterItem.getAmt().compareTo(refundAmt) == 0) continue;
            throw new FscBusinessException("198888", "\u7ea2\u51b2\u53d1\u7968\u91d1\u989d\u4e0d\u7b49\u4e8e\u53d1\u7968\u603b\u989d\uff08\u9000\u7968\u91d1\u989d\uff09");
        }
        FscBillInvoiceRedImportAbilityRspBO rspBO = new FscBillInvoiceRedImportAbilityRspBO();
        rspBO.setRefundId(reqBO.getRefundId());
        rspBO.setPreItems(preItems);
        rspBO.setAfterItems(afterItems);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRedInvoiceInfo(List<InvoiceBO> afterItems, List<FscInvoicePO> list, List<InvoiceBO> preItems, Integer oldInvoiceCategory) {
        FscInvoicePO preInvoice;
        Map<Object, Object> invoiceMap = new HashMap();
        invoiceMap = FscConstants.InvoiceCategory.FULL_ELECTRON.equals(oldInvoiceCategory) ? list.stream().collect(Collectors.toMap(FscInvoicePO::getFullElecNo, fscInvoicePO -> fscInvoicePO)) : list.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceNo, fscInvoicePO -> fscInvoicePO));
        for (InvoiceBO afterItem : afterItems) {
            preInvoice = (FscInvoicePO)invoiceMap.get(afterItem.getPreInvoiceNo());
            if (preInvoice == null) {
                throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u539f\u53d1\u7968\u4fe1\u606f\uff01");
            }
            afterItem.setInvoiceId(preInvoice.getInvoiceId());
            afterItem.setTaxNo(preInvoice.getTaxNo());
            afterItem.setBank(preInvoice.getBank());
            afterItem.setAccount(preInvoice.getAccount());
            afterItem.setAddress(preInvoice.getAddress());
            afterItem.setPhone(preInvoice.getPhone());
        }
        for (InvoiceBO preItem : preItems) {
            preInvoice = (FscInvoicePO)invoiceMap.get(preItem.getInvoiceNo());
            if (preInvoice == null) {
                throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u539f\u53d1\u7968\u4fe1\u606f\uff01");
            }
            preItem.setInvoiceId(preInvoice.getInvoiceId());
        }
    }

    private void valExcelData(List<String> rowData, FscOrderRefundPO refundPO) {
        try {
            if (StringUtils.isEmpty((Object)rowData.get(2))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(2));
            }
            if (rowData.get(3).equals(this.telegraphicCategory) && StringUtils.isEmpty((Object)rowData.get(3))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(3));
            }
            if (StringUtils.isEmpty((Object)rowData.get(4))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(4));
            }
            if (StringUtils.isEmpty((Object)rowData.get(5))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(5));
            }
            if (StringUtils.isEmpty((Object)rowData.get(6))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(6));
            }
            if (StringUtils.isEmpty((Object)rowData.get(7))) {
                if (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform())) {
                    throw new FscBusinessException("191025", INVOICE_MAP.get(71));
                }
                throw new FscBusinessException("191025", INVOICE_MAP.get(7));
            }
            if (StringUtils.isEmpty((Object)rowData.get(8))) {
                if (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform())) {
                    throw new FscBusinessException("191025", INVOICE_MAP.get(81));
                }
                throw new FscBusinessException("191025", INVOICE_MAP.get(8));
            }
            if (StringUtils.isEmpty((Object)rowData.get(9))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(9));
            }
            if (StringUtils.isEmpty((Object)rowData.get(10))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(10));
            }
            if (StringUtils.isEmpty((Object)rowData.get(11))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(11));
            }
            if (rowData.get(12).equals(this.telegraphicCategory) && StringUtils.isEmpty((Object)rowData.get(12))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(12));
            }
            if (StringUtils.isEmpty((Object)rowData.get(13))) {
                if (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform())) {
                    throw new FscBusinessException("191025", INVOICE_MAP.get(131));
                }
                throw new FscBusinessException("191025", INVOICE_MAP.get(13));
            }
            if (StringUtils.isEmpty((Object)rowData.get(14))) {
                if (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform())) {
                    throw new FscBusinessException("191025", INVOICE_MAP.get(141));
                }
                throw new FscBusinessException("191025", INVOICE_MAP.get(14));
            }
            if (StringUtils.isEmpty((Object)rowData.get(15))) {
                if (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform())) {
                    throw new FscBusinessException("191025", INVOICE_MAP.get(151));
                }
                throw new FscBusinessException("191025", INVOICE_MAP.get(15));
            }
            if (StringUtils.isEmpty((Object)rowData.get(16))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(16));
            }
            if (StringUtils.isEmpty((Object)rowData.get(17))) {
                throw new FscBusinessException("191025", INVOICE_MAP.get(17));
            }
        }
        catch (FscBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FscBusinessException("191025", "\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u6a21\u677f");
        }
    }

    private void valid(FscBillInvoiceRedImportAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFileUrl())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fileUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    static {
        INVOICE_MAP.put(0, "\u3010\u5e8f\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(1, "\u3010\u539f\u53d1\u7968\u9000\u7968\u65b9\u5f0f\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(2, "\u3010\u539f\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(3, "\u3010\u539f\u53d1\u7968\u4ee3\u7801\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(4, "\u3010\u539f\u53d1\u7968\u62ac\u5934\u3011\u4e3a\u7a7a\uff0c\u7ea2\u8272\u5217\u6807\u9898\u4e3a\u5fc5\u586b\u9879");
        INVOICE_MAP.put(5, "\u3010\u539f\u53d1\u7968\u7c7b\u578b\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(6, "\u3010\u539f\u53d1\u7968\u7c7b\u522b\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(7, "\u3010\u539f\u53d1\u7968\u603b\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(71, "\u3010\u539f\u53d1\u7968\u603b\u989d\uff08\u539f\u5e01\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(8, "\u3010\u539f\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(81, "\u3010\u539f\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u539f\u5e01\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(9, "\u3010\u539f\u7a0e\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(91, "\u3010\u539f\u7a0e\u989d\uff08\u539f\u5e01\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(10, "\u3010\u539f\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(11, "\u3010\u7ea2\u7968\u53d1\u7968\u53f7\u7801\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(12, "\u3010\u53d1\u7968\u4ee3\u7801\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(13, "\u3010\u53d1\u7968\u603b\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(131, "\u3010\u53d1\u7968\u603b\u989d\uff08\u539f\u5e01\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(14, "\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(141, "\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u539f\u5e01\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(15, "\u3010\u7a0e\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(151, "\u3010\u7a0e\u989d\uff08\u539f\u5e01\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(16, "\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(17, "\u3010\u53d1\u7968\u62ac\u5934\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(18, "\u3010\u53d1\u7968\u7c7b\u578b\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        INVOICE_MAP.put(19, "\u3010\u53d1\u7968\u7c7b\u522b\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        DOWN = 0;
    }
}

