/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.api.AgrFinanceSelectAgreementAbilityService;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementReqBo;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementRspBo;
import com.tydic.contract.ability.FscFinanceSelectContractAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractReqBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscFinanceRefundableContractListQryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscFinanceRefundableContractListQryReqBO;
import com.tydic.fsc.bill.ability.bo.FscFinanceRefundableContractListQryRspBO;
import com.tydic.fsc.bill.ability.bo.FscFinanceRefundableContractListQryRspBOData;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscFinanceRefundableContractListQryAbilityService"})
public class FscFinanceRefundableContractListQryAbilityServiceImpl
implements FscFinanceRefundableContractListQryAbilityService {
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscFinanceSelectContractAbilityService fscFinanceSelectContractAbilityService;
    @Autowired
    private AgrFinanceSelectAgreementAbilityService agrFinanceSelectAgreementAbilityService;

    @PostMapping(value={"qryRefundableContractList"})
    public FscFinanceRefundableContractListQryRspBO qryRefundableContractList(@RequestBody FscFinanceRefundableContractListQryReqBO reqBo) {
        FscFinanceRefundableContractListQryRspBO rspBO = new FscFinanceRefundableContractListQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (null == reqBo.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setRefundId(reqBo.getRefundId());
        fscOrderRelationPo.setFscOrderId(reqBo.getFscOrderId());
        List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return rspBO;
        }
        List contractIdList = list.stream().map(FscOrderRelationPO::getContractId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty((Collection)reqBo.getFilterContractIds())) {
            contractIdList.removeAll(reqBo.getFilterContractIds());
        }
        FscFinanceRefundableContractListQryRspBO qryRspBO = new FscFinanceRefundableContractListQryRspBO();
        if (CollectionUtil.isEmpty(contractIdList)) {
            qryRspBO.setRespCode("0000");
            qryRspBO.setRows(new ArrayList());
            return qryRspBO;
        }
        if ("2".equals(reqBo.getContractSource())) {
            AgrFinanceSelectAgreementReqBo queryReq = (AgrFinanceSelectAgreementReqBo)JUtil.js((Object)reqBo, AgrFinanceSelectAgreementReqBo.class);
            queryReq.setAgreementIds(contractIdList);
            AgrFinanceSelectAgreementRspBo agreementRspBo = this.agrFinanceSelectAgreementAbilityService.selectAgreementPage(queryReq);
            qryRspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agreementRspBo.getRows()), FscFinanceRefundableContractListQryRspBOData.class));
            qryRspBO.setTotal(agreementRspBo.getTotal());
            qryRspBO.setPageNo(agreementRspBo.getPageNo());
            qryRspBO.setRecordsTotal(agreementRspBo.getRecordsTotal());
            qryRspBO.setRespCode(agreementRspBo.getRespCode());
            qryRspBO.setRespDesc(agreementRspBo.getRespDesc());
        } else {
            FscFinanceSelectContractReqBo queryReq = (FscFinanceSelectContractReqBo)JUtil.js((Object)reqBo, FscFinanceSelectContractReqBo.class);
            queryReq.setContractList(contractIdList);
            FscFinanceSelectContractRspBo fscFinanceSelectContractRspBo = this.fscFinanceSelectContractAbilityService.selectContractPage(queryReq);
            qryRspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)fscFinanceSelectContractRspBo.getRows()), FscFinanceRefundableContractListQryRspBOData.class));
            qryRspBO.setTotal(fscFinanceSelectContractRspBo.getTotal());
            qryRspBO.setPageNo(fscFinanceSelectContractRspBo.getPageNo());
            qryRspBO.setRecordsTotal(fscFinanceSelectContractRspBo.getRecordsTotal());
            qryRspBO.setRespCode(fscFinanceSelectContractRspBo.getRespCode());
            qryRspBO.setRespDesc(fscFinanceSelectContractRspBo.getRespDesc());
        }
        return qryRspBO;
    }
}

