/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscReliefOverduePenaltyQryListAbilityService;
import com.tydic.fsc.bill.ability.bo.FscPenaltyOrderBO;
import com.tydic.fsc.bill.ability.bo.FscQryReliefOverduePenaltyBO;
import com.tydic.fsc.bill.ability.bo.FscQryReliefOverduePenaltyDetailReqBO;
import com.tydic.fsc.bill.ability.bo.FscQryReliefOverduePenaltyDetailRspBO;
import com.tydic.fsc.bill.ability.bo.FscReliefOverduePenaltyQryListAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscReliefOverduePenaltyQryListAbilityRspBO;
import com.tydic.fsc.dao.FscOverduePenaltyMapper;
import com.tydic.fsc.dao.FscPenaltyOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayNodeEnum;
import com.tydic.fsc.enums.FscPayRuleEnum;
import com.tydic.fsc.enums.FscPenaltyOrderStatusEnum;
import com.tydic.fsc.enums.FscReliefOverPenaltyAuditResultEnum;
import com.tydic.fsc.enums.FscReliefOverPenaltyStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOverduePenaltyPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscReliefOverduePenaltyQryListAbilityService"})
public class FscReliefOverduePenaltyQryListAbilityServiceImpl
implements FscReliefOverduePenaltyQryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscReliefOverduePenaltyQryListAbilityServiceImpl.class);
    @Autowired
    private FscOverduePenaltyMapper fscOverduePenaltyMapper;
    @Autowired
    private FscPenaltyOrderMapper fscPenaltyOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"qryReliefOverduePenaltyList"})
    public FscReliefOverduePenaltyQryListAbilityRspBO qryReliefOverduePenaltyList(@RequestBody FscReliefOverduePenaltyQryListAbilityReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        if (null == reqBO) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscReliefOverduePenaltyQryListAbilityRspBO rspBO = new FscReliefOverduePenaltyQryListAbilityRspBO();
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        FscOverduePenaltyPO po = new FscOverduePenaltyPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List fscOverduePenaltyList = this.fscOverduePenaltyMapper.getListPage(po, page);
        List<Object> rows = new ArrayList<FscQryReliefOverduePenaltyBO>();
        if (!CollectionUtils.isEmpty((Collection)fscOverduePenaltyList)) {
            rows = JSONArray.parseArray((String)JSON.toJSONString((Object)fscOverduePenaltyList), FscQryReliefOverduePenaltyBO.class);
        }
        this.translate(rows);
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryReliefOverduePenaltyDetail"})
    public FscQryReliefOverduePenaltyDetailRspBO qryReliefOverduePenaltyDetail(@RequestBody FscQryReliefOverduePenaltyDetailReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscQryReliefOverduePenaltyDetailRspBO rspBO = new FscQryReliefOverduePenaltyDetailRspBO();
        List fscPenaltyOrderBOS = this.fscPenaltyOrderMapper.selectDetail(reqBO.getOverduePenaltyId());
        List<Object> details = new ArrayList<FscPenaltyOrderBO>();
        if (!CollectionUtils.isEmpty((Collection)fscPenaltyOrderBOS)) {
            details = JSONObject.parseArray((String)JSON.toJSONString((Object)fscPenaltyOrderBOS), FscPenaltyOrderBO.class);
        }
        this.translateDetail(details);
        rspBO.setOverDuePenaltyList(details);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void translateDetail(List<FscPenaltyOrderBO> details) {
        details.forEach(fscPenaltyOrderBO -> {
            if (!StringUtils.isEmpty((Object)fscPenaltyOrderBO.getStatus())) {
                fscPenaltyOrderBO.setStatusDesc(FscPenaltyOrderStatusEnum.getInstance((String)fscPenaltyOrderBO.getStatus()).getCodeDesc());
            }
            if (null != fscPenaltyOrderBO.getPayRule()) {
                fscPenaltyOrderBO.setPayRuleDesc(FscPayRuleEnum.getInstance((Integer)fscPenaltyOrderBO.getPayRule()).getCodeDesc());
            }
            if (null != fscPenaltyOrderBO.getPayNode()) {
                fscPenaltyOrderBO.setPayNodeDesc(FscPayNodeEnum.getInstance((Integer)fscPenaltyOrderBO.getPayNode()).getCodeDesc());
            }
        });
    }

    private void translate(List<FscQryReliefOverduePenaltyBO> rows) {
        rows.forEach(fscOverduePenaltyBO -> {
            if (null != fscOverduePenaltyBO.getStatus()) {
                fscOverduePenaltyBO.setStatusDesc(FscReliefOverPenaltyStatusEnum.getInstance((Integer)fscOverduePenaltyBO.getStatus()).getCodeDesc());
            }
            if (null != fscOverduePenaltyBO.getAuditResult()) {
                fscOverduePenaltyBO.setAuditResultDesc(FscReliefOverPenaltyAuditResultEnum.getInstance((Integer)fscOverduePenaltyBO.getAuditResult()).getCodeDesc());
            }
        });
    }
}

