/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffBO;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceWriteOffAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceWriteOffAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceWriteOffAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceWriteOffAtomServiceImpl
implements FscFinanceWriteOffAtomService {
    @Autowired
    FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    FscOrderMapper fscOrderMapper;
    @Autowired
    FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    FscOrderPayItemMapper fscOrderPayItemMapper;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;

    @Override
    public FscFinanceWriteOffAtomRspBO purWriteOff(FscFinanceWriteOffAtomReqBO reqBO) {
        FscFinanceWriteOffAtomRspBO rspBO = new FscFinanceWriteOffAtomRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
        fscFinanceWriteOffPO.setFscOrderId(reqBO.getOrderId());
        this.fscFinanceWriteOffMapper.deleteBy(fscFinanceWriteOffPO);
        if (!CollectionUtils.isEmpty(reqBO.getPurWriteOffAmountList())) {
            BigDecimal writeOffAmt = reqBO.getPurWriteOffAmountList().stream().map(FscFinanceWriteOffBO::getWriteOffAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (writeOffAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.checkWriteOffAmt(fscOrderPO, writeOffAmt, reqBO.getOrderId());
            }
            List insertWritePOList = JSON.parseArray((String)JSONObject.toJSONString(reqBO.getPurWriteOffAmountList()), FscFinanceWriteOffPO.class);
            HashMap<Long, BigDecimal> updatePayWriteOffAmountMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> updatePayItemWriteOffAmountMap = new HashMap<Long, BigDecimal>();
            for (FscFinanceWriteOffPO po : insertWritePOList) {
                po.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
                po.setFscOrderId(fscOrderPO.getFscOrderId());
                po.setFscOrderNo(fscOrderPO.getOrderNo());
                po.setWriteOffType(FscConstants.FscFinanceWriteOffType.PAY);
                po.setCreateTime(new Date());
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateUserName(reqBO.getName());
                po.setDelFlag(FscConstants.DicDelFlag.NO);
                BigDecimal payWriteOffAmt = (BigDecimal)updatePayWriteOffAmountMap.get(po.getPayOrderId());
                if (payWriteOffAmt == null) {
                    updatePayWriteOffAmountMap.put(po.getPayOrderId(), po.getWriteOffAmt());
                } else {
                    payWriteOffAmt = payWriteOffAmt.add(po.getWriteOffAmt());
                    updatePayWriteOffAmountMap.put(po.getPayOrderId(), payWriteOffAmt);
                }
                BigDecimal payItemWriteOffAmt = (BigDecimal)updatePayItemWriteOffAmountMap.get(po.getPayOrderId());
                if (payItemWriteOffAmt == null) {
                    updatePayItemWriteOffAmountMap.put(po.getOrderPayItemId(), po.getWriteOffAmt());
                    continue;
                }
                payItemWriteOffAmt = payItemWriteOffAmt.add(po.getWriteOffAmt());
                updatePayItemWriteOffAmountMap.put(po.getOrderPayItemId(), payItemWriteOffAmt);
            }
            this.fscFinanceWriteOffMapper.insertBatch(insertWritePOList);
            fscOrderPO.setPurWriteOffAmount(writeOffAmt);
            int count = this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPO);
            if (count == 0) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u6838\u9500\u91d1\u989d\u5931\u8d25");
                return rspBO;
            }
            for (Long payOrderId : updatePayWriteOffAmountMap.keySet()) {
                FscOrderPO payOrderPO = new FscOrderPO();
                payOrderPO.setFscOrderId(payOrderId);
                payOrderPO.setPurWriteOffAmount((BigDecimal)updatePayWriteOffAmountMap.get(payOrderId));
                count = this.fscOrderMapper.updatePurWriteOffAmountAdd(payOrderPO);
                if (count != 0) continue;
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u4ed8\u6b3e\u6838\u9500\u91d1\u989d\u5931\u8d25");
                return rspBO;
            }
            for (Long itemId : updatePayItemWriteOffAmountMap.keySet()) {
                FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setOrderPayItemId(itemId);
                fscOrderPayItemPO.setPurWriteOffAmount((BigDecimal)updatePayItemWriteOffAmountMap.get(itemId));
                count = this.fscOrderPayItemMapper.updateWriteOffAmountAdd(fscOrderPayItemPO);
                if (count != 0) continue;
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u4ed8\u6b3e\u660e\u7ec6\u6838\u9500\u91d1\u989d\u5931\u8d25");
                return rspBO;
            }
        }
        return (FscFinanceWriteOffAtomRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)rspBO)), FscFinanceWriteOffAtomRspBO.class));
    }

    private void checkWriteOffAmt(FscOrderPO orderPO, BigDecimal writeOffAmt, Long fscOrderId) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(fscOrderId);
        List orderRelationPOS = this.fscOrderRelationMapper.getList(relationPO);
        if (CollectionUtils.isEmpty((Collection)orderRelationPOS)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\uff01");
        }
        if (FscOrderFlowEnum.ENGINEERING_INVOICE.getCode().equals(orderPO.getOrderFlow())) {
            return;
        }
        Long orderId = ((FscOrderRelationPO)orderRelationPOS.get(0)).getOrderId();
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderId(orderId);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        BigDecimal shouldPayRadio = BigDecimal.ZERO;
        if (((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType() != null && ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE) && !CollectionUtils.isEmpty((Collection)((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList())) {
            List proPayList = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList();
            for (UocPhasePayListBO uocPhasePayListBO : proPayList) {
                if (!uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.SHOULD_PAY) && !uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT)) continue;
                shouldPayRadio = shouldPayRadio.add(uocPhasePayListBO.getNodePayRatio());
            }
        }
        if (shouldPayRadio.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (orderPO.getSettleType() != null && orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            shouldPayRadio = BigDecimal.ONE;
        }
        BigDecimal shouldPayAmount = orderPO.getTotalCharge().multiply(shouldPayRadio).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        BigDecimal shouldWriteOffAmount = orderPO.getTotalCharge().subtract(shouldPayAmount).setScale(2, RoundingMode.HALF_UP);
        if (writeOffAmt.compareTo(shouldWriteOffAmount) > 0) {
            throw new FscBusinessException("198888", "\u6838\u9500\u91d1\u989d[" + writeOffAmt + "]\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u9884\u4ed8\u6bd4\u4f8b\u91d1\u989d[" + shouldWriteOffAmount + "]\u3002");
        }
    }
}

