/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.ContractQueryPayNodeAbilityService;
import com.tydic.contract.ability.bo.ContractQueryPayNodeAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQueryPayNodeAbilityRspBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityReqBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityRspBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementItemBO;
import com.tydic.contract.ability.enums.ContractObjectTypeEnum;
import com.tydic.contract.ability.finance.ContractSyncSettlementAbilityService;
import com.tydic.fsc.bill.ability.enums.FscOperatorTypeEnum;
import com.tydic.fsc.bill.atom.api.finance.FscSyncContractSettlementDetailAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomRspBO;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractSettlementDetailPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscSyncContractSettlementDetailAtomServiceImpl
implements FscSyncContractSettlementDetailAtomService {
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;
    @Autowired
    private ContractSyncSettlementAbilityService contractSyncSettlementAbilityService;
    @Autowired
    private ContractQueryPayNodeAbilityService contractQueryPayNodeAbilityService;

    @Override
    public FscSyncContractSettlementDetailAtomRspBO syncContractSettlementDetail(FscSyncContractSettlementDetailAtomReqBO reqBO) {
        if (Objects.isNull(reqBO) || Objects.isNull(reqBO.getFscOrderId()) || Objects.isNull(reqBO.getOperatorType())) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25,\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        fscOrderFinancePO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderFinancePO financePO = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePO);
        if (Objects.isNull(financePO)) {
            throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u6c47\u7387\u4fe1\u606f\uff01");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        List<Long> contractIdList = fscOrderItemPOList.stream().map(FscOrderItemPO::getContractId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contractIdList)) {
            throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u7ed3\u7b97\u660e\u7ec6\u4e2d\u672a\u8bb0\u5f55\u5408\u540c\u4fe1\u606f\uff01");
        }
        contractIdList.forEach(contractId -> {
            int count;
            List<FscOrderItemPO> orderItemPOList = fscOrderItemPOList.stream().filter(e -> contractId.equals(e.getContractId())).collect(Collectors.toList());
            Set payDetailIdList = orderItemPOList.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(payDetailIdList)) {
                throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u660e\u7ec6ID\uff01");
            }
            FscContractSettlementDetailPO fscContractSettlementDetailPO = new FscContractSettlementDetailPO();
            fscContractSettlementDetailPO.setContractId(contractId);
            List<FscContractSettlementDetailPO> settlementDetailPOList = this.fscContractSettlementDetailMapper.getList(fscContractSettlementDetailPO);
            ArrayList addList = new ArrayList();
            ArrayList updateList = new ArrayList();
            if (FscOperatorTypeEnum.ADD.getCode().equals(reqBO.getOperatorType())) {
                Map<Object, Object> settlementDetailPOMap = !CollectionUtils.isEmpty(settlementDetailPOList = this.initContractPayItem(settlementDetailPOList, orderItemPOList)) ? settlementDetailPOList.stream().collect(Collectors.toMap(FscContractSettlementDetailPO::getDetailId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
                orderItemPOList.forEach(e -> {
                    FscContractSettlementDetailPO detailPO = new FscContractSettlementDetailPO();
                    if (!CollectionUtils.isEmpty((Map)settlementDetailPOMap) && settlementDetailPOMap.containsKey(e.getOrderId())) {
                        detailPO.setDetailId(e.getOrderId());
                        detailPO.setSettleAmt(((FscContractSettlementDetailPO)settlementDetailPOMap.get(e.getOrderId())).getSettleAmt().add(e.getAmt()));
                        detailPO.setSettleAmtLocal(((FscContractSettlementDetailPO)settlementDetailPOMap.get(e.getOrderId())).getSettleAmtLocal().add(e.getAmt().multiply(financePO.getExchangeRate())));
                        detailPO.setVersion(((FscContractSettlementDetailPO)settlementDetailPOMap.get(e.getOrderId())).getVersion());
                        updateList.add(detailPO);
                    } else {
                        detailPO.setDetailId(e.getOrderId());
                        detailPO.setContractId(e.getContractId());
                        detailPO.setSettleAmt(e.getAmt());
                        detailPO.setSettleAmtLocal(e.getAmt().multiply(financePO.getExchangeRate()));
                        addList.add(detailPO);
                    }
                });
            } else {
                if (CollectionUtils.isEmpty((Collection)settlementDetailPOList)) {
                    throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u7ed3\u7b97\u660e\u7ec6\uff01");
                }
                Map<Long, BigDecimal> itemMap = orderItemPOList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getOrderId, Collectors.mapping(FscOrderItemPO::getAmt, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
                settlementDetailPOList.forEach(e -> {
                    if (CollectionUtils.isEmpty((Map)itemMap) || !itemMap.containsKey(e.getDetailId())) {
                        return;
                    }
                    if (e.getSettleAmt().subtract((BigDecimal)itemMap.get(e.getDetailId())).compareTo(BigDecimal.ZERO) < 0) {
                        throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u5408\u540c\u5269\u4f59\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff01");
                    }
                    FscContractSettlementDetailPO detailPO = new FscContractSettlementDetailPO();
                    detailPO.setDetailId(e.getDetailId());
                    detailPO.setSettleAmt(e.getSettleAmt().subtract((BigDecimal)itemMap.get(e.getDetailId())));
                    detailPO.setSettleAmtLocal(e.getSettleAmtLocal().subtract(((BigDecimal)itemMap.get(e.getDetailId())).subtract(financePO.getExchangeRate())));
                    detailPO.setVersion(e.getVersion());
                    updateList.add(detailPO);
                });
            }
            if (!CollectionUtils.isEmpty(addList) && (count = this.fscContractSettlementDetailMapper.insertBatch(addList)) == 0) {
                throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u65b0\u589e\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(updateList) && (count = this.fscContractSettlementDetailMapper.updateAmtByVersion(updateList)) == 0) {
                throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u4fee\u6539\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff01");
            }
        });
        ContractSyncSettlementAbilityReqBO contractSyncSettlementAbilityReqBO = new ContractSyncSettlementAbilityReqBO();
        contractSyncSettlementAbilityReqBO.setObjectId(reqBO.getFscOrderId());
        contractSyncSettlementAbilityReqBO.setObjectType(ContractObjectTypeEnum.SETTLE.getCode());
        contractSyncSettlementAbilityReqBO.setUserId(reqBO.getUserId());
        ArrayList contractList = new ArrayList();
        fscOrderItemPOList.forEach(e -> {
            ContractSyncSettlementItemBO syncSettlementItemBO = (ContractSyncSettlementItemBO)JSON.parseObject((String)JSON.toJSONString((Object)e), ContractSyncSettlementItemBO.class);
            syncSettlementItemBO.setPayDetailId(e.getOrderId());
            contractList.add(syncSettlementItemBO);
        });
        if (FscOperatorTypeEnum.ADD.getCode().equals(reqBO.getOperatorType())) {
            contractSyncSettlementAbilityReqBO.setAddList(contractList);
        } else {
            contractSyncSettlementAbilityReqBO.setDeleteList(contractList);
        }
        ContractSyncSettlementAbilityRspBO contractSyncSettlementAbilityRspBO = this.contractSyncSettlementAbilityService.modifySettlement(contractSyncSettlementAbilityReqBO);
        if (Objects.nonNull(contractSyncSettlementAbilityRspBO) && !"0000".equals(contractSyncSettlementAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u540c\u6b65\u5408\u540c\u6a21\u5757\u7ed3\u7b97\u4fe1\u606f\u5931\u8d25\uff1a" + contractSyncSettlementAbilityRspBO.getRespDesc());
        }
        FscSyncContractSettlementDetailAtomRspBO rspBO = new FscSyncContractSettlementDetailAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<FscContractSettlementDetailPO> initContractPayItem(List<FscContractSettlementDetailPO> settlementDetailPOList, List<FscOrderItemPO> orderItemPOList) {
        ContractQueryPayNodeAbilityReqBO contractReqBO = new ContractQueryPayNodeAbilityReqBO();
        contractReqBO.setContractId(orderItemPOList.get(0).getContractId());
        ContractQueryPayNodeAbilityRspBO contractRspBO = this.contractQueryPayNodeAbilityService.queryPayNode(contractReqBO);
        if (Objects.nonNull(contractRspBO) && !"0000".equals(contractRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u67e5\u8be2\u5408\u540c\u7ea6\u5b9a\u4ed8\u6b3e\u65b9\u5f0f\u5931\u8d25\uff01");
        }
        if (Objects.isNull(contractRspBO) || CollectionUtils.isEmpty((Collection)contractRspBO.getContractQueryPayNodeBOList())) {
            throw new FscBusinessException("8888", "\u66f4\u65b0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u7ea6\u5b9a\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f\uff01");
        }
        List<Object> detailId = !CollectionUtils.isEmpty(settlementDetailPOList) ? settlementDetailPOList.stream().map(FscContractSettlementDetailPO::getDetailId).collect(Collectors.toList()) : new ArrayList();
        ArrayList initDetailPOList = new ArrayList();
        contractRspBO.getContractQueryPayNodeBOList().forEach(e -> {
            if (!CollectionUtils.isEmpty((Collection)detailId) && detailId.contains(e.getId())) {
                return;
            }
            FscContractSettlementDetailPO initDetailPO = new FscContractSettlementDetailPO();
            initDetailPO.setDetailId(e.getId());
            initDetailPO.setContractId(e.getRelateId());
            initDetailPO.setPayType(e.getMoneyType());
            initDetailPO.setPanelPointCode(e.getPanelPointCode());
            initDetailPO.setPanelPointName(e.getPanelPointName());
            initDetailPO.setDays(e.getDays());
            initDetailPO.setPayPercent(e.getPayPercent());
            initDetailPO.setPlanAmount(e.getPlanAmount());
            initDetailPO.setSettleAmt(BigDecimal.ZERO);
            initDetailPO.setSettleAmtLocal(BigDecimal.ZERO);
            initDetailPOList.add(initDetailPO);
        });
        if (!CollectionUtils.isEmpty(initDetailPOList)) {
            this.fscContractSettlementDetailMapper.insertBatch(initDetailPOList);
        }
        FscContractSettlementDetailPO fscContractSettlementDetailPO = new FscContractSettlementDetailPO();
        fscContractSettlementDetailPO.setContractId(orderItemPOList.get(0).getContractId());
        settlementDetailPOList = this.fscContractSettlementDetailMapper.getList(fscContractSettlementDetailPO);
        return settlementDetailPOList;
    }
}

