/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundWithdrawBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundWithdrawBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundWithdrawBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifyRecallFlowReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifyRecallFlowRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifyRecallFlowService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uac.po.ApprovalLogPO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscComOrderRefundWithdrawBusiServiceImpl
implements FscComOrderRefundWithdrawBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderRefundWithdrawBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscUnifyRecallFlowService fscUnifyRecallFlowService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    private static final String WF_TYPE = "CH";
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u64a4\u56de";

    @Override
    public FscComOrderRefundWithdrawBusiRspBO dealOrderRefundWithdraw(FscComOrderRefundWithdrawBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u4fe1\u606f");
        }
        if (FscConstants.OrderFlow.REFUND_PAY.equals(refundPO.getOrderFlow())) {
            return this.dealUnifyWithdraw(reqBO, refundPO);
        }
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            this.dealUpWithdraw(reqBO, refundPO);
        } else if (refundPO.getPushUnifyStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            return this.dealUnifyWithdraw(reqBO, refundPO);
        }
        FscComOrderRefundWithdrawBusiRspBO rspBO = new FscComOrderRefundWithdrawBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscComOrderRefundWithdrawBusiRspBO dealUnifyWithdraw(FscComOrderRefundWithdrawBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        FscComOrderRefundWithdrawBusiRspBO rspBO = new FscComOrderRefundWithdrawBusiRspBO();
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(reqBO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("egbuzId", (Object)refundPO.getRefundId());
        jsonObject.put("egbuzNum", (Object)refundPO.getRefundNo());
        if (!StringUtils.isEmpty((Object)reqBO.getWithdrawReason())) {
            jsonObject.put("cause", (Object)reqBO.getWithdrawReason());
        } else {
            jsonObject.put("cause", (Object)"\u64a4\u56de\u539f\u56e0");
        }
        jsonObject.put("deptId", (Object)refundPO.getUnifyDeptId());
        jsonObject.put("instId", (Object)refundPO.getInstanceId());
        jsonObject.put("orgId", (Object)refundPO.getUnifyOrgId());
        if (FscConstants.OrderFlow.REFUND_INVOICE.equals(refundPO.getOrderFlow())) {
            jsonObject.put("typeId", (Object)"8037");
        } else if (FscConstants.OrderFlow.REFUND_PAY.equals(refundPO.getOrderFlow())) {
            if (refundPO.getRefundReasonType().equals(FscConstants.RefundType.INSPECTION) || refundPO.getRefundReasonType().equals(FscConstants.RefundType.CANCEL) || refundPO.getRefundReasonType().equals(FscConstants.RefundType.REJECTION) || refundPO.getRefundReasonType().equals(FscConstants.RefundType.RETURN_GOODS)) {
                jsonObject.put("typeId", (Object)"8036");
            } else {
                jsonObject.put("typeId", (Object)"8019");
            }
        }
        jsonObject.put("wfType", (Object)WF_TYPE);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.debug("\u8c03\u7528\u7edf\u4e00\u7ed3\u7b97\u53c2\u6570\u52a0\u5bc6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)encryptionAbilityReqBO));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        FscUnifyRecallFlowReqBO fscUnifyRecallFlowReqBO = new FscUnifyRecallFlowReqBO();
        fscUnifyRecallFlowReqBO.setData(encryptionAbilityRspBO.getData());
        fscUnifyRecallFlowReqBO.setToken(tokenQryAbilityRspBO.getData());
        FscUnifyRecallFlowRspBO fscUnifyRecallFlowRspBO = this.fscUnifyRecallFlowService.dealRecallFlow(fscUnifyRecallFlowReqBO);
        if (!fscUnifyRecallFlowRspBO.getRespCode().equals("0000")) {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(refundPO, FscConstants.FscPushStatus.FAIL, FscConstants.FscPurchasePushType.ORDER_RECALL_FLOW);
            pushLogPo.setRespData(JSONObject.toJSONString((Object)fscUnifyRecallFlowRspBO));
            pushLogPo.setPushData(jsonArray.toJSONString());
            pushLogPo.setPushParseData(encryptionAbilityRspBO.getData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(fscUnifyRecallFlowRspBO.getMsg());
        } else {
            FscPurchasePushLogPo pushLogPo = this.buildPushLog(refundPO, FscConstants.FscPushStatus.SUCCESS, FscConstants.FscPurchasePushType.ORDER_RECALL_FLOW);
            pushLogPo.setRespData(JSONObject.toJSONString((Object)fscUnifyRecallFlowRspBO));
            pushLogPo.setPushData(jsonArray.toJSONString());
            pushLogPo.setPushParseData(encryptionAbilityRspBO.getData());
            this.fscPurchasePushLogMapper.insert(pushLogPo);
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u7ed3\u7b97\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
            log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u7ed3\u7b97\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
            if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
            FscOrderRefundPO updatePo = new FscOrderRefundPO();
            updatePo.setRefundId(refundPO.getRefundId());
            updatePo.setPushUnifyStatus(FscConstants.FscPushStatus.BACK);
            this.fscOrderRefundMapper.updateById(updatePo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void dealUpWithdraw(FscComOrderRefundWithdrawBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        ApprovalLogPO approvalLogPO;
        if (!refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.AUDITING)) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u9000\u7968\u5355\u636e\u53ef\u4ee5\u64a4\u56de\u3002");
        }
        boolean withdrawFlag = false;
        List approvalList = this.fscOrderRefundMapper.getRefundApprovalList(refundPO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)approvalList)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u636e\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)approvalList) && ((approvalLogPO = (ApprovalLogPO)approvalList.get(approvalList.size() - 1)).getFinish() == 1 || approvalLogPO.getAuditAdvice().equals("\u53d1\u8d77\u5ba1\u6279"))) {
            withdrawFlag = true;
        }
        if (!withdrawFlag) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u636e\u5df2\u5b58\u5728\u5ba1\u6279,\u4e0d\u53ef\u64a4\u56de!");
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        List taskIds = this.fscOrderRefundMapper.getNextTaskId(refundPO.getRefundId());
        this.fscOrderRefundMapper.deleteAuditTask(taskIds, refundPO.getRefundId());
        this.fscOrderRefundMapper.deleteAuditTaskCandidate(taskIds, refundPO.getRefundId());
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.SAVE);
        this.fscOrderRefundMapper.updateById(updatePo);
    }

    private FscPurchasePushLogPo buildPushLog(FscOrderRefundPO refundPO, Integer pushStatus, Integer pushType) {
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(refundPO.getRefundId());
        pushLogPo.setObjectNo(refundPO.getRefundNo());
        pushLogPo.setPushStatus(pushStatus);
        pushLogPo.setType(pushType);
        pushLogPo.setCreateTime(new Date());
        return pushLogPo;
    }
}

