/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityReqBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityRspBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementItemBO;
import com.tydic.contract.ability.enums.ContractObjectTypeEnum;
import com.tydic.contract.ability.finance.ContractSyncSettlementAbilityService;
import com.tydic.fsc.bill.atom.api.finance.FscSyncContractSettlementDetailAtomService;
import com.tydic.fsc.bill.busi.api.FscDealCancelPaymentBusiService;
import com.tydic.fsc.bill.busi.bo.FscDealCancelPaymentBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscDealCancelPaymentBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscDealCancelPaymentBusiServiceImpl
implements FscDealCancelPaymentBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDealCancelPaymentBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private ContractSyncSettlementAbilityService contractSyncSettlementAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private FscSyncContractSettlementDetailAtomService fscSyncContractSettlementDetailAtomService;
    public static final String BUSI_NAME = "\u53d6\u6d88\u4ed8\u6b3e";
    public static final String BUSI_CODE = "1215";
    private static final Integer OBJ_TYPE_SEVEN = 7;

    @Override
    public FscDealCancelPaymentBusiRspBO dealCancelPayment(FscDealCancelPaymentBusiReqBO reqBO) {
        reqBO.getFscOrderIds().forEach(fscOrderId -> {
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(fscOrderId);
            FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
            this.var(fscOrder);
            if (FscConstants.FscPayOrderState.TO_AUDIT.equals(fscOrder.getOrderState())) {
                UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
                uacQryAuditLogReqBO.setObjId(fscOrder.getFscOrderId().toString());
                uacQryAuditLogReqBO.setObjType(OBJ_TYPE_SEVEN);
                log.info("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u5165\u53c2================" + JSON.toJSONString((Object)uacQryAuditLogReqBO));
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(uacQryAuditLogReqBO);
                log.info("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u51fa\u53c2================" + JSON.toJSONString((Object)uacQryAuditLogRspBO));
                if (null != uacQryAuditLogRspBO.getLogInfo() && uacQryAuditLogRspBO.getLogInfo().getAuditResult() != null) {
                    throw new FscBusinessException("191125", "\u5df2\u6709\u5ba1\u6279\u8bb0\u5f55\uff0c\u4e0d\u80fd\u53d6\u6d88\u4ed8\u6b3e\u5355");
                }
            }
            this.syncContract((Long)fscOrderId, reqBO);
            if (!StringUtils.isEmpty((Object)fscOrder.getOrderFlowKey())) {
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
                FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                flowAtomReqBO.setOrderId(fscOrderId);
                flowAtomReqBO.setCurStatus(fscOrder.getOrderState());
                flowAtomReqBO.setBusiName(BUSI_NAME);
                flowAtomReqBO.setBusiCode(BUSI_CODE);
                flowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
                if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
                }
            }
        });
        FscDealCancelPaymentBusiRspBO rspBo = new FscDealCancelPaymentBusiRspBO();
        rspBo.setFscOrderIds(reqBO.getFscOrderIds());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void var(FscOrderPO fscOrder) {
        if (fscOrder == null) {
            throw new FscBusinessException("198888", "\u672a\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fe1\u606f");
        }
        if (!FscConstants.FscPayOrderState.TO_AUDIT.equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u4e0b\u624d\u80fd\u53d6\u6d88\u4ed8\u6b3e");
        }
    }

    private void syncContract(Long fscOrderId, FscDealCancelPaymentBusiReqBO reqBO) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(fscOrderId);
        List payItems = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (CollectionUtils.isEmpty((Collection)payItems)) {
            return;
        }
        List shouldPayIds = payItems.stream().map(FscOrderPayItemPO::getShouldPayId).collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayIds(shouldPayIds);
        List shouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            return;
        }
        List updateShouldPayList = shouldPayPOList.stream().map(e -> {
            FscShouldPayPO updateShouldPay = new FscShouldPayPO();
            BeanUtils.copyProperties((Object)e, (Object)updateShouldPay);
            updateShouldPay.setPayingAmount(new BigDecimal(BigInteger.ZERO));
            updateShouldPay.setPaidAmount(new BigDecimal(BigInteger.ZERO));
            updateShouldPay.setToPayAmount(e.getShouldPayAmount());
            return updateShouldPay;
        }).collect(Collectors.toList());
        log.debug("\u4fee\u6539\u91d1\u989dpo\uff1a{}", (Object)JSON.toJSONString(updateShouldPayList));
        this.fscShouldPayMapper.updateAmountBatch(updateShouldPayList);
        ContractSyncSettlementAbilityReqBO contractSyncSettlementAbilityReqBO = new ContractSyncSettlementAbilityReqBO();
        contractSyncSettlementAbilityReqBO.setObjectId(fscOrderId);
        contractSyncSettlementAbilityReqBO.setObjectType(ContractObjectTypeEnum.PRE_PAY.getCode());
        contractSyncSettlementAbilityReqBO.setUserId(reqBO.getUserId());
        ArrayList contractList = new ArrayList();
        shouldPayPOList.forEach(e -> {
            ContractSyncSettlementItemBO syncSettlementItemBO = new ContractSyncSettlementItemBO();
            syncSettlementItemBO.setPayDetailId(e.getObjectId());
            syncSettlementItemBO.setAmt(e.getPayingAmount());
            syncSettlementItemBO.setContractId(e.getContractId());
            contractList.add(syncSettlementItemBO);
        });
        log.debug("\u4fee\u6539\u5408\u540c\u91d1\u989dpo\uff1a{}", (Object)JSON.toJSONString((Object)shouldPayPOList));
        contractSyncSettlementAbilityReqBO.setDeleteList(contractList);
        log.info("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u8c03\u7528\u5408\u540c\u540c\u6b65\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)contractSyncSettlementAbilityReqBO));
        ContractSyncSettlementAbilityRspBO contractSyncSettlementAbilityRspBO = this.contractSyncSettlementAbilityService.modifySettlement(contractSyncSettlementAbilityReqBO);
        log.info("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u8c03\u7528\u5408\u540c\u540c\u6b65\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)contractSyncSettlementAbilityRspBO));
        if (Objects.nonNull(contractSyncSettlementAbilityRspBO) && !"0000".equals(contractSyncSettlementAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u540c\u6b65\u5408\u540c\u6a21\u5757\u7ed3\u7b97\u4fe1\u606f\u5931\u8d25\uff1a" + contractSyncSettlementAbilityRspBO.getRespDesc());
        }
    }
}

