/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.busi.api.FscEngineeringBillPayRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringBillPayRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringBillPayRefundCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscEngineeringBillPayRefundCreateBusiServiceImpl
implements FscEngineeringBillPayRefundCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringBillPayRefundCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u4fee\u6539";
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;

    @Override
    public FscEngineeringBillPayRefundCreateBusiRspBO dealEngineeringPayRefundCreate(FscEngineeringBillPayRefundCreateBusiReqBO reqBO) {
        int count;
        this.checkRefundNo(reqBO.getRefundNo());
        FscOrderRefundPO refundPO = this.buildRefundPayInfo(reqBO);
        this.fscOrderRefundMapper.insert(refundPO);
        List<FscPayShouldRefundPO> fscPayShouldRefundList = this.assembleShouldRefund(reqBO, refundPO);
        if (!CollectionUtils.isEmpty(fscPayShouldRefundList) && (count = this.fscPayShouldRefundMapper.insertBatch(fscPayShouldRefundList)) != fscPayShouldRefundList.size()) {
            throw new FscBusinessException("190000", "\u4fdd\u5b58\u9000\u6b3e\u5e94\u4ed8\u5355\u4fe1\u606f\u5931\u8d25");
        }
        List<FscPayRefundDetailPO> fscPayRefundDetailList = this.assembleRefundDetail(refundPO, reqBO, fscPayShouldRefundList);
        int count2 = this.fscPayRefundDetailMapper.insertBatch(fscPayRefundDetailList);
        if (count2 != fscPayRefundDetailList.size()) {
            throw new FscBusinessException("190000", "\u4fdd\u5b58\u9000\u6b3e\u660e\u7ec6\u5931\u8d25");
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(refundPO.getRefundId());
        fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
        this.fscAttachmentMapper.deleteBy(fscAttachmentPO);
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setFscOrderId(refundPO.getRefundId());
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentPO.setCreateTime(new Date());
                attachmentPO.setCreateUser(reqBO.getName());
                attachmentPO.setFormatType(attachmentBO.getFormatType());
                attachmentPO.setFileSize(attachmentBO.getFileSize());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId())) {
            this.saveFinanceInfo(reqBO, refundPO, fscPayRefundDetailList);
        }
        if (reqBO.getOperationType() == 1) {
            this.dealWorkFlow(refundPO);
        }
        FscEngineeringBillPayRefundCreateBusiRspBO rspBO = new FscEngineeringBillPayRefundCreateBusiRspBO();
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkRefundNo(String refundNo) {
        int count = this.fscOrderRefundMapper.checkRefundNo(refundNo);
        if (count > 0) {
            throw new FscBusinessException("190000", "\u9000\u7968\u5355\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
        }
    }

    private void saveFinanceInfo(FscEngineeringBillPayRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO, List<FscPayRefundDetailPO> refundDetailPOList) {
        Map<Long, FscPayRefundDetailPO> refundDetailMap = refundDetailPOList.stream().collect(Collectors.toMap(FscPayRefundDetailPO::getPayOrderId, o -> o));
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setRefundId(refundPO.getRefundId());
        financePO.setCreateTime(new Date());
        financePO.setCreateUserId(reqBO.getUserId());
        financePO.setCreateUserName(reqBO.getName());
        financePO.setCreateUserAccount(reqBO.getUserName());
        int count = this.fscRefundFinanceMapper.insert(financePO);
        if (count != 1) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<FscFinanceRefundItemPO> refundItemList = new ArrayList<FscFinanceRefundItemPO>(reqBO.getFinanceItemList().size());
        if (!CollectionUtils.isEmpty(reqBO.getFinanceItemList())) {
            HashMap<Long, FscFinancePayItemPO> itemMap = new HashMap<Long, FscFinancePayItemPO>();
            for (FscFinanceRefundItemBO itemBO : reqBO.getFinanceItemList()) {
                FscFinanceRefundItemPO itemPO = new FscFinanceRefundItemPO();
                BeanUtils.copyProperties((Object)itemBO, (Object)itemPO);
                itemPO.setRefundId(refundPO.getRefundId());
                itemPO.setFinanceRefundItemId(Long.valueOf(Sequence.getInstance().nextId()));
                itemPO.setRefundShouldPayId(refundDetailMap.get(itemBO.getPayOrderId()).getRefundShouldPayId());
                itemPO.setRefundDetailId(refundDetailMap.get(itemBO.getPayOrderId()).getRefundDetailId());
                itemPO.setPayOrderId(itemBO.getPayOrderId());
                itemPO.setObjectId(itemBO.getFscOrderId());
                itemPO.setObjectNo(itemBO.getFscOrderNo());
                refundItemList.add(itemPO);
                FscFinancePayItemPO payItemPO = (FscFinancePayItemPO)itemMap.get(itemBO.getPayItemId());
                if (payItemPO == null) {
                    payItemPO = new FscFinancePayItemPO();
                    payItemPO.setFinancePayItemId(itemBO.getPayItemId());
                    payItemPO.setRefundAmt(itemBO.getRefundAmt());
                    payItemPO.setRefundAmtLocal(itemBO.getRefundAmtLocal());
                } else {
                    payItemPO.setRefundAmt(payItemPO.getRefundAmt().add(itemBO.getRefundAmt()));
                    payItemPO.setRefundAmtLocal(payItemPO.getRefundAmtLocal().add(itemBO.getRefundAmtLocal()));
                }
                itemMap.put(itemBO.getPayItemId(), payItemPO);
            }
            ArrayList updateItemList = new ArrayList();
            for (Long key : itemMap.keySet()) {
                updateItemList.add(itemMap.get(key));
            }
            count = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateItemList);
            if (count != updateItemList.size()) {
                throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
            count = this.fscFinanceRefundItemMapper.insertBatch(refundItemList);
            if (count != refundItemList.size()) {
                throw new FscBusinessException("190000", "\u5b58\u50a8\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void dealStartApproval(FscEngineeringBillPayRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M003045");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u9000\u6b3e\u5355\u5ba1\u6279\u6d41\uff01");
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(refundPO.getRefundId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel("\u4ed8\u6b3e\u7533\u8bf7\u5355_");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + refundPO.getRefundNo() + "(\u9000\u6b3e\u7533\u8bf7\u5355\u53f7)\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscOrderRefundMapper.updateById(updatePo);
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus())) {
            paramMap.put("startFlag", 1);
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private FscOrderRefundPO buildRefundPayInfo(FscEngineeringBillPayRefundCreateBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundNo(reqBO.getRefundNo());
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setAgentUserId(reqBO.getAgentUserId());
        refundPO.setAgentUserName(reqBO.getAgentUserName());
        refundPO.setAuditStatus(FscConstants.AuditStatus.SAVE);
        refundPO.setRefundDate(reqBO.getRefundDate());
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setRefundAmount(reqBO.getRefundAmount());
        refundPO.setCreateTime(new Date());
        refundPO.setCreateUserId(reqBO.getUserId());
        refundPO.setCreateUserName(reqBO.getName());
        refundPO.setPushStatus(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_SERVICE_REFUND);
        refundPO.setBillStatus(FscConstants.RefundBillStatus.EFFECTIVE);
        if (reqBO.getOperationType() == 1) {
            refundPO.setRefundStatus(FscConstants.RefundPayOrderState.REFUNDING);
        } else {
            refundPO.setRefundStatus(FscConstants.RefundPayOrderState.DRAFT);
        }
        refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.ENGINEERING_REFUND_PAY.getDescr());
        refundPO.setUserType(reqBO.getUserType());
        refundPO.setBuynerNo(reqBO.getBuynerNo());
        refundPO.setBuynerName(reqBO.getBuynerName());
        refundPO.setSupplierId(reqBO.getSupplierId());
        refundPO.setSupplierName(reqBO.getSupplierName());
        refundPO.setOrderSource(FscOrderSourceEnum.CONTRACT.getCode());
        refundPO.setPayerId(reqBO.getAgentDeptId());
        refundPO.setPayerName(reqBO.getAgentDeptName());
        refundPO.setPayeeId(reqBO.getSupplierId());
        refundPO.setPayeeName(reqBO.getSupplierName());
        refundPO.setIsPushUnify(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
        refundPO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        Long refundId = reqBO.getRefundId();
        if (refundId == null) {
            refundId = Sequence.getInstance().nextId();
            refundPO.setRefundId(refundId);
        }
        reqBO.setRefundId(refundId);
        return refundPO;
    }

    private List<FscPayRefundDetailPO> assembleRefundDetail(FscOrderRefundPO refundPO, FscEngineeringBillPayRefundCreateBusiReqBO reqBO, List<FscPayShouldRefundPO> fscPayShouldRefundList) {
        ArrayList<FscPayRefundDetailPO> fscPayRefundDetailList = new ArrayList<FscPayRefundDetailPO>();
        for (FscPayShouldRefundPO fscPayShouldRefundPO : fscPayShouldRefundList) {
            FscPayRefundDetailPO fscPayRefundDetailPO = new FscPayRefundDetailPO();
            fscPayRefundDetailPO.setRefundDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayRefundDetailPO.setRefundId(refundPO.getRefundId());
            fscPayRefundDetailPO.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
            fscPayRefundDetailPO.setPaidAmt(fscPayShouldRefundPO.getTotalPaidAmount());
            fscPayRefundDetailPO.setBuynerNo(fscPayShouldRefundPO.getBuynerNo());
            fscPayRefundDetailPO.setBuynerName(fscPayShouldRefundPO.getBuynerName());
            fscPayRefundDetailPO.setPayOrderId(fscPayRefundDetailPO.getPayOrderId());
            fscPayRefundDetailPO.setPayOrderNo(fscPayShouldRefundPO.getPayOrderNo());
            fscPayRefundDetailPO.setFscOrderId(fscPayShouldRefundPO.getPayOrderId());
            fscPayRefundDetailPO.setFscOrderNo(fscPayShouldRefundPO.getPayOrderNo());
            fscPayRefundDetailPO.setCreateTime(new Date());
            fscPayRefundDetailPO.setCreateUserId(reqBO.getUserId());
            fscPayRefundDetailPO.setCreateUserName(reqBO.getName());
            fscPayRefundDetailPO.setRefundAmt(fscPayShouldRefundPO.getRefundAmount());
            fscPayRefundDetailList.add(fscPayRefundDetailPO);
            refundPO.setTradeMode(fscPayShouldRefundPO.getTradeMode());
            FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
            fscOrderExtPO.setFscOrderId(fscPayShouldRefundPO.getPayOrderId());
            fscOrderExtPO.setUnifyPushStatus(FscConstants.FscPushStatus.SUCCESS);
            List extPOList = this.fscOrderExtMapper.getList(fscOrderExtPO);
            if (!CollectionUtils.isEmpty((Collection)extPOList)) {
                refundPO.setIsPushUnify(FscConstants.IsPushUnify.PUSH);
            } else {
                refundPO.setIsPushUnify(FscConstants.IsPushUnify.UN_PUSH);
            }
            refundPO.setBuildAction(fscPayShouldRefundPO.getGenerateType());
        }
        return fscPayRefundDetailList;
    }

    private List<FscPayShouldRefundPO> assembleShouldRefund(FscEngineeringBillPayRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        ArrayList<FscPayShouldRefundPO> fscPayShouldRefundPOS = new ArrayList<FscPayShouldRefundPO>();
        Map<Long, List<FscFinanceRefundItemBO>> fscFinanceRefundItemBOS = reqBO.getFinanceItemList().stream().collect(Collectors.groupingBy(FscFinanceRefundItemBO::getFscOrderId));
        List fscOrderIdList = fscFinanceRefundItemBOS.keySet().stream().collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIdList);
        List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        Map<Long, FscOrderPO> fscOrderPOMap = fscOrderPOS.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, o -> o));
        for (Map.Entry<Long, List<FscFinanceRefundItemBO>> entry : fscFinanceRefundItemBOS.entrySet()) {
            List<FscFinanceRefundItemBO> fscFinanceRefundItemBOList = entry.getValue();
            FscPayShouldRefundPO fscPayShouldRefundPO = new FscPayShouldRefundPO();
            fscPayShouldRefundPO.setRefundShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayShouldRefundPO.setPayerId(fscOrderPOMap.get(entry.getKey()).getPayerId());
            fscPayShouldRefundPO.setPayerName(fscOrderPOMap.get(entry.getKey()).getPayerName());
            fscPayShouldRefundPO.setPayeeId(fscOrderPOMap.get(entry.getKey()).getPayeeId());
            fscPayShouldRefundPO.setPayeeName(fscOrderPOMap.get(entry.getKey()).getPayeeName());
            fscPayShouldRefundPO.setRefundNo(refundPO.getRefundNo());
            fscPayShouldRefundPO.setRefundId(refundPO.getRefundId());
            fscPayShouldRefundPO.setSupplierId(fscOrderPOMap.get(entry.getKey()).getPayeeId());
            fscPayShouldRefundPO.setSupplierName(fscOrderPOMap.get(entry.getKey()).getPayeeName());
            fscPayShouldRefundPO.setOrderSource(FscOrderSourceEnum.CONTRACT.getCode());
            fscPayShouldRefundPO.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
            fscPayShouldRefundPO.setRefundType(null);
            fscPayShouldRefundPO.setGenerateType(FscConstants.FscRefundGenerateType.HAND);
            fscPayShouldRefundPO.setTotalPaidAmount(fscOrderPOMap.get(entry.getKey()).getTotalCharge());
            fscPayShouldRefundPO.setRefundAmount(fscFinanceRefundItemBOList.stream().map(FscFinanceRefundItemBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            fscPayShouldRefundPO.setPayingAmount(fscFinanceRefundItemBOList.stream().map(FscFinanceRefundItemBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            fscPayShouldRefundPO.setPaidAmount(BigDecimal.ZERO);
            fscPayShouldRefundPO.setRefundPayStatus(FscConstants.RefundPayOrderState.REFUNDING);
            fscPayShouldRefundPO.setBuynerNo(reqBO.getBuynerNo());
            fscPayShouldRefundPO.setBuynerName(reqBO.getBuynerName());
            fscPayShouldRefundPO.setCreateTime(new Date());
            fscPayShouldRefundPO.setCreateUserId(reqBO.getUserId());
            fscPayShouldRefundPO.setCreateUserName(reqBO.getName());
            fscPayShouldRefundPO.setCreateOrgId(reqBO.getOrgId());
            fscPayShouldRefundPO.setCreateOrgName(reqBO.getOrgName());
            fscPayShouldRefundPO.setIsPushUnify(Integer.valueOf(0));
            fscPayShouldRefundPO.setPayOrderId(fscFinanceRefundItemBOList.get(0).getFscOrderId());
            fscPayShouldRefundPO.setPayOrderNo(fscFinanceRefundItemBOList.get(0).getFscOrderNo());
            fscPayShouldRefundPO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
            fscPayShouldRefundPO.setContractId(fscOrderPOMap.get(entry.getKey()).getContractId());
            fscPayShouldRefundPO.setContractNo(fscOrderPOMap.get(entry.getKey()).getContractNo());
            fscPayShouldRefundPO.setContractName(fscOrderPOMap.get(entry.getKey()).getContractName());
            fscPayShouldRefundPO.setRefundMethod(reqBO.getRefundMethod().toString());
            if (fscPayShouldRefundPO.getTotalPaidAmount().compareTo(fscPayShouldRefundPO.getPayingAmount()) < 0) {
                throw new FscBusinessException("190000", "\u60a8\u7684\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u60a8\u7684\u53ef\u9000\u6b3e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\u3002");
            }
            fscPayShouldRefundPOS.add(fscPayShouldRefundPO);
        }
        return fscPayShouldRefundPOS;
    }
}

