/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.busi.api.FscEngineeringRefundPayConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayConfirmBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscFinancePayRefundConfirmReqBankStatementBusiBO;
import com.tydic.fsc.bill.busi.bo.FscFinancePayRefundConfirmReqDraftInfoBusiBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceOccupyRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleaseRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomBankBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomDraftBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomSupplyBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscEngineeringRefundPayConfirmBusiServiceImpl
implements FscEngineeringRefundPayConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringRefundPayConfirmBusiServiceImpl.class);
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceOccupyRefundInfoAtomService fscFinanceOccupyRefundInfoAtomService;
    @Autowired
    private FscFinanceReleaseRefundInfoAtomService fscFinanceReleaseRefundInfoAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u786e\u8ba4";

    @Override
    public FscEngineeringRefundPayConfirmBusiRspBO dealEngineeringRefundPayConfirm(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscEngineeringRefundPayConfirmBusiRspBO rspBO = new FscEngineeringRefundPayConfirmBusiRspBO();
        FscPayRefundDetailPO fscPayRefundDetailPO = this.getPayRefundDetail(reqBO.getRefundId());
        FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(reqBO.getRefundId());
        FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(reqBO.getRefundId());
        this.initiateFlowApprove(reqBO, fscOrderRefundPO);
        this.updateRefundFinance(reqBO);
        this.dealRefundItemInfo(reqBO);
        this.dealAddFinanceBankStatement(reqBO, fscPayRefundDetailPO);
        this.dealAddFinanceDraftInfo(reqBO, fscPayRefundDetailPO);
        this.occupyRefundInfo(reqBO, fscOrderRefundPO, fscRefundFinancePO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddFinanceBankStatement(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceBankStatement(reqBO, fscPayRefundDetailPO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceBankStatementByTemp(reqBO, fscPayRefundDetailPO);
        }
    }

    private void addFinanceBankStatement(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return;
        }
        List addBankStatementList = JUtil.jsl(reqBO.getBankStatementList(), FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void addFinanceBankStatementByTemp(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        List<FscFinanceBankStatementTempPO> financeBankStatementTempList = this.getFinanceBankStatementTempList(reqBO);
        if (CollectionUtils.isEmpty(financeBankStatementTempList)) {
            return;
        }
        List addBankStatementList = JUtil.jsl(financeBankStatementTempList, FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void dealAddFinanceDraftInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceDraftInfo(reqBO, fscPayRefundDetailPO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceDraftInfoByTemp(reqBO, fscPayRefundDetailPO);
        }
    }

    private void addFinanceDraftInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(reqBO.getDraftInfoList(), FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void addFinanceDraftInfoByTemp(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        List<FscFinanceDraftInfoTempPO> financeDraftTempList = this.getFinanceDraftTempList(reqBO);
        if (CollectionUtils.isEmpty(financeDraftTempList)) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(financeDraftTempList, FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void updateRefundFinance(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setExchangeRate(reqBO.getExchangeRate());
        updateFscRefundFinanceSet.setRefundPayMethod(reqBO.getRefundPayMethod());
        updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDITING);
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(reqBO.getRefundId());
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private void initiateFlowApprove(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        this.invokeUacNoTask(reqBO, fscOrderRefundPO);
        this.dealRefundStatusFlow(fscOrderRefundPO);
    }

    private void invokeUacNoTask(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        if (fscOrderRefundPO.getSettlePlatform() != 3) {
            return;
        }
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("M003045");
        uacNoTaskAuditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getRefundId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(String.valueOf(reqBO.getRefundId()));
        approvalObjBO.setObjName("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2: " + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2: " + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("194203", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5ba1\u6279\u6d41");
        }
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
    }

    private void dealRefundStatusFlow(FscOrderRefundPO fscOrderRefundPO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderRefundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderRefundPO.getRefundStatus());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("confirmFlag", "1");
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private FscPayRefundDetailPO getPayRefundDetail(Long refundId) {
        FscPayRefundDetailPO qryFscPayRefundDetail = new FscPayRefundDetailPO();
        qryFscPayRefundDetail.setRefundId(refundId);
        return this.fscPayRefundDetailMapper.getModelBy(qryFscPayRefundDetail);
    }

    private FscOrderRefundPO getOrderRefund(Long refundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(refundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long refundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(refundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private List<FscFinanceDraftInfoPO> getFinanceDraftList(Long refundId) {
        FscFinanceDraftInfoPO qryFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        qryFscFinanceDraftInfo.setRefundId(refundId);
        return this.fscFinanceDraftInfoMapper.getList(qryFscFinanceDraftInfo);
    }

    private List<FscFinanceBankStatementPO> getFinanceBankStatementList(Long refundId) {
        FscFinanceBankStatementPO qryFscFinanceBankStatement = new FscFinanceBankStatementPO();
        qryFscFinanceBankStatement.setRefundId(refundId);
        return this.fscFinanceBankStatementMapper.getList(qryFscFinanceBankStatement);
    }

    private List<FscFinanceBankStatementTempPO> getFinanceBankStatementTempList(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return null;
        }
        List tempIdList = reqBO.getBankStatementList().stream().map(FscFinancePayRefundConfirmReqBankStatementBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceBankStatementTempPO qryFscFinanceBankStatementTemp = new FscFinanceBankStatementTempPO();
        qryFscFinanceBankStatementTemp.setTempIdList(tempIdList);
        return this.fscFinanceBankStatementTempMapper.getList(qryFscFinanceBankStatementTemp);
    }

    private List<FscFinanceDraftInfoTempPO> getFinanceDraftTempList(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return null;
        }
        List tempIdList = reqBO.getDraftInfoList().stream().map(FscFinancePayRefundConfirmReqDraftInfoBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceDraftInfoTempPO qryFscFinanceDraftInfoTemp = new FscFinanceDraftInfoTempPO();
        qryFscFinanceDraftInfoTemp.setTempIdList(tempIdList);
        return this.fscFinanceDraftInfoTempMapper.getList(qryFscFinanceDraftInfoTemp);
    }

    private void occupyRefundInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO> draftList = new ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomBankBO> bankList = new ArrayList<FscFinanceOccupyRefundInfoAtomBankBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList = new ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO>(1);
        this.packageOccupyRefundInfo(reqBO, draftList, bankList, supplyList);
        FscFinanceOccupyRefundInfoAtomReqBO fscFinanceOccupyRefundInfoAtomReqBO = new FscFinanceOccupyRefundInfoAtomReqBO();
        fscFinanceOccupyRefundInfoAtomReqBO.setObjId(fscOrderRefundPO.getRefundId());
        fscFinanceOccupyRefundInfoAtomReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgId(fscRefundFinancePO.getFinanceOrgId());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgName(fscRefundFinancePO.getFinanceOrgName());
        fscFinanceOccupyRefundInfoAtomReqBO.setDraftList(draftList);
        fscFinanceOccupyRefundInfoAtomReqBO.setBankList(bankList);
        fscFinanceOccupyRefundInfoAtomReqBO.setSupplyList(supplyList);
        fscFinanceOccupyRefundInfoAtomReqBO.setName(reqBO.getName());
        fscFinanceOccupyRefundInfoAtomReqBO.setUserName(reqBO.getUserName());
        fscFinanceOccupyRefundInfoAtomReqBO.setRefundFlag(reqBO.getRefundFlag());
        FscFinanceOccupyRefundInfoAtomRspBO fscFinanceOccupyRefundInfoAtomRspBO = this.fscFinanceOccupyRefundInfoAtomService.dealOccupyRefundInfo(fscFinanceOccupyRefundInfoAtomReqBO);
        if (!fscFinanceOccupyRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceOccupyRefundInfoAtomRspBO.getRespCode(), fscFinanceOccupyRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void packageOccupyRefundInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, List<FscFinanceOccupyRefundInfoAtomDraftBO> draftList, List<FscFinanceOccupyRefundInfoAtomBankBO> bankList, List<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList) {
        List<FscFinanceDraftInfoPO> fscFinanceDraftInfoList = this.getFinanceDraftList(reqBO.getRefundId());
        List<FscFinanceBankStatementPO> financeBankStatementList = this.getFinanceBankStatementList(reqBO.getRefundId());
        for (FscFinanceDraftInfoPO fscFinanceDraftInfoPO : fscFinanceDraftInfoList) {
            if (FscConstants.FinanceDraftType.SUPPLY.equals(fscFinanceDraftInfoPO.getDraftType())) {
                FscFinanceOccupyRefundInfoAtomSupplyBO fscFinanceOccupyRefundInfoAtomSupplyBO = (FscFinanceOccupyRefundInfoAtomSupplyBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomSupplyBO.class);
                supplyList.add(fscFinanceOccupyRefundInfoAtomSupplyBO);
                continue;
            }
            FscFinanceOccupyRefundInfoAtomDraftBO fscFinanceOccupyRefundInfoAtomDraftBO = (FscFinanceOccupyRefundInfoAtomDraftBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomDraftBO.class);
            draftList.add(fscFinanceOccupyRefundInfoAtomDraftBO);
        }
        for (FscFinanceBankStatementPO fscFinanceBankStatementPO : financeBankStatementList) {
            FscFinanceOccupyRefundInfoAtomBankBO fscFinanceOccupyRefundInfoAtomBankBO = (FscFinanceOccupyRefundInfoAtomBankBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceBankStatementPO), FscFinanceOccupyRefundInfoAtomBankBO.class);
            bankList.add(fscFinanceOccupyRefundInfoAtomBankBO);
        }
    }

    private void releaseRefundInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        FscFinanceReleaseRefundInfoAtomReqBO fscFinanceReleaseRefundInfoAtomReqBO = new FscFinanceReleaseRefundInfoAtomReqBO();
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundId(reqBO.getRefundId());
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundNo(fscOrderRefundPO.getRefundNo());
        FscFinanceReleaseRefundInfoAtomRspBO fscFinanceReleaseRefundInfoAtomRspBO = this.fscFinanceReleaseRefundInfoAtomService.dealReleaseRefundInfo(fscFinanceReleaseRefundInfoAtomReqBO);
        if (!fscFinanceReleaseRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceReleaseRefundInfoAtomRspBO.getRespCode(), fscFinanceReleaseRefundInfoAtomRspBO.getRespDesc());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dealRefundItemInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getFinanceItemList())) {
            return;
        }
        FscFinanceRefundItemPO qryFscFinanceRefundItem = new FscFinanceRefundItemPO();
        qryFscFinanceRefundItem.setRefundId(reqBO.getRefundId());
        List fscFinanceRefundItemPOList = this.fscFinanceRefundItemMapper.getList(qryFscFinanceRefundItem);
        HashMap<Long, Object> fscFinancePayItemMap = new HashMap<Long, Object>(1);
        for (Object fscFinanceRefundItemPO : fscFinanceRefundItemPOList) {
            void var7_9;
            FscFinancePayItemPO fscFinancePayItemPO = (FscFinancePayItemPO)fscFinancePayItemMap.get(fscFinanceRefundItemPO.getPayItemId());
            if (ObjectUtil.isEmpty((Object)fscFinancePayItemPO)) {
                FscFinancePayItemPO fscFinancePayItemPO2 = new FscFinancePayItemPO();
                fscFinancePayItemPO2.setFinancePayItemId(fscFinanceRefundItemPO.getPayItemId());
                fscFinancePayItemPO2.setRefundAmt(fscFinanceRefundItemPO.getRefundAmt().negate());
                fscFinancePayItemPO2.setRefundAmtLocal(fscFinanceRefundItemPO.getRefundAmtLocal().negate());
            } else {
                fscFinancePayItemPO.setRefundAmt(fscFinancePayItemPO.getRefundAmt().add(fscFinanceRefundItemPO.getRefundAmt().negate()));
                fscFinancePayItemPO.setRefundAmtLocal(fscFinancePayItemPO.getRefundAmtLocal().add(fscFinanceRefundItemPO.getRefundAmtLocal().negate()));
            }
            fscFinancePayItemMap.put(fscFinanceRefundItemPO.getPayItemId(), var7_9);
        }
        if (!CollectionUtils.isEmpty(fscFinancePayItemMap)) {
            ArrayList updateFscFinancePayItemList = new ArrayList(1);
            for (Long l : fscFinancePayItemMap.keySet()) {
                updateFscFinancePayItemList.add(fscFinancePayItemMap.get(l));
            }
            int rollbackFinancePayItemCount = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateFscFinancePayItemList);
            if (rollbackFinancePayItemCount != updateFscFinancePayItemList.size()) {
                throw new FscBusinessException("190000", "\u56de\u9000\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
        }
        ArrayList<FscFinanceRefundItemPO> fscFinanceRefundItem = new ArrayList<FscFinanceRefundItemPO>(1);
        fscFinancePayItemMap = new HashMap(1);
        for (FscFinanceRefundItemBO fscFinanceRefundItemBO : reqBO.getFinanceItemList()) {
            FscFinanceRefundItemPO fscFinanceRefundItemPO = new FscFinanceRefundItemPO();
            BeanUtils.copyProperties((Object)fscFinanceRefundItemBO, (Object)fscFinanceRefundItemPO);
            fscFinanceRefundItemPO.setRefundId(reqBO.getRefundId());
            fscFinanceRefundItem.add(fscFinanceRefundItemPO);
            FscFinancePayItemPO fscFinancePayItemPO = (FscFinancePayItemPO)fscFinancePayItemMap.get(fscFinanceRefundItemBO.getPayItemId());
            if (ObjectUtil.isEmpty((Object)fscFinancePayItemPO)) {
                fscFinancePayItemPO = new FscFinancePayItemPO();
                fscFinancePayItemPO.setFinancePayItemId(fscFinanceRefundItemBO.getPayItemId());
                fscFinancePayItemPO.setRefundAmt(fscFinanceRefundItemBO.getRefundAmt());
                fscFinancePayItemPO.setRefundAmtLocal(fscFinanceRefundItemBO.getRefundAmtLocal());
            } else {
                fscFinancePayItemPO.setRefundAmt(fscFinancePayItemPO.getRefundAmt().add(fscFinanceRefundItemBO.getRefundAmt()));
                fscFinancePayItemPO.setRefundAmtLocal(fscFinancePayItemPO.getRefundAmtLocal().add(fscFinanceRefundItemBO.getRefundAmtLocal()));
            }
            fscFinancePayItemMap.put(fscFinanceRefundItemBO.getPayItemId(), fscFinancePayItemPO);
        }
        ArrayList updateFscFinancePayItemList = new ArrayList(1);
        for (Long key : fscFinancePayItemMap.keySet()) {
            updateFscFinancePayItemList.add(fscFinancePayItemMap.get(key));
        }
        int n = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateFscFinancePayItemList);
        if (n != updateFscFinancePayItemList.size()) {
            throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
        }
        int occupyFinanceRefundItemCount = this.fscFinanceRefundItemMapper.updateRefundingAmtBatch(fscFinanceRefundItem);
        if (occupyFinanceRefundItemCount != fscFinanceRefundItem.size()) {
            throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
    }
}

