/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillAddPushLogBusiService;
import com.tydic.fsc.bill.busi.api.FscEngineeringRefundPayDeleteBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayDeleteBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayDeleteBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscEngineeringRefundPayDeleteBusiServiceImpl
implements FscEngineeringRefundPayDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringRefundPayDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    private static final String BUSI_NAME = "\u9000\u6b3e\u53d6\u6d88";
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscBillAddPushLogBusiService fscBillAddPushLogBusiService;
    @Value(value="${OPER_ORG_ID:436}")
    private String operOrgId;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;

    @Override
    public FscEngineeringRefundPayDeleteBusiRspBO dealEngineeringRefundPayDelete(FscEngineeringRefundPayDeleteBusiReqBO reqBO) {
        FscEngineeringRefundPayDeleteBusiRspBO rspBO = new FscEngineeringRefundPayDeleteBusiRspBO();
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (refundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355");
        }
        if (!(FscConstants.RefundPayOrderState.TO_COMFIR.equals(refundPO.getRefundStatus()) || FscConstants.RefundPayOrderState.REFUSED.equals(refundPO.getRefundStatus()) || FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus()))) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        List refundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(reqBO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)refundDetailList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u9000\u6b3e\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        ArrayList<FscPayShouldRefundPO> shouldRefundList = new ArrayList<FscPayShouldRefundPO>();
        for (FscPayRefundDetailPO po : refundDetailList) {
            FscPayShouldRefundPO fscPayShouldRefundPO = new FscPayShouldRefundPO();
            fscPayShouldRefundPO.setRefundShouldPayId(po.getRefundShouldPayId());
            fscPayShouldRefundPO.setPayingAmount(po.getRefundAmt().multiply(new BigDecimal(-1)));
            shouldRefundList.add(fscPayShouldRefundPO);
        }
        int count = this.fscPayShouldRefundMapper.updatePayingAmountBatch(shouldRefundList);
        if (count != shouldRefundList.size()) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u5355\u9000\u6b3e\u4e2d\u91d1\u989d\u5931\u8d25");
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("deleteFlag", FscConstants.BillOrderDeleteFlag.DELETE_YES);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setBillStatus(FscConstants.RefundBillStatus.INVALID);
        this.fscOrderRefundMapper.updateById(refundPO);
        FscFinanceRefundItemPO refundQueryVo = new FscFinanceRefundItemPO();
        refundQueryVo.setRefundId(reqBO.getRefundId());
        List refundList = this.fscFinanceRefundItemMapper.getList(refundQueryVo);
        HashMap<Long, FscFinancePayItemPO> payItemMap = new HashMap<Long, FscFinancePayItemPO>();
        for (FscFinanceRefundItemPO refundPayItemPO : refundList) {
            FscFinancePayItemPO payItemPO = (FscFinancePayItemPO)payItemMap.get(refundPayItemPO.getPayItemId());
            if (payItemPO == null) {
                payItemPO = new FscFinancePayItemPO();
                payItemPO.setFinancePayItemId(refundPayItemPO.getPayItemId());
                payItemPO.setRefundAmtLocal(refundPayItemPO.getRefundAmtLocal().negate());
                payItemPO.setRefundAmt(refundPayItemPO.getRefundAmt().negate());
            } else {
                payItemPO.setRefundAmtLocal(payItemPO.getRefundAmtLocal().add(refundPayItemPO.getRefundAmtLocal().negate()));
                payItemPO.setRefundAmt(payItemPO.getRefundAmt().add(refundPayItemPO.getRefundAmt().negate()));
            }
            payItemMap.put(refundPayItemPO.getPayItemId(), payItemPO);
        }
        if (!CollectionUtils.isEmpty(payItemMap)) {
            ArrayList updateItemList = new ArrayList();
            for (Long key : payItemMap.keySet()) {
                updateItemList.add(payItemMap.get(key));
            }
            count = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateItemList);
            if (count != updateItemList.size()) {
                throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

