/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscEngineeringRefundPayUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayUpdateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscEngineeringRefundPayUpdateBusiServiceImpl
implements FscEngineeringRefundPayUpdateBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u4fee\u6539";

    @Override
    public FscEngineeringRefundPayUpdateBusiRspBO dealEngineeringRefundPayUpdate(FscEngineeringRefundPayUpdateBusiReqBO reqBO) {
        int count;
        FscEngineeringRefundPayUpdateBusiRspBO rspBO = new FscEngineeringRefundPayUpdateBusiRspBO();
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (refundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355");
        }
        if (!(FscConstants.RefundPayOrderState.REFUSED.equals(refundPO.getRefundStatus()) || FscConstants.AuditStatus.AUDIT_REJECT.equals(refundPO.getAuditStatus()) || FscConstants.RefundPayOrderState.DRAFT.equals(refundPO.getRefundStatus()))) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        this.fscPayRefundDetailMapper.deleteByRefundId(reqBO.getRefundId());
        refundPO = this.buildRefundPayInfo(reqBO);
        this.fscOrderRefundMapper.updateById(refundPO);
        FscOrderRefundPO newRefundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        List<FscPayShouldRefundPO> fscPayShouldRefundList = this.assembleShouldRefund(reqBO, newRefundPO);
        if (!CollectionUtils.isEmpty(fscPayShouldRefundList) && (count = this.fscPayShouldRefundMapper.insertBatch(fscPayShouldRefundList)) != fscPayShouldRefundList.size()) {
            throw new FscBusinessException("190000", "\u4fdd\u5b58\u9000\u6b3e\u5e94\u4ed8\u5355\u4fe1\u606f\u5931\u8d25");
        }
        this.fscPayRefundDetailMapper.deleteByRefundId(reqBO.getRefundId());
        List<FscPayRefundDetailPO> fscPayRefundDetailList = this.assembleRefundDetail(refundPO, reqBO, fscPayShouldRefundList);
        int count2 = this.fscPayRefundDetailMapper.insertBatch(fscPayRefundDetailList);
        if (count2 != fscPayRefundDetailList.size()) {
            throw new FscBusinessException("190000", "\u4fdd\u5b58\u9000\u6b3e\u660e\u7ec6\u5931\u8d25");
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(refundPO.getRefundId());
        fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
        this.fscAttachmentMapper.deleteBy(fscAttachmentPO);
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setFscOrderId(refundPO.getRefundId());
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentPO.setCreateTime(new Date());
                attachmentPO.setCreateUser(reqBO.getName());
                attachmentPO.setFormatType(attachmentBO.getFormatType());
                attachmentPO.setFileSize(attachmentBO.getFileSize());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId())) {
            this.saveFinanceInfo(reqBO, fscPayRefundDetailList);
        }
        if (reqBO.getOperationType() == 1) {
            this.dealWorkFlow(refundPO);
        }
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscOrderRefundPO buildRefundPayInfo(FscEngineeringRefundPayUpdateBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setRefundDate(reqBO.getRefundDate());
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundAmount(reqBO.getRefundAmount());
        refundPO.setUpdateTime(new Date());
        refundPO.setBillStatus(FscConstants.RefundBillStatus.EFFECTIVE);
        if (reqBO.getOperationType() == 1) {
            refundPO.setRefundStatus(FscConstants.RefundPayOrderState.REFUNDING);
        }
        return refundPO;
    }

    /*
     * WARNING - void declaration
     */
    private void saveFinanceInfo(FscEngineeringRefundPayUpdateBusiReqBO reqBO, List<FscPayRefundDetailPO> refundDetailPOList) {
        Map<Long, FscPayRefundDetailPO> refundDetailMap = refundDetailPOList.stream().collect(Collectors.toMap(FscPayRefundDetailPO::getPayOrderId, o -> o));
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setRefundId(reqBO.getRefundId());
        financePO.setUpdateTime(new Date());
        financePO.setUpdateUserId(reqBO.getUserId());
        financePO.setUpdateUserName(reqBO.getName());
        financePO.setUpdateUserAccount(reqBO.getUserName());
        this.fscRefundFinanceMapper.updateById(financePO);
        FscFinanceRefundItemPO itemQueryVo = new FscFinanceRefundItemPO();
        itemQueryVo.setRefundId(reqBO.getRefundId());
        List itemPoList = this.fscFinanceRefundItemMapper.getList(itemQueryVo);
        HashMap<Long, Object> itemMap = new HashMap<Long, Object>();
        for (Object fscFinanceRefundItemPO : itemPoList) {
            void var10_12;
            FscFinancePayItemPO fscFinancePayItemPO = (FscFinancePayItemPO)itemMap.get(fscFinanceRefundItemPO.getPayItemId());
            if (fscFinancePayItemPO == null) {
                FscFinancePayItemPO fscFinancePayItemPO2 = new FscFinancePayItemPO();
                fscFinancePayItemPO2.setFinancePayItemId(fscFinanceRefundItemPO.getPayItemId());
                fscFinancePayItemPO2.setRefundAmt(fscFinanceRefundItemPO.getRefundAmt().negate());
                fscFinancePayItemPO2.setRefundAmtLocal(fscFinanceRefundItemPO.getRefundAmtLocal().negate());
            } else {
                fscFinancePayItemPO.setRefundAmt(fscFinancePayItemPO.getRefundAmt().add(fscFinanceRefundItemPO.getRefundAmt().negate()));
                fscFinancePayItemPO.setRefundAmtLocal(fscFinancePayItemPO.getRefundAmtLocal().add(fscFinanceRefundItemPO.getRefundAmtLocal().negate()));
            }
            itemMap.put(fscFinanceRefundItemPO.getPayItemId(), var10_12);
        }
        if (!CollectionUtils.isEmpty(itemMap)) {
            ArrayList updateItemList = new ArrayList();
            for (Long l : itemMap.keySet()) {
                updateItemList.add(itemMap.get(l));
            }
            int count = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateItemList);
            if (count != updateItemList.size()) {
                throw new FscBusinessException("190000", "\u56de\u9000\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
        }
        this.fscFinanceRefundItemMapper.deleteByRefundId(reqBO.getRefundId());
        ArrayList<FscFinanceRefundItemPO> refundItemList = new ArrayList<FscFinanceRefundItemPO>(reqBO.getFinanceItemList().size());
        if (!CollectionUtils.isEmpty(reqBO.getFinanceItemList())) {
            itemMap = new HashMap();
            for (FscFinanceRefundItemBO fscFinanceRefundItemBO : reqBO.getFinanceItemList()) {
                FscFinanceRefundItemPO itemPO = new FscFinanceRefundItemPO();
                BeanUtils.copyProperties((Object)fscFinanceRefundItemBO, (Object)itemPO);
                itemPO.setRefundId(reqBO.getRefundId());
                itemPO.setFinanceRefundItemId(Long.valueOf(Sequence.getInstance().nextId()));
                itemPO.setRefundShouldPayId(refundDetailMap.get(fscFinanceRefundItemBO.getPayOrderId()).getRefundShouldPayId());
                itemPO.setRefundDetailId(refundDetailMap.get(fscFinanceRefundItemBO.getPayOrderId()).getRefundDetailId());
                itemPO.setPayOrderId(fscFinanceRefundItemBO.getFscOrderId());
                refundItemList.add(itemPO);
                FscFinancePayItemPO payItemPO = (FscFinancePayItemPO)itemMap.get(fscFinanceRefundItemBO.getPayItemId());
                if (payItemPO == null) {
                    payItemPO = new FscFinancePayItemPO();
                    payItemPO.setFinancePayItemId(fscFinanceRefundItemBO.getPayItemId());
                    payItemPO.setRefundAmt(fscFinanceRefundItemBO.getRefundAmt());
                    payItemPO.setRefundAmtLocal(fscFinanceRefundItemBO.getRefundAmtLocal());
                } else {
                    payItemPO.setRefundAmt(payItemPO.getRefundAmt().add(fscFinanceRefundItemBO.getRefundAmt()));
                    payItemPO.setRefundAmtLocal(payItemPO.getRefundAmtLocal().add(fscFinanceRefundItemBO.getRefundAmtLocal()));
                }
                itemMap.put(fscFinanceRefundItemBO.getPayItemId(), payItemPO);
            }
            ArrayList updateItemList = new ArrayList();
            for (Long key : itemMap.keySet()) {
                updateItemList.add(itemMap.get(key));
            }
            int n = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateItemList);
            if (n != updateItemList.size()) {
                throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
            int n2 = this.fscFinanceRefundItemMapper.insertBatch(refundItemList);
            if (n2 != refundItemList.size()) {
                throw new FscBusinessException("190000", "\u5b58\u50a8\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private List<FscPayShouldRefundPO> assembleShouldRefund(FscEngineeringRefundPayUpdateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        ArrayList<FscPayShouldRefundPO> fscPayShouldRefundPOS = new ArrayList<FscPayShouldRefundPO>();
        Map<Long, List<FscFinanceRefundItemBO>> fscFinanceRefundItemBOS = reqBO.getFinanceItemList().stream().collect(Collectors.groupingBy(FscFinanceRefundItemBO::getFscOrderId));
        List fscOrderIdList = fscFinanceRefundItemBOS.keySet().stream().collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIdList);
        List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        Map<Long, FscOrderPO> fscOrderPOMap = fscOrderPOS.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, o -> o));
        for (Map.Entry<Long, List<FscFinanceRefundItemBO>> entry : fscFinanceRefundItemBOS.entrySet()) {
            List<FscFinanceRefundItemBO> fscFinanceRefundItemBOList = entry.getValue();
            FscPayShouldRefundPO fscPayShouldRefundPO = new FscPayShouldRefundPO();
            fscPayShouldRefundPO.setRefundShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayShouldRefundPO.setPayerId(fscOrderPOMap.get(entry.getKey()).getPayerId());
            fscPayShouldRefundPO.setPayerName(fscOrderPOMap.get(entry.getKey()).getPayerName());
            fscPayShouldRefundPO.setPayeeId(fscOrderPOMap.get(entry.getKey()).getPayeeId());
            fscPayShouldRefundPO.setPayeeName(fscOrderPOMap.get(entry.getKey()).getPayeeName());
            fscPayShouldRefundPO.setRefundNo(refundPO.getRefundNo());
            fscPayShouldRefundPO.setRefundId(refundPO.getRefundId());
            fscPayShouldRefundPO.setSupplierId(fscOrderPOMap.get(entry.getKey()).getPayeeId());
            fscPayShouldRefundPO.setSupplierName(fscOrderPOMap.get(entry.getKey()).getPayeeName());
            fscPayShouldRefundPO.setOrderSource(FscOrderSourceEnum.CONTRACT.getCode());
            fscPayShouldRefundPO.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
            fscPayShouldRefundPO.setRefundType(null);
            fscPayShouldRefundPO.setGenerateType(FscConstants.FscRefundGenerateType.HAND);
            fscPayShouldRefundPO.setTotalPaidAmount(fscOrderPOMap.get(entry.getKey()).getTotalCharge());
            fscPayShouldRefundPO.setRefundAmount(fscFinanceRefundItemBOList.stream().map(FscFinanceRefundItemBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            fscPayShouldRefundPO.setPayingAmount(fscFinanceRefundItemBOList.stream().map(FscFinanceRefundItemBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            fscPayShouldRefundPO.setPaidAmount(BigDecimal.ZERO);
            fscPayShouldRefundPO.setRefundPayStatus(FscConstants.RefundPayOrderState.REFUNDING);
            fscPayShouldRefundPO.setBuynerNo(reqBO.getBuynerNo());
            fscPayShouldRefundPO.setBuynerName(reqBO.getBuynerName());
            fscPayShouldRefundPO.setCreateTime(new Date());
            fscPayShouldRefundPO.setCreateUserId(reqBO.getUserId());
            fscPayShouldRefundPO.setCreateUserName(reqBO.getName());
            fscPayShouldRefundPO.setCreateOrgId(reqBO.getOrgId());
            fscPayShouldRefundPO.setCreateOrgName(reqBO.getOrgName());
            fscPayShouldRefundPO.setIsPushUnify(Integer.valueOf(0));
            fscPayShouldRefundPO.setPayOrderId(fscFinanceRefundItemBOList.get(0).getFscOrderId());
            fscPayShouldRefundPO.setPayOrderNo(fscFinanceRefundItemBOList.get(0).getFscOrderNo());
            fscPayShouldRefundPO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
            fscPayShouldRefundPO.setContractId(fscOrderPOMap.get(entry.getKey()).getContractId());
            fscPayShouldRefundPO.setContractNo(fscOrderPOMap.get(entry.getKey()).getContractNo());
            fscPayShouldRefundPO.setContractName(fscOrderPOMap.get(entry.getKey()).getContractName());
            fscPayShouldRefundPO.setRefundMethod(reqBO.getRefundMethod().toString());
            if (fscPayShouldRefundPO.getTotalPaidAmount().compareTo(fscPayShouldRefundPO.getPayingAmount()) < 0) {
                throw new FscBusinessException("190000", "\u60a8\u7684\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u60a8\u7684\u53ef\u9000\u6b3e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\u3002");
            }
            fscPayShouldRefundPOS.add(fscPayShouldRefundPO);
        }
        return fscPayShouldRefundPOS;
    }

    private List<FscPayRefundDetailPO> assembleRefundDetail(FscOrderRefundPO refundPO, FscEngineeringRefundPayUpdateBusiReqBO reqBO, List<FscPayShouldRefundPO> fscPayShouldRefundList) {
        ArrayList<FscPayRefundDetailPO> fscPayRefundDetailList = new ArrayList<FscPayRefundDetailPO>();
        for (FscPayShouldRefundPO fscPayShouldRefundPO : fscPayShouldRefundList) {
            FscPayRefundDetailPO fscPayRefundDetailPO = new FscPayRefundDetailPO();
            fscPayRefundDetailPO.setRefundDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayRefundDetailPO.setRefundId(refundPO.getRefundId());
            fscPayRefundDetailPO.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
            fscPayRefundDetailPO.setPaidAmt(fscPayShouldRefundPO.getTotalPaidAmount());
            fscPayRefundDetailPO.setBuynerNo(fscPayShouldRefundPO.getBuynerNo());
            fscPayRefundDetailPO.setBuynerName(fscPayShouldRefundPO.getBuynerName());
            fscPayRefundDetailPO.setPayOrderId(fscPayRefundDetailPO.getPayOrderId());
            fscPayRefundDetailPO.setPayOrderNo(fscPayShouldRefundPO.getPayOrderNo());
            fscPayRefundDetailPO.setFscOrderId(fscPayShouldRefundPO.getPayOrderId());
            fscPayRefundDetailPO.setFscOrderNo(fscPayShouldRefundPO.getPayOrderNo());
            fscPayRefundDetailPO.setCreateTime(new Date());
            fscPayRefundDetailPO.setCreateUserId(reqBO.getUserId());
            fscPayRefundDetailPO.setCreateUserName(reqBO.getName());
            fscPayRefundDetailPO.setRefundAmt(fscPayShouldRefundPO.getRefundAmount());
            fscPayRefundDetailList.add(fscPayRefundDetailPO);
            refundPO.setTradeMode(fscPayShouldRefundPO.getTradeMode());
            FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
            fscOrderExtPO.setFscOrderId(fscPayShouldRefundPO.getPayOrderId());
            fscOrderExtPO.setUnifyPushStatus(FscConstants.FscPushStatus.SUCCESS);
            List extPOList = this.fscOrderExtMapper.getList(fscOrderExtPO);
            if (!CollectionUtils.isEmpty((Collection)extPOList)) {
                refundPO.setIsPushUnify(FscConstants.IsPushUnify.PUSH);
            } else {
                refundPO.setIsPushUnify(FscConstants.IsPushUnify.UN_PUSH);
            }
            refundPO.setBuildAction(fscPayShouldRefundPO.getGenerateType());
        }
        return fscPayRefundDetailList;
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus())) {
            paramMap.put("startFlag", 1);
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }
}

