/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceUpdateSettleRefundInvoiceTempDetailBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceUpdateSettleRefundInvoiceTempReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceUpdateSettleRefundInvoiceTempRspBO;
import com.tydic.fsc.bill.ability.bo.finance.FscSettleRefundInvoiceTempDetailBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinanceSettleRefundInvoiceTempUpdateBatchBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscInvoiceTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscInvoiceTempPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceSettleRefundInvoiceTempUpdateBatchBusiServiceImpl
implements FscFinanceSettleRefundInvoiceTempUpdateBatchBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSettleRefundInvoiceTempUpdateBatchBusiServiceImpl.class);
    @Autowired
    private FscInvoiceTempMapper fscInvoiceTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Resource
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;

    @Override
    public FscFinanceUpdateSettleRefundInvoiceTempRspBO dealSettleRefundInvoiceTempUpdateBatch(FscFinanceUpdateSettleRefundInvoiceTempReqBO reqBO) {
        this.valid(reqBO);
        for (FscSettleRefundInvoiceTempDetailBO detailBO : reqBO.getDetailBOList()) {
            if (CollectionUtils.isEmpty((Collection)detailBO.getInvoiceTempList())) continue;
            List proInvoiceId = detailBO.getInvoiceTempList().stream().map(FscFinanceUpdateSettleRefundInvoiceTempDetailBO::getPreInvoiceId).collect(Collectors.toList());
            FscInvoiceRefundRelationPO fscInvoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
            fscInvoiceRefundRelationPO.setRefundId(detailBO.getRefundId());
            fscInvoiceRefundRelationPO.setInvoiceIds(proInvoiceId);
            List fscInvoiceRefundRelationPOList = this.fscInvoiceRefundRelationMapper.getList(fscInvoiceRefundRelationPO);
            if (CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationPOList)) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u539f\u7968\u5173\u8054\u7684\u9000\u7968\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u5165\u53c2\uff01");
            }
            Map invoiceRefundRelationPOMap = fscInvoiceRefundRelationPOList.stream().collect(Collectors.toMap(FscInvoiceRefundRelationPO::getInvoiceId, Function.identity(), (k1, k2) -> k1));
            detailBO.getInvoiceTempList().forEach(e -> {
                if (CollectionUtils.isEmpty((Map)invoiceRefundRelationPOMap) || !invoiceRefundRelationPOMap.containsKey(e.getPreInvoiceId())) {
                    throw new FscBusinessException("198888", "\u7ea2\u5b57\u53d1\u7968\u672a\u67e5\u8be2\u5230\u539f\u53d1\u7968\u4fe1\u606f\u3002");
                }
                if (Objects.nonNull(invoiceRefundRelationPOMap.get(e.getPreInvoiceId())) && ((FscInvoiceRefundRelationPO)invoiceRefundRelationPOMap.get(e.getPreInvoiceId())).getRefundAmt().compareTo(e.getAmt()) != 0) {
                    throw new FscBusinessException("198888", "\u7ea2\u5b57\u53d1\u7968\u91d1\u989d\u4e0d\u7b49\u4e8e\u9000\u7968\u91d1\u989d!\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5f00\u7968\u91d1\u989d\u3002");
                }
            });
        }
        for (FscSettleRefundInvoiceTempDetailBO detailBO : reqBO.getDetailBOList()) {
            if (detailBO.getTempId() == null || detailBO.getContractId() == null) continue;
            this.fscInvoiceTempMapper.deleteBatchByTempId(detailBO.getTempId(), detailBO.getContractId());
            this.fscOrderRelationTempMapper.deleteBatchByTempId(detailBO.getTempId(), detailBO.getContractId());
            this.fscAttachmentTempMapper.deleteByTempIdAndAttachmentTypeAndContractId(Collections.singletonList(detailBO.getTempId()), FscConstants.AttachmentType.REFUND_RED_INVOICE, detailBO.getContractId());
        }
        ArrayList fscInvoiceTempPOUpdateList = new ArrayList();
        ArrayList fscAttachmentTempPOUpdateList = new ArrayList();
        ArrayList abnormalOrderRelationTempPOUpdateList = new ArrayList();
        for (FscSettleRefundInvoiceTempDetailBO detailBO : reqBO.getDetailBOList()) {
            String attachmentString;
            List attachmentTempPOList;
            String abnormalTempString;
            List fscOrderRelationTempPOList;
            String invoiceTempString;
            List invoiceTempPOList;
            if (!CollectionUtils.isEmpty((Collection)detailBO.getInvoiceTempList()) && !CollectionUtils.isEmpty((Collection)(invoiceTempPOList = JSONObject.parseArray((String)(invoiceTempString = JSONObject.toJSONString((Object)detailBO.getInvoiceTempList())), FscInvoiceTempPO.class)))) {
                invoiceTempPOList.stream().forEach(invoiceTempPO -> {
                    invoiceTempPO.setTempId(detailBO.getTempId());
                    invoiceTempPO.setContractId(detailBO.getContractId());
                    invoiceTempPO.setFscOrderId(detailBO.getFscOrderId());
                    invoiceTempPO.setRefundId(detailBO.getRefundId());
                    if (invoiceTempPO.getInvoiceId() == null) {
                        invoiceTempPO.setCreateTime(new Date());
                        invoiceTempPO.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
                    }
                });
                fscInvoiceTempPOUpdateList.addAll(invoiceTempPOList);
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getAbnormalList()) && !CollectionUtils.isEmpty((Collection)(fscOrderRelationTempPOList = JSONObject.parseArray((String)(abnormalTempString = JSONObject.toJSONString((Object)detailBO.getAbnormalList())), FscOrderRelationTempPO.class)))) {
                fscOrderRelationTempPOList.stream().forEach(orderRelationTempPO -> {
                    orderRelationTempPO.setTempId(detailBO.getTempId());
                    orderRelationTempPO.setFscOrderId(detailBO.getFscOrderId());
                    orderRelationTempPO.setRefundId(detailBO.getRefundId());
                    orderRelationTempPO.setContractId(detailBO.getContractId());
                    if (orderRelationTempPO.getId() == null) {
                        orderRelationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    }
                });
                abnormalOrderRelationTempPOUpdateList.addAll(fscOrderRelationTempPOList);
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getAttachmentList()) || CollectionUtils.isEmpty((Collection)(attachmentTempPOList = JSONObject.parseArray((String)(attachmentString = JSONObject.toJSONString((Object)detailBO.getAttachmentList())), FscAttachmentTempPO.class)))) continue;
            attachmentTempPOList.stream().forEach(attachmentTempPO -> {
                if (Objects.isNull(attachmentTempPO.getAttachmentId())) {
                    attachmentTempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                }
                attachmentTempPO.setFscOrderId(detailBO.getTempId());
                attachmentTempPO.setObjId(detailBO.getContractId());
                attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_RED_INVOICE);
                attachmentTempPO.setObjType(FscConstants.AttachmentType.REFUND_RED_INVOICE);
            });
            fscAttachmentTempPOUpdateList.addAll(attachmentTempPOList);
        }
        if (!CollectionUtils.isEmpty(fscInvoiceTempPOUpdateList)) {
            this.fscInvoiceTempMapper.insertOrUpdateBatch(fscInvoiceTempPOUpdateList);
        }
        if (!CollectionUtils.isEmpty(fscAttachmentTempPOUpdateList)) {
            this.fscAttachmentTempMapper.insertOrUpdateBatch(fscAttachmentTempPOUpdateList);
        }
        if (!CollectionUtils.isEmpty(abnormalOrderRelationTempPOUpdateList)) {
            this.fscOrderRelationTempMapper.insertOrUpdateBatch(abnormalOrderRelationTempPOUpdateList);
        }
        FscFinanceUpdateSettleRefundInvoiceTempRspBO rspBO = new FscFinanceUpdateSettleRefundInvoiceTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceUpdateSettleRefundInvoiceTempReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailBOList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6570\u636e\u96c6\u5408[detailBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscSettleRefundInvoiceTempDetailBO detailBO : reqBO.getDetailBOList()) {
            if (detailBO.getTempId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getFscOrderId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getRefundId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u7968\u5355ID[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (detailBO.getContractId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getInvoiceTempList())) continue;
            for (FscFinanceUpdateSettleRefundInvoiceTempDetailBO invoiceTempDetailBO : detailBO.getInvoiceTempList()) {
                if (invoiceTempDetailBO.getPreInvoiceId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u539f\u53d1\u7968ID[preInvoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getInvoiceNo() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u53f7\u7801[InvoiceNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getInvoiceCode() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u4ee3\u7801[invoiceCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getBuyName() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u62ac\u5934[buyName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getInvoiceType() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getAmt() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u603b\u91d1\u989d\uff08\u539f\u5e01\uff09[amt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getUntaxAmt() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u539f\u5e01\uff09[untaxAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getTaxAmt() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7a0e\u989d\uff08\u539f\u5e01\uff09[taxAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (invoiceTempDetailBO.getUntaxAmt().add(invoiceTempDetailBO.getTaxAmt()).compareTo(invoiceTempDetailBO.getAmt()) == 0) continue;
                throw new FscBusinessException("198888", "\u7ea2\u5b57\u53d1\u7968\u7a0e\u989d\u52a0\u4e0a\u4e0d\u542b\u7a0e\u989d\u4e0d\u7b49\u4e8e\u53d1\u7968\u91d1\u989d!\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5f00\u7968\u91d1\u989d\u3002");
            }
        }
    }
}

