/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscDraftAbilityBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayPrintService;
import com.tydic.fsc.pay.ability.bo.FscPayManagerPrintReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayManagerPrintRspBO;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.common.ability.api.UocMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocMainOrderDetailQueryRspBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayPrintService"})
public class FscPayPrintServiceImpl
implements FscPayPrintService {
    private static final Logger log = LoggerFactory.getLogger(FscPayPrintServiceImpl.class);
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${saleOrderTabId:30001}")
    private Integer TAB_ID;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private DycStationSelectService dycStationSelectService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Autowired
    private UocMainOrderDetailQueryAbilityService uocMainOrderDetailQueryAbilityService;

    @PostMapping(value={"fscPayPrint"})
    public FscPayManagerPrintRspBO fscPayPrint(@RequestBody FscPayManagerPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> list = this.addPdfTable(reqBO);
        PdfUtils.addTableListToDoc((Document)document, list);
        document.close();
        if (reqBO.getMergerFlag().booleanValue()) {
            FscPayManagerPrintRspBO rspBO = new FscPayManagerPrintRspBO();
            rspBO.setByteArrayOutputStream(byteArrayOutputStream);
            return rspBO;
        }
        String pdfUrl = this.uploadFile("\u4ed8\u6b3e\u5355", byteArrayOutputStream);
        return new FscPayManagerPrintRspBO(pdfUrl, fscOrderPo.getOrderNo(), null);
    }

    private String createBillPdfPrint(FscPayManagerPrintReqBO reqBO) {
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> list = this.addPdfTable(reqBO);
        PdfUtils.addTableListToDoc((Document)document, list);
        document.close();
        return this.uploadFile("\u4ed8\u6b3e\u5355", byteArrayOutputStream);
    }

    private List<PdfPTable> addPdfTable(FscPayManagerPrintReqBO reqBO) {
        FscComOrderDetailQueryAbilityReqBO orderDetailReqBO = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailReqBO.setOrderId(reqBO.getOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailReqBO);
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = new ContractDetailQueryAbilityRspBO();
        if (CheckUtils.isNotBlank((Object)orderDetail.getContractId())) {
            ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
            contractDetailQueryAbilityReqBO.setContractId(orderDetail.getContractId());
            contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
        }
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(1));
        if (orderDetail.getShouldPayMethod() == 2 && !StringUtils.isEmpty((Object)orderDetail.getInspExecution()) && "2".equals(orderDetail.getInspExecution()) && Objects.nonNull(orderDetail.getSettleId())) {
            fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(orderDetail.getSettleId());
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(6));
        }
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, orderDetail, reqBO);
        this.addMiddleTable(tableList, orderDetail, contractDetailQueryAbilityRspBO);
        this.addAuditTable(tableList, approvalList);
        return tableList;
    }

    public void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO fscComOrderDetailQueryAbilityRspBO, FscPayManagerPrintReqBO reqBO) {
        boolean settlePlatFlag;
        String orgName = "\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8";
        String deptName = fscComOrderDetailQueryAbilityRspBO.getCreateOrgName();
        boolean bl = settlePlatFlag = Objects.nonNull(fscComOrderDetailQueryAbilityRspBO.getSettlePlatform()) && fscComOrderDetailQueryAbilityRspBO.getSettlePlatform() == 2;
        if (settlePlatFlag) {
            FscOrderExtPO extPO = new FscOrderExtPO();
            extPO.setFscOrderId(fscComOrderDetailQueryAbilityRspBO.getFscOrderId());
            FscOrderExtPO modelBy = this.fscOrderExtMapper.getModelBy(extPO);
            if (Objects.nonNull(modelBy.getUnifyOrgName())) {
                orgName = modelBy.getUnifyOrgName();
            }
            if (Objects.nonNull(modelBy.getUnifyDeptName())) {
                deptName = orgName + " - " + modelBy.getUnifyDeptName();
            }
        }
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)fscComOrderDetailQueryAbilityRspBO.getPayerName(), (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)23, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)("\u9644\u4ef6" + (fscComOrderDetailQueryAbilityRspBO.getAttachmentList() == null ? 0 : fscComOrderDetailQueryAbilityRspBO.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)1, null);
        tableList.add(titleTable1);
        String typeStr = "\u91c7\u8d2d\u5e94\u4ed8\u6b3e\u5355";
        if (fscComOrderDetailQueryAbilityRspBO.getShouldPayMethod() == 0) {
            typeStr = "\u91c7\u8d2d\u9884\u4ed8\u6b3e\u5355";
        }
        tableList.add(this.dealColor(fscComOrderDetailQueryAbilityRspBO, typeStr, reqBO));
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u90e8\u95e8\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)(deptName == null ? "-" : deptName), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)(fscComOrderDetailQueryAbilityRspBO.getCreateOperName() == null ? "-" : fscComOrderDetailQueryAbilityRspBO.getCreateOperName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        tableList.add(pageTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderItemDetail, ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO) {
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4ed8\u6b3e\u7f16\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)(orderItemDetail.getOrderNo() == null ? "-" : orderItemDetail.getOrderNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4ed8\u6b3e\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)(orderItemDetail.getOrderName() == null ? "-" : orderItemDetail.getOrderName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4e1a\u52a1\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        List shouldPayBOList = this.fscShouldPayMapper.getByFscOrderId(orderItemDetail.getFscOrderId());
        String fscTypeStr = "-";
        if (!CollectionUtils.isEmpty((Collection)shouldPayBOList)) {
            if (((FscShouldPayPO)shouldPayBOList.get(0)).getOrderType() != null) {
                Map<String, Map<String, String>> dicMap = this.getDicMap();
                fscTypeStr = dicMap.get("FSC_TYPE").get(orderItemDetail.getOrderType() + "");
            }
            if (Objects.nonNull(orderItemDetail.getSettlePlatform()) && orderItemDetail.getSettlePlatform() == 2) {
                fscTypeStr = "\u81ea\u9700\u91c7\u8d2d";
            }
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)fscTypeStr, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable4);
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)FscStringUtils.convertValueCopy((Object)contractDetailQueryAbilityRspBO.getContractCode()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)FscStringUtils.convertValueCopy((Object)contractDetailQueryAbilityRspBO.getContractName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)12, null);
        tableList.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        String paymentMethodStr = "-";
        if (orderItemDetail.getPaymentMethod() != null) {
            if (orderItemDetail.getPaymentMethod() == 1) {
                paymentMethodStr = "\u94f6\u884c\u652f\u4ed8";
            } else if (orderItemDetail.getPaymentMethod() == 2) {
                paymentMethodStr = "\u6c47\u7968\u652f\u4ed8";
            }
        }
        UocMainOrderDetailQueryReqBO saleDetailsReqBO = new UocMainOrderDetailQueryReqBO();
        saleDetailsReqBO.setOrderId(((FscShouldPayPO)shouldPayBOList.get(0)).getOrderId());
        saleDetailsReqBO.setQueryLevelList(Collections.singletonList(3));
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocMainOrderDetailQueryRspBO saleDetailsRspBO = this.uocMainOrderDetailQueryAbilityService.getUocMainOrderDetailQuery(saleDetailsReqBO);
        if (!"0000".equals(saleDetailsRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        String catt = "-";
        if (saleDetailsRspBO.getOrdAgreementRspBO() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)saleDetailsRspBO.getOrdAgreementRspBO().getAgreementId())) {
            AgrAgreementBO agrAgreementBO;
            AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
            agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(Long.valueOf(saleDetailsRspBO.getOrdAgreementRspBO().getAgreementId()));
            agrQryAgreementSubjectDetailsAbilityReqBO.setTranslateFlag(Boolean.valueOf(false));
            agrQryAgreementSubjectDetailsAbilityReqBO.setQueryAttachmentFlag(Boolean.valueOf(false));
            agrQryAgreementSubjectDetailsAbilityReqBO.setQueryScopeFlag(Boolean.valueOf(false));
            AgrQryAgreementSubjectDetailsAbilityRspBO agrQryAgreementSubjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
            if (agrQryAgreementSubjectDetailsAbilityRspBO != null && agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(agrAgreementBO = agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO()).getCategory())) {
                catt = agrAgreementBO.getCategory();
            }
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u54c1\u7c7b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)catt, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u4ed8\u6b3e\u65b9\u5f0f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)paymentMethodStr, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5b9e\u9645\u6536\u6b3e\u5355\u4f4d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)FscStringUtils.convertValueCopy((Object)orderItemDetail.getPayeeAccountName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable6);
        PdfPTable pageTable7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u5e01\u79cd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u4eba\u6c11\u5e01", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u6c47\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d(\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)orderItemDetail.getTotalCharge()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable7);
        PdfPTable pageTable8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u4ed8\u6b3e\u8bf4\u660e", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)FscStringUtils.convertValueCopy((Object)orderItemDetail.getRemark()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable8);
        PdfPTable pageTable9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u6536\u6b3e\u8d26\u6237\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(pageTable9);
        PdfPTable pageTable10 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u5b9e\u9645\u6536\u6b3e\u5355\u4f4d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u5f00\u6237\u94f6\u884c", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable10);
        PdfPTable pageTable11 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)orderItemDetail.getPayeeName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)orderItemDetail.getPayeeAccountName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)orderItemDetail.getPayeeBankName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)orderItemDetail.getPayeeBankAccount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable11);
        PdfPTable pageTable12 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)"\u4ed8\u6b3e\u4f9d\u636e\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(pageTable12);
        PdfPTable pageTable13 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u4ed8\u6b3e\u4f9d\u636e\u5355\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u4ed8\u6b3e\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u5355\u636e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u5df2\u4ed8\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable13);
        PdfPTable pageTable14 = PdfUtils.newPdfTable();
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (int i = 0; i < shouldPayBOList.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)shouldPayBOList.get(i);
            if (fscShouldPayPO.getSettleId() != null) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscShouldPayPO.getSettleId());
                FscOrderPO modelBy = this.fscOrderMapper.getModelBy(fscOrderPO);
                fscShouldPayPO.setObjectNo(modelBy.getOrderNo());
            }
            String shouldpayMethodStr = "-";
            if (fscShouldPayPO.getShouldPayMethod() != null) {
                if (fscShouldPayPO.getShouldPayMethod() == 0) {
                    shouldpayMethodStr = "\u9884\u4ed8\u6b3e";
                } else if (fscShouldPayPO.getShouldPayMethod() == 2) {
                    shouldpayMethodStr = "\u5e94\u4ed8\u6b3e";
                }
            }
            PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)fscShouldPayPO.getObjectNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)shouldpayMethodStr, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)fscShouldPayPO.getShouldPayAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)this.dealDecimal(fscShouldPayPO.getShouldPayAmount(), fscShouldPayPO.getPayAmount()).setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)fscShouldPayPO.getPayAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            totalAmt = totalAmt.add(fscShouldPayPO.getPayAmount());
        }
        tableList.add(pageTable14);
        PdfPTable pageTable15 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)16, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)totalAmt.setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable15);
        List operateCapitalPlanList = this.fscOperateCapitalPlanMapper.getListByFscOrderId(orderItemDetail.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)operateCapitalPlanList)) {
            PdfPTable pageTable16 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)"\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
            tableList.add(pageTable16);
            PdfPTable pageTable17 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u671f\u95f4", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u8d44\u91d1\u9879\u76ee", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u8d44\u91d1\u8ba1\u5212\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u8d44\u91d1\u8ba1\u5212\u4f59\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672c\u6b21\u6267\u884c\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable17);
            PdfPTable pageTable18 = PdfUtils.newPdfTable();
            for (int i = 0; i < operateCapitalPlanList.size(); ++i) {
                FscOperateCapitalPlanPO fscOperateCapitalPlanPO = (FscOperateCapitalPlanPO)operateCapitalPlanList.get(i);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)fscOperateCapitalPlanPO.getPeriod(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)fscOperateCapitalPlanPO.getItemName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)fscOperateCapitalPlanPO.getPlanAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)fscOperateCapitalPlanPO.getAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)fscOperateCapitalPlanPO.getUseAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            }
            tableList.add(pageTable18);
        }
        if (FscConstants.FscPaymentMethod.INVOICE_PAY.equals(orderItemDetail.getPaymentMethod())) {
            PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u7968\u636e\u660e\u7ec6", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
            tableList.add(pageTableAuditTitle);
            PdfPTable pageTableAudit = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u7535\u5b50\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u51fa\u7968\u65e5", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5230\u671f\u65e5", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u627f\u5151\u4eba\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u7968\u9762\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTableAudit);
            List draftList = orderItemDetail.getDraftList();
            BigDecimal totalDraftAmt = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)draftList)) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                for (int i = 0; i < draftList.size(); ++i) {
                    PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)String.valueOf(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscDraftAbilityBO)draftList.get(i)).getDraftNumber()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscDraftAbilityBO)draftList.get(i)).getDraftDate()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscDraftAbilityBO)draftList.get(i)).getDueDate()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)((FscDraftAbilityBO)draftList.get(i)).getAcceptorName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)new BigDecimal(((FscDraftAbilityBO)draftList.get(i)).getDraftAmount())), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                    totalDraftAmt = totalDraftAmt.add(new BigDecimal(((FscDraftAbilityBO)draftList.get(i)).getDraftAmount()));
                }
                tableList.add(auditTable);
            }
            PdfPTable pageTable19 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable19, (Object)"\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable19, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)16, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable19, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)totalDraftAmt), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable19);
        }
    }

    public void addAuditTable(List<PdfPTable> tableList, List<FscApprovalprocessListBO> auditList) {
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u7b7e\u5b57\u5ba1\u6279", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
        tableList.add(pageTableAuditTitle);
        PdfPTable pageTableAudit = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u65f6\u95f4", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u8282\u70b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u72b6\u6001", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u610f\u89c1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTableAudit);
        if (!CollectionUtils.isEmpty(auditList)) {
            for (int i = 0; i < auditList.size(); ++i) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)String.valueOf(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getStationName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getOperName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAudit()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAdvice()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(auditTable);
            }
        }
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u53d1\u8d77\u5ba1\u6279");
        for (int i = 1; i < approvalList.size(); ++i) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)approvalList.get(i).getStepName())) {
                approvalList.get(i).setStationName(approvalList.get(i).getStepName());
                continue;
            }
            approvalList.get(i).setStationName("\u53d1\u8d77\u5ba1\u6279");
        }
        log.info("\u4e8c\u6b21\u5904\u7406\u4fe1\u606f\u4eba\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014:" + approvalList.toString());
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private PdfPTable dealColor(FscComOrderDetailQueryAbilityRspBO abilityRspBO, String typeStr, FscPayManagerPrintReqBO reqBO) {
        log.info("\u662f\u5426\u5bf9\u63a5\u65b0\u4e1a\u8d22:" + abilityRspBO.getSettlePlatform());
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        Integer pushResult = 0;
        if (abilityRspBO.getSettlePlatform() != null && abilityRspBO.getSettlePlatform() == 2) {
            FscPurchasePushLogPo po = new FscPurchasePushLogPo();
            po.setObjectId(abilityRspBO.getFscOrderId());
            po.setType(FscConstants.OrderFlow.PAY);
            po.setOrderBy("create_time desc");
            po.setPushStatus(Integer.valueOf(1));
            List modelBy = this.fscPurchasePushLogMapper.getList(po);
            if (!CollectionUtils.isEmpty((Collection)modelBy) && ((FscPurchasePushLogPo)modelBy.get(0)).getPushStatus() != null) {
                pushResult = ((FscPurchasePushLogPo)modelBy.get(0)).getPushStatus();
            }
        } else {
            FscPushLogPO pushLogPO = new FscPushLogPO();
            pushLogPO.setObjectId(abilityRspBO.getFscOrderId());
            pushLogPO.setType(FscConstants.OrderFlow.PAY);
            pushLogPO.setStatus(Integer.valueOf(1));
            FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(pushLogPO);
            if (lastPushLog != null && lastPushLog.getStatus() != null) {
                pushResult = lastPushLog.getStatus();
            }
        }
        PdfPCell cell1 = new PdfPCell();
        Paragraph paragraph = new Paragraph();
        paragraph.add((Element)new Chunk(typeStr, PdfUtils.DEFAULT_TITLE_FONT));
        if (pushResult != 1 && (StringUtils.isEmpty((Object)reqBO.getIsprofess()) || "0".equals(reqBO.getIsprofess()))) {
            paragraph.add((Element)new Chunk("(\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u4ec5\u4f9b\u9884\u89c8\u4f7f\u7528)", PdfUtils.DEFAULT_TITLE_FONT_RED));
        }
        paragraph.setAlignment(1);
        cell1.addElement((Element)paragraph);
        cell1.setColspan(24);
        cell1.setFixedHeight(40.0f);
        cell1.setVerticalAlignment(5);
        pageTable2.addCell(cell1);
        return pageTable2;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("FSC_TYPE");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }

    private BigDecimal dealDecimal(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null) {
            bigDecimal1 = BigDecimal.ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        return bigDecimal1.subtract(bigDecimal2);
    }

    @Autowired
    public void setFileClient(FileClient fileClient) {
        this.fileClient = fileClient;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }

    @Autowired
    public void setContractDetailQueryAbilityService(ContractDetailQueryAbilityService contractDetailQueryAbilityService) {
        this.contractDetailQueryAbilityService = contractDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }
}

