/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.finance.FscEngineeringReopenInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillReopenInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillReopenInvoiceAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringReopenInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscEngineeringReopenInvoiceAbilityService"})
public class FscEngineeringReopenInvoiceAbilityServiceImpl
implements FscEngineeringReopenInvoiceAbilityService {
    @Autowired
    private FscEngineeringReopenInvoiceBusiService fscEngineeringReopenInvoiceBusiService;
    @Resource
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @PostMapping(value={"dealEngineeringInvoiceReopen"})
    public FscBillReopenInvoiceAbilityRspBO dealEngineeringInvoiceReopen(@RequestBody FscBillReopenInvoiceAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_NOT_CHECK);
        if (Objects.isNull(reqBO.getNewFscOrderId())) {
            this.checkReopen(reqBO.getRefundId(), refundPO.getMakeType(), refundPO.getReceiveType());
        }
        List<String> serial = this.getSerial(FscBillInvoiceSerial.ENGINEERING_CONTRACT_NO.getCode(), 1);
        FscBillReopenInvoiceBusiReqBO busiReqBO = (FscBillReopenInvoiceBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillReopenInvoiceBusiReqBO.class));
        busiReqBO.setParamMap(paramMap);
        busiReqBO.setFscOrderNo(serial.get(0));
        busiReqBO.setFscOrderId(refundPO.getFscOrderId());
        busiReqBO.setToPayAmount(refundPO.getToPayAmount());
        busiReqBO.setShouldPayAmount(refundPO.getShouldPayAmount());
        busiReqBO.setSettlePlatform(refundPO.getSettlePlatform());
        FscBillReopenInvoiceBusiRspBO busiRspBO = this.fscEngineeringReopenInvoiceBusiService.dealEngineeringInvoiceReopen(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        this.sendMq((Long)busiRspBO.getFscOrderIds().get(0), reqBO.getRefundId());
        FscBillReopenInvoiceAbilityRspBO rspBO = new FscBillReopenInvoiceAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkReopen(Long refundId, Integer makeType, Integer receiveType) {
        int count = this.fscOrderRefundMapper.checkInvoiceReopen(refundId, makeType, receiveType);
        if (count != 0) {
            throw new FscBusinessException("198888", "\u5df2\u5b58\u5728\u91cd\u5f00\u7ed3\u7b97\u5355,\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\uff01");
        }
    }

    private void sendMq(Long fscOrderId, Long refundId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u751f\u6210\u7ed3\u7b97\u5355\u7f16\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void valid(FscBillReopenInvoiceAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getRefundId())) {
            throw new FscBusinessException("198888", "refundId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOperType())) {
            throw new FscBusinessException("198888", "\u5165\u53c2operType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

