/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceEngineeringInvoiceItemListQryAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceEngineeringInvoiceItemListQryAbilityBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceEngineeringInvoiceItemListQryAbilityServiceReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceEngineeringInvoiceItemListQryAbilityService"})
public class FscFinanceEngineeringInvoiceItemListQryAbilityServiceImpl
implements FscFinanceEngineeringInvoiceItemListQryAbilityService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;

    @PostMapping(value={"qryEngineeringInvoiceItemList"})
    public FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO qryEngineeringInvoiceItemList(@RequestBody FscFinanceEngineeringInvoiceItemListQryAbilityServiceReqBO reqBO) {
        this.checkInput(reqBO);
        FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderItemPO.class);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscOrderItemMapper.financeWriteOffAdjustQryPage(fscOrderItemPO, page);
        List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscFinanceEngineeringInvoiceItemListQryAbilityBO.class);
        FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO rspBO = new FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO();
        FscOrderItemPO fscOrderItemPO1 = this.fscOrderItemMapper.getAmt(fscOrderItemPO);
        if (fscOrderItemPO1 != null) {
            rspBO.setAmtTotal(fscOrderItemPO1.getAmtTotal() != null ? fscOrderItemPO1.getAmtTotal() : BigDecimal.ZERO);
            rspBO.setUntaxAmtTotal(fscOrderItemPO1.getUntaxAmtTotal() != null ? fscOrderItemPO1.getUntaxAmtTotal() : BigDecimal.ZERO);
            rspBO.setContractLeaveInvoiceAmtTotal(fscOrderItemPO1.getContractLeaveInvoiceAmtTotal() != null ? fscOrderItemPO1.getContractLeaveInvoiceAmtTotal() : BigDecimal.ZERO);
        }
        if (reqBO.getContractId() != null) {
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentPO.setObjId(reqBO.getContractId());
            List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOList)) {
                rspBO.setAttachmentList(JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentPOList), AttachmentBO.class));
            }
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationPO.setContractId(reqBO.getContractId());
            FscOrderRelationPO modelBy = this.fscOrderRelationMapper.getModelBy(fscOrderRelationPO);
            if (modelBy != null && StringUtils.isNotBlank((CharSequence)modelBy.getContractRemark())) {
                rspBO.setContractRemark(modelBy.getContractRemark());
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryRefundEngineeringInvoiceItemList"})
    public FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO qryRefundEngineeringInvoiceItemList(@RequestBody FscFinanceEngineeringInvoiceItemListQryAbilityServiceReqBO reqBO) {
        this.checkRefundInput(reqBO);
        FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderItemPO.class);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscOrderItemMapper.financeRefundWriteOffAdjustQryPage(fscOrderItemPO, page);
        List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscFinanceEngineeringInvoiceItemListQryAbilityBO.class);
        FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO rspBO = new FscFinanceEngineeringInvoiceItemListQryAbilityServiceRspBO();
        FscOrderItemPO fscOrderItemPO1 = this.fscOrderItemMapper.getRefundAmt(fscOrderItemPO);
        if (fscOrderItemPO1 != null) {
            rspBO.setAmtTotal(fscOrderItemPO1.getAmtTotal() != null ? fscOrderItemPO1.getAmtTotal() : BigDecimal.ZERO);
            rspBO.setUntaxAmtTotal(fscOrderItemPO1.getAmtTotal() != null ? fscOrderItemPO1.getAmtTotal() : BigDecimal.ZERO);
            rspBO.setContractLeaveInvoiceAmtTotal(fscOrderItemPO1.getAmtTotal() != null ? fscOrderItemPO1.getAmtTotal() : BigDecimal.ZERO);
        }
        if (reqBO.getContractId() != null) {
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setObjId(reqBO.getContractId());
            List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOList)) {
                rspBO.setAttachmentList(JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentPOList), AttachmentBO.class));
            }
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationPO.setContractId(reqBO.getContractId());
            FscOrderRelationPO modelBy = this.fscOrderRelationMapper.getModelBy(fscOrderRelationPO);
            if (modelBy != null && StringUtils.isNotBlank((CharSequence)modelBy.getContractRemark())) {
                rspBO.setContractRemark(modelBy.getContractRemark());
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkRefundInput(FscFinanceEngineeringInvoiceItemListQryAbilityServiceReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getRefundId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u6b3e\u5355ID\u4e3a\u7a7a");
        }
    }

    private void checkInput(FscFinanceEngineeringInvoiceItemListQryAbilityServiceReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
    }
}

