/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceSaveAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceSaveReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceSaveRspBo;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceEditBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceSaveAbilityService"})
public class FscFinanceInvoiceSaveAbilityServiceImpl
implements FscFinanceInvoiceSaveAbilityService {
    @Autowired
    private FscBillInvoiceEditBusiService fscBillInvoiceEditBusiService;

    @PostMapping(value={"invoiceSaveBatch"})
    public FscFinanceInvoiceSaveRspBo invoiceSaveBatch(@RequestBody FscFinanceInvoiceSaveReqBo reqBo) {
        if (Objects.isNull(reqBo.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fscOrderId]\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBo.getContractId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[contractId]\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBo.getInvoiceList())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[invoiceList]\u4e3a\u7a7a");
        }
        ArrayList<FscInvoicePO> fscInvoicePOList = new ArrayList<FscInvoicePO>();
        reqBo.getInvoiceList().forEach(e -> {
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoicePO.setFscOrderId(reqBo.getFscOrderId());
            fscInvoicePO.setBillDate(e.getBillDate());
            fscInvoicePO.setTaxAmt(e.getRmbTax());
            fscInvoicePO.setAmt(e.getRmbAmountTax());
            fscInvoicePO.setUntaxAmt(e.getRmbAmount());
            fscInvoicePO.setInvoiceNo(e.getInvoiceNo());
            fscInvoicePO.setInvoiceCode(e.getInvoiceCode());
            fscInvoicePO.setBuyName(e.getBuyerName());
            fscInvoicePO.setTaxNo(e.getBuyerId());
            switch (e.getInvoiceType()) {
                case "1010100": {
                    fscInvoicePO.setInvoiceType("00");
                    fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.PAPER);
                    break;
                }
                case "1010101": {
                    fscInvoicePO.setInvoiceType("01");
                    fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.PAPER);
                    break;
                }
                case "1010102": {
                    fscInvoicePO.setInvoiceType("01");
                    fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.ELECTRON);
                    break;
                }
                case "1010107": {
                    fscInvoicePO.setInvoiceType("00");
                    fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.FULL_ELECTRON);
                    fscInvoicePO.setFullElecNo(e.getInvoiceNo());
                    break;
                }
                case "1010108": {
                    fscInvoicePO.setInvoiceType("01");
                    fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.FULL_ELECTRON);
                    fscInvoicePO.setFullElecNo(e.getInvoiceNo());
                    break;
                }
            }
            fscInvoicePO.setStatus(FscConstants.FscInvoiceStatus.VALID);
            fscInvoicePO.setCreateTime(new Date());
            fscInvoicePO.setCreateOperId(String.valueOf(reqBo.getUserId()));
            fscInvoicePO.setCreateOperName(reqBo.getUserName());
            fscInvoicePO.setCreateOrgId(reqBo.getCompanyId());
            fscInvoicePO.setCreateCompanyName(reqBo.getCompanyName());
            fscInvoicePO.setUpdateTime(new Date());
            fscInvoicePO.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            fscInvoicePO.setContractId(reqBo.getContractId());
            fscInvoicePO.setFinanceGuid(e.getGuid());
            fscInvoicePO.setUploadShareStatus(FscConstants.FinanceInvoiceUploadShareStatus.UPLOAD_SUCCESS);
            fscInvoicePOList.add(fscInvoicePO);
        });
        int num = this.fscBillInvoiceEditBusiService.inertBatch(fscInvoicePOList);
        FscFinanceInvoiceSaveRspBo rspBo = new FscFinanceInvoiceSaveRspBo();
        rspBo.setRespCode(num > 0 ? "0000" : "190000");
        rspBo.setRespDesc(num > 0 ? "\u6210\u529f" : "\u5931\u8d25");
        return rspBo;
    }
}

