/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceOrderRefundPayAtomService;
import com.tydic.fsc.bill.atom.bo.FscFinanceOrderRefundPayAtomRspBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceOrderRefundPayAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceRefundWriteOffMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderPaymentDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundPayItemMapper;
import com.tydic.fsc.dao.FscRefundPaymentDetailMapper;
import com.tydic.fsc.dao.FscRefundShouldPayDetailMapper;
import com.tydic.fsc.dao.FscRefundShouldPayMapper;
import com.tydic.fsc.dao.FscShouldPayDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceRefundWriteOffPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderPaymentDetailPO;
import com.tydic.fsc.po.FscOrderRefundBO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundPayItemPO;
import com.tydic.fsc.po.FscRefundPaymentDetailPO;
import com.tydic.fsc.po.FscRefundShouldPayDetailPO;
import com.tydic.fsc.po.FscRefundShouldPayPO;
import com.tydic.fsc.po.FscShouldPayDetailPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceOrderRefundPayAtomServiceImpl
implements FscFinanceOrderRefundPayAtomService {
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private FscRefundShouldPayMapper fscRefundShouldPayMapper;
    @Autowired
    private FscRefundPayItemMapper fscRefundPayItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderPaymentDetailMapper fscOrderPaymentDetailMapper;
    @Autowired
    private FscRefundShouldPayDetailMapper fscRefundShouldPayDetailMapper;
    @Autowired
    private FscShouldPayDetailMapper fscShouldPayDetailMapper;
    @Autowired
    private FscRefundPaymentDetailMapper fscRefundPaymentDetailMapper;
    @Autowired
    private FscFinanceRefundWriteOffMapper fscFinanceRefundWriteOffMapper;

    @Override
    public FscFinanceOrderRefundPayAtomRspBO dealFinanceRefundPay(FscFinanceOrderRefundPayAtomReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", reqBO.getRefundId() + "\u67e5\u8be2\u51b2\u9500\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == 1) {
            if (refundPO.getChangeAmt() == null || refundPO.getChangeAmt().compareTo(BigDecimal.ZERO) == 0) {
                this.dealRefundNew(refundPO, true);
            } else if (refundPO.getChangeAmt().compareTo(refundPO.getRefundAmount()) != 0) {
                this.dealRefundBack(refundPO);
                this.dealRefundNew(refundPO, true);
            }
        } else if (reqBO.getOperationType() == 2) {
            this.dealRefundBack(refundPO);
        }
        FscFinanceOrderRefundPayAtomRspBO rspBO = new FscFinanceOrderRefundPayAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRefundNew(FscOrderRefundPO refundPO, Boolean isUp) {
        FscFinanceWriteOffPO financeWriteOffPO;
        FscOrderRefundBO orderRefundBO;
        FscOrderRefundBO orderRefundBO2;
        List refundBOList = this.fscOrderItemMapper.sumOrderAmtByRefundId(refundPO.getRefundId());
        HashMap<Long, FscOrderRefundBO> orderMap = new HashMap<Long, FscOrderRefundBO>(refundBOList.size());
        HashMap<Long, BigDecimal> refundAmtMap = new HashMap<Long, BigDecimal>(refundBOList.size());
        for (FscOrderRefundBO orderRefundBO3 : refundBOList) {
            orderMap.put(orderRefundBO3.getOrderId(), orderRefundBO3);
            refundAmtMap.put(orderRefundBO3.getOrderId(), orderRefundBO3.getRefundAmt());
        }
        ArrayList<FscShouldPayDetailPO> paydetailUpdList = new ArrayList<FscShouldPayDetailPO>();
        HashMap<Long, FscShouldPayPO> shouldPayUpdList = new HashMap<Long, FscShouldPayPO>();
        List payDetailPOList = new ArrayList();
        Map<Object, Object> writeOffMap = new HashMap();
        if (refundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            payDetailPOList = this.fscShouldPayDetailMapper.qryRefundList(refundPO.getFscOrderId(), orderMap.keySet());
        } else {
            payDetailPOList = this.fscShouldPayDetailMapper.qryOrderRefundList(refundPO.getFscOrderId(), orderMap.keySet());
            List writeOffList = this.fscFinanceWriteOffMapper.sumWriteOffAmtByFscOrderInfo(refundPO.getFscOrderId(), orderMap.keySet());
            writeOffMap = writeOffList.stream().collect(Collectors.toMap(FscFinanceWriteOffPO::getOrderId, FscFinanceWriteOffPO::getWriteOffAmt));
        }
        ArrayList<Long> shouldPayIds = new ArrayList<Long>();
        BigDecimal toPayAmt = BigDecimal.ZERO;
        for (FscShouldPayDetailPO fscShouldPayDetailPO : payDetailPOList) {
            FscShouldPayPO shouldPayPO;
            FscOrderRefundBO orderRefundBO4;
            shouldPayIds.add(fscShouldPayDetailPO.getShouldPayId());
            fscShouldPayDetailPO.setToPayAmt(fscShouldPayDetailPO.getShouldPayAmt().subtract(fscShouldPayDetailPO.getPayAmount()).subtract(fscShouldPayDetailPO.getRefundAmount()));
            if (refundPO.getSettleType().equals(FscConstants.SettleType.ORDER) && writeOffMap.get(fscShouldPayDetailPO.getOrderId()) != null) {
                fscShouldPayDetailPO.setToPayAmt(fscShouldPayDetailPO.getToPayAmt().subtract((BigDecimal)writeOffMap.get(fscShouldPayDetailPO.getOrderId())));
            }
            if (fscShouldPayDetailPO.getToPayAmt().compareTo(BigDecimal.ZERO) <= 0 || (orderRefundBO4 = (FscOrderRefundBO)orderMap.get(fscShouldPayDetailPO.getOrderId())) == null) continue;
            if (orderRefundBO4.getRefundAmt().compareTo(fscShouldPayDetailPO.getToPayAmt()) <= 0) {
                fscShouldPayDetailPO.setRefundAmount(orderRefundBO4.getRefundAmt());
                paydetailUpdList.add(fscShouldPayDetailPO);
                toPayAmt = toPayAmt.add(orderRefundBO4.getRefundAmt());
                orderMap.remove(orderRefundBO4.getOrderId());
                if (shouldPayUpdList.containsKey(fscShouldPayDetailPO.getShouldPayId())) {
                    shouldPayPO = (FscShouldPayPO)shouldPayUpdList.get(fscShouldPayDetailPO.getShouldPayId());
                    shouldPayPO.setRefundAmount(shouldPayPO.getRefundAmount().add(orderRefundBO4.getRefundAmt()));
                } else {
                    shouldPayPO = new FscShouldPayPO();
                    shouldPayPO.setShouldPayId(fscShouldPayDetailPO.getShouldPayId());
                    shouldPayPO.setRefundAmount(orderRefundBO4.getRefundAmt());
                }
                shouldPayUpdList.put(fscShouldPayDetailPO.getShouldPayId(), shouldPayPO);
                continue;
            }
            fscShouldPayDetailPO.setRefundAmount(fscShouldPayDetailPO.getToPayAmt());
            paydetailUpdList.add(fscShouldPayDetailPO);
            toPayAmt = toPayAmt.add(fscShouldPayDetailPO.getToPayAmt());
            orderRefundBO4.setRefundAmt(orderRefundBO4.getRefundAmt().subtract(fscShouldPayDetailPO.getToPayAmt()));
            orderMap.put(orderRefundBO4.getOrderId(), orderRefundBO4);
            if (shouldPayUpdList.containsKey(fscShouldPayDetailPO.getShouldPayId())) {
                shouldPayPO = (FscShouldPayPO)shouldPayUpdList.get(fscShouldPayDetailPO.getShouldPayId());
                shouldPayPO.setRefundAmount(shouldPayPO.getRefundAmount().add(fscShouldPayDetailPO.getToPayAmt()));
            } else {
                shouldPayPO = new FscShouldPayPO();
                shouldPayPO.setShouldPayId(fscShouldPayDetailPO.getShouldPayId());
                shouldPayPO.setRefundAmount(fscShouldPayDetailPO.getToPayAmt());
            }
            shouldPayUpdList.put(fscShouldPayDetailPO.getShouldPayId(), shouldPayPO);
        }
        refundPO.setToPayAmount(toPayAmt);
        if (CollectionUtils.isEmpty(orderMap.keySet())) {
            this.dealUpdateToPayInfo(paydetailUpdList, shouldPayUpdList, refundPO, isUp);
            return;
        }
        ArrayList<FscOrderPaymentDetailPO> updPaymentList = new ArrayList<FscOrderPaymentDetailPO>();
        BigDecimal shouldPayAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(shouldPayIds)) {
            FscOrderPaymentDetailPO fscOrderPaymentDetailPO = new FscOrderPaymentDetailPO();
            fscOrderPaymentDetailPO.setShouldPayIds(shouldPayIds);
            fscOrderPaymentDetailPO.setOrderIds(orderMap.keySet());
            List paymentDetailPOList = this.fscOrderPaymentDetailMapper.getRefundList(fscOrderPaymentDetailPO);
            for (FscOrderPaymentDetailPO paymentDetailPO : paymentDetailPOList) {
                paymentDetailPO.setOrderAmount((BigDecimal)refundAmtMap.get(paymentDetailPO.getOrderId()));
                paymentDetailPO.setPayAmount(paymentDetailPO.getPayAmount().subtract(paymentDetailPO.getRefundAmount()));
                if (paymentDetailPO.getPayAmount().compareTo(BigDecimal.ZERO) <= 0 || (orderRefundBO2 = (FscOrderRefundBO)orderMap.get(paymentDetailPO.getOrderId())) == null || orderRefundBO2.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (paymentDetailPO.getPayAmount().compareTo(orderRefundBO2.getRefundAmt()) >= 0) {
                    paymentDetailPO.setRefundAmount(orderRefundBO2.getRefundAmt());
                    updPaymentList.add(paymentDetailPO);
                    shouldPayAmt = shouldPayAmt.add(orderRefundBO2.getRefundAmt());
                    orderMap.remove(paymentDetailPO.getOrderId());
                    continue;
                }
                paymentDetailPO.setRefundAmount(paymentDetailPO.getPayAmount());
                updPaymentList.add(paymentDetailPO);
                shouldPayAmt = shouldPayAmt.add(paymentDetailPO.getPayAmount());
                orderRefundBO2.setRefundAmt(orderRefundBO2.getRefundAmt().subtract(paymentDetailPO.getPayAmount()));
                orderMap.put(paymentDetailPO.getOrderId(), orderRefundBO2);
            }
        }
        refundPO.setShouldPayAmount(shouldPayAmt);
        if (CollectionUtils.isEmpty(orderMap)) {
            this.dealUpdateToPayInfo(paydetailUpdList, shouldPayUpdList, refundPO, isUp);
            this.dealUpdateShouldPayInfo(updPaymentList, refundPO, isUp);
            return;
        }
        FscFinanceWriteOffPO writeOffPO = new FscFinanceWriteOffPO();
        writeOffPO.setFscOrderId(refundPO.getFscOrderId());
        writeOffPO.setOrderIds(orderMap.keySet());
        List writeOffPOList = this.fscFinanceWriteOffMapper.getRefundList(writeOffPO);
        ArrayList<FscFinanceRefundWriteOffPO> refundWriteOffList = new ArrayList<FscFinanceRefundWriteOffPO>(writeOffPOList.size());
        ArrayList<FscFinanceWriteOffPO> updateList = new ArrayList<FscFinanceWriteOffPO>();
        orderRefundBO2 = writeOffPOList.iterator();
        while (orderRefundBO2.hasNext() && (orderRefundBO = (FscOrderRefundBO)orderMap.get((financeWriteOffPO = (FscFinanceWriteOffPO)orderRefundBO2.next()).getOrderId())).getRefundAmt().compareTo(BigDecimal.ZERO) > 0) {
            financeWriteOffPO.setWriteOffAmt(financeWriteOffPO.getWriteOffAmt().subtract(financeWriteOffPO.getRefundAmt()));
            if (financeWriteOffPO.getWriteOffAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            FscFinanceRefundWriteOffPO refundWriteOffPO = new FscFinanceRefundWriteOffPO();
            BeanUtils.copyProperties((Object)financeWriteOffPO, (Object)refundWriteOffPO);
            refundWriteOffPO.setRefundWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
            refundWriteOffPO.setCreateTime(new Date());
            refundWriteOffPO.setRefundId(refundPO.getRefundId());
            refundWriteOffPO.setChargeId(financeWriteOffPO.getChargeId());
            refundWriteOffPO.setChargeDetailId(financeWriteOffPO.getChargeDetailId());
            if (orderRefundBO.getRefundAmt().compareTo(financeWriteOffPO.getWriteOffAmt()) <= 0) {
                refundWriteOffPO.setRefundAmt(orderRefundBO.getRefundAmt());
                orderMap.remove(orderRefundBO.getOrderId());
            } else {
                refundWriteOffPO.setRefundAmt(financeWriteOffPO.getWriteOffAmt());
                orderRefundBO.setRefundAmt(orderRefundBO.getRefundAmt().subtract(financeWriteOffPO.getWriteOffAmt()));
                orderMap.put(orderRefundBO.getOrderId(), orderRefundBO);
            }
            if (financeWriteOffPO.getOrderId() != null) {
                refundWriteOffPO.setOrderId(financeWriteOffPO.getOrderId());
            }
            refundWriteOffList.add(refundWriteOffPO);
            financeWriteOffPO.setRefundAmt(refundWriteOffPO.getRefundAmt());
            updateList.add(financeWriteOffPO);
        }
        this.dealUpdateToPayInfo(paydetailUpdList, shouldPayUpdList, refundPO, isUp);
        this.dealUpdateShouldPayInfo(updPaymentList, refundPO, isUp);
        if (!CollectionUtils.isEmpty(refundWriteOffList)) {
            int count = this.fscFinanceRefundWriteOffMapper.insertBatch(refundWriteOffList);
            if (count != refundWriteOffList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u91c7\u8d2d\u51b2\u9500\u6838\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscFinanceWriteOffMapper.updateRefundAmtBatch(updateList);
            if (count != updateList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u7ed3\u7b97\u6838\u9500\u51b2\u9500\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void valid(FscFinanceOrderRefundPayAtomReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void dealUpdateToPayInfo(List<FscShouldPayDetailPO> paydetailUpdList, Map<Long, FscShouldPayPO> shouldPayUpdList, FscOrderRefundPO refundPO, Boolean isUp) {
        if (!CollectionUtils.isEmpty(paydetailUpdList)) {
            int count = this.fscShouldPayDetailMapper.updateRefundAmountBatch(paydetailUpdList);
            if (count != paydetailUpdList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList<FscRefundShouldPayDetailPO> refundShouldPayDetailPOList = new ArrayList<FscRefundShouldPayDetailPO>();
            for (FscShouldPayDetailPO fscShouldPayDetailPO : paydetailUpdList) {
                FscRefundShouldPayDetailPO refundDetailPO = new FscRefundShouldPayDetailPO();
                BeanUtils.copyProperties((Object)fscShouldPayDetailPO, (Object)refundDetailPO);
                refundDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundDetailPO.setFscOrderId(refundPO.getFscOrderId());
                refundDetailPO.setShouldPayDetailId(fscShouldPayDetailPO.getId());
                refundDetailPO.setRefundId(refundPO.getRefundId());
                refundShouldPayDetailPOList.add(refundDetailPO);
            }
            count = this.fscRefundShouldPayDetailMapper.insertBatch(refundShouldPayDetailPOList);
            if (count != refundShouldPayDetailPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u5e94\u4ed8\u51b2\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(shouldPayUpdList)) {
            ArrayList<FscShouldPayPO> updateList = new ArrayList<FscShouldPayPO>();
            ArrayList<FscRefundShouldPayPO> refundShouldPayPOList = new ArrayList<FscRefundShouldPayPO>();
            for (Long key : shouldPayUpdList.keySet()) {
                FscShouldPayPO shouldPayPO = shouldPayUpdList.get(key);
                updateList.add(shouldPayPO);
                FscRefundShouldPayPO refundShouldPayPO = new FscRefundShouldPayPO();
                refundShouldPayPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundShouldPayPO.setRefundId(refundPO.getRefundId());
                refundShouldPayPO.setAmount(shouldPayPO.getRefundAmount());
                refundShouldPayPO.setShouldPayId(shouldPayPO.getShouldPayId());
                refundShouldPayPO.setExt1(refundPO.getFscOrderId() + "");
                refundShouldPayPO.setExt2(refundPO.getFscOrderNo());
                refundShouldPayPOList.add(refundShouldPayPO);
            }
            int count = this.fscShouldPayMapper.updateRefundAmountBatch(updateList);
            if (count != updateList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u672a\u4ed8\u6b3e\u51b2\u9500\u91d1\u989d\u5931\u8d25\uff01");
            }
            count = this.fscRefundShouldPayMapper.insertBatch(refundShouldPayPOList);
            if (count != refundShouldPayPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u9000\u6b3e\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (isUp.booleanValue()) {
            FscOrderRefundPO updatePO = new FscOrderRefundPO();
            updatePO.setRefundId(refundPO.getRefundId());
            updatePO.setToPayAmount(refundPO.getToPayAmount());
            updatePO.setShouldPayAmount(BigDecimal.ZERO);
            this.fscOrderRefundMapper.updateById(updatePO);
        }
    }

    private void dealUpdateShouldPayInfo(List<FscOrderPaymentDetailPO> updPaymentList, FscOrderRefundPO refundPO, Boolean isUp) {
        if (CollectionUtils.isEmpty(updPaymentList)) {
            return;
        }
        if (isUp.booleanValue()) {
            FscOrderRefundPO updatePo = new FscOrderRefundPO();
            updatePo.setRefundId(refundPO.getRefundId());
            updatePo.setToPayAmount(refundPO.getToPayAmount());
            updatePo.setShouldPayAmount(refundPO.getShouldPayAmount());
            this.fscOrderRefundMapper.updateById(updatePo);
        }
        ArrayList<FscRefundPaymentDetailPO> refundDetailList = new ArrayList<FscRefundPaymentDetailPO>();
        HashMap<Long, FscRefundPayItemPO> payItemPOMap = new HashMap<Long, FscRefundPayItemPO>();
        HashMap<Long, FscShouldPayPO> shouldPayPOMap = new HashMap<Long, FscShouldPayPO>();
        for (FscOrderPaymentDetailPO fscOrderPaymentDetailPO : updPaymentList) {
            FscRefundPaymentDetailPO refundPaymentDetailPO = new FscRefundPaymentDetailPO();
            BeanUtils.copyProperties((Object)fscOrderPaymentDetailPO, (Object)refundPaymentDetailPO);
            refundPaymentDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundPaymentDetailPO.setRefundId(refundPO.getRefundId());
            refundPaymentDetailPO.setPayOrderId(fscOrderPaymentDetailPO.getPayOrderId());
            refundPaymentDetailPO.setExt1(fscOrderPaymentDetailPO.getOrderPayItemId() + "");
            refundPaymentDetailPO.setAmount(fscOrderPaymentDetailPO.getRefundAmount());
            refundPaymentDetailPO.setOrderAmt(fscOrderPaymentDetailPO.getOrderAmount());
            refundDetailList.add(refundPaymentDetailPO);
            FscRefundPayItemPO refundPayItemPO = (FscRefundPayItemPO)payItemPOMap.get(fscOrderPaymentDetailPO.getOrderPayItemId());
            if (refundPayItemPO == null) {
                refundPayItemPO = new FscRefundPayItemPO();
                BeanUtils.copyProperties((Object)fscOrderPaymentDetailPO, (Object)refundPayItemPO);
                refundPayItemPO.setAmount(fscOrderPaymentDetailPO.getRefundAmount());
                refundPayItemPO.setFscOrderId(refundPO.getFscOrderId());
                refundPayItemPO.setRefundId(refundPO.getRefundId());
                refundPayItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                refundPayItemPO.setPayItemId(fscOrderPaymentDetailPO.getOrderPayItemId());
                payItemPOMap.put(fscOrderPaymentDetailPO.getOrderPayItemId(), refundPayItemPO);
            } else {
                refundPayItemPO.setAmount(refundPayItemPO.getAmount().add(fscOrderPaymentDetailPO.getRefundAmount()));
                payItemPOMap.put(fscOrderPaymentDetailPO.getOrderPayItemId(), refundPayItemPO);
            }
            FscShouldPayPO shouldPayPO = (FscShouldPayPO)shouldPayPOMap.get(fscOrderPaymentDetailPO.getShouldPayId());
            if (shouldPayPO == null) {
                shouldPayPO = new FscShouldPayPO();
                shouldPayPO.setShouldPayId(fscOrderPaymentDetailPO.getShouldPayId());
                shouldPayPO.setRefundAmount(fscOrderPaymentDetailPO.getRefundAmount());
            } else {
                shouldPayPO.setRefundAmount(shouldPayPO.getRefundAmount().add(fscOrderPaymentDetailPO.getRefundAmount()));
            }
            shouldPayPOMap.put(shouldPayPO.getShouldPayId(), shouldPayPO);
        }
        ArrayList<FscRefundPayItemPO> refundPayItemPOList = new ArrayList<FscRefundPayItemPO>();
        for (Long key : payItemPOMap.keySet()) {
            refundPayItemPOList.add((FscRefundPayItemPO)payItemPOMap.get(key));
        }
        int n = this.fscRefundPayItemMapper.insertBatch(refundPayItemPOList);
        if (n != refundPayItemPOList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u51b2\u9500\u4ed8\u6b3e\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
        int n2 = this.fscRefundPaymentDetailMapper.insertBatch(refundDetailList);
        if (n2 != refundDetailList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u51b2\u9500\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        int n3 = this.fscOrderPaymentDetailMapper.updateRefundAmountBatch(updPaymentList);
        if (n3 != updPaymentList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList shouldPayPOList = new ArrayList(shouldPayPOMap.values());
        int n4 = this.fscShouldPayMapper.updateRefundAmountBatch(shouldPayPOList);
        if (n4 != shouldPayPOList.size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u5355\u51b2\u9500\u91d1\u989d\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void dealRefundBack(FscOrderRefundPO refundPO) {
        FscRefundShouldPayDetailPO payDetailPO = new FscRefundShouldPayDetailPO();
        payDetailPO.setRefundId(refundPO.getRefundId());
        List refundPayDetailList = this.fscRefundShouldPayDetailMapper.getList(payDetailPO);
        if (!CollectionUtils.isEmpty((Collection)refundPayDetailList)) {
            int count = this.fscRefundShouldPayDetailMapper.deleteByRefundId(refundPO.getRefundId());
            if (count != refundPayDetailList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u5e94\u4ed8\u51b2\u9500\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List<FscShouldPayDetailPO> payDetailPOList = FscFinanceOrderRefundPayAtomServiceImpl.getDetailPOS(refundPayDetailList);
            count = this.fscShouldPayDetailMapper.updateRefundAmountBatch(payDetailPOList);
            if (count != payDetailPOList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscRefundShouldPayMapper.deleteByRefundId(refundPO.getRefundId());
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u5220\u9664\u51b2\u9500\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscFinanceRefundWriteOffPO refundWriteOffPO = new FscFinanceRefundWriteOffPO();
        refundWriteOffPO.setRefundId(refundPO.getRefundId());
        List refundWriteOffPOList = this.fscFinanceRefundWriteOffMapper.getList(refundWriteOffPO);
        ArrayList<FscFinanceWriteOffPO> writeOffPOList = new ArrayList<FscFinanceWriteOffPO>();
        if (!CollectionUtils.isEmpty((Collection)refundWriteOffPOList)) {
            for (FscFinanceRefundWriteOffPO refWriteOffPO : refundWriteOffPOList) {
                FscFinanceWriteOffPO writeOffPO = new FscFinanceWriteOffPO();
                BeanUtils.copyProperties((Object)refWriteOffPO, (Object)writeOffPO);
                writeOffPO.setRefundAmt(refWriteOffPO.getRefundAmt().negate());
                writeOffPOList.add(writeOffPO);
            }
            int count = this.fscFinanceWriteOffMapper.updateRefundAmtBatch(writeOffPOList);
            if (count != writeOffPOList.size()) {
                throw new FscBusinessException("198888", "\u56de\u9000\u6838\u9500\u51b2\u9500\u91d1\u989d\u5931\u8d25\uff01");
            }
            count = this.fscFinanceRefundWriteOffMapper.deleteByRefundId(refundPO.getRefundId());
            if (count != refundWriteOffPOList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u6838\u9500\u51b2\u9500\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscRefundPaymentDetailPO detailPO = new FscRefundPaymentDetailPO();
        detailPO.setRefundId(refundPO.getRefundId());
        List refundDetailList = this.fscRefundPaymentDetailMapper.getList(detailPO);
        HashMap<Long, FscShouldPayPO> shouldPayPOMap = new HashMap<Long, FscShouldPayPO>();
        if (!CollectionUtils.isEmpty((Collection)refundDetailList)) {
            ArrayList<FscOrderPaymentDetailPO> paymentDetailPOList = new ArrayList<FscOrderPaymentDetailPO>(refundDetailList.size());
            for (FscRefundPaymentDetailPO refundPaymentDetailPO : refundDetailList) {
                FscShouldPayPO shouldPayPO;
                FscOrderPaymentDetailPO paymentDetailPO = new FscOrderPaymentDetailPO();
                paymentDetailPO.setPaymentDetailId(refundPaymentDetailPO.getPaymentDetailId());
                paymentDetailPO.setRefundAmount(refundPaymentDetailPO.getAmount().negate());
                paymentDetailPOList.add(paymentDetailPO);
                if (shouldPayPOMap.containsKey(refundPaymentDetailPO.getShouldPayId())) {
                    shouldPayPO = (FscShouldPayPO)shouldPayPOMap.get(refundPaymentDetailPO.getShouldPayId());
                    shouldPayPO.setRefundAmount(shouldPayPO.getRefundAmount().add(refundPaymentDetailPO.getAmount().negate()));
                } else {
                    shouldPayPO = new FscShouldPayPO();
                    shouldPayPO.setShouldPayId(refundPaymentDetailPO.getShouldPayId());
                    shouldPayPO.setRefundAmount(refundPaymentDetailPO.getAmount().negate());
                }
                shouldPayPOMap.put(shouldPayPO.getShouldPayId(), shouldPayPO);
            }
            int count = this.fscOrderPaymentDetailMapper.updateRefundAmountBatch(paymentDetailPOList);
            if (count != paymentDetailPOList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u51b2\u9500\u6570\u636e\u5931\u8d25\uff01");
            }
            count = this.fscRefundPaymentDetailMapper.deleteByRefundId(refundPO.getRefundId());
            if (count != refundDetailList.size()) {
                throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscRefundPayItemMapper.deleteByRefundId(refundPO.getRefundId());
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u51b2\u9500\u5173\u8054\u8868\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList shouldPayPOList = new ArrayList(shouldPayPOMap.values());
            count = this.fscShouldPayMapper.updateRefundAmountBatch(shouldPayPOList);
            if (count != shouldPayPOList.size()) {
                throw new FscBusinessException("198888", "\u56de\u9000\u5e94\u4ed8\u5355\u51b2\u9500\u91d1\u989d\u5931\u8d25\uff01");
            }
        }
    }

    @NotNull
    private static List<FscShouldPayDetailPO> getDetailPOS(List<FscRefundShouldPayDetailPO> refundPayDetailList) {
        ArrayList<FscShouldPayDetailPO> payDetailPOList = new ArrayList<FscShouldPayDetailPO>();
        for (FscRefundShouldPayDetailPO refundPayDetailPO : refundPayDetailList) {
            FscShouldPayDetailPO shouldPayDetailPO = new FscShouldPayDetailPO();
            shouldPayDetailPO.setId(refundPayDetailPO.getShouldPayDetailId());
            shouldPayDetailPO.setRefundAmount(refundPayDetailPO.getRefundAmount().negate());
            payDetailPOList.add(shouldPayDetailPO);
        }
        return payDetailPOList;
    }

    @Override
    public FscFinanceOrderRefundPayAtomRspBO financeRefundPay(FscFinanceOrderRefundPayAtomReqBO reqBO) {
        this.dealRefundNew(reqBO.getRefundPO(), false);
        return new FscFinanceOrderRefundPayAtomRspBO();
    }

    @Override
    public FscFinanceOrderRefundPayAtomRspBO financeRefundChange(FscFinanceOrderRefundPayAtomReqBO reqBO) {
        this.dealRefundBack(reqBO.getRefundPO());
        this.dealRefundNew(reqBO.getRefundPO(), false);
        return new FscFinanceOrderRefundPayAtomRspBO();
    }

    @Override
    public FscFinanceOrderRefundPayAtomRspBO financeRefundBack(FscFinanceOrderRefundPayAtomReqBO reqBO) {
        this.dealRefundBack(reqBO.getRefundPO());
        return new FscFinanceOrderRefundPayAtomRspBO();
    }
}

