/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundUpdateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderSpecialRefundUpdateBusiServiceImpl
implements FscBillOrderSpecialRefundUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderSpecialRefundUpdateBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u521b\u5efa";

    @Override
    public FscBillOrderSpecialRefundUpdateBusiRspBO dealSpecialRefundUpdate(FscBillOrderSpecialRefundUpdateBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setRefundReason(reqBO.getRefundReason());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setCertification(reqBO.getCertification());
        refundPO.setYcUserId(reqBO.getYcUserId());
        refundPO.setYcPersonId(reqBO.getYcPersonId());
        refundPO.setYcPersonName(reqBO.getYcPersonName());
        refundPO.setYcDeptId(reqBO.getYcDeptId());
        refundPO.setYcDeptName(reqBO.getYcDeptName());
        refundPO.setExt1(reqBO.getAgentAccount());
        refundPO.setFscOrderId(reqBO.getFscOrderId());
        ArrayList<Long> delInvoiceIds = new ArrayList<Long>();
        FscInvoiceRefundRelationPO invoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
        invoiceRefundRelationPO.setRefundId(reqBO.getRefundId());
        List refundInvoiceList = this.fscInvoiceRefundRelationMapper.getList(invoiceRefundRelationPO);
        BigDecimal totalRefundAmt = BigDecimal.ZERO;
        HashMap<Long, FscBillOrderRefundCreateInvoiceBO> invoiceMap = new HashMap<Long, FscBillOrderRefundCreateInvoiceBO>();
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            invoiceMap.put(invoiceBO.getInvoiceId(), invoiceBO);
            totalRefundAmt = totalRefundAmt.add(invoiceBO.getRefundAmt());
        }
        refundPO.setRefundAmount(totalRefundAmt);
        for (FscInvoiceRefundRelationPO refundRelationPO : refundInvoiceList) {
            if (invoiceMap.get(refundRelationPO.getInvoiceId()) == null) {
                delInvoiceIds.add(refundRelationPO.getInvoiceId());
                continue;
            }
            invoiceMap.remove(refundRelationPO.getInvoiceId());
        }
        boolean bakRelationFlag = false;
        this.dealAttachment(reqBO);
        if (!CollectionUtils.isEmpty(delInvoiceIds)) {
            bakRelationFlag = true;
            FscInvoiceItemPO itemPO = new FscInvoiceItemPO();
            itemPO.setInvoiceIds(delInvoiceIds);
            List list = this.fscInvoiceItemMapper.getList(itemPO);
            List idList = list.stream().map(FscInvoiceItemPO::getId).collect(Collectors.toList());
            int delCount = this.fscOrderItemMapper.deleteByRefundInvoiceIds(idList);
            if (delCount < 0) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u91ca\u653e\u9000\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            int count = this.fscInvoiceItemMapper.updateRefundAmtByIdsSub(delInvoiceIds);
            if (count < 0) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u91ca\u653e\u53d1\u7968\u660e\u7ec6\u5360\u7528\u91d1\u989d\u5931\u8d25\uff01");
            }
            FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
            refundRelationPO.setInvoiceIds(delInvoiceIds);
            refundRelationPO.setRefundId(reqBO.getRefundId());
            delCount = this.fscInvoiceRefundRelationMapper.deleteByIds(refundRelationPO);
            if (delCount != delInvoiceIds.size()) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u5220\u9664\u53d1\u7968\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(invoiceMap)) {
            bakRelationFlag = true;
            List<FscInvoiceRefundRelationPO> invoiceRelationList = this.buildRefundInvoiceInfo(invoiceMap, refundPO, reqBO);
            List<FscOrderItemPO> orderItemPOS = this.buildRefundItemInfo(invoiceMap.keySet(), reqBO.getRefundId());
            int count = this.fscInvoiceRefundRelationMapper.insertBatch(invoiceRelationList);
            if (count != invoiceRelationList.size()) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u63d2\u5165\u9000\u7968\u53d1\u7968\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
            }
            count = this.fscOrderItemMapper.insertBatch(orderItemPOS);
            if (count != orderItemPOS.size()) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u63d2\u5165\u9000\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List invoiceIdList = invoiceRelationList.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
            FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
            invoiceItemPO.setInvoiceIds(invoiceIdList);
            int invoiceItemCount = this.fscInvoiceItemMapper.getCheckBy(invoiceItemPO);
            count = this.fscInvoiceItemMapper.updateRefundAmtByIds(invoiceIdList);
            if (count != invoiceItemCount) {
                throw new FscBusinessException("198888", "\u5360\u7528\u53d1\u7968\u660e\u7ec6\u9000\u7968\u91d1\u989d\u5931\u8d25\uff01");
            }
        }
        if (bakRelationFlag) {
            FscOrderItemPO orderItemPO = new FscOrderItemPO();
            orderItemPO.setRefundId(reqBO.getRefundId());
            List orderItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
            HashMap<Long, FscOrderRelationPO> relationMap = new HashMap<Long, FscOrderRelationPO>();
            for (FscOrderItemPO fscOrderItemPO : orderItemList) {
                FscOrderRelationPO relationPO;
                fscOrderItemPO.setRefundId(refundPO.getRefundId());
                fscOrderItemPO.setFscOrderId(null);
                if (relationMap.get(fscOrderItemPO.getAcceptOrderId()) != null) {
                    relationPO = (FscOrderRelationPO)relationMap.get(fscOrderItemPO.getAcceptOrderId());
                    relationPO.setSettleAmt(relationPO.getSettleAmt().add(fscOrderItemPO.getAmt()));
                }
                relationPO = new FscOrderRelationPO();
                relationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                relationPO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
                relationPO.setOrderId(fscOrderItemPO.getOrderId());
                relationPO.setRefundId(refundPO.getRefundId());
                relationPO.setSettleAmt(fscOrderItemPO.getAmt());
                relationMap.put(fscOrderItemPO.getAcceptOrderId(), relationPO);
            }
            ArrayList<FscOrderRelationPO> relationPOList = new ArrayList<FscOrderRelationPO>();
            for (Long key : relationMap.keySet()) {
                relationPOList.add((FscOrderRelationPO)relationMap.get(key));
            }
            int delCount = this.fscOrderRelationMapper.deleteByRefundIds(Collections.singletonList(reqBO.getRefundId()));
            if (delCount < 0) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u5220\u9664\u9000\u7968\u5173\u8054\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            int insertCount = this.fscOrderRelationMapper.insertBatch(relationPOList);
            if (insertCount != relationPOList.size()) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968-\u63d2\u5165\u9000\u7968\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        this.fscOrderRefundMapper.updateById(refundPO);
        if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
            this.dealStartApproval(reqBO, refundPO);
            List invoiceIds = reqBO.getInvoiceBOS().stream().map(FscBillOrderRefundCreateInvoiceBO::getInvoiceId).collect(Collectors.toList());
            FscInvoicePO invoicePO = new FscInvoicePO();
            invoicePO.setInvoiceIds(invoiceIds);
            invoicePO.setStatus(FscConstants.FscInvoiceStatus.TO_CONFIRM);
            int num = this.fscInvoiceMapper.updateInvoiceStatus(invoicePO);
            if (num == 0) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff01");
            }
            this.dealWorkFlow(refundPO);
        }
        FscBillOrderSpecialRefundUpdateBusiRspBO rspBO = new FscBillOrderSpecialRefundUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAttachment(FscBillOrderSpecialRefundUpdateBusiReqBO reqBO) {
        List attachmentIds;
        int count;
        FscAttachmentPO queryVo = new FscAttachmentPO();
        queryVo.setObjId(reqBO.getRefundId());
        queryVo.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
        List attachmentPOS = this.fscAttachmentMapper.getList(queryVo);
        if (!CollectionUtils.isEmpty((Collection)attachmentPOS) && (count = this.fscAttachmentMapper.deleteByAttachmentIds(attachmentIds = attachmentPOS.stream().map(FscAttachmentPO::getAttachmentId).collect(Collectors.toList()))) != attachmentIds.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(reqBO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                attachmentList.add(attachmentPO);
            }
            count = this.fscAttachmentMapper.insertBatch(attachmentList);
            if (count != attachmentList.size()) {
                throw new FscBusinessException("198888", "\u65b0\u589e\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private List<FscOrderItemPO> buildRefundItemInfo(Set<Long> invoiceIds, Long refundId) {
        FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
        invoiceItemPO.setInvoiceIdsSet(invoiceIds);
        List invoiceList = this.fscInvoiceItemMapper.getList(invoiceItemPO);
        ArrayList<FscOrderItemPO> itemList = new ArrayList<FscOrderItemPO>();
        for (FscInvoiceItemPO itemPO : invoiceList) {
            FscOrderItemPO orderItemPO = (FscOrderItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemPO), FscOrderItemPO.class);
            orderItemPO.setFscOrderId(null);
            orderItemPO.setRefundId(refundId);
            orderItemPO.setInvoiceItemId(itemPO.getId());
            itemList.add(orderItemPO);
        }
        return itemList;
    }

    private List<FscInvoiceRefundRelationPO> buildRefundInvoiceInfo(Map<Long, FscBillOrderRefundCreateInvoiceBO> invoiceMap, FscOrderRefundPO refundPO, FscBillOrderSpecialRefundUpdateBusiReqBO reqBO) {
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setFscOrderId(refundPO.getFscOrderId());
        List listNoPage = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        ArrayList<FscInvoiceRefundRelationPO> invoiceRefundRelationPOS = new ArrayList<FscInvoiceRefundRelationPO>();
        for (Long invoiceId : invoiceMap.keySet()) {
            FscBillOrderRefundCreateInvoiceBO invoiceBO = invoiceMap.get(invoiceId);
            FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
            refundRelationPO.setRefundId(refundPO.getRefundId());
            refundRelationPO.setFscOrderId(refundPO.getFscOrderId());
            refundRelationPO.setInvoiceId(invoiceBO.getInvoiceId());
            refundRelationPO.setRefundAmt(invoiceBO.getRefundAmt());
            refundRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            BigDecimal noTaxAmt = TaxUtils.calNoTaxAmt((BigDecimal)refundRelationPO.getRefundAmt(), (BigDecimal)((FscOrderItemPO)listNoPage.get(0)).getTaxRate().setScale(2, RoundingMode.HALF_UP));
            refundRelationPO.setTaxAmt(refundRelationPO.getRefundAmt().subtract(noTaxAmt));
            refundRelationPO.setUntaxAmt(noTaxAmt);
            if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
                refundRelationPO.setInvoiceStatus(FscConstants.FscInvoiceStatus.TO_CONFIRM);
            } else {
                refundRelationPO.setInvoiceStatus(FscConstants.FscInvoiceStatus.VALID);
            }
            refundRelationPO.setCreateTime(new Date());
            invoiceRefundRelationPOS.add(refundRelationPO);
        }
        return invoiceRefundRelationPOS;
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(FscRefundFlowProcKeyEnum.TRAFFIC_REFUND_INVOICE.getDescr());
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.TRAFFIC_REFUND_INVOICE);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("startFlag", "1");
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void dealStartApproval(FscBillOrderSpecialRefundUpdateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001040");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u5e73\u53f0\u6d41\u91cf\u8d39\u9000\u7968\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5e73\u53f0\u6d41\u91cf\u8d39\u9000\u7968\u5ba1\u6279\u6d41\u7a0b\uff01");
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(refundPO.getRefundId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel("\u9500\u552e\u9000\u7968\u7533\u8bf7\u5355");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u7968\u7533\u8bf7\u5355" + refundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscOrderRefundMapper.updateById(updatePo);
    }
}

