/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundConfirmBusiRspBO;
import com.tydic.fsc.bo.FscPayRefundAgainstListBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPurOrderRefundAmtMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayClaimDetailPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillPayRefundConfirmBusiServiceImpl
implements FscBillPayRefundConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundConfirmBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPurOrderRefundAmtMapper fscPurOrderRefundAmtMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    private static final String BUSI_NAME = "\u9000\u6b3e\u786e\u8ba4";

    @Override
    public FscBillPayRefundConfirmBusiRspBO dealPayRefundConfirm(FscBillPayRefundConfirmBusiReqBO reqBO) {
        FscPayShouldRefundPO fscPayShouldRefundPO;
        FscBillPayRefundConfirmBusiRspBO rspBO = new FscBillPayRefundConfirmBusiRspBO();
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        rspBO.setRefundId(reqBO.getRefundId());
        rspBO.setTradeMode(refundPO.getTradeMode());
        Integer userType = refundPO.getUserType();
        if (FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(refundPO.getTradeMode()) && refundPO.getIsPushUnify() != null && refundPO.getIsPushUnify().equals(FscConstants.IsPushUnify.PUSH)) {
            BigDecimal notClaimAmt;
            FscPayClaimDetailPO claimDetailPO;
            if (FscConstants.RefundUserType.PURCHASE.equals(userType)) {
                claimDetailPO = new FscPayClaimDetailPO();
                claimDetailPO.setRefundId(reqBO.getRefundId());
                notClaimAmt = this.fscPayClaimDetailMapper.queryClaimAmtByRefundId(claimDetailPO);
            } else {
                claimDetailPO = new FscClaimDetailPO();
                claimDetailPO.setRefundId(reqBO.getRefundId());
                notClaimAmt = this.fscClaimDetailMapper.queryClaimAmtByRefundId((FscClaimDetailPO)claimDetailPO);
            }
            if (notClaimAmt.compareTo(BigDecimal.ZERO) > 0) {
                throw new FscBusinessException("190000", "\u9000\u6b3e\u5355\u672a\u8fdb\u884c\u9000\u6b3e\u8ba4\u9886\u6216\u8005\u8ba4\u9886\u5355\u672a\u5b8c\u6210\u8ba4\u9886");
            }
            if (CollectionUtils.isEmpty(reqBO.getAgainstList())) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u6838\u9500\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBO.getFlowFlag().booleanValue()) {
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getAgainstList())) {
            ArrayList<FscPayClaimRefundPO> againstList = new ArrayList<FscPayClaimRefundPO>();
            for (FscPayRefundAgainstListBO bo : reqBO.getAgainstList()) {
                FscPayClaimRefundPO fscPayClaimRefundPO = new FscPayClaimRefundPO();
                fscPayClaimRefundPO.setId(bo.getId());
                fscPayClaimRefundPO.setAgainstAmt(bo.getAgainstAmt());
                againstList.add(fscPayClaimRefundPO);
            }
            int count = this.fscPayClaimRefundMapper.updateAgainstAmountBatch(againstList);
            if (count != againstList.size()) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u51b2\u9500\u91d1\u989d\u5931\u8d25");
            }
        }
        refundPO = (FscOrderRefundPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderRefundPO.class);
        refundPO.setExt1(reqBO.getAgentAccount());
        if (FscConstants.RefundUserType.PURCHASE.equals(userType)) {
            refundPO.setBillStatus(FscConstants.RefundBillStatus.AGAINST);
        }
        this.fscOrderRefundMapper.updateById(refundPO);
        int count = this.fscPayShouldRefundMapper.updateRefundById(reqBO.getRefundId());
        if (count <= 0) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u5355\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
        }
        count = this.fscOrderRefundPayRelationMapper.updateRefundById(reqBO.getRefundId());
        if (count <= 0) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u660e\u7ec6\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
        }
        if (FscConstants.RefundUserType.PURCHASE.equals(refundPO.getUserType()) && (fscPayShouldRefundPO = this.fscPayShouldRefundMapper.queryByRefundId(reqBO.getRefundId())).getPaidAmount().compareTo(fscPayShouldRefundPO.getRefundAmount()) == 0) {
            BigDecimal refundAmt = this.fscPurOrderRefundAmtMapper.getRefundAmtByOrderId(fscPayShouldRefundPO.getOrderId());
            BigDecimal refundedAmt = this.fscPayShouldRefundMapper.getRefundedAmtByOrderId(fscPayShouldRefundPO.getOrderId());
            if (refundedAmt.compareTo(refundAmt) >= 0) {
                FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
                fscClaimDetailPO.setOrderIds(Collections.singleton(fscPayShouldRefundPO.getOrderId()));
                fscClaimDetailPO.setRefundLock(FscConstants.RefundLock.NO);
                count = this.fscClaimDetailMapper.updateRefundLock(fscClaimDetailPO);
                if (count < 1) {
                    throw new FscBusinessException("190000", "\u91ca\u653e\u8ba2\u5355\u8ba4\u9886\u660e\u7ec6\u9000\u6b3e\u9501\u5b9a\u5931\u8d25");
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

