/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.busi.api.FscBillReopenInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderItemReqBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderItemTempMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderItemTempPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillReopenInvoiceBusiServiceImpl
implements FscBillReopenInvoiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillReopenInvoiceBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderItemTempMapper fscOrderItemTempMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;

    @Override
    public FscBillReopenInvoiceBusiRspBO dealInvoiceReopen(FscBillReopenInvoiceBusiReqBO reqBO) {
        int count;
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        this.dealReopenOrder(orderPO, reqBO);
        HashMap itemReqMap = new HashMap(8);
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderItemBOList())) {
            reqBO.getFscOrderItemBOList().forEach(itemReqBO -> itemReqMap.put(itemReqBO.getInspectionItemId(), itemReqBO));
        }
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setRefundId(reqBO.getRefundId());
        List refundItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        HashMap<Long, FscOrderItemPO> refundItemMap = new HashMap<Long, FscOrderItemPO>();
        HashSet<Long> orderItemIdSets = new HashSet<Long>();
        BigDecimal totalCharge = BigDecimal.ZERO;
        for (FscOrderItemPO fscOrderItemPO : refundItemList) {
            FscOrderItemPO refundItemPO = (FscOrderItemPO)refundItemMap.get(fscOrderItemPO.getOrderItemId());
            if (refundItemPO != null) {
                fscOrderItemPO.setAmt(fscOrderItemPO.getAmt().add(refundItemPO.getAmt()));
                fscOrderItemPO.setUntaxAmt(fscOrderItemPO.getUntaxAmt().add(refundItemPO.getUntaxAmt()));
                fscOrderItemPO.setTaxAmt(fscOrderItemPO.getTaxAmt().add(refundItemPO.getTaxAmt()));
                fscOrderItemPO.setNum(fscOrderItemPO.getNum().add(refundItemPO.getNum()));
            }
            orderItemIdSets.add(fscOrderItemPO.getOrderItemId());
            totalCharge = totalCharge.add(fscOrderItemPO.getAmt());
            refundItemMap.put(fscOrderItemPO.getOrderItemId(), fscOrderItemPO);
        }
        orderPO.setTotalCharge(totalCharge);
        orderPO.setToPayAmount(totalCharge);
        BigDecimal amount = BigDecimal.ZERO;
        if (FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD.equals(orderPO.getPayType()) && FscConstants.MerchantPayNodeRule.SIGN.equals(orderPO.getShouldPayType())) {
            amount = orderPO.getTotalCharge();
        } else if (reqBO.getToPayAmount() != null) {
            // empty if block
        }
        Map<Object, Object> orderItemTempMap = new HashMap();
        if (null != reqBO.getNewFscOrderId()) {
            FscOrderItemTempPO fscOrderItemTempPO = new FscOrderItemTempPO();
            fscOrderItemTempPO.setFscOrderId(reqBO.getNewFscOrderId());
            List fscOrderItemTempPOList = this.fscOrderItemTempMapper.getList(fscOrderItemTempPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderItemTempPOList)) {
                orderItemTempMap = fscOrderItemTempPOList.stream().collect(Collectors.toMap(FscOrderItemTempPO::getOrderItemId, o -> o, (o1, o2) -> o1));
            }
        }
        HashMap<Long, BigDecimal> relationMap = new HashMap<Long, BigDecimal>();
        orderItemPO = new FscOrderItemPO();
        orderItemPO.setOrderItemIdSets(orderItemIdSets);
        orderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List orderItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        if (orderItemList.size() != orderItemIdSets.size()) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u539f\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        for (FscOrderItemPO fscOrderItemPO : orderItemList) {
            FscOrderItemReqBO fscOrderItemReqBO;
            FscOrderItemPO refundItemPO = (FscOrderItemPO)refundItemMap.get(fscOrderItemPO.getOrderItemId());
            if (refundItemPO == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u9000\u7968\u660e\u7ec6\u5931\u8d25\uff01");
            }
            fscOrderItemPO.setAmt(refundItemPO.getAmt());
            fscOrderItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getAmt(), (BigDecimal)fscOrderItemPO.getTaxRate()));
            fscOrderItemPO.setUntaxAmt(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getTaxAmt()));
            fscOrderItemPO.setNum(refundItemPO.getNum());
            fscOrderItemPO.setPurchaseAmt(fscOrderItemPO.getPurchasePrice().multiply(fscOrderItemPO.getNum()).setScale(2, RoundingMode.HALF_UP));
            BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getPurchaseAmt(), (BigDecimal)fscOrderItemPO.getTaxRate());
            fscOrderItemPO.setPurchaseUntaxAmt(fscOrderItemPO.getPurchaseAmt().subtract(purchaseTaxAmt));
            if (fscOrderItemPO.getSalesUnitRate() != null) {
                fscOrderItemPO.setSettleNum(fscOrderItemPO.getNum().multiply(fscOrderItemPO.getSalesUnitRate()));
            }
            if ((fscOrderItemReqBO = (FscOrderItemReqBO)itemReqMap.get(fscOrderItemPO.getOrderItemId())) != null && (Objects.nonNull(fscOrderItemReqBO.getProductDescription()) || Objects.nonNull(fscOrderItemReqBO.getSpecificationsModel()))) {
                fscOrderItemPO.setProductDescription(fscOrderItemReqBO.getProductDescription());
                fscOrderItemPO.setSpecificationsModel(fscOrderItemReqBO.getSpecificationsModel());
            }
            if (relationMap.get(fscOrderItemPO.getAcceptOrderId()) == null) {
                relationMap.put(fscOrderItemPO.getAcceptOrderId(), fscOrderItemPO.getAmt());
            } else {
                BigDecimal settleAmt = (BigDecimal)relationMap.get(fscOrderItemPO.getAcceptOrderId());
                settleAmt = settleAmt.add(fscOrderItemPO.getAmt());
                relationMap.put(fscOrderItemPO.getAcceptOrderId(), settleAmt);
            }
            fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderItemPO.setFscOrderId(orderPO.getFscOrderId());
            fscOrderItemPO.setRefundAmt(BigDecimal.ZERO);
            fscOrderItemPO.setRefundId(null);
            if (null == reqBO.getNewFscOrderId() || CollectionUtils.isEmpty(orderItemTempMap) || !orderItemTempMap.containsKey(fscOrderItemPO.getOrderItemId())) continue;
            FscOrderItemTempPO fscOrderItemTempPO = (FscOrderItemTempPO)orderItemTempMap.get(fscOrderItemPO.getOrderItemId());
            fscOrderItemPO.setProductDescription(fscOrderItemTempPO.getProductDescription());
            fscOrderItemPO.setSpecificationsModel(fscOrderItemTempPO.getSpecificationsModel());
        }
        Map<Object, Object> contactRemarkMap = new HashMap();
        if (null != reqBO.getNewFscOrderId()) {
            FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
            fscOrderRelationTempPO.setFscOrderId(reqBO.getNewFscOrderId());
            List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
                contactRemarkMap = fscOrderRelationTempPOList.stream().collect(Collectors.toMap(FscOrderRelationTempPO::getContractId, o -> o, (o1, o2) -> o1));
            }
        }
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(reqBO.getFscOrderId());
        relationPO.setAcceptOrderIdSets(relationMap.keySet());
        List relationList = this.fscOrderRelationMapper.getListNoPage(relationPO);
        for (FscOrderRelationPO fscOrderRelationPO : relationList) {
            if (relationMap.get(fscOrderRelationPO.getAcceptOrderId()) == null) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u91d1\u989d\u5931\u8d25\uff01");
            }
            fscOrderRelationPO.setSettleAmt((BigDecimal)relationMap.get(fscOrderRelationPO.getAcceptOrderId()));
            fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderRelationPO.setFscOrderId(orderPO.getFscOrderId());
            fscOrderRelationPO.setAmount(BigDecimal.ZERO);
            if (fscOrderRelationPO.getSettleAmt().compareTo(amount) >= 0 && amount.compareTo(BigDecimal.ZERO) > 0) {
                fscOrderRelationPO.setAmount(amount);
                amount = BigDecimal.ZERO;
            } else if (fscOrderRelationPO.getSettleAmt().compareTo(amount) < 0 && amount.compareTo(BigDecimal.ZERO) > 0) {
                fscOrderRelationPO.setAmount(fscOrderRelationPO.getSettleAmt());
                amount = amount.subtract(fscOrderRelationPO.getSettleAmt());
            }
            if (null != reqBO.getNewFscOrderId()) {
                if (CollectionUtils.isEmpty(contactRemarkMap) || !contactRemarkMap.containsKey(fscOrderRelationPO.getContractId())) continue;
                FscOrderRelationTempPO fscOrderRelationTempPO = (FscOrderRelationTempPO)contactRemarkMap.get(fscOrderRelationPO.getContractId());
                fscOrderRelationPO.setContractRemark(fscOrderRelationTempPO.getContractRemark());
                continue;
            }
            fscOrderRelationPO.setContractRemark(reqBO.getContractRemark());
        }
        FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
        fscOrderInvoicePo.setFscOrderId(orderPO.getFscOrderId());
        fscOrderInvoicePo.setBillOperName(reqBO.getName());
        fscOrderInvoicePo.setBillTime(new Date());
        fscOrderInvoicePo.setBillTimeStart(new Date());
        FscOrderInvoicePO orderInvoicePO = new FscOrderInvoicePO();
        orderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePO);
        fscOrderInvoicePo.setAccountSetId(orderInvoicePO.getAccountSetId());
        fscOrderInvoicePo.setAccountSetName(orderInvoicePO.getAccountSetName());
        if (this.operationOrgId.equals(orderPO.getPayeeId())) {
            fscOrderInvoicePo.setInvoiceCategory(FscConstants.FscInvoiceCategory.FULL);
        }
        orderPO.setBuyName(fscOrderInvoicePo.getBuyName());
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            this.saveFile(reqBO.getAttachmentList(), orderPO.getFscOrderId(), ((FscOrderRelationPO)relationList.get(0)).getContractId(), reqBO.getNewFscOrderId());
        }
        FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
        fscInvoiceRulePO.setFscOrderId(orderPO.getFscOrderId());
        fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
        fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
        fscInvoiceRulePO.setElecFlag(elecFlag);
        fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
        FscOrderExtPO extPO = new FscOrderExtPO();
        extPO.setFscOrderId(reqBO.getFscOrderId());
        extPO = this.fscOrderExtMapper.getModelBy(extPO);
        if (extPO != null) {
            extPO.setFscOrderId(orderPO.getFscOrderId());
            extPO.setUnifyPushStatus(null);
            int count2 = this.fscOrderExtMapper.insert(extPO);
            if (count2 != 1) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u6269\u5c55\u8868\u6570\u636e\u5931\u8d25\uff01");
            }
        }
        FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
        orderFinancePO.setFscOrderId(reqBO.getFscOrderId());
        orderFinancePO = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
        if (orderFinancePO != null) {
            orderFinancePO.setFscOrderId(orderPO.getFscOrderId());
            orderFinancePO.setCreateUserId(reqBO.getUserName());
            orderFinancePO.setCreateUserName(reqBO.getName());
            orderFinancePO.setCreateTime(new Date());
            orderFinancePO.setUpdateUserId(null);
            orderFinancePO.setUpdateUserName(null);
            orderFinancePO.setUpdateTime(null);
            orderFinancePO.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
            orderFinancePO.setPushFinanceRemark(null);
            orderFinancePO.setNote(reqBO.getNote());
            orderFinancePO.setExchangeRate(reqBO.getExchangeRate());
            orderFinancePO.setFinanceAuditAccount(null);
            orderFinancePO.setFinanceAuditName(null);
            orderFinancePO.setPostingDate(null);
            orderFinancePO.setPostingStatus("0");
            orderFinancePO.setPaySource(null);
            count = this.fscOrderFinanceMapper.insert(orderFinancePO);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if ((count = this.fscOrderInvoiceMapper.insert(fscOrderInvoicePo)) != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList<FscOrderPO> orderPOList = new ArrayList<FscOrderPO>();
        orderPOList.add(orderPO);
        count = this.fscOrderMapper.insertBatch(orderPOList);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscInvoiceRuleMapper.insert(fscInvoiceRulePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderItemMapper.insertBatch(orderItemList);
        if (count != orderItemList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderRelationMapper.insertBatch(relationList);
        if (count != relationList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setReopenFscOrderId(orderPO.getFscOrderId());
        refundPO.setReopenFlag(FscConstants.ReopenFlag.YES);
        count = this.fscOrderRefundMapper.updateById(refundPO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u51b2\u9500\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        FscBillReopenInvoiceBusiRspBO rspBO = new FscBillReopenInvoiceBusiRspBO();
        if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(Collections.singletonList(orderPO.getFscOrderId()));
            fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
            count = this.fscOrderMapper.dealSave(fscOrderPO);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u5931\u8d25\uff01");
            }
        } else {
            FscOrderStatusStartAtomReqBO atomReqBO = (FscOrderStatusStartAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
            atomReqBO.setOrderFlow(orderPO.getOrderFlow());
            atomReqBO.setOrderId(orderPO.getFscOrderId());
            FscOrderStatusStartAtomRspBO atomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193008", atomRspBO.getRespDesc());
            }
            if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
                this.startApproval(reqBO, orderPO, rspBO);
            }
        }
        rspBO.setFscOrderIds(Collections.singletonList(orderPO.getFscOrderId()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void startApproval(FscBillReopenInvoiceBusiReqBO reqBO, FscOrderPO orderPO, FscBillReopenInvoiceBusiRspBO rspBO) {
        String[] org;
        this.fscOrderMapper.deleteOrderSendTemp(orderPO.getFscOrderId());
        FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        fscSendTemp.setFscOrderId(orderPO.getFscOrderId());
        fscSendTemp.setYcDeptName(reqBO.getDeptName());
        fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
        fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
        fscSendTemp.setYcPersonName(reqBO.getPersonName());
        fscSendTemp.setBuynerName(orderPO.getBuynerName());
        fscSendTemp.setBuynerNo(orderPO.getBuynerNo());
        int count = this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5ba1\u6279\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        boolean individuallyPay = !orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL);
        FscOrderPO fscOrderPO = new FscOrderPO();
        Boolean uacFlag = this.invokeUacTask(reqBO, orderPO, individuallyPay);
        if (uacFlag.booleanValue() && individuallyPay) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
        if (uacFlag.booleanValue()) {
            fscOrderPO.setSendState(FscOrderSendStateEnum.NOT_AUDIT.getCode());
            fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_PASS);
            rspBO.setApprovalFlag(true);
        }
        if (!uacFlag.booleanValue()) {
            FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
            taskPo.setFscOrderId(orderPO.getFscOrderId());
            fscOrderPO.setSignApplyTime(new Date());
            List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
            if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            }
            fscOrderPO.setSendApplyTime(new Date());
            fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
            fscOrderPO.setSendUserId(reqBO.getUserId());
            fscOrderPO.setSendUserName(reqBO.getName());
        }
        fscOrderPO.setFscOrderId(orderPO.getFscOrderId());
        fscOrderPO.setOperatorId(reqBO.getUserId());
        fscOrderPO.setOperatorName(reqBO.getName());
        String operationNo = String.valueOf(reqBO.getOrgId());
        String[] pur = reqBO.getOrgPath().split("-");
        block0: for (String pro : org = this.proOrg.split(",")) {
            for (String t : pur) {
                if (!pro.equals(t)) continue;
                operationNo = pro;
                continue block0;
            }
        }
        fscOrderPO.setOperationNo(operationNo);
        this.fscOrderMapper.updateById(fscOrderPO);
    }

    private void saveFile(List<AttachmentBO> attachmentList, Long fscOrderId, Long contractId, Long newFscOrderId) {
        ArrayList<FscAttachmentPO> fileList = new ArrayList<FscAttachmentPO>();
        for (AttachmentBO attachmentBO : attachmentList) {
            FscAttachmentPO attachmentPO = new FscAttachmentPO();
            attachmentPO.setFscOrderId(fscOrderId);
            attachmentPO.setAttachmentName(attachmentBO.getAttachmentName());
            attachmentPO.setAttachmentUrl(attachmentBO.getAttachmentUrl());
            attachmentPO.setObjId(contractId);
            if (null != newFscOrderId) {
                attachmentPO.setObjId(attachmentBO.getObjId());
            }
            attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentPO.setObjType(FscConstants.AttachmentObjType.FSC_ORDER);
            attachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER);
            fileList.add(attachmentPO);
        }
        this.fscAttachmentMapper.insertBatch(fileList);
    }

    private void dealReopenOrder(FscOrderPO orderPO, FscBillReopenInvoiceBusiReqBO reqBO) {
        orderPO.setOrderNo(reqBO.getFscOrderNo());
        orderPO.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        orderPO.setRefundId(reqBO.getRefundId());
        orderPO.setCreateTime(new Date());
        orderPO.setCreateCompanyId(reqBO.getCompanyId());
        orderPO.setCreateCompanyName(reqBO.getCompanyName());
        orderPO.setCreateOrgId(reqBO.getOrgId());
        orderPO.setCreateOrgName(reqBO.getOrgName());
        orderPO.setCreateOperId(reqBO.getUserId());
        orderPO.setCreateOperName(reqBO.getName());
        orderPO.setInvoiceRemark(reqBO.getInvoiceRemark());
        orderPO.setSettlePlatform(reqBO.getSettlePlatform());
        orderPO.setRemark(reqBO.getRemark());
    }

    private Boolean invokeUacTask(FscBillReopenInvoiceBusiReqBO reqBO, FscOrderPO orderPO, boolean individuallyPay) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        if (individuallyPay) {
            if (FscOrderSourceEnum.ELECTRIC_AREA.getCode().equals(orderPO.getOrderSource()) && FscConstants.FscOrderMakeType.OPERTION.equals(orderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(orderPO.getReceiveType())) {
                auditCreateReqBO.setMenuId("FSC_ARGEE_DOWN_ORDER_INVOICE_PROCESS");
            } else {
                auditCreateReqBO.setMenuId("M001007");
            }
        } else {
            auditCreateReqBO.setMenuId("M001008");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(orderPO.getFscOrderId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(orderPO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(orderPO.getFscOrderId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                String orderTypeStr = orderPO.getOrderType() == 2 && orderPO.getTradeMode() != null && orderPO.getTradeMode() == 2 && orderPO.getOrderSource() == 3 && orderPO.getSettlePlatform() != null && orderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(orderPO.getOrderType() + "");
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(orderPO.getOrderNo() + "\u9500\u552e\u7ed3\u7b97_" + orderTypeStr + "_" + orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9500\u552e\u7ed3\u7b97\u5355" + orderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        try {
            this.taskTodoWaitService.syncNotifyAccountWaitDone(orderPO.getFscOrderId());
        }
        catch (Exception e) {
            log.error("dealCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
        return uacNoTaskAuditCreateRspBO.getNotFindFlag();
    }
}

