/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffCancelBusiService;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffCancelServiceBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffCancelServiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustDetailPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceWriteOffCancelBusiServiceImpl
implements FscFinanceWriteOffCancelBusiService {
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;

    @Override
    public FscFinanceWriteOffCancelServiceBusiRspBO cancelFinanceWriteOff(FscFinanceWriteOffCancelServiceBusiReqBO reqBO) {
        FscFinanceWriteOffCancelServiceBusiRspBO rspBO = new FscFinanceWriteOffCancelServiceBusiRspBO();
        Iterator iterator = reqBO.getList().iterator();
        while (iterator.hasNext()) {
            FscFinanceWriteOffAdjustPO adjustPO;
            adjustPO.setWriteOffAmt(FscConstants.FinanceWriteOffType.ADD.equals((adjustPO = (FscFinanceWriteOffAdjustPO)iterator.next()).getBillType()) ? adjustPO.getWriteOffAmt().negate() : adjustPO.getWriteOffAmt());
            this.dealAmount(adjustPO);
            FscFinanceWriteOffAdjustPO adjustPo = new FscFinanceWriteOffAdjustPO();
            adjustPo.setUpdateTime(new Date());
            adjustPo.setUpdateUserId(reqBO.getUserId());
            adjustPo.setUpdateUserName(reqBO.getUserName());
            adjustPo.setBillStatus(FscConstants.WriteOffBillStatus.WITHDRAWING.equals(adjustPO.getBillStatus()) ? FscConstants.WriteOffBillStatus.WITHDRAW_END : FscConstants.WriteOffBillStatus.CANCELED);
            FscFinanceWriteOffAdjustPO where = new FscFinanceWriteOffAdjustPO();
            where.setAdjustId(adjustPO.getAdjustId());
            this.fscFinanceWriteOffAdjustMapper.updateBy(adjustPo, where);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void dealAmount(FscFinanceWriteOffAdjustPO adjustPO) {
        FscFinanceWriteOffAdjustDetailPO adjustDetailPO = new FscFinanceWriteOffAdjustDetailPO();
        adjustDetailPO.setAdjustId(adjustPO.getAdjustId());
        List list = this.fscFinanceWriteOffAdjustDetailMapper.getList(adjustDetailPO);
        for (FscFinanceWriteOffAdjustDetailPO detailPO : list) {
            int num;
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setOrderPayItemId(detailPO.getOrderPayDetailId());
            fscOrderPayItemPO.setPurWriteOffAmount(detailPO.getWriteOffAmt());
            if (adjustPO.getWriteOffAmt().compareTo(BigDecimal.ZERO) < 0) {
                fscOrderPayItemPO.setPurWriteOffAmount(detailPO.getWriteOffAmt().negate());
            }
            if ((num = this.fscOrderPayItemMapper.updatePurWriteOffAmountAdd(fscOrderPayItemPO)) >= 1) continue;
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u5355\u6838\u9500\u91d1\u989d[purWriteOffAmount]\u5f02\u5e38,orderPayItemId:" + detailPO.getOrderPayDetailId());
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(adjustPO.getFscOrderId());
        fscOrderPo.setPurWriteOffAmount(adjustPO.getWriteOffAmt());
        int num = this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPo);
        if (num < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4e3b\u5355\u6838\u9500\u91d1\u989d[purWriteOffAmount]\u5f02\u5e38,fscOrderId:" + adjustPO.getFscOrderId());
        }
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(adjustPO.getBillType())) {
            FscFinanceWriteOffPO set = new FscFinanceWriteOffPO();
            List cancelDetailsId = list.stream().map(FscFinanceWriteOffAdjustDetailPO::getCancelAdjustDetailId).collect(Collectors.toList());
            set.setCancelStatus(Integer.valueOf(1));
            if (adjustPO.getWriteOffAmt().compareTo(BigDecimal.ZERO) > 0) {
                set.setCancelStatus(Integer.valueOf(0));
            }
            FscFinanceWriteOffPO where = new FscFinanceWriteOffPO();
            where.setWriteOffIds(cancelDetailsId);
            int i = this.fscFinanceWriteOffMapper.updateBy(set, where);
            if (i < 1) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u64a4\u9500\u72b6\u6001\u5f02\u5e38,writeOffIds:" + cancelDetailsId);
            }
        }
    }
}

