/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscReconcilDealBusiService;
import com.tydic.fsc.bill.busi.bo.FscReconciliationDataBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscReconciliationDataBusiRspBO;
import com.tydic.fsc.dao.FscYcClaimDetailReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcClaimReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcFscReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcOrderReconciliationInfoMapper;
import com.tydic.fsc.dao.FscYcPayReconciliationInfoMapper;
import com.tydic.fsc.po.FscYcClaimDetailReconciliationInfoPO;
import com.tydic.fsc.po.FscYcClaimReconciliationInfoPO;
import com.tydic.fsc.po.FscYcFscReconciliationInfoPO;
import com.tydic.fsc.po.FscYcOrderReconciliationInfoPO;
import com.tydic.fsc.po.FscYcPayReconciliationInfoPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscReconcilDealBusiServiceImpl
implements FscReconcilDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscReconcilDealBusiServiceImpl.class);
    @Autowired
    private FscYcOrderReconciliationInfoMapper fscYcOrderReconciliationInfoMapper;
    @Autowired
    private FscYcFscReconciliationInfoMapper fscYcFscReconciliationInfoMapper;
    @Autowired
    private FscYcPayReconciliationInfoMapper fscYcPayReconciliationInfoMapper;
    @Autowired
    private FscYcClaimReconciliationInfoMapper fscYcClaimReconciliationInfoMapper;
    @Autowired
    private FscYcClaimDetailReconciliationInfoMapper fscYcClaimDetailReconciliationInfoMapper;

    @Override
    public FscReconciliationDataBusiRspBO dealData(FscReconciliationDataBusiReqBO reqBO) {
        JSONObject resultData = JSONObject.parseObject((String)reqBO.getContent());
        String type = resultData.getString("type");
        JSONArray jsonArray = resultData.getJSONArray("rows");
        Date date = new Date();
        switch (type) {
            case "1": {
                ArrayList<FscYcOrderReconciliationInfoPO> poList = new ArrayList<FscYcOrderReconciliationInfoPO>();
                ArrayList<String> orderNos = new ArrayList<String>();
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    FscYcOrderReconciliationInfoPO po = new FscYcOrderReconciliationInfoPO();
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setOrderId(Long.valueOf(jsonObject.getLongValue("PO_HEADER_ID")));
                    po.setOrderNo(jsonObject.getString("PO_NUMBER"));
                    po.setContactId(Long.valueOf(jsonObject.getLongValue("EG_CONTRACT_ID")));
                    po.setAccount(jsonObject.getString("ORG_NAME"));
                    po.setDept(jsonObject.getString("DEPT_NAME"));
                    po.setOperator(jsonObject.getString("PERSON_NAME"));
                    po.setCreateTime(date);
                    poList.add(po);
                    orderNos.add(po.getOrderNo());
                }
                this.fscYcOrderReconciliationInfoMapper.deleteOrderNo(orderNos);
                this.fscYcOrderReconciliationInfoMapper.insertBatch(poList);
                break;
            }
            case "2": {
                ArrayList<FscYcFscReconciliationInfoPO> fscPoList = new ArrayList<FscYcFscReconciliationInfoPO>();
                ArrayList<Long> fscOrderIds = new ArrayList<Long>();
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    FscYcFscReconciliationInfoPO po = new FscYcFscReconciliationInfoPO();
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setFscOrderId(Long.valueOf(jsonObject.getLongValue("EG_BALANCE_ID")));
                    po.setType(Integer.valueOf(2));
                    po.setTotalCharge(jsonObject.getString("AMOUNT"));
                    po.setPostingStatus("\u5df2\u8fc7\u8d26".equals(jsonObject.getString("POST_STATUS")) ? "1" : "0");
                    po.setPostingDate(jsonObject.getString("GL_DATE"));
                    po.setVoucher(jsonObject.getString("INVOICE_NUM"));
                    po.setWriteOffAmount(jsonObject.getString("WRITE_AMOUNT"));
                    po.setErpTotalCharge(jsonObject.getString("INVOICE_AMOUNT"));
                    po.setErpWriteOffAmount(jsonObject.getString("ERP_WRITE_AMOUNT"));
                    po.setCreateTime(date);
                    fscPoList.add(po);
                    fscOrderIds.add(po.getFscOrderId());
                }
                this.fscYcFscReconciliationInfoMapper.deleteByFscOrderId(fscOrderIds);
                this.fscYcFscReconciliationInfoMapper.insertBatch(fscPoList);
                break;
            }
            case "3": {
                ArrayList<FscYcFscReconciliationInfoPO> shList = new ArrayList<FscYcFscReconciliationInfoPO>();
                ArrayList<Long> shIds = new ArrayList<Long>();
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    FscYcFscReconciliationInfoPO po = new FscYcFscReconciliationInfoPO();
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setFscOrderId(Long.valueOf(jsonObject.getLongValue("EG_TESCO_ID")));
                    po.setType(Integer.valueOf(1));
                    po.setTotalCharge(jsonObject.getString("JS_AMMOUNT"));
                    po.setPostingStatus("\u5df2\u8fc7\u8d26".equals(jsonObject.getString("IMPORT_STATUS_DIS")) ? "1" : "0");
                    po.setPostingDate(jsonObject.getString("GL_DATE"));
                    po.setVoucher(jsonObject.getString("ERP_TRX_NUMBER"));
                    po.setWriteOffAmount(jsonObject.getString("YE_HEAMOUNT"));
                    po.setErpTotalCharge(jsonObject.getString("EXTENDED_AMOUNT"));
                    po.setErpWriteOffAmount(jsonObject.getString("amount_applied"));
                    po.setCreateTime(date);
                    shList.add(po);
                    shIds.add(po.getFscOrderId());
                }
                this.fscYcFscReconciliationInfoMapper.deleteByFscOrderId(shIds);
                this.fscYcFscReconciliationInfoMapper.insertBatch(shList);
                break;
            }
            case "4": {
                ArrayList<FscYcPayReconciliationInfoPO> payPoList = new ArrayList<FscYcPayReconciliationInfoPO>();
                ArrayList<Long> payIds = new ArrayList<Long>();
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    FscYcPayReconciliationInfoPO po = new FscYcPayReconciliationInfoPO();
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setFscOrderId(Long.valueOf(jsonObject.getLongValue("EG_PAYMENT_ID")));
                    po.setTotalCharge(jsonObject.getString("AMOUNT"));
                    po.setPostingStatus("\u5df2\u8fc7\u8d26".equals(jsonObject.getString("POST_STATUS_DIS")) ? "1" : "0");
                    po.setPostingDate(jsonObject.getString("GL_DATE"));
                    po.setVoucher(jsonObject.getString("ERP_CHECK_NUMBER"));
                    po.setPayDate(jsonObject.getString("PAY_DATE"));
                    po.setErpAmount(jsonObject.getString("ERP_AMOUNT"));
                    po.setCreateTime(date);
                    payPoList.add(po);
                    payIds.add(po.getFscOrderId());
                }
                this.fscYcPayReconciliationInfoMapper.deleteByFscOrderId(payIds);
                this.fscYcPayReconciliationInfoMapper.insertBatch(payPoList);
                break;
            }
            case "5": {
                ArrayList<FscYcClaimReconciliationInfoPO> claimPoList = new ArrayList<FscYcClaimReconciliationInfoPO>();
                ArrayList<Long> claimIds = new ArrayList<Long>();
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    FscYcClaimReconciliationInfoPO po = new FscYcClaimReconciliationInfoPO();
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setClaimId(Long.valueOf(jsonObject.getLongValue("EG_TESCO_ID")));
                    po.setTotalCharge(jsonObject.getString("AMOUNT"));
                    po.setPostingStatus("\u5df2\u8fc7\u8d26".equals(jsonObject.getString("IMPORT_STATUS")) ? "1" : "0");
                    po.setFlowingWater(jsonObject.getString("BANK_FLOW_NUMBER"));
                    po.setVoucher(jsonObject.getString("ERP_RECEIPT_NUMBER"));
                    po.setErpAmount(jsonObject.getString("ERP_AMOUNT"));
                    po.setRecDate(jsonObject.getString("REC_DATE"));
                    po.setCreateTime(date);
                    claimPoList.add(po);
                    claimIds.add(po.getClaimId());
                }
                this.fscYcClaimReconciliationInfoMapper.deleteByClaimId(claimIds);
                this.fscYcClaimReconciliationInfoMapper.insertBatch(claimPoList);
                break;
            }
            case "6": {
                ArrayList<FscYcClaimDetailReconciliationInfoPO> detailPoList = new ArrayList<FscYcClaimDetailReconciliationInfoPO>();
                ArrayList<Long> detailIds = new ArrayList<Long>();
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    FscYcClaimDetailReconciliationInfoPO po = new FscYcClaimDetailReconciliationInfoPO();
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setClaimDetailId(Long.valueOf(jsonObject.getLongValue("EG_TESCO_ID")));
                    po.setTotalCharge(jsonObject.getString("CLAIM_AMOUNT"));
                    po.setVerifiedOff(jsonObject.getString("ERP_WRITE_AMOUNT"));
                    po.setNotVerifiedOff(jsonObject.getString("REM_AMOUNT"));
                    po.setCreateTime(date);
                    detailPoList.add(po);
                    detailIds.add(po.getClaimDetailId());
                }
                this.fscYcClaimDetailReconciliationInfoMapper.deleteByClaimIdDetail(detailIds);
                this.fscYcClaimDetailReconciliationInfoMapper.insertBatch(detailPoList);
                break;
            }
            default: {
                log.error("type is not exist");
            }
        }
        return new FscReconciliationDataBusiRspBO();
    }

    @Override
    public FscReconciliationDataBusiRspBO deleteData(FscReconciliationDataBusiReqBO reqBO) {
        if (reqBO.getContent().contains("1")) {
            this.fscYcOrderReconciliationInfoMapper.deleteAll();
        }
        if (reqBO.getContent().contains("2")) {
            this.fscYcFscReconciliationInfoMapper.deleteAll();
        }
        if (reqBO.getContent().contains("3")) {
            this.fscYcPayReconciliationInfoMapper.deleteAll();
        }
        if (reqBO.getContent().contains("4")) {
            this.fscYcClaimReconciliationInfoMapper.deleteAll();
        }
        if (reqBO.getContent().contains("5")) {
            this.fscYcClaimDetailReconciliationInfoMapper.deleteAll();
        }
        return new FscReconciliationDataBusiRspBO();
    }
}

