/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscSyncYcRefundInvoicePostBusiService;
import com.tydic.fsc.bill.busi.bo.FscSyncYcRefundInvoicePostBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscSyncYcRefundInvoicePostBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscSyncYcRefundInvoicePostBusiServiceImpl
implements FscSyncYcRefundInvoicePostBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u8fc7\u8d26";

    @Override
    public FscSyncYcRefundInvoicePostBusiRspBO dealYcRefundInvoicePost(FscSyncYcRefundInvoicePostBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getBillId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (!refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.AUDIT_PASS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u901a\u8fc7\u72b6\u6001,\u65e0\u6cd5\u8fc7\u8d26\uff01");
        }
        if (!refundPO.getInvoiceStatus().equals(FscConstants.FscInvoiceStatus.RED) || !refundPO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
            this.syncOrderStatus(refundPO);
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        if (reqBO.getBillDate() == null) {
            updatePo.setPostTime(new Date());
        } else {
            updatePo.setPostTime(reqBO.getBillDate());
        }
        this.fscOrderRefundMapper.updateById(updatePo);
        this.dealWorkFlow(refundPO);
        FscSyncYcRefundInvoicePostBusiRspBO rspBO = new FscSyncYcRefundInvoicePostBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncOrderStatus(FscOrderRefundPO refundPO) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setRefundId(refundPO.getRefundId());
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.REFUND);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        FscUocOrderRelUpdateAtomRspBO fscUocOrderRelUpdateAtomRspBO = this.fscUocOrderRelUpdateAtomService.dealRefundUpdate(fscUocOrderRelUpdateAtomReqBO);
        if (!fscUocOrderRelUpdateAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscUocOrderRelUpdateAtomRspBO.getRespCode(), "\u91ca\u653e\u8ba2\u5355\u5931\u8d25\uff1a" + fscUocOrderRelUpdateAtomRspBO.getRespDesc());
        }
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }
}

