/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceEditAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceEditAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceEditAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderItemRhMatchAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceEditBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceEditBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceEditBusiRspBO;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneDealReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceEditAbilityService"})
public class FscBillInvoiceEditAbilityServiceImpl
implements FscBillInvoiceEditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillInvoiceEditAbilityServiceImpl.class);
    @Autowired
    private FscBillInvoiceEditBusiService fscBillInvoiceEditBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource(name="fscOrderItemRhMqServiceProvider")
    private ProxyMessageProducer fscOrderItemRhMqServiceProvider;
    @Value(value="${es.FSC_ORDER_ITEM_RH_MATCH_TOPIC:FSC_ORDER_ITEM_RH_MATCH_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_ORDER_ITEM_RH_MATCH_TAG:FSC_ORDER_ITEM_RH_MATCH_TAG}")
    private String tag;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;

    @PostMapping(value={"editInvoice"})
    public FscBillInvoiceEditAbilityRspBO editInvoice(@RequestBody FscBillInvoiceEditAbilityReqBO reqBO) {
        this.validParam(reqBO);
        FscBillInvoiceEditBusiReqBO busiReqBO = (FscBillInvoiceEditBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillInvoiceEditBusiReqBO.class));
        FscBillInvoiceEditBusiRspBO busiRspBO = this.fscBillInvoiceEditBusiService.editInvoice(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("193019", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        this.sendFscOrderItemRhMq(reqBO);
        try {
            this.dealWaitDone(reqBO);
        }
        catch (Exception e) {
            log.error("\u5f85\u5f00\u7968\u7ed3\u7b97\u5355\u53d6\u6d88", (Throwable)e);
        }
        FscBillInvoiceEditAbilityRspBO rspBO = new FscBillInvoiceEditAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealWaitDone(FscBillInvoiceEditAbilityReqBO reqBO) {
        if ("1".equals(reqBO.getSubmitFlag())) {
            FscTodoBusinessWaitDoneDealReqBo fscTodoBusinessWaitDoneDealReqBo = new FscTodoBusinessWaitDoneDealReqBo();
            fscTodoBusinessWaitDoneDealReqBo.setBusiCode("1020");
            fscTodoBusinessWaitDoneDealReqBo.setDealUserNo(String.valueOf(reqBO.getUserName()));
            fscTodoBusinessWaitDoneDealReqBo.setDealUserName(reqBO.getName());
            fscTodoBusinessWaitDoneDealReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
            fscTodoBusinessWaitDoneDealReqBo.setObjId(String.valueOf(reqBO.getFscOrderId()));
            this.fscBusinessPendingTodoAbilityService.dealWaitDone(fscTodoBusinessWaitDoneDealReqBo);
        }
    }

    @PostMapping(value={"returnInvoice"})
    public FscBillInvoiceEditAbilityRspBO returnInvoice(@RequestBody FscBillInvoiceEditAbilityReqBO reqBO) {
        this.returnValidParam(reqBO);
        FscBillInvoiceEditBusiReqBO busiReqBO = (FscBillInvoiceEditBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillInvoiceEditBusiReqBO.class));
        FscBillInvoiceEditBusiRspBO busiRspBO = this.fscBillInvoiceEditBusiService.returnInvoice(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("193019", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        this.sendFscOrderItemRhMq(reqBO);
        FscBillInvoiceEditAbilityRspBO rspBO = new FscBillInvoiceEditAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendFscOrderItemRhMq(FscBillInvoiceEditAbilityReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform().equals(FscConstants.SettlePlatform.YES) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType())) {
            FscBillOrderItemRhMatchAbilityReqBO matchAbilityReqBO = new FscBillOrderItemRhMatchAbilityReqBO();
            matchAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            ProxySendResult proxySendResult = this.fscOrderItemRhMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)matchAbilityReqBO)));
        }
    }

    private void sendMq(FscBillInvoiceEditAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }

    private void returnValidParam(FscBillInvoiceEditAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    private void validParam(FscBillInvoiceEditAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAddFlag())) {
            if (ObjectUtil.isEmpty((Object)reqBO.getInvoiceBO())) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u4fe1\u606f[invoiceBO]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isEmpty((Object)reqBO.getSubmitFlag())) {
                throw new FscBusinessException("191000", "\u884c\u65b0\u589e\u3001\u4fdd\u5b58\u64cd\u4f5c\uff0c\u63d0\u4ea4\u6807\u8bc6[submitFlag]\u5fc5\u987b\u4e3a\u7a7a\uff01");
            }
        } else if (StringUtils.isEmpty((Object)reqBO.getSubmitFlag())) {
            throw new FscBusinessException("191000", "\u63d0\u4ea4\u6807\u8bc6[submitFlag]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getInvoiceBO())) {
            if (reqBO.getInvoiceBO().getInvoiceId() == null) {
                throw new FscBusinessException("191000", "\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getInvoiceBO().getInvoiceCategory() == null) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getInvoiceBO().getInvoiceNo())) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getInvoiceBO().getAmt() == null) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getInvoiceBO().getTaxAmt() == null) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getInvoiceBO().getUntaxAmt() == null) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getInvoiceBO().getUntaxAmt().compareTo(reqBO.getInvoiceBO().getAmt()) > 0) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f00\u7968\u91d1\u989d\uff01");
            }
            if ((FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceBO().getInvoiceCategory()) || FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceBO().getInvoiceCategory())) && StringUtils.isEmpty((Object)reqBO.getInvoiceBO().getInvoiceCode())) {
                throw new FscBusinessException("191000", "\u7eb8\u8d28\u53d1\u7968\u548c\u7535\u5b50\u53d1\u7968\u7c7b\u578b\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

