/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscBillOrderConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderConfirmBusiRspBO;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneDealReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderConfirmAbilityService"})
public class FscBillOrderConfirmAbilityServiceImpl
implements FscBillOrderConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderConfirmAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderConfirmBusiService fscBillOrderConfirmBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealBillOrderConfirm"})
    public FscBillOrderConfirmAbilityRspBO dealBillOrderConfirm(@RequestBody FscBillOrderConfirmAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmResult() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[confirmResult]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmResult().equals(FscConstants.FscConfirmResult.NOT_CONFIRM) && StringUtils.isEmpty((Object)reqBO.getRejectReason())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[rejectReason]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscBillOrderConfirmAbilityRspBO abilityRspBO = new FscBillOrderConfirmAbilityRspBO();
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(reqBO.getFscOrderIds());
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        HashSet<String> result = new HashSet<String>();
        for (FscOrderPO fscOrderPO : orderList) {
            if (!fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_UN_CONFIRMED) && !fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.APPROVAL_REJECT)) continue;
            FscBillOrderConfirmBusiReqBO confirmReqBO = new FscBillOrderConfirmBusiReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)confirmReqBO));
            confirmReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            confirmReqBO.setConfirmResult(reqBO.getConfirmResult());
            FscBillOrderConfirmBusiRspBO confirmRspBO = this.fscBillOrderConfirmBusiService.dealBillOrderConfirm(confirmReqBO);
            if (!confirmRspBO.getRespCode().equals("0000")) {
                result.add("\u7ed3\u7b97\u5355\u53f7" + fscOrderPO.getOrderNo() + "\u786e\u8ba4\u5931\u8d25\uff01" + confirmRspBO.getRespDesc());
            }
            FscComOrderListSyncAbilityReqBO syncReqBo = new FscComOrderListSyncAbilityReqBO();
            syncReqBo.setFscOrderId(fscOrderPO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(syncReqBo);
            try {
                this.dealWaitDone(reqBO, fscOrderPO);
            }
            catch (Exception e) {
                log.error("\u7ed3\u7b97\u5355\u56de\u9000\u53d6\u6d88\u5f85\u529e{}", (Object)e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(result)) {
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(String.join((CharSequence)",", result));
            return abilityRspBO;
        }
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        return abilityRspBO;
    }

    private void dealWaitDone(FscBillOrderConfirmAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        if (fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_UN_CONFIRMED)) {
            FscTodoBusinessWaitDoneDealReqBo fscTodoBusinessWaitDoneDealReqBo = new FscTodoBusinessWaitDoneDealReqBo();
            if ("0".equals(fscOrderPO.getOrderType().toString())) {
                fscTodoBusinessWaitDoneDealReqBo.setBusiCode("1034");
            } else if ("1".equals(fscOrderPO.getOrderSource().toString())) {
                fscTodoBusinessWaitDoneDealReqBo.setBusiCode("1035");
            } else {
                return;
            }
            fscTodoBusinessWaitDoneDealReqBo.setDealUserNo(String.valueOf(reqBO.getUserName()));
            fscTodoBusinessWaitDoneDealReqBo.setDealUserName(reqBO.getName());
            fscTodoBusinessWaitDoneDealReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
            fscTodoBusinessWaitDoneDealReqBo.setObjId(String.valueOf(fscOrderPO.getFscOrderId()));
            this.fscBusinessPendingTodoAbilityService.dealWaitDone(fscTodoBusinessWaitDoneDealReqBo);
        }
    }
}

