/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateReopenShouldPayAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateReopenShouldPayAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateReopenShouldPayAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateReopenShouldPayBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateReopenShouldPayBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateReopenShouldPayBusiRspBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundPayItemMapper;
import com.tydic.fsc.dao.FscRefundPaymentDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderCreateReopenShouldPayAbilityService"})
public class FscBillOrderCreateReopenShouldPayAbilityServiceImpl
implements FscBillOrderCreateReopenShouldPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateReopenShouldPayAbilityServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscRefundPaymentDetailMapper fscRefundPaymentDetailMapper;
    @Autowired
    private FscRefundPayItemMapper fscRefundPayItemMapper;
    @Autowired
    private FscBillOrderCreateReopenShouldPayBusiService fscBillOrderCreateReopenShouldPayBusiService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TOPIC:FSC_SIGN_BACK_FILL_INVOICE_TOPIC}")
    private String fscSignBackFillInvoiceTopic;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TAG:FSC_SIGN_BACK_FILL_INVOICE_TAG}")
    private String fscSignBackFillInvoiceTag;
    @Resource(name="fscSignBackFillInvoiceMqServiceProvider")
    private ProxyMessageProducer fscSignBackFillInvoiceMqServiceProvider;
    @Resource
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @PostMapping(value={"createReopenShouldPay"})
    public FscBillOrderCreateReopenShouldPayAbilityRspBO createReopenShouldPay(@RequestBody FscBillOrderCreateReopenShouldPayAbilityReqBO reqBO) {
        FscBillOrderCreateReopenShouldPayAbilityRspBO rspBO = new FscBillOrderCreateReopenShouldPayAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (FscOrderFlowEnum.ENGINEERING_INVOICE.getCode().equals(fscOrderPO.getOrderFlow())) {
            this.handelEngineeringReopen(fscOrderPO);
            return rspBO;
        }
        String billDateMax = this.fscInvoiceMapper.setInvoiceBillDate(fscOrderPO.getFscOrderId());
        HashSet<String> orderCodeList = new HashSet<String>();
        HashSet<String> orderOperList = new HashSet<String>();
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        if (fscOrderPO.getRefundId() != null) {
            List shouldPayPOList = this.fscShouldPayMapper.getReopenShouldPay(fscOrderPO.getRefundId());
            if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
                return rspBO;
            }
            if (CollectionUtils.isEmpty((Collection)reqBO.getOrderCodeList()) || CollectionUtils.isEmpty((Collection)reqBO.getOrderOperList())) {
                this.getOrderCode(fscOrderPO, orderCodeList, orderOperList);
            } else {
                orderCodeList.addAll(reqBO.getOrderCodeList());
                orderOperList.addAll(reqBO.getOrderOperList());
            }
            this.createReopenShouldPay(fscOrderPO, fscShouldPayBOS, orderCodeList, orderOperList, billDateMax, shouldPayPOList);
        }
        FscBillOrderCreateReopenShouldPayBusiReqBO busiReqBO = new FscBillOrderCreateReopenShouldPayBusiReqBO();
        busiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setRefundId(fscOrderPO.getRefundId());
        FscBillOrderCreateReopenShouldPayBusiRspBO busiRspBO = this.fscBillOrderCreateReopenShouldPayBusiService.createReopenShouldPay(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u5355\u8f6c\u79fb\u5931\u8d25" + busiRspBO.getRespDesc());
        }
        if (reqBO.getSyncESFlag() == null) {
            this.sendMq(reqBO.getOrderId());
        }
        return rspBO;
    }

    public void handelEngineeringReopen(FscOrderPO fscOrderPO) {
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundId(fscOrderPO.getRefundId());
        fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
        if (Objects.isNull(fscOrderRefundPO) || Objects.isNull(fscOrderRefundPO.getFscOrderId())) {
            log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u9000\u7968\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
            return;
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setRefundId(fscOrderRefundPO.getRefundId());
        List refundItemList = this.fscOrderItemMapper.getRefundList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)refundItemList)) {
            log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u9000\u7968\u660e\u7ec6\u4fe1\u606f\uff01");
            return;
        }
        FscOrderItemPO originOrderItemPO = new FscOrderItemPO();
        originOrderItemPO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
        List orderItemPOList = this.fscOrderItemMapper.getFinanceList(originOrderItemPO);
        if (Objects.isNull(orderItemPOList)) {
            log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u539f\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\uff01");
            return;
        }
        Map<Long, FscOrderItemPO> fscOrderItemPOMap = orderItemPOList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscOrderPO.getFscOrderId());
        this.transferShouldPay(fscOrderRefundPO, refundItemList, fscOrderPO, signTemp, fscOrderItemPOMap);
        this.transferWriteOff(fscOrderRefundPO, refundItemList, fscOrderPO, signTemp, fscOrderItemPOMap);
    }

    private void transferShouldPay(FscOrderRefundPO fscOrderRefundPO, List<FscOrderItemPO> refundItemList, FscOrderPO fscOrderPO, FscOrderPO signTemp, Map<Long, FscOrderItemPO> fscOrderItemPOMap) {
        int count;
        List orderIds = refundItemList.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setObjectId(fscOrderRefundPO.getFscOrderId());
        fscShouldPayPO.setOrderIds(orderIds);
        List shouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            return;
        }
        List shouldPayIds = shouldPayPOList.stream().map(FscShouldPayPO::getShouldPayId).collect(Collectors.toList());
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
        List fscOrderPayItemPOList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderPayItemPOList)) {
            return;
        }
        Map<Long, List<FscOrderPayItemPO>> payItemMap = fscOrderPayItemPOList.stream().collect(Collectors.groupingBy(FscOrderPayItemPO::getShouldPayId));
        Map refundItemMap = refundItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        if (CollectionUtils.isEmpty(refundItemMap)) {
            log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u9000\u7968\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\uff01");
            return;
        }
        ArrayList insertShouldPayList = new ArrayList();
        ArrayList updateShouldPayList = new ArrayList();
        ArrayList insertPayItemList = new ArrayList();
        ArrayList updatePayItemList = new ArrayList();
        shouldPayPOList.forEach(payPO -> {
            if (!refundItemMap.containsKey(payPO.getOrderId())) {
                return;
            }
            if (!fscOrderItemPOMap.containsKey(payPO.getOrderId())) {
                log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5bf9\u5e94\u7684\u539f\u7ed3\u7b97\u660e\u7ec6, orderId:" + payPO.getOrderId());
                return;
            }
            FscOrderItemPO refundItemPO = (FscOrderItemPO)refundItemMap.get(payPO.getOrderId());
            FscOrderItemPO orderItemPO = (FscOrderItemPO)fscOrderItemPOMap.get(payPO.getOrderId());
            if (refundItemPO.getAmt().compareTo(BigDecimal.ZERO) == 0 || payPO.getPaidAmount().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (orderItemPO.getAmt().subtract(orderItemPO.getRefundAmt()).compareTo(payPO.getShouldPayAmount().subtract(payPO.getRefundAmt())) >= 0) {
                return;
            }
            BigDecimal maxTransferAmount = payPO.getShouldPayAmount().subtract(payPO.getRefundAmt()).subtract(orderItemPO.getAmt().subtract(orderItemPO.getRefundAmt()));
            BigDecimal transferAmt = maxTransferAmount.compareTo(refundItemPO.getAmt()) >= 0 ? refundItemPO.getAmt() : maxTransferAmount;
            FscShouldPayPO insertShouldPayPO = (FscShouldPayPO)JSON.parseObject((String)JSON.toJSONString((Object)payPO), FscShouldPayPO.class);
            insertShouldPayPO.setShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
            insertShouldPayPO.setObjectId(fscOrderPO.getFscOrderId());
            insertShouldPayPO.setObjectNo(fscOrderPO.getOrderNo());
            insertShouldPayPO.setPayingAmount(BigDecimal.ZERO);
            insertShouldPayPO.setRefundAmt(BigDecimal.ZERO);
            insertShouldPayPO.setRefundAmount(BigDecimal.ZERO);
            insertShouldPayPO.setCreateTime(new Date());
            insertShouldPayPO.setRefundId(fscOrderRefundPO.getRefundId());
            insertShouldPayPO.setOriginalAmount(transferAmt);
            insertShouldPayPO.setShouldPayAmount(transferAmt);
            if (payPO.getToPayAmount().compareTo(payPO.getRefundAmt()) > 0) {
                if (payPO.getToPayAmount().subtract(payPO.getRefundAmt()).subtract(transferAmt).compareTo(BigDecimal.ZERO) > 0) {
                    insertShouldPayPO.setToPayAmount(transferAmt);
                } else {
                    insertShouldPayPO.setToPayAmount(transferAmt.subtract(payPO.getToPayAmount().subtract(payPO.getRefundAmt())));
                }
                insertShouldPayPO.setToPayAmount(BigDecimal.ZERO);
            }
            if (transferAmt.compareTo(insertShouldPayPO.getToPayAmount()) > 0) {
                insertShouldPayPO.setPaidAmount(transferAmt.subtract(insertShouldPayPO.getToPayAmount()));
            }
            if (Objects.nonNull(signTemp)) {
                insertShouldPayPO.setCreateId(signTemp.getUserId());
                insertShouldPayPO.setCreateName(signTemp.getName());
                insertShouldPayPO.setCreateAccount(signTemp.getUserName());
                insertShouldPayPO.setCreateCompanyId(signTemp.getCompanyId());
                insertShouldPayPO.setCreateCompanyName(signTemp.getCompanyName());
                insertShouldPayPO.setCreateOrgId(signTemp.getOrgId());
                insertShouldPayPO.setCreateOrgName(signTemp.getOrgName());
            }
            insertShouldPayList.add(insertShouldPayPO);
            FscShouldPayPO updatePayPO = new FscShouldPayPO();
            updatePayPO.setShouldPayId(payPO.getShouldPayId());
            updatePayPO.setRefundAmt(transferAmt);
            updateShouldPayList.add(updatePayPO);
            List payItemPOList = (List)payItemMap.get(payPO.getShouldPayId());
            if (CollectionUtils.isEmpty((Collection)payItemPOList)) {
                log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\uff01");
                return;
            }
            BigDecimal[] shouldPayAmount = new BigDecimal[]{transferAmt};
            payItemPOList.forEach(payItem -> {
                if (payItem.getPayAmount().compareTo(BigDecimal.ZERO) == 0 || shouldPayAmount[0].compareTo(BigDecimal.ZERO) == 0) {
                    return;
                }
                FscOrderPayItemPO insertItemPO = (FscOrderPayItemPO)JSON.parseObject((String)JSON.toJSONString((Object)payItem), FscOrderPayItemPO.class);
                insertItemPO.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
                insertItemPO.setFscBillOrderId(String.valueOf(fscOrderPO.getFscOrderId()));
                insertItemPO.setFscOrderNo(fscOrderPO.getOrderNo());
                insertItemPO.setSettleId(fscOrderPO.getFscOrderId());
                insertItemPO.setShouldPayId(insertShouldPayPO.getShouldPayId());
                insertItemPO.setRefundAmt(BigDecimal.ZERO);
                insertItemPO.setRefundAmount(BigDecimal.ZERO);
                insertItemPO.setReduceAmt(BigDecimal.ZERO);
                insertItemPO.setRefundId(fscOrderRefundPO.getRefundId());
                if (shouldPayAmount[0].compareTo(payItem.getPayAmount()) >= 0) {
                    insertItemPO.setPayAmount(payItem.getPayAmount());
                    shouldPayAmount[0] = shouldPayAmount[0].subtract(payItem.getPayAmount());
                } else {
                    insertItemPO.setPayAmount(shouldPayAmount[0]);
                    shouldPayAmount[0] = BigDecimal.ZERO;
                }
                insertPayItemList.add(insertItemPO);
                FscOrderPayItemPO updateItemPO = new FscOrderPayItemPO();
                updateItemPO.setOrderPayItemId(payItem.getOrderPayItemId());
                updateItemPO.setRefundAmt(insertItemPO.getPayAmount());
                updatePayItemList.add(updateItemPO);
            });
        });
        if (!CollectionUtils.isEmpty(insertShouldPayList) && (count = this.fscShouldPayMapper.insertBatch(insertShouldPayList)) == 0) {
            throw new FscBusinessException("198888", "\u8f6c\u79fb\u5e94\u4ed8\u5931\u8d25\uff0c\u63d2\u5165\u5e94\u4ed8\u8868\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(updateShouldPayList) && (count = this.fscShouldPayMapper.updateRefundAmtBatch(updateShouldPayList)) != updateShouldPayList.size()) {
            throw new FscBusinessException("198888", "\u8f6c\u79fb\u5e94\u4ed8\u5931\u8d25\uff0c\u66f4\u65b0\u5e94\u4ed8\u8868\u9000\u6b3e\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(insertPayItemList) && (count = this.fscOrderPayItemMapper.insertBatch(insertPayItemList)) == 0) {
            throw new FscBusinessException("198888", "\u8f6c\u79fb\u5e94\u4ed8\u5931\u8d25,\u63d2\u5165\u4ed8\u6b3e\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(updatePayItemList) && (count = this.fscOrderPayItemMapper.updateRefundAmtBatch(updatePayItemList)) != updatePayItemList.size()) {
            throw new FscBusinessException("198888", "\u8f6c\u79fb\u5e94\u4ed8\u5931\u8d25,\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u8868\u9000\u6b3e\u91d1\u989d\u5931\u8d25\uff01");
        }
    }

    private void transferWriteOff(FscOrderRefundPO fscOrderRefundPO, List<FscOrderItemPO> refundItemList, FscOrderPO fscOrderPO, FscOrderPO signTemp, Map<Long, FscOrderItemPO> fscOrderItemPOMap) {
        FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
        fscFinanceWriteOffPO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
        List financeWriteOffPOList = this.fscFinanceWriteOffMapper.getEngineeringRefundList(fscFinanceWriteOffPO);
        if (CollectionUtils.isEmpty((Collection)financeWriteOffPOList)) {
            return;
        }
        Map refundItemMap = refundItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        if (CollectionUtils.isEmpty(refundItemMap)) {
            log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u9000\u7968\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\uff01");
            return;
        }
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        financeWriteOffPOList.stream().filter(item -> Objects.nonNull(item.getOrderId())).forEach(e -> {
            if (!refundItemMap.containsKey(e.getOrderId())) {
                return;
            }
            if (!fscOrderItemPOMap.containsKey(e.getOrderId())) {
                log.error("\u5904\u7406\u5de5\u7a0b\u670d\u52a1\u91cd\u65b0\u5f00\u7968\u4ed8\u6b3e\u548c\u6838\u9500\u8f6c\u79fb\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5bf9\u5e94\u7684\u539f\u7ed3\u7b97\u660e\u7ec6, orderId:" + e.getOrderId());
                return;
            }
            FscOrderItemPO refundItemPO = (FscOrderItemPO)refundItemMap.get(e.getOrderId());
            if (refundItemPO.getAmt().compareTo(BigDecimal.ZERO) == 0 || e.getWriteOffAmt().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            FscOrderItemPO orderItemPO = (FscOrderItemPO)fscOrderItemPOMap.get(e.getOrderId());
            if (orderItemPO.getAmt().subtract(orderItemPO.getRefundAmt()).compareTo(e.getWriteOffAmt()) >= 0) {
                log.info("\u5f53\u539f\u7ed3\u7b97\u660e\u7ec6\u5269\u4f59\u7ed3\u7b97\u91d1\u989d > \u660e\u7ec6\u5269\u4f59\u6838\u9500\u91d1\u989d\uff0c\u4e0d\u9700\u8981\u8fc1\u79fb\u5e94\u4ed8, \u5408\u540c\u4ed8\u6b3e\u660e\u7ec6ID\uff1a" + e.getOrderId());
                return;
            }
            BigDecimal shouldTransferAmount = e.getWriteOffAmt().subtract(orderItemPO.getAmt().subtract(orderItemPO.getRefundAmt()));
            BigDecimal transferAmt = shouldTransferAmount.compareTo(refundItemPO.getAmt()) >= 0 ? refundItemPO.getAmt() : shouldTransferAmount;
            FscFinanceWriteOffPO insertPO = (FscFinanceWriteOffPO)JSON.parseObject((String)JSON.toJSONString((Object)e), FscFinanceWriteOffPO.class);
            insertPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
            insertPO.setFscOrderId(fscOrderPO.getFscOrderId());
            insertPO.setFscOrderNo(fscOrderPO.getOrderNo());
            insertPO.setRefundAmt(BigDecimal.ZERO);
            insertPO.setCreateTime(new Date());
            insertPO.setUpdateTime(new Date());
            insertPO.setWriteOffAmt(transferAmt);
            if (Objects.nonNull(signTemp)) {
                insertPO.setCreateUserId(signTemp.getUserId());
                insertPO.setCreateUserName(signTemp.getName());
                insertPO.setUpdateUserId(signTemp.getUserId());
                insertPO.setUpdateUserName(signTemp.getName());
            }
            ((FscOrderItemPO)refundItemMap.get(e.getOrderId())).setAmt(((FscOrderItemPO)refundItemMap.get(e.getOrderId())).getAmt().subtract(transferAmt));
            insertList.add(insertPO);
            FscFinanceWriteOffPO updatePO = new FscFinanceWriteOffPO();
            updatePO.setWriteOffId(e.getWriteOffId());
            updatePO.setWriteOffAmt(transferAmt);
            updateList.add(updatePO);
        });
        if (!CollectionUtils.isEmpty(insertList)) {
            this.fscFinanceWriteOffMapper.insertBatch(insertList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.fscFinanceWriteOffMapper.updateRefundAmtBatch(updateList);
        }
    }

    private void getOrderCode(FscOrderPO fscOrderPO, Set<String> orderCodeList, Set<String> orderOperList) {
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)fscAcceptOrderListQueryAtomRspBO.getOrderCodeList())) {
                orderCodeList.addAll(fscAcceptOrderListQueryAtomRspBO.getOrderCodeList());
            }
            if (!CollectionUtils.isEmpty((Collection)fscAcceptOrderListQueryAtomRspBO.getOrderOperList())) {
                orderOperList.addAll(fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
            }
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)fscSaleOrderListQueryAtomRspBO.getOrderCodeList())) {
                orderCodeList.addAll(fscSaleOrderListQueryAtomRspBO.getOrderCodeList());
            }
            if (!CollectionUtils.isEmpty((Collection)fscSaleOrderListQueryAtomRspBO.getOrderOperList())) {
                orderOperList.addAll(fscSaleOrderListQueryAtomRspBO.getOrderOperList());
            }
        }
    }

    private void createReopenShouldPay(FscOrderPO fscOrderPO, List<FscShouldPayBO> fscShouldPayBOS, Set<String> orderCodeList, Set<String> orderOperList, String billDateMax, List<FscShouldPayPO> shouldPayPOList) {
        Map<Object, Object> oldShouldPayIdMap = new HashMap();
        List oldShouldPayIds = shouldPayPOList.stream().map(FscShouldPayPO::getShouldPayId).collect(Collectors.toList());
        FscShouldPayPO searchShouldPayPo = new FscShouldPayPO();
        searchShouldPayPo.setShouldPayIds(oldShouldPayIds);
        List shouldPayPOS = this.fscShouldPayMapper.getList(searchShouldPayPo);
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOS)) {
            oldShouldPayIdMap = shouldPayPOS.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, o -> o));
        }
        for (FscShouldPayPO shouldPayPO : shouldPayPOList) {
            FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
            BeanUtils.copyProperties((Object)shouldPayPO, (Object)fscShouldPayBO);
            fscShouldPayBO.setShouldPayAmount(shouldPayPO.getRefundAmount());
            fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
            fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
            fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
            fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
            fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
            fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
            fscShouldPayBO.setShouldPayMethod(shouldPayPO.getPayMethod());
            fscShouldPayBO.setBillDate(billDateMax);
            fscShouldPayBO.setRefundId(fscOrderPO.getRefundId());
            if (oldShouldPayIdMap.containsKey(shouldPayPO.getShouldPayId())) {
                fscShouldPayBO.setNodePayRatio(((FscShouldPayPO)oldShouldPayIdMap.get(shouldPayPO.getShouldPayId())).getNodePayRatio());
                fscShouldPayBO.setPayConfId(((FscShouldPayPO)oldShouldPayIdMap.get(shouldPayPO.getShouldPayId())).getPayConfId());
            }
            fscShouldPayBOS.add(fscShouldPayBO);
        }
    }

    private void sendMq(Long orderId) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(orderId);
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        JSONObject object = new JSONObject();
        object.put("fscOrderId", (Object)orderId);
        ProxySendResult proxySendResult = this.fscSignBackFillInvoiceMqServiceProvider.send(new ProxyMessage(this.fscSignBackFillInvoiceTopic, this.fscSignBackFillInvoiceTag, JSONObject.toJSONString((Object)object)));
    }
}

