/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundUpdateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundUpdateAbilityRspBO;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceRefundPayTempQryAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundUpdateBusiRspBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.bo.FscPayRefundShouldBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundUpdateAbilityService"})
public class FscBillPayRefundUpdateAbilityServiceImpl
implements FscBillPayRefundUpdateAbilityService {
    @Autowired
    private FscBillPayRefundUpdateBusiService fscBillPayRefundUpdateBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscFinanceRefundPayTempQryAtomService fscFinanceRefundPayTempQryAtomService;

    @PostMapping(value={"dealPayRefundUpdate"})
    public FscBillPayRefundUpdateAbilityRspBO dealPayRefundUpdate(@RequestBody FscBillPayRefundUpdateAbilityReqBO reqBO) {
        if (reqBO.getTempId() != null) {
            this.qryTempInfo(reqBO);
        }
        this.valid(reqBO);
        FscBillPayRefundUpdateBusiReqBO fscBillPayRefundUpdateBusiReqBO = (FscBillPayRefundUpdateBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillPayRefundUpdateBusiReqBO.class));
        FscBillPayRefundUpdateBusiRspBO fscBillPayRefundUpdateBusiRspBO = this.fscBillPayRefundUpdateBusiService.dealPayRefundUpdate(fscBillPayRefundUpdateBusiReqBO);
        if (!"0000".equals(fscBillPayRefundUpdateBusiRspBO.getRespCode())) {
            return (FscBillPayRefundUpdateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundUpdateBusiRspBO)), FscBillPayRefundUpdateAbilityRspBO.class);
        }
        this.syncEs(reqBO.getRefundId());
        FscBillPayRefundUpdateAbilityRspBO rspBO = new FscBillPayRefundUpdateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void qryTempInfo(FscBillPayRefundUpdateAbilityReqBO reqBO) {
        FscFinanceRefundPayTempQryAtomReqBO atomReqBO = new FscFinanceRefundPayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        FscFinanceRefundPayTempQryAtomRspBO atomRspBO = this.fscFinanceRefundPayTempQryAtomService.qryTempInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4e34\u65f6\u8868\u4fe1\u606f\u5931\u8d25:" + atomRspBO.getRespDesc());
        }
        reqBO.setFinanceItemList(atomRspBO.getFinanceItemList());
        reqBO.setFileList(atomRspBO.getFileList());
        reqBO.setFscRefundShouldPayBOS(atomRspBO.getFscRefundShouldPayBOS());
    }

    private void syncEs(Long refundId) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void valid(FscBillPayRefundUpdateAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscRefundShouldPayBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscRefundSHouldPayBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            BigDecimal refundAmt = BigDecimal.ZERO;
            for (FscFinanceRefundItemBO itemBO : reqBO.getFinanceItemList()) {
                refundAmt = refundAmt.add(itemBO.getRefundAmt());
                if (itemBO.getPayItemId() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.payItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (itemBO.getRefundAmt() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d[fscFinanceRefundItemBO.refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (itemBO.getRefundAmt().compareTo(BigDecimal.ZERO) == 0) {
                    throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d[fscFinanceRefundItemBO.refundAmt]\u4e0d\u80fd\u4e3a0\uff01");
                }
                if (itemBO.getRefundAmtLocal() != null) continue;
                throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.refundAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (refundAmt.compareTo(((FscPayRefundShouldBO)reqBO.getFscRefundShouldPayBOS().get(0)).getRefundAmt()) != 0 || refundAmt.compareTo(reqBO.getRefundAmount()) != 0) {
                throw new FscBusinessException("198888", "\u9000\u6b3e\u660e\u7ec6\u884c\u5408\u8ba1\u9000\u6b3e\u91d1\u989d\u548c\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId()) && CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            throw new FscBusinessException("198888", "\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u9000\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

