/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscComOrderRefundSupConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundSupConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundSupConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundSupConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundSupConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundSupConfirmBusiRspBO;
import com.tydic.fsc.bo.FscAttachmentBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoiceTempPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscComOrderRefundSupConfirmAbilityService"})
public class FscComOrderRefundSupConfirmAbilityServiceImpl
implements FscComOrderRefundSupConfirmAbilityService {
    @Autowired
    private FscComOrderRefundSupConfirmBusiService fscComOrderRefundSupConfirmBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscInvoiceTempMapper fscInvoiceTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderRefundSupConfirm"})
    public FscComOrderRefundSupConfirmAbilityRspBO dealOrderRefundSupConfirm(@RequestBody FscComOrderRefundSupConfirmAbilityReqBO reqBO) {
        String reqString;
        FscComOrderRefundSupConfirmBusiReqBO busiReqBO;
        FscComOrderRefundSupConfirmBusiRspBO busiRspBO;
        this.valid(reqBO);
        if (null != reqBO.getTempId()) {
            this.setParam(reqBO);
        }
        if ((busiRspBO = this.fscComOrderRefundSupConfirmBusiService.dealOrderRefundSupConfirm(busiReqBO = (FscComOrderRefundSupConfirmBusiReqBO)((Object)JSONObject.parseObject((String)(reqString = JSONObject.toJSONString((Object)reqBO)), FscComOrderRefundSupConfirmBusiReqBO.class)))).getRespCode().equals("0000")) {
            this.sendMq(reqBO.getRefundId(), busiRspBO.getFscOrderId());
        }
        return (FscComOrderRefundSupConfirmAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscComOrderRefundSupConfirmAbilityRspBO.class);
    }

    private void setParam(FscComOrderRefundSupConfirmAbilityReqBO reqBO) {
        if (FscConstants.RefundSupConfirmType.RED.equals(reqBO.getConfirmType())) {
            FscInvoiceTempPO fscInvoiceTempPO = new FscInvoiceTempPO();
            fscInvoiceTempPO.setTempId(reqBO.getTempId());
            List fscInvoiceTempPOList = this.fscInvoiceTempMapper.getList(fscInvoiceTempPO);
            if (CollectionUtils.isEmpty((Collection)fscInvoiceTempPOList)) {
                throw new FscBusinessException("198888", "\u8bf7\u9009\u62e9\u53d1\u7968");
            }
            reqBO.setRedInvoiceList(new ArrayList());
            for (FscInvoiceTempPO invoiceTempPO : fscInvoiceTempPOList) {
                this.valTempData(invoiceTempPO);
                InvoiceBO invoiceBO = (InvoiceBO)JUtil.js((Object)invoiceTempPO, InvoiceBO.class);
                invoiceBO.setInvoiceId(invoiceTempPO.getPreInvoiceId());
                invoiceBO.setFscOrderId(null);
                reqBO.getRedInvoiceList().add(invoiceBO);
            }
        }
        FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
        fscAttachmentTempPO.setFscOrderId(reqBO.getTempId());
        List attachmentTempList = this.fscAttachmentTempMapper.getList(fscAttachmentTempPO);
        if (!CollectionUtils.isEmpty((Collection)attachmentTempList)) {
            ArrayList<FscAttachmentBO> attachmentList = new ArrayList<FscAttachmentBO>();
            for (FscAttachmentTempPO attachmentTempPO : attachmentTempList) {
                FscAttachmentBO fscAttachmentBO = (FscAttachmentBO)JUtil.js((Object)attachmentTempPO, FscAttachmentBO.class);
                fscAttachmentBO.setFscOrderId(reqBO.getRefundId());
                fscAttachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentList.add(fscAttachmentBO);
            }
            reqBO.setRedAttachmentList(attachmentList);
        }
    }

    private void valTempData(FscInvoiceTempPO invoiceTempPO) {
        if (null == invoiceTempPO.getInvoiceCategory()) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceCategory]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == invoiceTempPO.getInvoiceType()) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoiceTempPO.getInvoiceCategory())) {
            if (invoiceTempPO.getInvoiceNo().length() != 20) {
                throw new FscBusinessException("198888", "\u5168\u7535\u7968 \u53d1\u7968\u53f7\u7801\u4f4d\u6570\u9519\u8bef,\u8bf7\u91cd\u65b0\u66f4\u65b0\u6a21\u677f\u4e0a\u4f20!");
            }
        } else if (invoiceTempPO.getInvoiceNo().length() != 8) {
            throw new FscBusinessException("198888", "\u53d1\u7968\u53f7\u7801\u4f4d\u6570\u9519\u8bef,\u8bf7\u91cd\u65b0\u66f4\u65b0\u6a21\u677f\u4e0a\u4f20");
        }
    }

    private void sendMq(Long refundId, Long fscOrderId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO refundInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        refundInvoiceListSyncAbilityReqBO.setFscOrderId(refundId);
        refundInvoiceListSyncAbilityReqBO.setSyncType(FscConstants.FscSyncType.REFUND);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(refundInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void valid(FscComOrderRefundSupConfirmAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getConfirmType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[confirmType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getTempId()) {
            if (reqBO.getConfirmType().equals(FscConstants.RefundSupConfirmType.RED) && CollectionUtils.isEmpty((Collection)reqBO.getRedInvoiceList())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (InvoiceBO invoiceBO : reqBO.getRedInvoiceList()) {
                if (invoiceBO.getInvoiceId() != null) continue;
                throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceList\u7684invoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

