/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscRefundSerialNoAbilityService;
import com.tydic.fsc.bill.ability.bo.FscRefundSerialNoAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscRefundSerialNoAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscRefundSerialMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscRefundSerialPO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscRefundSerialNoAbilityService"})
public class FscRefundSerialNoAbilityServiceImpl
implements FscRefundSerialNoAbilityService {
    @Autowired
    private FscRefundSerialMapper fscRefundSerialMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"refundSerialNo"})
    public FscRefundSerialNoAbilityRspBO refundSerialNo(@RequestBody FscRefundSerialNoAbilityReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[orderNo]\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getFscOrderNo());
        int checkBy = this.fscOrderMapper.getCheckBy(fscOrderPO);
        if (checkBy < 1) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[orderNo]\u503c\u6709\u8bef,\u67e5\u8be2\u4e0d\u5230\u7ed3\u7b97\u5355");
        }
        FscRefundSerialNoAbilityRspBO rspBo = new FscRefundSerialNoAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        FscRefundSerialPO feeRefundSerialPO = new FscRefundSerialPO();
        feeRefundSerialPO.setFscOrderNo(reqBO.getFscOrderNo());
        List fscRefundSerialPOS = this.fscRefundSerialMapper.selectByCondition(feeRefundSerialPO);
        if (fscRefundSerialPOS.isEmpty()) {
            rspBo.setRefundNo(reqBO.getFscOrderNo() + "-01");
        } else if (fscRefundSerialPOS.size() == 1) {
            rspBo.setRefundNo(reqBO.getFscOrderNo() + "-" + String.format("%02d", ((FscRefundSerialPO)fscRefundSerialPOS.get(0)).getNum() + 1));
        } else {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u9000\u6b3e\u5355\u6d41\u6c34\u53f7\u8868\u6570\u636e\u6709\u8bef");
        }
        return rspBo;
    }
}

