/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.finance.FscEngineeringInvoiceSignAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringInvoiceSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringInvoiceSignAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceSignBusiRspBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscEngineeringInvoiceSignAbilityService"})
public class FscEngineeringInvoiceSignAbilityServiceImpl
implements FscEngineeringInvoiceSignAbilityService {
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscEngineeringInvoiceSignBusiService fscEngineeringInvoiceSignBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";

    @PostMapping(value={"dealEngineeringInvoiceSign"})
    public FscEngineeringInvoiceSignAbilityRspBO dealEngineeringInvoiceSign(@RequestBody FscEngineeringInvoiceSignAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!(FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(fscOrderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.FINANCE_BACK.equals(fscOrderPO.getOrderState()))) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u7b7e\u6536\u7533\u8bf7");
        }
        this.valCmpResult(reqBO);
        this.checkCmpResult(reqBO.getInvoiceCmpResult(), fscOrderPO);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List itemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
        List checkItemList = itemPOList.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getSettleItemCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkItemList)) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u660e\u7ec6\u4e2d\u7ed3\u7b97\u4e8b\u9879\u5fc5\u586b\uff01");
        }
        FscEngineeringInvoiceSignBusiReqBO fscEngineeringInvoiceSignBusiReqBO = (FscEngineeringInvoiceSignBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscEngineeringInvoiceSignBusiReqBO.class));
        fscEngineeringInvoiceSignBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        FscEngineeringInvoiceSignBusiRspBO fscEngineeringInvoiceSignBusiRspBO = this.fscEngineeringInvoiceSignBusiService.dealEngineeringInvoiceSign(fscEngineeringInvoiceSignBusiReqBO);
        if (!"0000".equals(fscEngineeringInvoiceSignBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscEngineeringInvoiceSignBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return (FscEngineeringInvoiceSignAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscEngineeringInvoiceSignBusiRspBO)), FscEngineeringInvoiceSignAbilityRspBO.class);
    }

    private void sendMq(FscEngineeringInvoiceSignAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void val(FscEngineeringInvoiceSignAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
        if (Integer.valueOf(1).equals(reqBO.getPaySource()) && CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("191000", "\u5373\u6302\u5373\u4ed8\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void valCmpResult(FscEngineeringInvoiceSignAbilityReqBO reqBO) {
        if (null == reqBO.getInvoiceCmpResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2invoiceCmpResult\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceCmpResult().getCmpResultStr())) {
            throw new FscBusinessException("191000", "\u5165\u53c2cmpResultStr\u4e3a\u7a7a");
        }
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, 3);
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString()) || Objects.nonNull(invoiceCmpResultBO.getPoolCmpResultNum()) && invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuilder cmpResult = new StringBuilder(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        boolean categoryFlag = FscConstants.FscInvoiceCategory.FULL.equals(invoiceCmpResultBO.getInvoiceCategory());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck()) || categoryFlag) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck()) || categoryFlag) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck()) || categoryFlag) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck()) || categoryFlag) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
    }
}

