/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.busi.api.FscEngineeringRefundPayConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayConfirmBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscFinancePayRefundConfirmReqBankStatementBusiBO;
import com.tydic.fsc.bill.busi.bo.FscFinancePayRefundConfirmReqDraftInfoBusiBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceOccupyRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleaseRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomBankBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomDraftBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomSupplyBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscEngineeringRefundPayConfirmBusiServiceImpl
implements FscEngineeringRefundPayConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringRefundPayConfirmBusiServiceImpl.class);
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceOccupyRefundInfoAtomService fscFinanceOccupyRefundInfoAtomService;
    @Autowired
    private FscFinanceReleaseRefundInfoAtomService fscFinanceReleaseRefundInfoAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u786e\u8ba4";
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;

    @Override
    public FscEngineeringRefundPayConfirmBusiRspBO dealEngineeringRefundPayConfirm(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscEngineeringRefundPayConfirmBusiRspBO rspBO = new FscEngineeringRefundPayConfirmBusiRspBO();
        FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(reqBO.getRefundId());
        FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(reqBO.getRefundId());
        this.initiateFlowApprove(reqBO, fscOrderRefundPO);
        this.sendFinanceConfirmNotice(reqBO, fscOrderRefundPO);
        this.updateRefundFinance(reqBO);
        this.dealRefundItemInfo(reqBO);
        this.dealAddFinanceBankStatement(reqBO);
        this.dealAddFinanceDraftInfo(reqBO);
        this.dealAddFinanceCapitalPlan(reqBO);
        this.occupyRefundInfo(reqBO, fscOrderRefundPO, fscRefundFinancePO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddFinanceBankStatement(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceBankStatement(reqBO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceBankStatementByTemp(reqBO);
        }
    }

    private void sendFinanceConfirmNotice(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(reqBO.getRefundId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)fscApprovalTaskQueryBOList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        String type = this.getTypeByRefundId(fscOrderRefundPO.getRefundId());
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderRefundPO.getRefundNo() + "\u9000\u6b3e\u7533\u8bf7\u5355_" + type + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25dealEngineeringRefundPayConfirm: {}", (Object)e.getMessage());
        }
    }

    private String getTypeByRefundId(Long refundId) {
        List fscPayRefundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(refundId);
        if (CollectionUtils.isEmpty((Collection)fscPayRefundDetailList)) {
            return null;
        }
        FscPayShouldRefundPO fscPayShouldRefundPO = this.fscPayShouldRefundMapper.queryById(((FscPayRefundDetailPO)fscPayRefundDetailList.get(0)).getRefundShouldPayId());
        if (null == fscPayShouldRefundPO) {
            return null;
        }
        Integer businessType = fscPayShouldRefundPO.getBusinessType();
        String type = Integer.valueOf(1).equals(businessType) ? "\u5de5\u7a0b\u6b3e" : (Integer.valueOf(2).equals(businessType) ? "\u670d\u52a1\u6b3e" : null);
        return type;
    }

    private void addFinanceBankStatement(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return;
        }
        List addBankStatementList = JUtil.jsl(reqBO.getBankStatementList(), FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void addFinanceBankStatementByTemp(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        List<FscFinanceBankStatementTempPO> financeBankStatementTempList = this.getFinanceBankStatementTempList(reqBO);
        if (CollectionUtils.isEmpty(financeBankStatementTempList)) {
            return;
        }
        List addBankStatementList = JUtil.jsl(financeBankStatementTempList, FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void dealAddFinanceDraftInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceDraftInfo(reqBO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceDraftInfoByTemp(reqBO);
        }
    }

    private void addFinanceDraftInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(reqBO.getDraftInfoList(), FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void addFinanceDraftInfoByTemp(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        List<FscFinanceDraftInfoTempPO> financeDraftTempList = this.getFinanceDraftTempList(reqBO);
        if (CollectionUtils.isEmpty(financeDraftTempList)) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(financeDraftTempList, FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void updateRefundFinance(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setExchangeRate(reqBO.getExchangeRate());
        updateFscRefundFinanceSet.setRefundPayMethod(reqBO.getRefundPayMethod());
        updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDITING);
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(reqBO.getRefundId());
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private void initiateFlowApprove(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        this.invokeUacNoTask(reqBO, fscOrderRefundPO);
        this.dealRefundStatusFlow(fscOrderRefundPO);
    }

    private void invokeUacNoTask(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        if (fscOrderRefundPO.getSettlePlatform() != 3) {
            return;
        }
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("M003045");
        uacNoTaskAuditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getRefundId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(String.valueOf(reqBO.getRefundId()));
        approvalObjBO.setObjName("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u7533\u8bf7\u5355\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2: " + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u7533\u8bf7\u5355\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2: " + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("194203", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5ba1\u6279\u6d41");
        }
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        try {
            this.taskTodoWaitService.syncNotifyEngRefundWaitDone(reqBO.getRefundId());
        }
        catch (Exception e) {
            log.error("dealEngineeringRefundPayConfirm -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
    }

    private void dealRefundStatusFlow(FscOrderRefundPO fscOrderRefundPO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderRefundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderRefundPO.getRefundStatus());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("confirmFlag", "1");
        paramMap.put("registerFlag", "");
        paramMap.put("deleteFlag", "");
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private FscPayRefundDetailPO getPayRefundDetail(Long refundId) {
        FscPayRefundDetailPO qryFscPayRefundDetail = new FscPayRefundDetailPO();
        qryFscPayRefundDetail.setRefundId(refundId);
        return this.fscPayRefundDetailMapper.getModelBy(qryFscPayRefundDetail);
    }

    private FscOrderRefundPO getOrderRefund(Long refundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(refundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long refundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(refundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private List<FscFinanceDraftInfoPO> getFinanceDraftList(Long refundId) {
        FscFinanceDraftInfoPO qryFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        qryFscFinanceDraftInfo.setRefundId(refundId);
        return this.fscFinanceDraftInfoMapper.getList(qryFscFinanceDraftInfo);
    }

    private List<FscFinanceBankStatementPO> getFinanceBankStatementList(Long refundId) {
        FscFinanceBankStatementPO qryFscFinanceBankStatement = new FscFinanceBankStatementPO();
        qryFscFinanceBankStatement.setRefundId(refundId);
        return this.fscFinanceBankStatementMapper.getList(qryFscFinanceBankStatement);
    }

    private List<FscFinanceBankStatementTempPO> getFinanceBankStatementTempList(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return null;
        }
        List tempIdList = reqBO.getBankStatementList().stream().map(FscFinancePayRefundConfirmReqBankStatementBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceBankStatementTempPO qryFscFinanceBankStatementTemp = new FscFinanceBankStatementTempPO();
        qryFscFinanceBankStatementTemp.setTempIdList(tempIdList);
        return this.fscFinanceBankStatementTempMapper.getList(qryFscFinanceBankStatementTemp);
    }

    private List<FscFinanceDraftInfoTempPO> getFinanceDraftTempList(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return null;
        }
        List tempIdList = reqBO.getDraftInfoList().stream().map(FscFinancePayRefundConfirmReqDraftInfoBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceDraftInfoTempPO qryFscFinanceDraftInfoTemp = new FscFinanceDraftInfoTempPO();
        qryFscFinanceDraftInfoTemp.setTempIdList(tempIdList);
        return this.fscFinanceDraftInfoTempMapper.getList(qryFscFinanceDraftInfoTemp);
    }

    private void occupyRefundInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO> draftList = new ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomBankBO> bankList = new ArrayList<FscFinanceOccupyRefundInfoAtomBankBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList = new ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO>(1);
        ArrayList<FscFinancePlanItemBO> planList = new ArrayList<FscFinancePlanItemBO>(1);
        this.packageOccupyRefundInfo(reqBO, draftList, bankList, supplyList, planList);
        FscFinanceOccupyRefundInfoAtomReqBO fscFinanceOccupyRefundInfoAtomReqBO = new FscFinanceOccupyRefundInfoAtomReqBO();
        fscFinanceOccupyRefundInfoAtomReqBO.setObjId(fscOrderRefundPO.getRefundId());
        fscFinanceOccupyRefundInfoAtomReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgId(fscRefundFinancePO.getFinanceOrgId());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgName(fscRefundFinancePO.getFinanceOrgName());
        fscFinanceOccupyRefundInfoAtomReqBO.setDraftList(draftList);
        fscFinanceOccupyRefundInfoAtomReqBO.setBankList(bankList);
        fscFinanceOccupyRefundInfoAtomReqBO.setSupplyList(supplyList);
        fscFinanceOccupyRefundInfoAtomReqBO.setPlanList(planList);
        fscFinanceOccupyRefundInfoAtomReqBO.setName(reqBO.getName());
        fscFinanceOccupyRefundInfoAtomReqBO.setUserName(reqBO.getUserName());
        fscFinanceOccupyRefundInfoAtomReqBO.setRefundFlag(reqBO.getRefundFlag());
        FscFinanceOccupyRefundInfoAtomRspBO fscFinanceOccupyRefundInfoAtomRspBO = this.fscFinanceOccupyRefundInfoAtomService.dealOccupyRefundInfo(fscFinanceOccupyRefundInfoAtomReqBO);
        if (!fscFinanceOccupyRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceOccupyRefundInfoAtomRspBO.getRespCode(), fscFinanceOccupyRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void packageOccupyRefundInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, List<FscFinanceOccupyRefundInfoAtomDraftBO> draftList, List<FscFinanceOccupyRefundInfoAtomBankBO> bankList, List<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList, List<FscFinancePlanItemBO> planList) {
        List<FscFinanceDraftInfoPO> fscFinanceDraftInfoList = this.getFinanceDraftList(reqBO.getRefundId());
        List<FscFinanceBankStatementPO> financeBankStatementList = this.getFinanceBankStatementList(reqBO.getRefundId());
        List<FscFinanceCapitalPlanPO> financeCapitalPlanList = this.getFinanceCapitalPlanList(reqBO.getRefundId());
        for (FscFinanceDraftInfoPO fscFinanceDraftInfoPO : fscFinanceDraftInfoList) {
            if (FscConstants.FinanceDraftType.SUPPLY.equals(fscFinanceDraftInfoPO.getDraftType())) {
                FscFinanceOccupyRefundInfoAtomSupplyBO fscFinanceOccupyRefundInfoAtomSupplyBO = (FscFinanceOccupyRefundInfoAtomSupplyBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomSupplyBO.class);
                supplyList.add(fscFinanceOccupyRefundInfoAtomSupplyBO);
                continue;
            }
            FscFinanceOccupyRefundInfoAtomDraftBO fscFinanceOccupyRefundInfoAtomDraftBO = (FscFinanceOccupyRefundInfoAtomDraftBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomDraftBO.class);
            draftList.add(fscFinanceOccupyRefundInfoAtomDraftBO);
        }
        for (FscFinanceBankStatementPO fscFinanceBankStatementPO : financeBankStatementList) {
            FscFinanceOccupyRefundInfoAtomBankBO fscFinanceOccupyRefundInfoAtomBankBO = (FscFinanceOccupyRefundInfoAtomBankBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceBankStatementPO), FscFinanceOccupyRefundInfoAtomBankBO.class);
            bankList.add(fscFinanceOccupyRefundInfoAtomBankBO);
        }
        for (FscFinanceCapitalPlanPO fscFinanceCapitalPlanPO : financeCapitalPlanList) {
            FscFinancePlanItemBO fscFinancePlanItemBO = (FscFinancePlanItemBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceCapitalPlanPO), FscFinancePlanItemBO.class);
            planList.add(fscFinancePlanItemBO);
        }
    }

    private void releaseRefundInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        FscFinanceReleaseRefundInfoAtomReqBO fscFinanceReleaseRefundInfoAtomReqBO = new FscFinanceReleaseRefundInfoAtomReqBO();
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundId(reqBO.getRefundId());
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundNo(fscOrderRefundPO.getRefundNo());
        FscFinanceReleaseRefundInfoAtomRspBO fscFinanceReleaseRefundInfoAtomRspBO = this.fscFinanceReleaseRefundInfoAtomService.dealReleaseRefundInfo(fscFinanceReleaseRefundInfoAtomReqBO);
        if (!fscFinanceReleaseRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceReleaseRefundInfoAtomRspBO.getRespCode(), fscFinanceReleaseRefundInfoAtomRspBO.getRespDesc());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dealRefundItemInfo(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getFinanceItemList())) {
            return;
        }
        FscFinanceRefundItemPO qryFscFinanceRefundItem = new FscFinanceRefundItemPO();
        qryFscFinanceRefundItem.setRefundId(reqBO.getRefundId());
        List fscFinanceRefundItemPOList = this.fscFinanceRefundItemMapper.getList(qryFscFinanceRefundItem);
        HashMap<Long, Object> fscFinancePayItemMap = new HashMap<Long, Object>(1);
        for (Object fscFinanceRefundItemPO : fscFinanceRefundItemPOList) {
            void var7_9;
            FscFinancePayItemPO fscFinancePayItemPO = (FscFinancePayItemPO)fscFinancePayItemMap.get(fscFinanceRefundItemPO.getPayItemId());
            if (ObjectUtil.isEmpty((Object)fscFinancePayItemPO)) {
                FscFinancePayItemPO fscFinancePayItemPO2 = new FscFinancePayItemPO();
                fscFinancePayItemPO2.setFinancePayItemId(fscFinanceRefundItemPO.getPayItemId());
                fscFinancePayItemPO2.setRefundAmt(fscFinanceRefundItemPO.getRefundAmt().negate());
                fscFinancePayItemPO2.setRefundAmtLocal(fscFinanceRefundItemPO.getRefundAmtLocal().negate());
            } else {
                fscFinancePayItemPO.setRefundAmt(fscFinancePayItemPO.getRefundAmt().add(fscFinanceRefundItemPO.getRefundAmt().negate()));
                fscFinancePayItemPO.setRefundAmtLocal(fscFinancePayItemPO.getRefundAmtLocal().add(fscFinanceRefundItemPO.getRefundAmtLocal().negate()));
            }
            fscFinancePayItemMap.put(fscFinanceRefundItemPO.getPayItemId(), var7_9);
        }
        if (!CollectionUtils.isEmpty(fscFinancePayItemMap)) {
            ArrayList updateFscFinancePayItemList = new ArrayList(1);
            for (Long l : fscFinancePayItemMap.keySet()) {
                updateFscFinancePayItemList.add(fscFinancePayItemMap.get(l));
            }
            int rollbackFinancePayItemCount = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateFscFinancePayItemList);
            if (rollbackFinancePayItemCount != updateFscFinancePayItemList.size()) {
                throw new FscBusinessException("190000", "\u56de\u9000\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
        }
        ArrayList<FscFinanceRefundItemPO> fscFinanceRefundItem = new ArrayList<FscFinanceRefundItemPO>(1);
        fscFinancePayItemMap = new HashMap(1);
        for (FscFinanceRefundItemBO fscFinanceRefundItemBO : reqBO.getFinanceItemList()) {
            FscFinanceRefundItemPO fscFinanceRefundItemPO = new FscFinanceRefundItemPO();
            BeanUtils.copyProperties((Object)fscFinanceRefundItemBO, (Object)fscFinanceRefundItemPO);
            fscFinanceRefundItemPO.setRefundId(reqBO.getRefundId());
            fscFinanceRefundItem.add(fscFinanceRefundItemPO);
            FscFinancePayItemPO fscFinancePayItemPO = (FscFinancePayItemPO)fscFinancePayItemMap.get(fscFinanceRefundItemBO.getPayItemId());
            if (ObjectUtil.isEmpty((Object)fscFinancePayItemPO)) {
                fscFinancePayItemPO = new FscFinancePayItemPO();
                fscFinancePayItemPO.setFinancePayItemId(fscFinanceRefundItemBO.getPayItemId());
                fscFinancePayItemPO.setRefundAmt(fscFinanceRefundItemBO.getRefundAmt());
                fscFinancePayItemPO.setRefundAmtLocal(fscFinanceRefundItemBO.getRefundAmtLocal());
            } else {
                fscFinancePayItemPO.setRefundAmt(fscFinancePayItemPO.getRefundAmt().add(fscFinanceRefundItemBO.getRefundAmt()));
                fscFinancePayItemPO.setRefundAmtLocal(fscFinancePayItemPO.getRefundAmtLocal().add(fscFinanceRefundItemBO.getRefundAmtLocal()));
            }
            fscFinancePayItemMap.put(fscFinanceRefundItemBO.getPayItemId(), fscFinancePayItemPO);
        }
        ArrayList updateFscFinancePayItemList = new ArrayList(1);
        for (Long key : fscFinancePayItemMap.keySet()) {
            updateFscFinancePayItemList.add(fscFinancePayItemMap.get(key));
        }
        int n = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateFscFinancePayItemList);
        if (n != updateFscFinancePayItemList.size()) {
            throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
        }
        int occupyFinanceRefundItemCount = this.fscFinanceRefundItemMapper.updateRefundingAmtBatch(fscFinanceRefundItem);
        if (occupyFinanceRefundItemCount != fscFinanceRefundItem.size()) {
            throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void dealAddFinanceCapitalPlan(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceCapitalPlan(reqBO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceCapitalPlanByTemp(reqBO);
        }
    }

    private void addFinanceCapitalPlan(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscFinanceCapitalPlanPO deleteFscFinanceCapitalPlan = new FscFinanceCapitalPlanPO();
        deleteFscFinanceCapitalPlan.setRefundId(reqBO.getRefundId());
        this.fscFinanceCapitalPlanMapper.deleteBy(deleteFscFinanceCapitalPlan);
        if (CollectionUtils.isEmpty(reqBO.getPlanList())) {
            return;
        }
        List addCapitalPlanList = JUtil.jsl(reqBO.getPlanList(), FscFinanceCapitalPlanPO.class);
        for (FscFinanceCapitalPlanPO capitalPlan : addCapitalPlanList) {
            capitalPlan.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
            capitalPlan.setCreateTime(new Date());
        }
        this.fscFinanceCapitalPlanMapper.insertBatch(addCapitalPlanList);
    }

    private void addFinanceCapitalPlanByTemp(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        FscFinanceCapitalPlanPO deleteFscFinanceCapitalPlan = new FscFinanceCapitalPlanPO();
        deleteFscFinanceCapitalPlan.setRefundId(reqBO.getRefundId());
        this.fscFinanceCapitalPlanMapper.deleteBy(deleteFscFinanceCapitalPlan);
        List<FscFinanceCapitalPlanTempPO> financeCapitalPlanTempList = this.getFinanceCapitalPlanTempList(reqBO);
        if (CollectionUtils.isEmpty(financeCapitalPlanTempList)) {
            return;
        }
        List addCapitalPlanList = JUtil.jsl(financeCapitalPlanTempList, FscFinanceCapitalPlanPO.class);
        for (FscFinanceCapitalPlanPO capitalPlan : addCapitalPlanList) {
            capitalPlan.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
            capitalPlan.setCreateTime(new Date());
        }
        this.fscFinanceCapitalPlanMapper.insertBatch(addCapitalPlanList);
    }

    private List<FscFinanceCapitalPlanTempPO> getFinanceCapitalPlanTempList(FscEngineeringRefundPayConfirmBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getPlanList())) {
            return null;
        }
        List tempIdList = reqBO.getPlanList().stream().map(FscFinancePlanItemBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceCapitalPlanTempPO qryFscFinanceCapitalPlanTemp = new FscFinanceCapitalPlanTempPO();
        qryFscFinanceCapitalPlanTemp.setTempIdList(tempIdList);
        return this.fscFinanceCapitalPlanTempMapper.getList(qryFscFinanceCapitalPlanTemp);
    }

    private List<FscFinanceCapitalPlanPO> getFinanceCapitalPlanList(Long refundId) {
        FscFinanceCapitalPlanPO qryFscFinanceCapitalPlan = new FscFinanceCapitalPlanPO();
        qryFscFinanceCapitalPlan.setRefundId(refundId);
        return this.fscFinanceCapitalPlanMapper.getList(qryFscFinanceCapitalPlan);
    }
}

