/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscOrderAutoCreateConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscOrderAutoCreateConsumer.class);
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;
    @Autowired
    private FscBillEcomCheckAbilityService fscBillEcomCheckAbilityService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private CacheClient cacheClient;
    private static final String AUTO_ECOM_CHECK_KEY = "AUTO_ECOM_CHECK_KEY_";

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscBillOrderCreateAbilityReqBO reqBO = (FscBillOrderCreateAbilityReqBO)JSON.parseObject((String)message.getContent(), FscBillOrderCreateAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u81ea\u52a8\u5f00\u7968\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
            if ("2".equals(reqBO.getOrderSource())) {
                this.dealCheck(reqBO.getFscOrderInfoBoMap());
                List acceptOrderIds = reqBO.getFscOrderInfoBoMap().values().stream().map(FscOrderInfoBO::getAcceptOrderId).collect(Collectors.toList());
                FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
                fscCheckResultPO.setAcceptOrderIds(acceptOrderIds);
                List fscCheckResultPOList = this.fscCheckResultMapper.getList(fscCheckResultPO);
                boolean allMatch = fscCheckResultPOList.stream().allMatch(fscCheckResult -> FscConstants.BillCheck.EQUALS.equals(fscCheckResult.getStatus()));
                if (allMatch) {
                    this.fscBillOrderCreateAbilityService.dealCreate(reqBO);
                }
            } else {
                this.fscBillOrderCreateAbilityService.dealCreate(reqBO);
            }
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void dealCheck(Map<Long, FscOrderInfoBO> fscOrderInfoBOMap) {
        for (FscOrderInfoBO fscOrderInfoBO : fscOrderInfoBOMap.values()) {
            FscBillEcomCheckApplyBusiReqBO applyBusiReqBO = null;
            ArrayList<RelOrderBO> relOrderBOList = null;
            if (null == this.cacheClient.get(AUTO_ECOM_CHECK_KEY + fscOrderInfoBO.getOrderId())) {
                try {
                    applyBusiReqBO = new FscBillEcomCheckApplyBusiReqBO();
                    applyBusiReqBO.setSupplierId(this.str2Long(fscOrderInfoBO.getSupplierId()));
                    relOrderBOList = new ArrayList<RelOrderBO>();
                    RelOrderBO relOrderBO = new RelOrderBO();
                    relOrderBO.setAcceptOrderId(fscOrderInfoBO.getAcceptOrderId());
                    relOrderBO.setMyAmount(fscOrderInfoBO.getInspTotalPurchaseMoney());
                    relOrderBO.setOrderId(fscOrderInfoBO.getOrderId());
                    relOrderBO.setOtherNo(fscOrderInfoBO.getOrderNo());
                    relOrderBO.setSaleAmount(fscOrderInfoBO.getInspTotalSaleMoney());
                    relOrderBO.setSupId(this.str2Long(fscOrderInfoBO.getSupplierId()));
                    relOrderBOList.add(relOrderBO);
                    applyBusiReqBO.setRelOrderList(relOrderBOList);
                }
                catch (Exception e) {
                    log.error("\u81ea\u52a8\u5bf9\u8d26\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)fscOrderInfoBO.getOrderId(), (Object)e);
                }
                FscBillEcomCheckApplyBusiRspBO applyBusiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(applyBusiReqBO);
                if (!"0000".equals(applyBusiRspBO.getRespCode())) {
                    log.error("\u8ba2\u5355id:{}\u5bf9\u8d26\u51fa\u9519\uff1a{}", (Object)fscOrderInfoBO.getOrderId(), (Object)applyBusiRspBO.getRespDesc());
                    continue;
                }
                this.cacheClient.set(AUTO_ECOM_CHECK_KEY + fscOrderInfoBO.getOrderId(), (Object)fscOrderInfoBO.getOrderId());
            }
            if (null == this.cacheClient.get(AUTO_ECOM_CHECK_KEY + fscOrderInfoBO.getOrderId())) continue;
            FscBillEcomCheckAbilityReqBO checkAbilityReqBO = new FscBillEcomCheckAbilityReqBO();
            checkAbilityReqBO.setRelOrderList(relOrderBOList);
            FscBillEcomCheckAbilityRspBO checkAbilityRspBO = this.fscBillEcomCheckAbilityService.dealEcomCheck(checkAbilityReqBO);
            if (!"0000".equals(checkAbilityRspBO.getRespCode())) {
                log.error("\u8ba2\u5355id:{}\u5bf9\u8d26\u51fa\u9519\uff1a{}", (Object)fscOrderInfoBO.getOrderId(), (Object)checkAbilityRspBO.getRespDesc());
                this.cacheClient.delete(AUTO_ECOM_CHECK_KEY + fscOrderInfoBO.getOrderId());
                continue;
            }
            this.cacheClient.delete(AUTO_ECOM_CHECK_KEY + fscOrderInfoBO.getOrderId());
        }
    }

    private Long str2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("198888", "\u6570\u636e\u8f6c\u6362\u9519\u8bef");
        }
    }
}

