/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillOrderAdvanceWriteAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderAdvanceWriteAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderAdvanceWriteAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderAdvanceWriteBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderAdvanceWriteBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderAdvanceWriteBusiRspBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCVerificationBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscWriteOffPO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderAdvanceWriteAbilityService"})
public class FscBillOrderAdvanceWriteAbilityServiceImpl
implements FscBillOrderAdvanceWriteAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderAdvanceWriteAbilityServiceImpl.class);
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscBillOrderAdvanceWriteBusiService fscBillOrderAdvanceWriteBusiService;

    @PostMapping(value={"orderAdvanceWrite"})
    public FscBillOrderAdvanceWriteAbilityRspBO orderAdvanceWrite(@RequestBody FscBillOrderAdvanceWriteAbilityReqBO reqBO) {
        FscBillOrderAdvanceWriteAbilityRspBO rspBO = new FscBillOrderAdvanceWriteAbilityRspBO();
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long fscOrderId = reqBO.getFscOrderId();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        if (!fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE) && !fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION)) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u6838\u9500\u3002");
        }
        if (fscOrderPO.getWriteOffAmount().compareTo(fscOrderPO.getTotalCharge()) == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u7ed3\u7b97\u5355\u5df2\u5b8c\u6210\u6838\u9500");
            return rspBO;
        }
        if (fscOrderPO.getWriteOffAmount().compareTo(fscOrderPO.getTotalCharge()) > 0) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38");
        }
        String lockKey = "lock:saleWriteOff:" + fscOrderPO.getBuynerNo();
        RLock rLock = this.redissonClient.getLock(lockKey);
        try {
            boolean result = rLock.tryLock(60000L, 60000L, TimeUnit.MILLISECONDS);
            if (!result) {
                log.error(reqBO.getFscOrderId() + "\u83b7\u53d6\u5e76\u53d1\u9501\u5931\u8d25\uff0clockKey={}", (Object)lockKey);
                throw new BusinessException("8888", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
            log.debug(reqBO.getFscOrderId() + "\u83b7\u53d6\u9501\u6210\u529f");
            if (fscOrderPO.getOrderSource().toString().equals("2")) {
                this.dealEcomWriteOff(reqBO, fscOrderPO);
            } else {
                this.dealSelfWriteOff(reqBO, fscOrderPO);
            }
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("\u81ea\u52a8\u6838\u9500\u8865\u5f55\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            Thread.currentThread().interrupt();
            throw new BusinessException("8888", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        finally {
            if (rLock != null && rLock.isHeldByCurrentThread()) {
                rLock.unlock();
                log.debug(reqBO.getFscOrderId() + "\u89e3\u9501\u6210\u529f");
            }
        }
        FscBillOrderInvoiceSignAbilityReqBO fscBillOrderInvoiceSignAbilityReqBO = new FscBillOrderInvoiceSignAbilityReqBO();
        fscBillOrderInvoiceSignAbilityReqBO.setOrderId(fscOrderId);
        this.sendMq(fscBillOrderInvoiceSignAbilityReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealEcomWriteOff(FscBillOrderAdvanceWriteAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        if (fscOrderPO.getPayType() != 3 && fscOrderPO.getPayType() != 4 && fscOrderPO.getPayType() != 5) {
            return;
        }
        FscClaimDetailPO fscClaimDetail = new FscClaimDetailPO();
        fscClaimDetail.setBuyerNo(fscOrderPO.getBuynerNo());
        fscClaimDetail.setPostingStatus("1");
        List fscClaimDetailPOList = this.fscClaimDetailMapper.getAllByBuynerNo(fscClaimDetail);
        if (CollectionUtils.isEmpty((Collection)fscClaimDetailPOList)) {
            return;
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        FscOrderWriteRelationPO writeRelationPO = new FscOrderWriteRelationPO();
        writeRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List writeList = this.fscOrderWriteRelationMapper.getList(writeRelationPO);
        HashMap<Long, BigDecimal> writeRelationMap = new HashMap<Long, BigDecimal>();
        for (FscOrderWriteRelationPO orderWriteRelationPO : writeList) {
            BigDecimal writeOffAmount = (BigDecimal)writeRelationMap.get(orderWriteRelationPO.getItemId());
            if (writeOffAmount == null) {
                writeRelationMap.put(orderWriteRelationPO.getItemId(), orderWriteRelationPO.getWriteOffAmount());
                continue;
            }
            writeOffAmount = writeOffAmount.add(orderWriteRelationPO.getWriteOffAmount());
            writeRelationMap.put(orderWriteRelationPO.getItemId(), writeOffAmount);
        }
        HashMap<Long, BigDecimal> remainWriteMap = new HashMap<Long, BigDecimal>();
        ArrayList<FscWriteOffPO> advanceWriteList = new ArrayList<FscWriteOffPO>();
        Date writeOffDate = new Date();
        ArrayList<FscClaimDetailPO> updateClaimList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscOrderWriteRelationPO> writeRelationList = new ArrayList<FscOrderWriteRelationPO>();
        BigDecimal fscOrderWriteOffAmount = new BigDecimal(0);
        BigDecimal totalCharge = fscOrderPO.getTotalCharge().subtract(fscOrderPO.getWriteOffAmount());
        block1: for (FscClaimDetailPO claimDetailPO : fscClaimDetailPOList) {
            BigDecimal writeAmount;
            BigDecimal remainWriteAmt = (BigDecimal)remainWriteMap.get(claimDetailPO.getClaimDetailId());
            if (remainWriteAmt == null) {
                remainWriteAmt = claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount());
            }
            if (remainWriteAmt.compareTo(BigDecimal.ZERO) <= 0 || totalCharge.compareTo(BigDecimal.ZERO) <= 0) break;
            BigDecimal writeOffAmount = claimDetailPO.getClaimAmt().subtract(remainWriteAmt);
            BigDecimal notWriteAmount = remainWriteAmt;
            if (notWriteAmount.compareTo(totalCharge) >= 0) {
                writeAmount = totalCharge;
                claimDetailPO.setWriteOffAmount(totalCharge);
                remainWriteAmt = remainWriteAmt.subtract(totalCharge);
                totalCharge = BigDecimal.ZERO;
            } else {
                claimDetailPO.setWriteOffAmount(notWriteAmount);
                totalCharge = totalCharge.subtract(notWriteAmount);
                writeAmount = notWriteAmount;
                remainWriteAmt = remainWriteAmt.subtract(notWriteAmount);
            }
            remainWriteMap.put(claimDetailPO.getClaimDetailId(), remainWriteAmt);
            updateClaimList.add(claimDetailPO);
            fscOrderWriteOffAmount = fscOrderWriteOffAmount.add(writeAmount);
            for (FscOrderItemPO itemPO : fscOrderItemPOList) {
                if (writeAmount.compareTo(BigDecimal.ZERO) <= 0) continue block1;
                BigDecimal itemNeedWrite = itemPO.getAmt().subtract(itemPO.getWriteOffAmount());
                if (writeRelationMap.get(itemPO.getId()) != null) {
                    itemNeedWrite = itemPO.getAmt().subtract((BigDecimal)writeRelationMap.get(itemPO.getId()));
                }
                if (itemNeedWrite.compareTo(BigDecimal.ZERO) <= 0) continue;
                FscWriteOffPO fscWriteOffPO = new FscWriteOffPO();
                fscWriteOffPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffPO.setFscOrderId(fscOrderPO.getFscOrderId());
                fscWriteOffPO.setFscOrderNo(fscOrderPO.getOrderNo());
                fscWriteOffPO.setOrderAmount(itemPO.getAmt());
                fscWriteOffPO.setOrderId(itemPO.getOrderId());
                fscWriteOffPO.setOrderCode(itemPO.getOrderCode());
                if (FscConstants.FscWriteType.CLAIM.equals(claimDetailPO.getWriteType())) {
                    fscWriteOffPO.setClaimId(claimDetailPO.getClaimId());
                } else {
                    fscWriteOffPO.setChangeId(claimDetailPO.getClaimId());
                }
                fscWriteOffPO.setHandleUserId(claimDetailPO.getHandleUserId());
                fscWriteOffPO.setHandleUserName(claimDetailPO.getHandleUserName());
                fscWriteOffPO.setHandleDeptId(claimDetailPO.getHandleDeptId());
                fscWriteOffPO.setHandleDeptName(claimDetailPO.getHandleDeptName());
                fscWriteOffPO.setClaimType(claimDetailPO.getClaimType());
                fscWriteOffPO.setBuynerNo(fscOrderPO.getBuynerNo());
                fscWriteOffPO.setBuynerName(fscOrderPO.getBuynerName());
                fscWriteOffPO.setTotalCharge(fscOrderPO.getTotalCharge());
                fscWriteOffPO.setPayerId(fscOrderPO.getPayerId());
                fscWriteOffPO.setPayerName(fscOrderPO.getPayerName());
                fscWriteOffPO.setWriteOffDate(new Date());
                fscWriteOffPO.setStatus(Integer.valueOf(1));
                FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
                fscOrderWriteRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
                if (FscConstants.FscWriteType.CLAIM.equals(claimDetailPO.getWriteType())) {
                    fscOrderWriteRelationPO.setClaimDetailId(claimDetailPO.getClaimDetailId());
                    fscOrderWriteRelationPO.setClaimId(claimDetailPO.getClaimId());
                } else {
                    fscOrderWriteRelationPO.setChangeDetailId(claimDetailPO.getClaimDetailId());
                    fscOrderWriteRelationPO.setChangeId(claimDetailPO.getClaimId());
                }
                fscOrderWriteRelationPO.setClaimAmt(claimDetailPO.getClaimAmt());
                fscOrderWriteRelationPO.setWriteOffDate(writeOffDate);
                fscOrderWriteRelationPO.setClaimNo(claimDetailPO.getClaimNo());
                fscOrderWriteRelationPO.setItemId(itemPO.getId());
                fscOrderWriteRelationPO.setOrderId(itemPO.getOrderId());
                fscOrderWriteRelationPO.setOrderCode(itemPO.getOrderCode());
                fscOrderWriteRelationPO.setBuynerNo(fscOrderPO.getBuynerNo());
                fscOrderWriteRelationPO.setBuynerName(fscOrderPO.getBuynerName());
                if (writeAmount.compareTo(itemNeedWrite) >= 0) {
                    itemPO.setWriteOffAmount(itemPO.getWriteOffAmount().add(itemNeedWrite));
                    fscWriteOffPO.setThisAmount(itemNeedWrite);
                    fscOrderWriteRelationPO.setWriteOffAmount(itemNeedWrite);
                    writeOffAmount = writeOffAmount.add(itemNeedWrite);
                    fscWriteOffPO.setWriteOffAmount(writeOffAmount);
                    notWriteAmount = notWriteAmount.subtract(itemNeedWrite);
                    fscWriteOffPO.setRemainAmount(notWriteAmount);
                    fscOrderWriteRelationPO.setRemainAmount(notWriteAmount);
                    writeAmount = writeAmount.subtract(itemNeedWrite);
                } else {
                    itemPO.setWriteOffAmount(itemPO.getWriteOffAmount().add(writeAmount));
                    fscWriteOffPO.setThisAmount(writeAmount);
                    fscOrderWriteRelationPO.setWriteOffAmount(writeAmount);
                    writeOffAmount = writeOffAmount.add(writeAmount);
                    fscWriteOffPO.setWriteOffAmount(writeOffAmount);
                    notWriteAmount = BigDecimal.ZERO;
                    writeAmount = BigDecimal.ZERO;
                    fscOrderWriteRelationPO.setRemainAmount(notWriteAmount);
                }
                advanceWriteList.add(fscWriteOffPO);
                writeRelationList.add(fscOrderWriteRelationPO);
            }
        }
        ArrayList<FscWriteOffPO> fscWriteOffPOList = new ArrayList<FscWriteOffPO>();
        if (!CollectionUtils.isEmpty(advanceWriteList)) {
            fscWriteOffPOList.addAll(advanceWriteList);
        }
        FscBillOrderAdvanceWriteBusiReqBO orderAdvanceWriteReqBO = new FscBillOrderAdvanceWriteBusiReqBO();
        orderAdvanceWriteReqBO.setOrderId(fscOrderPO.getFscOrderId());
        orderAdvanceWriteReqBO.setFscClaimDetailList(updateClaimList);
        orderAdvanceWriteReqBO.setFscWriteOffPOList(fscWriteOffPOList);
        log.error("\u7ed3\u7b97\u6838\u9500\u5173\u7cfb\uff1a" + JSONObject.toJSONString(writeRelationList));
        orderAdvanceWriteReqBO.setWriteRelationList(writeRelationList);
        if (null == fscOrderPO.getWriteOffAmount()) {
            fscOrderPO.setWriteOffAmount(new BigDecimal(0));
        }
        orderAdvanceWriteReqBO.setWriteOffAmountAdd(fscOrderWriteOffAmount);
        orderAdvanceWriteReqBO.setWriteOffAmount(fscOrderPO.getWriteOffAmount().add(fscOrderWriteOffAmount));
        if (orderAdvanceWriteReqBO.getWriteOffAmount().compareTo(fscOrderPO.getTotalCharge()) > 0) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38");
        }
        FscBillOrderAdvanceWriteBusiRspBO orderAdvanceWriteRsqBO = this.fscBillOrderAdvanceWriteBusiService.dealOrderAdvanceWrite(orderAdvanceWriteReqBO);
        if (!"0000".equals(orderAdvanceWriteRsqBO.getRespCode())) {
            throw new FscBusinessException("193011", orderAdvanceWriteRsqBO.getRespDesc());
        }
    }

    private FscBillOrderAdvanceWriteBusiReqBO dealSelfWriteOff(FscBillOrderAdvanceWriteAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        HashMap<Long, BigDecimal> orderInvoiceMap = new HashMap<Long, BigDecimal>(16);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        HashSet<Long> invoiceOrderIds = new HashSet<Long>();
        for (FscOrderItemPO orderItemPO : fscOrderItemPOList) {
            invoiceOrderIds.add(orderItemPO.getOrderId());
            if (orderInvoiceMap.get(orderItemPO.getOrderId()) == null) {
                orderInvoiceMap.put(orderItemPO.getOrderId(), orderItemPO.getAmt());
                continue;
            }
            BigDecimal invoiceAmount = (BigDecimal)orderInvoiceMap.get(orderItemPO.getOrderId());
            invoiceAmount = invoiceAmount.add(orderItemPO.getAmt());
            orderInvoiceMap.put(orderItemPO.getOrderId(), invoiceAmount);
        }
        HashMap<Long, FscWriteOffPO> fscWriteOffMap = new HashMap<Long, FscWriteOffPO>(16);
        Date writeOffDate = new Date();
        BigDecimal fscOrderWriteOffAmount = new BigDecimal(0);
        ArrayList<FscOrderWriteRelationPO> writeRelationList = new ArrayList<FscOrderWriteRelationPO>();
        ArrayList<FscOrderItemBO> orderItemPOUpdateList = new ArrayList<FscOrderItemBO>();
        ArrayList<FscClaimDetailPO> updateClaimList = new ArrayList<FscClaimDetailPO>();
        FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
        fscClaimDetailPo.setOrderIds(invoiceOrderIds);
        List claimDetailList = this.fscClaimDetailMapper.getWriteOffPay(fscClaimDetailPo);
        if (CollectionUtils.isEmpty((Collection)claimDetailList)) {
            return null;
        }
        for (Object claimDetailPO : claimDetailList) {
            BigDecimal orderInvoiceAmt;
            BigDecimal fscOrderItemWriteOffAmount = new BigDecimal(0);
            if (null == claimDetailPO.getWriteOffAmount()) {
                claimDetailPO.setWriteOffAmount(new BigDecimal(0));
            }
            FscBillTaxSendSaleFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendSaleFscOrderToYCVerificationBO();
            BigDecimal noWriteOffAmount = claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount());
            if (orderInvoiceMap.get(claimDetailPO.getOrderId()) == null || noWriteOffAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            FscWriteOffPO fscWriteOffPO = (FscWriteOffPO)fscWriteOffMap.get(claimDetailPO.getOrderId());
            if (fscWriteOffPO == null) {
                fscWriteOffPO = new FscWriteOffPO();
                fscWriteOffPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffPO.setFscOrderId(fscOrderPO.getFscOrderId());
                fscWriteOffPO.setFscOrderNo(fscOrderPO.getOrderNo());
                fscWriteOffPO.setClaimId(claimDetailPO.getClaimId());
                fscWriteOffPO.setHandleUserId(claimDetailPO.getHandleUserId());
                fscWriteOffPO.setHandleUserName(claimDetailPO.getHandleUserName());
                fscWriteOffPO.setHandleDeptId(claimDetailPO.getHandleDeptId());
                fscWriteOffPO.setHandleDeptName(claimDetailPO.getHandleDeptName());
                fscWriteOffPO.setClaimType(claimDetailPO.getClaimType());
                fscWriteOffPO.setOrderId(claimDetailPO.getOrderId());
                fscWriteOffPO.setOrderCode(claimDetailPO.getOrderCode());
                fscWriteOffPO.setBuynerNo(fscOrderPO.getBuynerNo());
                fscWriteOffPO.setBuynerName(fscOrderPO.getBuynerName());
                fscWriteOffPO.setTotalCharge(fscOrderPO.getTotalCharge());
                fscWriteOffPO.setOrderAmount((BigDecimal)orderInvoiceMap.get(claimDetailPO.getOrderId()));
                fscWriteOffPO.setPayerId(fscOrderPO.getPayerId());
                fscWriteOffPO.setPayerName(fscOrderPO.getPayerName());
                fscWriteOffPO.setWriteOffDate(writeOffDate);
                fscWriteOffPO.setStatus(Integer.valueOf(1));
            }
            if ((orderInvoiceAmt = (BigDecimal)orderInvoiceMap.get(claimDetailPO.getOrderId())).compareTo(noWriteOffAmount) > 0) {
                verificationBO.setAPPLY_AMOUNT(noWriteOffAmount);
                orderInvoiceAmt = orderInvoiceAmt.subtract(noWriteOffAmount);
                orderInvoiceMap.put(claimDetailPO.getOrderId(), orderInvoiceAmt);
            } else {
                verificationBO.setAPPLY_AMOUNT(orderInvoiceAmt);
                orderInvoiceMap.remove(claimDetailPO.getOrderId());
            }
            if (fscWriteOffPO.getThisAmount() == null) {
                fscWriteOffPO.setThisAmount(verificationBO.getAPPLY_AMOUNT());
            } else {
                fscWriteOffPO.setThisAmount(fscWriteOffPO.getThisAmount().add(verificationBO.getAPPLY_AMOUNT()));
            }
            fscWriteOffPO.setWriteOffAmount(fscWriteOffPO.getThisAmount());
            fscWriteOffMap.put(claimDetailPO.getOrderId(), fscWriteOffPO);
            if (claimDetailPO.getClaimAmt().compareTo(claimDetailPO.getWriteOffAmount().add(verificationBO.getAPPLY_AMOUNT())) < 0) {
                throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba4\u9886\u91d1\u989d\uff01");
            }
            claimDetailPO.setWriteOffAmount(verificationBO.getAPPLY_AMOUNT());
            fscOrderItemWriteOffAmount = fscOrderItemWriteOffAmount.add(verificationBO.getAPPLY_AMOUNT());
            fscOrderWriteOffAmount = fscOrderWriteOffAmount.add(verificationBO.getAPPLY_AMOUNT());
            FscOrderItemBO fscOrderItemBO = new FscOrderItemBO();
            fscOrderItemBO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderItemBO.setOrderId(claimDetailPO.getOrderId());
            fscOrderItemBO.setWriteOffAmount(fscOrderItemWriteOffAmount);
            fscOrderItemBO.setWriteOffAmountAdd(fscOrderItemWriteOffAmount);
            orderItemPOUpdateList.add(fscOrderItemBO);
            claimDetailPO.setWriteOffDate(writeOffDate);
            updateClaimList.add((FscClaimDetailPO)claimDetailPO);
            FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
            fscOrderWriteRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderWriteRelationPO.setClaimDetailId(claimDetailPO.getClaimDetailId());
            fscOrderWriteRelationPO.setClaimId(claimDetailPO.getClaimId());
            fscOrderWriteRelationPO.setClaimAmt(claimDetailPO.getClaimAmt());
            fscOrderWriteRelationPO.setWriteOffAmount(verificationBO.getAPPLY_AMOUNT());
            fscOrderWriteRelationPO.setWriteOffDate(writeOffDate);
            fscOrderWriteRelationPO.setClaimNo(claimDetailPO.getClaimNo());
            fscOrderWriteRelationPO.setOrderId(claimDetailPO.getOrderId());
            fscOrderWriteRelationPO.setOrderCode(claimDetailPO.getOrderCode());
            fscOrderWriteRelationPO.setBuynerNo(fscOrderPO.getBuynerNo());
            fscOrderWriteRelationPO.setBuynerName(fscOrderPO.getBuynerName());
            writeRelationList.add(fscOrderWriteRelationPO);
        }
        ArrayList<FscWriteOffPO> fscWriteOffPOList = new ArrayList<FscWriteOffPO>();
        if (!CollectionUtils.isEmpty(fscWriteOffMap.keySet())) {
            for (Long key : fscWriteOffMap.keySet()) {
                fscWriteOffPOList.add((FscWriteOffPO)fscWriteOffMap.get(key));
            }
        }
        FscBillOrderAdvanceWriteBusiReqBO orderAdvanceWriteReqBO = new FscBillOrderAdvanceWriteBusiReqBO();
        orderAdvanceWriteReqBO.setOrderId(fscOrderPO.getFscOrderId());
        orderAdvanceWriteReqBO.setFscClaimDetailList(updateClaimList);
        orderAdvanceWriteReqBO.setFscWriteOffPOList(fscWriteOffPOList);
        orderAdvanceWriteReqBO.setWriteRelationList(writeRelationList);
        orderAdvanceWriteReqBO.setOrderItemList(orderItemPOUpdateList);
        if (null == fscOrderPO.getWriteOffAmount()) {
            fscOrderPO.setWriteOffAmount(new BigDecimal(0));
        }
        orderAdvanceWriteReqBO.setWriteOffAmountAdd(fscOrderWriteOffAmount);
        orderAdvanceWriteReqBO.setWriteOffAmount(fscOrderPO.getWriteOffAmount().add(fscOrderWriteOffAmount));
        if (orderAdvanceWriteReqBO.getWriteOffAmount().compareTo(fscOrderPO.getTotalCharge()) > 0) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38");
        }
        FscBillOrderAdvanceWriteBusiRspBO orderAdvanceWriteRsqBO = this.fscBillOrderAdvanceWriteBusiService.dealOrderAdvanceWrite(orderAdvanceWriteReqBO);
        if (!"0000".equals(orderAdvanceWriteRsqBO.getRespCode())) {
            throw new FscBusinessException("193011", orderAdvanceWriteRsqBO.getRespDesc());
        }
        return null;
    }

    private void sendMq(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }
}

