/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscComOrderRefundConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundConfirmBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushEngTodoAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyRefundInvoiceAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.po.FscOrderExtPO;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscComOrderRefundConfirmAbilityService"})
public class FscComOrderRefundConfirmAbilityServiceImpl
implements FscComOrderRefundConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderRefundConfirmAbilityServiceImpl.class);
    @Autowired
    private FscComOrderRefundConfirmBusiService fscComOrderRefundConfirmBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPushEngTodoAbilityService fscPushEngTodoAbilityService;
    @Value(value="${es.FSC_PUSH_UNIFY_REFUND__INVOICE_TOPIC:FSC_PUSH_UNIFY_REFUND__INVOICE_TOPIC}")
    private String fscPushUnifyRefundTopic;
    @Value(value="${es.FSC_PUSH_UNIFY_REFUND__INVOICE_TAG:FSC_PUSH_UNIFY_REFUND__INVOICE_TAG}")
    private String fscPushUnifyRefundTag;
    @Resource(name="fscPushUnifyRefundInvoiceMqServiceProvider")
    private ProxyMessageProducer fscPushUnifyRefundInvoiceMqServiceProvider;

    @PostMapping(value={"dealOrderRefundConfirm"})
    public FscComOrderRefundConfirmAbilityRspBO dealOrderRefundConfirm(@RequestBody FscComOrderRefundConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundConfirmBusiReqBO busiReqBO = (FscComOrderRefundConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundConfirmBusiReqBO.class));
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundConfirmBusiRspBO busiRspBO = this.fscComOrderRefundConfirmBusiService.dealOrderRefundConfirm(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("\u9000\u7968\u5355[").append(refundId).append("]\u786e\u8ba4\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
                continue;
            }
            if (busiRspBO.getUnifyFlag().booleanValue()) {
                this.dealPushRefund(refundId, busiRspBO.getFscOrderId());
            }
            this.sendMq(refundId);
        }
        FscComOrderRefundConfirmAbilityRspBO rspBO = new FscComOrderRefundConfirmAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    @PostMapping(value={"dealProjectOrderRefundConfirm"})
    public FscComOrderRefundConfirmAbilityRspBO dealProjectOrderRefundConfirm(@RequestBody FscComOrderRefundConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundConfirmBusiReqBO busiReqBO = (FscComOrderRefundConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundConfirmBusiReqBO.class));
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundConfirmBusiRspBO busiRspBO = this.fscComOrderRefundConfirmBusiService.dealProjectOrderRefundConfirm(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("\u9000\u7968\u5355[").append(refundId).append("]\u786e\u8ba4\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
                continue;
            }
            try {
                FscPushEngTodoAbilityServiceReqBO todoAbilityServiceReqBO = new FscPushEngTodoAbilityServiceReqBO();
                todoAbilityServiceReqBO.setBusiCode("1205");
                todoAbilityServiceReqBO.setBusiName("\u5de5\u7a0b\u670d\u52a1\u9000\u7968\u5ba1\u6279");
                todoAbilityServiceReqBO.setObjId(refundId);
                todoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT);
                this.fscPushEngTodoAbilityService.dealEngPushTodo(todoAbilityServiceReqBO);
            }
            catch (Exception e) {
                log.error("dealFinanceStartApproval|\u53d1\u9001\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
            }
            this.sendMq(refundId);
        }
        FscComOrderRefundConfirmAbilityRspBO rspBO = new FscComOrderRefundConfirmAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void dealPushRefund(Long refundId, Long fscOrderId) {
        FscOrderExtPO extPO = new FscOrderExtPO();
        extPO.setFscOrderId(fscOrderId);
        extPO = this.fscOrderExtMapper.getModelBy(extPO);
        if (extPO != null && extPO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            FscPushUnifyRefundInvoiceAbilityReqBO abilityReqBO = new FscPushUnifyRefundInvoiceAbilityReqBO();
            abilityReqBO.setRefundId(refundId);
            this.fscPushUnifyRefundInvoiceMqServiceProvider.send(new ProxyMessage(this.fscPushUnifyRefundTopic, this.fscPushUnifyRefundTag, JSON.toJSONString((Object)abilityReqBO)));
        }
    }

    private void valid(FscComOrderRefundConfirmAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getConfirmType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[confirmType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO abilityReqBO = new FscComRefundSyncAbilityReqBO();
        abilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(abilityReqBO);
    }
}

