/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscEngineeringRefundPayUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscEngineeringRefundPayUpdateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscEngineeringRefundPayUpdateAbilityRspBO;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceRefundPayTempQryAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscEngineeringRefundPayUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundPayUpdateBusiRspBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscEngineeringRefundPayUpdateAbilityService"})
public class FscEngineeringRefundPayUpdateAbilityServiceImpl
implements FscEngineeringRefundPayUpdateAbilityService {
    @Autowired
    private FscEngineeringRefundPayUpdateBusiService fscEngineeringRefundPayUpdateBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscFinanceRefundPayTempQryAtomService fscFinanceRefundPayTempQryAtomService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealEngineeringRefundPayUpdate"})
    public FscEngineeringRefundPayUpdateAbilityRspBO dealEngineeringRefundPayUpdate(@RequestBody FscEngineeringRefundPayUpdateAbilityReqBO reqBO) {
        if (reqBO.getTempId() != null) {
            this.qryTempInfo(reqBO);
        }
        this.valid(reqBO);
        FscEngineeringRefundPayUpdateBusiReqBO fscBillPayRefundCreateBusiReqBO = (FscEngineeringRefundPayUpdateBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscEngineeringRefundPayUpdateBusiReqBO.class));
        FscEngineeringRefundPayUpdateBusiRspBO fscBillPayRefundCreateBusiRspBO = this.fscEngineeringRefundPayUpdateBusiService.dealEngineeringRefundPayUpdate(fscBillPayRefundCreateBusiReqBO);
        if (!"0000".equals(fscBillPayRefundCreateBusiRspBO.getRespCode())) {
            return (FscEngineeringRefundPayUpdateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundCreateBusiRspBO)), FscEngineeringRefundPayUpdateAbilityRspBO.class);
        }
        if (reqBO.getRefundId() != null) {
            this.syncEs(reqBO);
        }
        FscEngineeringRefundPayUpdateAbilityRspBO rspBO = new FscEngineeringRefundPayUpdateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEs(FscEngineeringRefundPayUpdateAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(reqBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void valid(FscEngineeringRefundPayUpdateAbilityReqBO reqBO) {
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundDate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundAmount() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.RefundUserType.PURCHASE.equals(reqBO.getUserType())) {
            if (reqBO.getAgentUserId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentUserName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getAgentDeptId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentDeptName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            BigDecimal refundAmt = BigDecimal.ZERO;
            for (FscFinanceRefundItemBO itemBO : reqBO.getFinanceItemList()) {
                refundAmt = refundAmt.add(itemBO.getRefundAmt());
                if (itemBO.getRefundAmt() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (itemBO.getRefundAmtLocal() != null) continue;
                throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.refundAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (refundAmt.compareTo(reqBO.getRefundAmount()) != 0) {
                throw new FscBusinessException("198888", "\u9000\u6b3e\u660e\u7ec6\u884c\u5408\u8ba1\u9000\u6b3e\u91d1\u989d\u548c\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
            }
        }
    }

    private void qryTempInfo(FscEngineeringRefundPayUpdateAbilityReqBO reqBO) {
        FscFinanceRefundPayTempQryAtomReqBO atomReqBO = new FscFinanceRefundPayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        FscFinanceRefundPayTempQryAtomRspBO atomRspBO = this.fscFinanceRefundPayTempQryAtomService.qryTempInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4e34\u65f6\u8868\u4fe1\u606f\u5931\u8d25:" + atomRspBO.getRespDesc());
        }
        reqBO.setFinanceItemList(atomRspBO.getFinanceItemList());
    }
}

