/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscEngineeringRefundRefuseAbilityService;
import com.tydic.fsc.bill.ability.bo.FscEngineeringRefundRefuseAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscEngineeringRefundRefuseAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscEngineeringRefundRefuseBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundRefuseBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringRefundRefuseBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscEngineeringRefundRefuseAbilityService"})
public class FscEngineeringRefundRefuseAbilityServiceImpl
implements FscEngineeringRefundRefuseAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscEngineeringRefundRefuseBusiService fscEngineeringRefundRefuseBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @PostMapping(value={"dealEngineeringRefundRefuse"})
    public FscEngineeringRefundRefuseAbilityRspBO dealEngineeringRefundRefuse(@RequestBody FscEngineeringRefundRefuseAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscEngineeringRefundRefuseBusiReqBO busiReqBO = (FscEngineeringRefundRefuseBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscEngineeringRefundRefuseBusiReqBO.class));
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundIdList(reqBO.getRefundIds());
        List refundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
        List notToComfire = refundPOList.stream().filter(e -> !FscConstants.RefundPayOrderState.TO_COMFIR.equals(e.getRefundStatus()) && !FscConstants.RefundPayOrderState.REFUNDING.equals(e.getRefundStatus()) && !FscConstants.AuditResultStatus.REFUSE.equals(e.getAuditStatus())).map(FscOrderRefundPO::getRefundNo).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notToComfire)) {
            throw new FscBusinessException("198888", "\u9000\u6b3e\u5355[" + (String)notToComfire.get(0) + "]\u72b6\u6001\u5f02\u5e38\uff01");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (FscOrderRefundPO po : refundPOList) {
            busiReqBO.setRefundId(po.getRefundId());
            FscEngineeringRefundRefuseBusiRspBO busiRspBO = this.fscEngineeringRefundRefuseBusiService.dealEngineeringRefundRefuse(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                stringBuilder.append("\u9000\u6b3e\u5355[id:").append(po.getRefundId()).append("]\u5904\u7406\u56de\u9000\u5931\u8d25\uff1a").append(busiRspBO.getRespCode());
                continue;
            }
            this.sendMq(po.getRefundId());
        }
        FscEngineeringRefundRefuseAbilityRspBO rspBO = new FscEngineeringRefundRefuseAbilityRspBO();
        if (!StringUtils.isEmpty((Object)stringBuilder.toString())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(stringBuilder.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }
}

