/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.fsc.bill.ability.api.FscFinanceWriteOffCancelService;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffCancelServiceReqBO;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffCancelServiceRspBO;
import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffCancelBusiService;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffCancelServiceBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffCancelServiceBusiRspBO;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscFinanceWriteOffCancelService"})
public class FscFinanceWriteOffCancelServiceImpl
implements FscFinanceWriteOffCancelService {
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffCancelBusiService fscFinanceWriteOffCancelBusiService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;

    @PostMapping(value={"cancelFinanceWriteOff"})
    public FscFinanceWriteOffCancelServiceRspBO cancelFinanceWriteOff(@RequestBody FscFinanceWriteOffCancelServiceReqBO reqBo) {
        if (CollectionUtil.isEmpty((Collection)reqBo.getAdjustIdList())) {
            throw new FscBusinessException("190000", "\u5fc5\u4f20\u53c2\u6570[adjustIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPo = new FscFinanceWriteOffAdjustPO();
        fscFinanceWriteOffAdjustPo.setAdjustIds(reqBo.getAdjustIdList());
        List list = this.fscFinanceWriteOffAdjustMapper.getList(fscFinanceWriteOffAdjustPo);
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "adjustIdList\u53c2\u6570\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
        }
        list.forEach(e -> {
            if (Arrays.asList(FscConstants.WriteOffBillStatus.FINANCE_END, FscConstants.WriteOffBillStatus.PUSH_SUCCESS).contains(e.getBillStatus())) {
                throw new FscBusinessException("190000", "\u5f53\u524d\u6838\u9500\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88:" + e.getBillStatus());
            }
        });
        FscFinanceWriteOffCancelServiceBusiReqBO busiReqBO = new FscFinanceWriteOffCancelServiceBusiReqBO();
        busiReqBO.setList(list);
        FscFinanceWriteOffCancelServiceBusiRspBO busiRspBO = this.fscFinanceWriteOffCancelBusiService.cancelFinanceWriteOff(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            list.forEach(e -> {
                FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
                syncReqBO.setFscOrderId(e.getFscOrderId());
                this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
            });
        }
        FscFinanceWriteOffCancelServiceRspBO rspBO = new FscFinanceWriteOffCancelServiceRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }
}

