/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.finance.FscEngineeringInvoiceCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringInvoiceCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringInvoiceCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringInvoiceCreateBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceCreateBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseAccountAbilityBO;
import com.tydic.umc.general.ability.bo.UmcQryEnterpriseAccountListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryEnterpriseAccountListAbilityRspBO;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscEngineeringInvoiceCreateAbilityService"})
public class FscEngineeringInvoiceCreateAbilityServiceImpl
implements FscEngineeringInvoiceCreateAbilityService {
    @Autowired
    private FscEngineeringInvoiceCreateBusiService fscEngineeringInvoiceCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealEngineeringInvoiceCreate"})
    public FscEngineeringInvoiceCreateAbilityRspBO dealEngineeringInvoiceCreate(@RequestBody FscEngineeringInvoiceCreateAbilityReqBO reqBO) {
        this.checkInput(reqBO);
        FscEngineeringInvoiceCreateBusiReqBO busiReqBO = (FscEngineeringInvoiceCreateBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscEngineeringInvoiceCreateBusiReqBO.class));
        UmcQryEnterpriseAccountListAbilityReqBO accountListAbilityReqBO = new UmcQryEnterpriseAccountListAbilityReqBO();
        accountListAbilityReqBO.setBuyerNoList(Collections.singletonList(reqBO.getBuynerNo()));
        accountListAbilityReqBO.setPageNo(Integer.valueOf(1));
        accountListAbilityReqBO.setPageSize(Integer.valueOf(1));
        UmcQryEnterpriseAccountListAbilityRspBO accountListAbilityRspBO = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountList(accountListAbilityReqBO);
        if (Objects.nonNull(accountListAbilityRspBO) && !"0000".equals(accountListAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5f02\u5e38\uff1a" + accountListAbilityRspBO.getRespDesc());
        }
        busiReqBO.setAccountSetId(((UmcEnterpriseAccountAbilityBO)accountListAbilityRspBO.getRows().get(0)).getAccountId());
        busiReqBO.setAccountSetName(((UmcEnterpriseAccountAbilityBO)accountListAbilityRspBO.getRows().get(0)).getAccountName());
        busiReqBO.setBuynerErpNo(((UmcEnterpriseAccountAbilityBO)accountListAbilityRspBO.getRows().get(0)).getErpOrgCode());
        FscEngineeringInvoiceCreateBusiRspBO rspBO = this.fscEngineeringInvoiceCreateBusiService.dealEngineeringInvoiceCreate(busiReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return (FscEngineeringInvoiceCreateAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)rspBO)), FscEngineeringInvoiceCreateAbilityRspBO.class);
    }

    private void checkInput(FscEngineeringInvoiceCreateAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierErpNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierErpNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[purchaserId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBuyName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[buyName]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPhone())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[phone]\u4e3a\u7a7a");
        }
        if (!(FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) || FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory()) || FscConstants.InvoiceCategory.FULL_ELECTRON.equals(reqBO.getInvoiceCategory()))) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceCategory]\u53d1\u7968\u7c7b\u522b\u53ea\u80fd\u4e3a1\u62162\u62163");
        }
        if (FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getProvince())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[province]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getProvinceCode())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[provinceCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCity())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[city]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCityCode())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[cityCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getArea())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[area]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAreaCode())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[areaCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveAddr())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveAddr]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveName())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceivePhone())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receivePhone]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (null == reqBO.getInvoiceType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceType]\u4e3a\u7a7a");
        }
    }
}

