/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.tydic.fsc.bill.ability.api.finance.FscFinanceTempQryAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceTempQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceTempQryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceTempQryAbilityService"})
public class FscFinanceTempQryAbilityServiceImpl
implements FscFinanceTempQryAbilityService {
    @Resource
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;

    @PostMapping(value={"queryTempList"})
    public FscFinanceTempQryAbilityRspBO queryTempList(@RequestBody FscFinanceTempQryAbilityReqBO reqBO) {
        FscFinanceTempQryAbilityRspBO rspBO = new FscFinanceTempQryAbilityRspBO();
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getFscOrderId()) || Objects.isNull(reqBO.getContractNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID\u548c\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
        fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderRelationTempPO.setContractNo(reqBO.getContractNo());
        List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
            List acceptIdList = fscOrderRelationTempPOList.stream().map(FscOrderRelationTempPO::getAcceptOrderId).distinct().collect(Collectors.toList());
            List orderIdList = fscOrderRelationTempPOList.stream().map(FscOrderRelationTempPO::getOrderId).distinct().collect(Collectors.toList());
            rspBO.setAcceptIdList(acceptIdList);
            rspBO.setOrderIdList(orderIdList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

