/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundUpdateAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundUpdateAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundUpdateAtomRspBO;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderRefundUpdateAtomServiceImpl
implements FscBillOrderRefundUpdateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundUpdateAtomServiceImpl.class);
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;

    @Override
    public FscBillOrderRefundUpdateAtomRspBO recordRefundUpdate(FscBillOrderRefundUpdateAtomReqBO reqBO) {
        int count;
        BigDecimal amt;
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscBillOrderRefundUpdateAtomRspBO rspBO = new FscBillOrderRefundUpdateAtomRspBO();
        ArrayList delOrderRelationIdList = new ArrayList();
        ArrayList delOrderItemIdList = new ArrayList();
        List<FscOrderItemPO> delOrderItemPOList = new ArrayList();
        ArrayList delInvoiceRelationIdList = new ArrayList();
        ArrayList<FscInvoiceItemPO> rollBackInvoiceItemPOList = new ArrayList<FscInvoiceItemPO>();
        HashMap<Long, BigDecimal> rollBackInvoiceItemIdMap = new HashMap<Long, BigDecimal>();
        ArrayList<FscOrderItemPO> rollBackFscOrderItemList = new ArrayList<FscOrderItemPO>();
        HashMap<Long, BigDecimal> rollBackFscOrderItemIdMap = new HashMap<Long, BigDecimal>();
        Boolean isExitInvoiceItem = false;
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setRefundId(reqBO.getRefundId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getListNoPage(relationPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            delOrderRelationIdList.addAll(fscOrderRelationPOS.stream().map(FscOrderRelationPO::getId).collect(Collectors.toList()));
        }
        FscOrderItemPO searchOrderItemPO = new FscOrderItemPO();
        searchOrderItemPO.setRefundId(reqBO.getRefundId());
        searchOrderItemPO.setOrderBy("id");
        List beforeOrderItemPOList = this.fscOrderItemMapper.getListNoPage(searchOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)beforeOrderItemPOList)) {
            delOrderItemIdList.addAll(beforeOrderItemPOList.stream().map(FscOrderItemPO::getId).collect(Collectors.toList()));
            delOrderItemPOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)beforeOrderItemPOList), FscOrderItemPO.class);
        }
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationPOS)) {
            delInvoiceRelationIdList.addAll(fscInvoiceRefundRelationPOS.stream().map(FscInvoiceRefundRelationPO::getId).collect(Collectors.toList()));
        }
        FscInvoiceItemPO searchInvoiceItemPO = new FscInvoiceItemPO();
        searchInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
        searchInvoiceItemPO.setOrderBy("ID");
        List fscInvoiceItemPOS = this.fscInvoiceItemMapper.getList(searchInvoiceItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceItemPOS)) {
            isExitInvoiceItem = true;
        }
        for (FscOrderItemPO fscOrderItemPO : delOrderItemPOList) {
            if (isExitInvoiceItem.booleanValue()) {
                if (rollBackInvoiceItemIdMap.containsKey(fscOrderItemPO.getInvoiceItemId())) {
                    amt = ((BigDecimal)rollBackInvoiceItemIdMap.get(fscOrderItemPO.getInvoiceItemId())).add(fscOrderItemPO.getRefundAmt());
                    rollBackInvoiceItemIdMap.put(fscOrderItemPO.getInvoiceItemId(), amt);
                    continue;
                }
                rollBackInvoiceItemIdMap.put(fscOrderItemPO.getInvoiceItemId(), fscOrderItemPO.getRefundAmt());
                continue;
            }
            if (rollBackFscOrderItemIdMap.containsKey(fscOrderItemPO.getInvoiceItemId())) {
                amt = ((BigDecimal)rollBackFscOrderItemIdMap.get(fscOrderItemPO.getInvoiceItemId())).add(fscOrderItemPO.getRefundAmt());
                rollBackFscOrderItemIdMap.put(fscOrderItemPO.getInvoiceItemId(), amt);
                continue;
            }
            rollBackFscOrderItemIdMap.put(fscOrderItemPO.getInvoiceItemId(), fscOrderItemPO.getRefundAmt());
        }
        for (Long l : rollBackInvoiceItemIdMap.keySet()) {
            amt = (BigDecimal)rollBackInvoiceItemIdMap.get(l);
            FscInvoiceItemPO rollBackInvoiceItemPO = new FscInvoiceItemPO();
            rollBackInvoiceItemPO.setId(l);
            rollBackInvoiceItemPO.setRefundAmt(amt);
            rollBackInvoiceItemPOList.add(rollBackInvoiceItemPO);
        }
        for (Long l : rollBackFscOrderItemIdMap.keySet()) {
            amt = (BigDecimal)rollBackFscOrderItemIdMap.get(l);
            FscOrderItemPO rollBackFscOrderItem = new FscOrderItemPO();
            rollBackFscOrderItem.setId(l);
            rollBackFscOrderItem.setRefundAmt(amt);
            rollBackFscOrderItemList.add(rollBackFscOrderItem);
        }
        if (!CollectionUtils.isEmpty(delOrderRelationIdList) && (count = this.fscOrderRelationMapper.deleteByPrmIds(delOrderRelationIdList)) != delOrderRelationIdList.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u8ba2\u5355\u5173\u8054\u8868\u6570\u636e\u6761\u6570\u4e0d\u5339\u914d\uff01");
        }
        if (!CollectionUtils.isEmpty(delOrderItemIdList) && (count = this.fscOrderItemMapper.deleteItemListByIds(delOrderItemIdList)) != delOrderItemIdList.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u7ed3\u7b97\u4e3b\u5355\u660e\u7ec6\u6570\u636e\u6761\u6570\u4e0d\u5339\u914d\uff01");
        }
        if (!CollectionUtils.isEmpty(rollBackInvoiceItemPOList)) {
            for (FscInvoiceItemPO fscInvoiceItemPO : rollBackInvoiceItemPOList) {
                fscInvoiceItemPO.setRefundAmt(fscInvoiceItemPO.getRefundAmt().negate());
            }
            count = this.fscInvoiceItemMapper.updateBatchRefundAmt(rollBackInvoiceItemPOList);
            if (rollBackInvoiceItemPOList.size() != count) {
                throw new FscBusinessException("198888", "\u56de\u9000\u4e4b\u524d\u5360\u7528\u53d1\u7968\u660e\u7ec6\u7684\u9000\u7968\u91d1\u989d\u6570\u636e\u6761\u6570\u4e0d\u5339\u914d\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(rollBackFscOrderItemList)) {
            for (FscOrderItemPO fscOrderItemPO : rollBackFscOrderItemList) {
                fscOrderItemPO.setRefundAmt(fscOrderItemPO.getRefundAmt().negate());
            }
            count = this.fscOrderItemMapper.updateBatchRefundAmt(rollBackFscOrderItemList);
            if (rollBackFscOrderItemList.size() != count) {
                throw new FscBusinessException("198888", "\u56de\u9000\u4e4b\u524d\u5360\u7528\u53d1\u7968\u660e\u7ec6\u7684\u9000\u7968\u91d1\u989d\u6570\u636e\u6761\u6570\u4e0d\u5339\u914d\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(delInvoiceRelationIdList)) {
            count = this.fscInvoiceRefundRelationMapper.deleteByPrmIds(delInvoiceRelationIdList);
            if (delInvoiceRelationIdList.size() != count) {
                throw new FscBusinessException("198888", "\u5220\u9664\u9000\u7968\u53d1\u7968\u4fe1\u606f\u6570\u636e\u6761\u6570\u4e0d\u5339\u914d");
            }
        }
        rspBO.setDelOrderItemPOList(delOrderItemPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

