/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffBO;
import com.tydic.fsc.bill.ability.enums.FscSettleStateEnum;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceWriteOffAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceWriteOffAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceWriteOffAtomRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderAdvanceUseInfoMapper;
import com.tydic.fsc.dao.FscOrderAdvanceUseItemMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderAdvanceUseInfoPO;
import com.tydic.fsc.po.FscOrderAdvanceUseItemPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPhasePayListBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceWriteOffAtomServiceImpl
implements FscFinanceWriteOffAtomService {
    @Autowired
    FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    FscOrderMapper fscOrderMapper;
    @Autowired
    FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    FscOrderPayItemMapper fscOrderPayItemMapper;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Resource
    private FscOrderAdvanceUseInfoMapper fscOrderAdvanceUseInfoMapper;
    @Resource
    private FscOrderAdvanceUseItemMapper fscOrderAdvanceUseItemMapper;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;

    @Override
    public FscFinanceWriteOffAtomRspBO purWriteOff(FscFinanceWriteOffAtomReqBO reqBO) {
        FscFinanceWriteOffAtomRspBO rspBO = new FscFinanceWriteOffAtomRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
        fscFinanceWriteOffPO.setFscOrderId(reqBO.getOrderId());
        this.fscFinanceWriteOffMapper.deleteBy(fscFinanceWriteOffPO);
        if (!CollectionUtils.isEmpty(reqBO.getPurWriteOffAmountList())) {
            BigDecimal writeOffAmt = reqBO.getPurWriteOffAmountList().stream().map(FscFinanceWriteOffBO::getWriteOffAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (writeOffAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.handleDistributePreAmt(fscOrderPO, reqBO);
            }
            List insertWritePOList = JSON.parseArray((String)JSONObject.toJSONString(reqBO.getPurWriteOffAmountList()), FscFinanceWriteOffPO.class);
            HashMap<Long, BigDecimal> updatePayWriteOffAmountMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> updatePayItemWriteOffAmountMap = new HashMap<Long, BigDecimal>();
            for (FscFinanceWriteOffPO po : insertWritePOList) {
                po.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
                po.setFscOrderId(fscOrderPO.getFscOrderId());
                po.setFscOrderNo(fscOrderPO.getOrderNo());
                po.setWriteOffType(FscConstants.FscFinanceWriteOffType.PAY);
                po.setCreateTime(new Date());
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateUserName(reqBO.getName());
                po.setDelFlag(FscConstants.DicDelFlag.NO);
                po.setCancelStatus(Integer.valueOf(0));
                BigDecimal payWriteOffAmt = (BigDecimal)updatePayWriteOffAmountMap.get(po.getPayOrderId());
                if (payWriteOffAmt == null) {
                    updatePayWriteOffAmountMap.put(po.getPayOrderId(), po.getWriteOffAmt());
                } else {
                    payWriteOffAmt = payWriteOffAmt.add(po.getWriteOffAmt());
                    updatePayWriteOffAmountMap.put(po.getPayOrderId(), payWriteOffAmt);
                }
                BigDecimal payItemWriteOffAmt = (BigDecimal)updatePayItemWriteOffAmountMap.get(po.getPayOrderId());
                if (payItemWriteOffAmt == null) {
                    updatePayItemWriteOffAmountMap.put(po.getOrderPayItemId(), po.getWriteOffAmt());
                    continue;
                }
                payItemWriteOffAmt = payItemWriteOffAmt.add(po.getWriteOffAmt());
                updatePayItemWriteOffAmountMap.put(po.getOrderPayItemId(), payItemWriteOffAmt);
            }
            this.fscFinanceWriteOffMapper.insertBatch(insertWritePOList);
            fscOrderPO.setPurWriteOffAmount(writeOffAmt);
            int count = this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPO);
            if (count == 0) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u6838\u9500\u91d1\u989d\u5931\u8d25");
                return rspBO;
            }
            for (Long payOrderId : updatePayWriteOffAmountMap.keySet()) {
                FscOrderPO payOrderPO = new FscOrderPO();
                payOrderPO.setFscOrderId(payOrderId);
                payOrderPO.setPurWriteOffAmount((BigDecimal)updatePayWriteOffAmountMap.get(payOrderId));
                count = this.fscOrderMapper.updatePurWriteOffAmountAdd(payOrderPO);
                if (count != 0) continue;
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u4ed8\u6b3e\u6838\u9500\u91d1\u989d\u5931\u8d25");
                return rspBO;
            }
            for (Long itemId : updatePayItemWriteOffAmountMap.keySet()) {
                FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setOrderPayItemId(itemId);
                fscOrderPayItemPO.setPurWriteOffAmount((BigDecimal)updatePayItemWriteOffAmountMap.get(itemId));
                count = this.fscOrderPayItemMapper.updateWriteOffAmountAdd(fscOrderPayItemPO);
                if (count != 0) continue;
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u4ed8\u6b3e\u660e\u7ec6\u6838\u9500\u91d1\u989d\u5931\u8d25");
                return rspBO;
            }
        }
        return (FscFinanceWriteOffAtomRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)rspBO)), FscFinanceWriteOffAtomRspBO.class));
    }

    private void checkWriteOffAmt(FscOrderPO orderPO, BigDecimal writeOffAmt, Long fscOrderId) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(fscOrderId);
        List orderRelationPOS = this.fscOrderRelationMapper.getList(relationPO);
        if (CollectionUtils.isEmpty((Collection)orderRelationPOS)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\uff01");
        }
        if (FscOrderFlowEnum.ENGINEERING_INVOICE.getCode().equals(orderPO.getOrderFlow())) {
            return;
        }
        Long orderId = ((FscOrderRelationPO)orderRelationPOS.get(0)).getOrderId();
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderId(orderId);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        BigDecimal shouldPayRadio = BigDecimal.ZERO;
        if (((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType() != null && ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE) && !CollectionUtils.isEmpty((Collection)((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList())) {
            List proPayList = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProPayList();
            for (UocPhasePayListBO uocPhasePayListBO : proPayList) {
                if (!uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.SHOULD_PAY) && !uocPhasePayListBO.getPayType().equals(FscConstants.PaymentMethod.DEPOSIT)) continue;
                shouldPayRadio = shouldPayRadio.add(uocPhasePayListBO.getNodePayRatio());
            }
        }
        if (shouldPayRadio.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (orderPO.getSettleType() != null && orderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            shouldPayRadio = BigDecimal.ONE;
        }
        BigDecimal shouldPayAmount = orderPO.getTotalCharge().multiply(shouldPayRadio).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        BigDecimal shouldWriteOffAmount = orderPO.getTotalCharge().subtract(shouldPayAmount).setScale(2, RoundingMode.HALF_UP);
        if (writeOffAmt.compareTo(shouldWriteOffAmount) > 0) {
            throw new FscBusinessException("198888", "\u6838\u9500\u91d1\u989d[" + writeOffAmt + "]\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u9884\u4ed8\u6bd4\u4f8b\u91d1\u989d[" + shouldWriteOffAmount + "]\u3002");
        }
    }

    public void handleDistributePreAmt(FscOrderPO orderPO, FscFinanceWriteOffAtomReqBO reqBO) {
        Map<Long, BigDecimal> writeMap = reqBO.getPurWriteOffAmountList().stream().collect(Collectors.groupingBy(FscFinanceWriteOffBO::getOrderId, Collectors.reducing(BigDecimal.ZERO, FscFinanceWriteOffBO::getWriteOffAmt, BigDecimal::add)));
        if (FscOrderFlowEnum.ENGINEERING_INVOICE.getCode().equals(orderPO.getOrderFlow())) {
            this.handleDistributePre(orderPO, writeMap);
            return;
        }
        if (FscConstants.SettleType.ORDER.equals(orderPO.getSettleType())) {
            this.handleSettleByOrder(orderPO, writeMap);
            return;
        }
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(orderPO.getFscOrderId());
        List orderRelationPOList = this.fscOrderRelationMapper.getList(relationPO);
        if (CollectionUtils.isEmpty((Collection)orderRelationPOList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\uff01");
        }
        Map<Long, String> writeNoMap = reqBO.getPurWriteOffAmountList().stream().collect(Collectors.toMap(FscFinanceWriteOffBO::getOrderId, FscFinanceWriteOffBO::getSaleVoucherNo, (k1, k2) -> k1));
        FscOrderAdvanceUseItemPO orderAdvanceUseItemPO = new FscOrderAdvanceUseItemPO();
        orderAdvanceUseItemPO.setFscOrderId(orderPO.getFscOrderId());
        List advanceUseItemPOList = this.fscOrderAdvanceUseItemMapper.getList(orderAdvanceUseItemPO);
        if (!CollectionUtils.isEmpty((Collection)advanceUseItemPOList)) {
            this.checkWriteOff(orderRelationPOList, writeMap, writeNoMap, advanceUseItemPOList);
        } else {
            this.handleDistributePre(orderPO, reqBO, writeMap, writeNoMap, orderRelationPOList);
        }
    }

    private void handleSettleByOrder(FscOrderPO orderPO, Map<Long, BigDecimal> writeMap) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(orderPO.getFscOrderId());
        List orderRelationPOList = this.fscOrderRelationMapper.getList(relationPO);
        if (CollectionUtils.isEmpty((Collection)orderRelationPOList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\uff01");
        }
        orderRelationPOList.forEach(e -> {
            if (CollectionUtils.isEmpty((Map)writeMap) || !writeMap.containsKey(e.getOrderId())) {
                return;
            }
            if (((BigDecimal)writeMap.get(e.getOrderId())).compareTo(e.getSettleAmt()) > 0) {
                throw new FscBusinessException("198888", "\u5408\u540c\u7f16\u7801\uff1a\u3010" + e.getContractNo() + "\u3011\u4e0b\u8ba2\u5355\u7f16\u53f7\uff1a\u3010 " + e.getOrderNo() + " \u3011\u6700\u5927\u6838\u9500\u91d1\u989d\u4e3a\uff1a" + e.getSettleAmt().setScale(2, RoundingMode.HALF_UP));
            }
        });
    }

    private void handleDistributePre(FscOrderPO orderPO, Map<Long, BigDecimal> writeMap) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(orderPO.getFscOrderId());
        List orderItemPOList = this.fscOrderItemMapper.getEngineeringPreStateList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)orderItemPOList)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u65e0\u9884\u4ed8\u9636\u6bb5\uff0c\u4e0d\u53ef\u8fdb\u884c\u6838\u9500\uff01");
        }
        orderItemPOList.forEach(e -> {
            if (CollectionUtils.isEmpty((Map)writeMap) || !writeMap.containsKey(e.getOrderId())) {
                return;
            }
            if (((BigDecimal)writeMap.get(e.getOrderId())).compareTo(e.getAmt()) > 0) {
                throw new FscBusinessException("198888", "\u5408\u540c\u7f16\u7801\uff1a\u3010" + e.getContractCode() + "\u3011\u4e0b\u7ed3\u7b97\u9636\u6bb5\uff1a\u3010 " + e.getContractSettleStateStr() + " \u3011\u6700\u5927\u6838\u9500\u91d1\u989d\u4e3a\uff1a" + e.getAmt().setScale(2, RoundingMode.HALF_UP));
            }
        });
    }

    private void handleDistributePre(FscOrderPO orderPO, FscFinanceWriteOffAtomReqBO reqBO, Map<Long, BigDecimal> writeMap, Map<Long, String> writeNoMap, List<FscOrderRelationPO> orderRelationPOList) {
        Map<Long, FscOrderInfoBO> fscOrderInfoBoMap = this.getOrderInfo(orderPO);
        if (CollectionUtils.isEmpty(fscOrderInfoBoMap)) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        Map<Long, List<FscOrderRelationPO>> settleMap = orderRelationPOList.stream().collect(Collectors.groupingBy(FscOrderRelationPO::getOrderId));
        List orderIds = orderRelationPOList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        FscOrderAdvanceUseInfoPO useInfoPOReq = new FscOrderAdvanceUseInfoPO();
        useInfoPOReq.setOrderIdList(orderIds);
        List fscOrderAdvanceUseInfoPOS = this.fscOrderAdvanceUseInfoMapper.getList(useInfoPOReq);
        Map<Object, Object> useInfoPOMap = !CollectionUtils.isEmpty((Collection)fscOrderAdvanceUseInfoPOS) ? fscOrderAdvanceUseInfoPOS.stream().collect(Collectors.toMap(FscOrderAdvanceUseInfoPO::getOrderId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
        ArrayList addInfoList = new ArrayList();
        ArrayList updateInfoList = new ArrayList();
        ArrayList<FscOrderAdvanceUseItemPO> fscOrderAdvanceUseItemPOList = new ArrayList<FscOrderAdvanceUseItemPO>();
        settleMap.forEach((key, val) -> {
            BigDecimal settleAmt = val.stream().map(FscOrderRelationPO::getSettleAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal qualityAmt = val.stream().map(FscOrderRelationPO::getQualityAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBoMap.get(((FscOrderRelationPO)val.get(0)).getAcceptOrderId());
            if (Objects.isNull(fscOrderInfoBO)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            List payList = fscOrderInfoBO.getPayList();
            if (CollectionUtils.isEmpty((Collection)payList) || !payList.stream().map(FscPhasePayListBO::getPayType).collect(Collectors.toList()).contains(FscConstants.PaymentMethod.PRE_PAY)) {
                return;
            }
            BigDecimal prePayRatio = payList.stream().filter(payListBO -> Objects.nonNull(payListBO.getPayType()) && FscConstants.PaymentMethod.PRE_PAY.equals(payListBO.getPayType())).map(FscPhasePayListBO::getNodePayRatio).reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
            BigDecimal shouldPayRatio = payList.stream().filter(payListBO -> Objects.nonNull(payListBO.getPayType()) && FscConstants.PaymentMethod.SHOULD_PAY.equals(payListBO.getPayType())).map(FscPhasePayListBO::getNodePayRatio).reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
            if (prePayRatio.compareTo(BigDecimal.ZERO) == 0 || shouldPayRatio.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            BigDecimal settleUseAmt = settleAmt.subtract(qualityAmt).multiply(prePayRatio.divide(prePayRatio.add(shouldPayRatio), 8, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            FscOrderAdvanceUseInfoPO fscOrderAdvanceUseInfoPO = new FscOrderAdvanceUseInfoPO();
            if (!CollectionUtils.isEmpty((Map)useInfoPOMap) && useInfoPOMap.containsKey(key)) {
                fscOrderAdvanceUseInfoPO.setId(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getId());
                BigDecimal leaveAmt = ((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getAdvanceAmt().subtract(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getTotalUseAmt());
                if (settleUseAmt.compareTo(leaveAmt) >= 0 || settleUseAmt.add(new BigDecimal("0.1")).compareTo(leaveAmt) > 0) {
                    settleUseAmt = leaveAmt;
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getAdvanceAmt());
                } else {
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getTotalUseAmt().add(settleUseAmt));
                }
                fscOrderAdvanceUseInfoPO.setAdvanceAmt(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getAdvanceAmt());
                fscOrderAdvanceUseInfoPO.setUpdateId(reqBO.getUserId());
                fscOrderAdvanceUseInfoPO.setUpdateTime(new Date());
                updateInfoList.add(fscOrderAdvanceUseInfoPO);
            } else {
                fscOrderAdvanceUseInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderAdvanceUseInfoPO.setOrderId(key);
                BigDecimal totalPrePayAmt = fscOrderInfoBO.getSaleMoneyIntegral().multiply(prePayRatio).setScale(2, RoundingMode.HALF_UP);
                fscOrderAdvanceUseInfoPO.setAdvanceAmt(totalPrePayAmt);
                if (settleUseAmt.compareTo(totalPrePayAmt) >= 0 || settleUseAmt.add(new BigDecimal("0.01")).compareTo(totalPrePayAmt) > 0) {
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(totalPrePayAmt);
                    settleUseAmt = totalPrePayAmt;
                } else {
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(settleUseAmt);
                }
                fscOrderAdvanceUseInfoPO.setCreateId(reqBO.getUserId());
                fscOrderAdvanceUseInfoPO.setCreateTime(new Date());
                fscOrderAdvanceUseInfoPO.setUpdateId(reqBO.getUserId());
                fscOrderAdvanceUseInfoPO.setUpdateTime(new Date());
                addInfoList.add(fscOrderAdvanceUseInfoPO);
            }
            FscOrderAdvanceUseItemPO fscOrderAdvanceUseItemPO = new FscOrderAdvanceUseItemPO();
            fscOrderAdvanceUseItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderAdvanceUseItemPO.setFscOrderId(orderPO.getFscOrderId());
            fscOrderAdvanceUseItemPO.setOrderId(key);
            fscOrderAdvanceUseItemPO.setUseAmt(settleUseAmt);
            fscOrderAdvanceUseItemPO.setLeaveAdvanceAmt(fscOrderAdvanceUseInfoPO.getAdvanceAmt().subtract(fscOrderAdvanceUseInfoPO.getTotalUseAmt()));
            fscOrderAdvanceUseItemPO.setCreateId(reqBO.getUserId());
            fscOrderAdvanceUseItemPO.setCreateTime(new Date());
            fscOrderAdvanceUseItemPO.setUpdateId(reqBO.getUserId());
            fscOrderAdvanceUseItemPO.setUpdateTime(new Date());
            fscOrderAdvanceUseItemPOList.add(fscOrderAdvanceUseItemPO);
        });
        this.checkWriteOff(orderRelationPOList, writeMap, writeNoMap, fscOrderAdvanceUseItemPOList);
        if (!CollectionUtils.isEmpty(addInfoList)) {
            this.fscOrderAdvanceUseInfoMapper.insertBatch(addInfoList);
        }
        if (!CollectionUtils.isEmpty(updateInfoList)) {
            this.fscOrderAdvanceUseInfoMapper.updateAmtBatch(updateInfoList);
        }
        if (!CollectionUtils.isEmpty(fscOrderAdvanceUseItemPOList)) {
            this.fscOrderAdvanceUseItemMapper.insertBatch(fscOrderAdvanceUseItemPOList);
        }
    }

    private void checkWriteOff(List<FscOrderRelationPO> orderRelationPOList, Map<Long, BigDecimal> writeMap, Map<Long, String> writeNoMap, List<FscOrderAdvanceUseItemPO> advanceUseItemPOList) {
        Map relationPOMap = orderRelationPOList.stream().collect(Collectors.toMap(FscOrderRelationPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        advanceUseItemPOList.forEach(e -> {
            if (CollectionUtils.isEmpty((Map)writeMap) || !writeMap.containsKey(e.getOrderId())) {
                return;
            }
            if (CollectionUtils.isEmpty((Map)relationPOMap) || !relationPOMap.containsKey(e.getOrderId())) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7f16\u53f7\u3010" + (String)writeNoMap.get(e.getOrderId()) + "\u3011\u5bf9\u5e94\u7684\u7ed3\u7b97\u4fe1\u606f");
            }
            if (FscSettleStateEnum.QUALITY.getCode().equals(((FscOrderRelationPO)relationPOMap.get(e.getOrderId())).getSettleState())) {
                throw new FscBusinessException("198888", "\u5408\u540c\u7f16\u53f7\u3010" + ((FscOrderRelationPO)relationPOMap.get(e.getOrderId())).getContractNo() + "\u3011\u4e3a\u8d28\u4fdd\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6838\u9500\uff01");
            }
            if (((BigDecimal)writeMap.get(e.getOrderId())).compareTo(e.getUseAmt()) > 0) {
                throw new FscBusinessException("198888", "\u8ba2\u5355\u7f16\u53f7\u3010" + (String)writeNoMap.get(e.getOrderId()) + "\u3011\u6700\u5927\u6838\u9500\u91d1\u989d\u4e3a\uff1a" + e.getUseAmt().setScale(2, RoundingMode.HALF_UP));
            }
        });
    }

    private Map<Long, FscOrderInfoBO> getOrderInfo(FscOrderPO fscOrderPO) {
        Map fscOrderInfoBoMap;
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
        }
        return fscOrderInfoBoMap;
    }
}

