/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscBillOrderQualityBO;
import com.tydic.fsc.bo.FscNoTaskAuditOrderAuditNoticeBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.bo.FscUacApproveEntrustBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckTempMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.dao.FscTaxCodeMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscCheckTempPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.po.FscTaxCodePO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderUpdateBusiServiceImpl
implements FscBillOrderUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderUpdateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscBillSendSaleFscOrderApplyAbilityService fscBillSendSaleFscOrderApplyAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCheckTempMapper fscCheckTempMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    private static final String BUSI_NAME = "\u8fd0\u8425\u63d0\u4ea4";
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;
    @Autowired
    private FscTaxCodeMapper fscTaxCodeMapper;

    @Override
    public FscBillOrderUpdateBusiRspBO dealUpdate(FscBillOrderUpdateBusiReqBO reqBO) {
        Long tempFscOrderId;
        FscBillOrderUpdateBusiRspBO rspBO = new FscBillOrderUpdateBusiRspBO();
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        this.fscOrderInvoiceMapper.updateById(fscOrderInvoicePO);
        BigDecimal qualityAmt = BigDecimal.ZERO;
        ArrayList<FscOrderRelationPO> qualityList = new ArrayList<FscOrderRelationPO>();
        ArrayList<Long> acceptOrderIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(reqBO.getQualityList())) {
            for (FscBillOrderQualityBO qualityBO : reqBO.getQualityList()) {
                qualityAmt = qualityAmt.add(qualityBO.getQualityAmt());
                FscOrderRelationPO relationPO = new FscOrderRelationPO();
                relationPO.setAcceptOrderId(qualityBO.getAcceptOrderId());
                relationPO.setFscOrderId(reqBO.getFscOrderId());
                relationPO.setQualityDate(qualityBO.getQualityDate());
                relationPO.setQualityAmt(qualityBO.getQualityAmt());
                qualityList.add(relationPO);
                acceptOrderIds.add(qualityBO.getAcceptOrderId());
            }
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setRemark(reqBO.getRemark());
        fscOrderPO.setInvoiceRemark(reqBO.getInvoiceRemark());
        fscOrderPO.setUpdateOperId(reqBO.getUserId().toString());
        fscOrderPO.setUpdateOperName(reqBO.getName());
        fscOrderPO.setUpdateTime(new Date());
        fscOrderPO.setTotalCharge(reqBO.getTotalCharge());
        fscOrderPO.setIsQuality(reqBO.getIsQuality());
        fscOrderPO.setQualityAmt(qualityAmt);
        this.fscOrderMapper.updateById(fscOrderPO);
        this.fscAttachmentMapper.deleteByfscOrderId(reqBO.getFscOrderId());
        ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                FscAttachmentPO fscAttachmentPO = (FscAttachmentPO)JSONObject.parseObject((String)JSON.toJSONString((Object)attachmentBO), FscAttachmentPO.class);
                fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
                fscAttachmentPO.setObjId(reqBO.getFscOrderId());
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPOList.add(fscAttachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
        }
        BigDecimal[] totalItemUntaxAmt = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal itemAmtSum = BigDecimal.ZERO;
        HashSet<BigDecimal> taxRate = new HashSet<BigDecimal>();
        List<FscOrderItemPO> fscOrderItemList = reqBO.getFscOrderItemPoList();
        if (!CollectionUtils.isEmpty(fscOrderItemList)) {
            int count;
            BigDecimal divide;
            ArrayList<FscOrderItemPO> updateList = new ArrayList<FscOrderItemPO>();
            ArrayList<FscOrderItemPO> addList = new ArrayList<FscOrderItemPO>();
            ArrayList<Long> deleteList = new ArrayList<Long>();
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemPO.setOrderItemIds(fscOrderItemList.stream().filter(e -> e.getOrderItemId() != null).map(e -> e.getOrderItemId()).collect(Collectors.toList()));
            Iterator list = this.fscOrderItemMapper.getList(fscOrderItemPO);
            List<Object> hasItemIds = new ArrayList();
            Object idMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)((Object)list))) {
                hasItemIds = list.stream().map(FscOrderItemPO::getOrderItemId).collect(Collectors.toList());
                idMap = list.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderItemId, orderItemPO -> orderItemPO, (e1, e2) -> e2));
            }
            for (FscOrderItemPO po : fscOrderItemList) {
                if (hasItemIds.contains(po.getOrderItemId())) {
                    if (BigDecimal.ZERO.compareTo(po.getNum()) >= 0) {
                        if (!idMap.containsKey(po.getOrderItemId())) continue;
                        deleteList.add(((FscOrderItemPO)idMap.get(po.getOrderItemId())).getId());
                        continue;
                    }
                    FscOrderItemPO orderItemPO2 = (FscOrderItemPO)idMap.get(po.getOrderItemId());
                    po.setPurchaseAmt(po.getNum().multiply(orderItemPO2.getPurchasePrice()));
                    BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)po.getPurchaseAmt(), (BigDecimal)orderItemPO2.getTaxRate());
                    po.setPurchaseUntaxAmt(po.getPurchaseAmt().subtract(purchaseTaxAmt));
                    if (orderItemPO2.getSalesUnitRate() != null && orderItemPO2.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                        po.setSettleNum(po.getNum().multiply(orderItemPO2.getSalesUnitRate()));
                    }
                    if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                        BigDecimal untaxPrice = po.getPrice().divide(BigDecimal.ONE.add(po.getTaxRate()), 8, RoundingMode.HALF_UP).stripTrailingZeros();
                        po.setUntaxAmt(AmountUtils.getBigDecimalFormat((BigDecimal)untaxPrice).multiply(po.getNum()).setScale(2, RoundingMode.HALF_UP));
                        po.setTaxAmt(po.getAmt().subtract(po.getUntaxAmt()));
                        totalItemUntaxAmt[0] = totalItemUntaxAmt[0].add(po.getUntaxAmt());
                        BigDecimal untaxPriceTemp = po.getPrice().divide(BigDecimal.ONE.add(po.getTaxRate()), 13, RoundingMode.HALF_UP).stripTrailingZeros();
                        po.setUntaxAmtTemp(AmountUtils.getBigDecimalFormat((BigDecimal)untaxPriceTemp).multiply(po.getNum()).setScale(2, RoundingMode.HALF_UP));
                        po.setTaxAmtTemp(po.getAmt().subtract(po.getUntaxAmtTemp()));
                    }
                    taxRate.add(po.getTaxRate());
                    updateList.add(po);
                    itemAmtSum = itemAmtSum.add(po.getAmt());
                    continue;
                }
                if (po.getNum() != null && po.getNum().compareTo(BigDecimal.ZERO) == 0) continue;
                addList.add(po);
            }
            ArrayList<FscOrderItemPO> insertPos = new ArrayList<FscOrderItemPO>();
            if (!CollectionUtils.isEmpty(addList)) {
                Map fscOrderInfoBoMap;
                if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType())) {
                    List orderIds = addList.stream().map(e -> e.getOrderId()).collect(Collectors.toList());
                    FscSaleOrderListQueryAtomReqBO fscSaleOrderListQueryAtomReqBO = new FscSaleOrderListQueryAtomReqBO();
                    fscSaleOrderListQueryAtomReqBO.setOrderIds(orderIds);
                    fscSaleOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                        fscSaleOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
                    }
                    fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
                    if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                        fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                    }
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                        fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
                    }
                    if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                        fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
                    }
                    fscSaleOrderListQueryAtomReqBO.setTabId(this.SALE_ORDER_TAB_ID);
                    fscSaleOrderListQueryAtomReqBO.setIsAfterSales(Boolean.valueOf(false));
                    fscSaleOrderListQueryAtomReqBO.setPageSize(Integer.valueOf(orderIds.size()));
                    FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(fscSaleOrderListQueryAtomReqBO);
                    log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)fscSaleOrderListQueryAtomRspBO));
                    if (null == fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != orderIds.size()) {
                        throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
                } else {
                    List inspectionVoucherIdList = addList.stream().map(e -> e.getAcceptOrderId()).collect(Collectors.toList());
                    FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
                    fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
                    fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                        fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
                    }
                    fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
                    if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                    }
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
                    }
                    if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
                    }
                    fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
                    FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = new FscAcceptOrderListQueryAtomRspBO();
                    log.debug("\u4e3b\u5355\u5f00\u7968\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscAcceptOrderListQueryAtomReqBO));
                    fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
                    log.debug("\u4e3b\u5355\u5f00\u7968\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscAcceptOrderListQueryAtomRspBO));
                    if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
                        throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
                }
                for (FscOrderItemPO itemPO : addList) {
                    FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBoMap.get(itemPO.getAcceptOrderId());
                    List orderItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class);
                    for (FscOrderItemPO orderItemPO3 : orderItemPOS) {
                        if (!orderItemPO3.getOrderItemId().equals(itemPO.getOrderItemId())) continue;
                        if (Objects.nonNull(fscOrderInfoBO.getOrderType()) && PebExtConstant.OrderType.CX_AGR.equals(fscOrderInfoBO.getOrderType())) {
                            orderItemPO3.setSkuName(orderItemPO3.getSkuMaterialLongDesc());
                        }
                        orderItemPO3.setFscOrderId(itemPO.getFscOrderId());
                        FscOrderItemPO fscOrderItemReqBO = itemPO;
                        if (Objects.nonNull(fscOrderItemReqBO.getProductDescription()) || Objects.nonNull(fscOrderItemReqBO.getSpecificationsModel())) {
                            orderItemPO3.setProductDescription(fscOrderItemReqBO.getProductDescription());
                            orderItemPO3.setSpecificationsModel(fscOrderItemReqBO.getSpecificationsModel());
                        } else {
                            this.dealDescAndModel(orderItemPO3, reqBO);
                        }
                        if (fscOrderItemReqBO.getNum() != null && fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) > 0) {
                            orderItemPO3.setNum(fscOrderItemReqBO.getNum());
                            orderItemPO3.setAmt(fscOrderItemReqBO.getAmt());
                            orderItemPO3.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)orderItemPO3.getAmt(), (BigDecimal)orderItemPO3.getTaxRate()));
                            orderItemPO3.setUntaxAmt(orderItemPO3.getAmt().subtract(orderItemPO3.getTaxAmt()));
                            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                                BigDecimal untaxPrice = fscOrderItemPO.getPrice().divide(BigDecimal.ONE.add(fscOrderItemPO.getTaxRate()), 8, RoundingMode.HALF_UP).stripTrailingZeros();
                                fscOrderItemPO.setUntaxAmt(AmountUtils.getBigDecimalFormat((BigDecimal)untaxPrice).multiply(fscOrderItemPO.getNum()).setScale(2, RoundingMode.HALF_UP));
                                fscOrderItemPO.setTaxAmt(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getUntaxAmt()));
                                totalItemUntaxAmt[0] = totalItemUntaxAmt[0].add(fscOrderItemPO.getUntaxAmt());
                                BigDecimal untaxPriceTemp = fscOrderItemPO.getPrice().divide(BigDecimal.ONE.add(fscOrderItemPO.getTaxRate()), 13, RoundingMode.HALF_UP).stripTrailingZeros();
                                fscOrderItemPO.setUntaxAmtTemp(AmountUtils.getBigDecimalFormat((BigDecimal)untaxPriceTemp).multiply(fscOrderItemPO.getNum()).setScale(2, RoundingMode.HALF_UP));
                                fscOrderItemPO.setTaxAmtTemp(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getUntaxAmtTemp()));
                            }
                            orderItemPO3.setPurchaseAmt(fscOrderItemReqBO.getNum().multiply(orderItemPO3.getPurchasePrice()));
                            BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)orderItemPO3.getPurchaseAmt(), (BigDecimal)orderItemPO3.getTaxRate());
                            orderItemPO3.setPurchaseUntaxAmt(orderItemPO3.getPurchaseAmt().subtract(purchaseTaxAmt));
                            if (orderItemPO3.getSalesUnitRate() != null && orderItemPO3.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                                orderItemPO3.setSettlePrice(orderItemPO3.getPrice().divide(orderItemPO3.getSalesUnitRate(), 8, 4));
                                orderItemPO3.setSettleNum(orderItemPO3.getNum().multiply(orderItemPO3.getSalesUnitRate()));
                            }
                            if (fscOrderItemReqBO.getNum().multiply(orderItemPO3.getPrice()).setScale(2, 4).compareTo(fscOrderItemReqBO.getAmt()) != 0) {
                                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u660e\u7ec6\u884c\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
                            }
                            taxRate.add(orderItemPO3.getTaxRate());
                        }
                        itemAmtSum = itemAmtSum.add(orderItemPO3.getAmt());
                        insertPos.add(orderItemPO3);
                        log.debug("\u5224\u65ad\u89c4\u683c\u578b\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderItemPO3));
                    }
                }
            }
            log.debug("\u7ed3\u7b97\u91d1\u989d\uff1a" + reqBO.getTotalCharge() + "\u8ba1\u7b97\u91d1\u989d\uff1a" + itemAmtSum);
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && taxRate.size() != 1) {
                throw new FscBusinessException("193008", "\u672c\u6b21\u5f00\u7968\u660e\u7ec6\u4e2d\u5b58\u5728\u591a\u4e2a\u7a0e\u7387\u7684\u60c5\u51b5\uff0c\u8bf7\u6309\u5355\u4e00\u7a0e\u7387\u8fdb\u884c\u5f00\u7968\u7ed3\u7b97\u3002");
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && (divide = reqBO.getTotalCharge().divide(BigDecimal.ONE.add((BigDecimal)new ArrayList(taxRate).get(0)), 2, RoundingMode.HALF_UP)).subtract(totalItemUntaxAmt[0]).abs().compareTo(new BigDecimal("0.06")) > 0) {
                if (!CollectionUtils.isEmpty(insertPos)) {
                    insertPos.forEach(e -> {
                        e.setUntaxAmt(e.getUntaxAmtTemp());
                        e.setTaxAmt(e.getTaxAmtTemp());
                    });
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    updateList.forEach(e -> {
                        e.setUntaxAmt(e.getUntaxAmtTemp());
                        e.setTaxAmt(e.getTaxAmtTemp());
                    });
                }
            }
            if (!CollectionUtils.isEmpty(insertPos)) {
                insertPos.forEach(insertPo -> insertPo.setId(Long.valueOf(Sequence.getInstance().nextId())));
                this.fscOrderItemMapper.insertBatch(insertPos);
            }
            if (!CollectionUtils.isEmpty(updateList) && (count = this.fscOrderItemMapper.updateBatchByList(updateList)) < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(deleteList) && (count = this.fscOrderItemMapper.deleteItemListByIds(deleteList)) < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        ArrayList<FscCheckTempPO> fscCheckTempPOList = new ArrayList<FscCheckTempPO>();
        FscOrderItemPO itemPO = new FscOrderItemPO();
        itemPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(itemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            FscOrderPO thisFscOrderPO = this.fscOrderMapper.qryByFscOrderId(reqBO.getFscOrderId());
            for (FscOrderItemPO fsc : fscOrderItemPOList) {
                this.checkTemp(reqBO, fsc, fscCheckTempPOList, thisFscOrderPO);
            }
        }
        try {
            log.info("------------------\u6dfb\u52a0\u65e5\u5fd71\uff1a" + JSON.toJSON(fscCheckTempPOList));
            if (!CollectionUtils.isEmpty(fscCheckTempPOList)) {
                this.fscCheckTempMapper.insertBatch(fscCheckTempPOList);
            }
        }
        catch (Exception e3) {
            log.error("\u6821\u9a8c\u5f00\u7968\u540d\u79f0\u548c\u89c4\u683c\u578b\u53f7\u63d2\u5165\u6570\u636e\u5e93\u9519\u8bef\uff01");
            e3.printStackTrace();
        }
        if (!(reqBO.getOperType() != null && Integer.valueOf(0).equals(reqBO.getOperType()) || !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || CollectionUtils.isEmpty((Collection)fscOrderItemPOList) || (tempFscOrderId = this.checkTaxCodeEqualTax(fscOrderItemPOList)) == null)) {
            rspBO.setFscOrderIds(Arrays.asList(tempFscOrderId));
            return rspBO;
        }
        if (!CollectionUtils.isEmpty(reqBO.getAcceptOrderIds())) {
            int count;
            List fscOrderRelationPOS = this.fscOrderItemMapper.getSumAmtByAccpetOrderId(reqBO.getAcceptOrderIds(), reqBO.getFscOrderId());
            if (!reqBO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOS) {
                    fscOrderRelationPO.setAmount(fscOrderRelationPO.getSettleAmt());
                }
            }
            if ((count = this.fscOrderRelationMapper.updateBatchByList(fscOrderRelationPOS)) < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff01");
            }
            count = this.fscOrderRelationMapper.checkSettleAmt(reqBO.getFscOrderId());
            if (count > 0) {
                throw new FscBusinessException("190000", "\u63d0\u7968\u91d1\u989d\u5f02\u5e38\uff01");
            }
            count = this.fscOrderMapper.checkSettleAmt(reqBO.getFscOrderId());
            if (count > 0) {
                throw new FscBusinessException("190000", "\u63d0\u7968\u91d1\u989d\u5f02\u5e38\uff01");
            }
        }
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setAcceptOrderIds(acceptOrderIds);
        relationPO.setFscOrderId(reqBO.getFscOrderId());
        List listNoPage = this.fscOrderRelationMapper.getListNoPage(relationPO);
        Map<Long, Long> relationMap = listNoPage.stream().collect(Collectors.toMap(FscOrderRelationPO::getAcceptOrderId, FscOrderRelationPO::getId));
        this.fscOrderRelationMapper.updateQualityAmt(reqBO.getFscOrderId());
        if (!CollectionUtils.isEmpty(reqBO.getQualityList())) {
            for (FscOrderRelationPO orderRelationPO : qualityList) {
                if (relationMap.get(orderRelationPO.getAcceptOrderId()) == null) {
                    throw new FscBusinessException("198888", "\u83b7\u53d6\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
                }
                orderRelationPO.setId(relationMap.get(orderRelationPO.getAcceptOrderId()));
            }
            int count = this.fscOrderRelationMapper.updateQualityList(qualityList);
            if (count != qualityList.size()) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u7ed3\u7b97\u5355\u8d28\u4fdd\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscOrderPO order = new FscOrderPO();
        order.setFscOrderId(reqBO.getFscOrderId());
        order = this.fscOrderMapper.getModelBy(order);
        if (reqBO.getOperType() == 1) {
            if (FscConstants.FscInvoiceOrderState.DRAFT.equals(reqBO.getCurStatus())) {
                FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
                fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getFscOrderId());
                HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
                if (reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION)) {
                    if (reqBO.getIsprofess().equals("0")) {
                        paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_APPROVAL);
                    } else {
                        paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_NOT_CHECK);
                    }
                } else if (reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER)) {
                    this.dealSupplierStart(reqBO, order, paramMap);
                } else if (reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) {
                    paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.ELECTRONIC);
                }
                fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
                FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
                if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
                }
            } else if ("1".equals(reqBO.getIsprofess())) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
                this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            }
            if ("0".equals(reqBO.getIsprofess()) || reqBO.getStartFlowFlag().booleanValue()) {
                FscBillSendSaleFscOrderApplyAbilityReqBO abilityReqBO = (FscBillSendSaleFscOrderApplyAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscBillSendSaleFscOrderApplyAbilityReqBO.class);
                this.dealApproval(abilityReqBO, reqBO.getFscOrderId(), reqBO.getCurStatus(), order, rspBO);
                rspBO.setNoticeOrderIds(Collections.singletonList(reqBO.getFscOrderId()));
            }
        }
        this.fscOrderItemMapper.updateDefaultSettle(reqBO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Long checkTaxCodeEqualTax(List<FscOrderItemPO> fscOrderItemPOList) {
        long fscOrderId = Sequence.getInstance().nextId();
        ArrayList<Long> taxCodeList = new ArrayList<Long>();
        ArrayList<FscCheckTempPO> fscCheckTempPOList = new ArrayList<FscCheckTempPO>();
        List fscOrderItemBOS = JSONObject.parseArray((String)JSONObject.toJSONString(fscOrderItemPOList), FscOrderItemBO.class);
        for (FscOrderItemPO fscOrderItemBO : fscOrderItemPOList) {
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemBO.getTaxCode())) {
                taxCodeList.add(Long.valueOf(fscOrderItemBO.getTaxCode()));
                continue;
            }
            FscCheckTempPO fscCheckTempPO = new FscCheckTempPO();
            fscCheckTempPO.setType("2");
            fscCheckTempPO.setReason("\u4e0d\u5b58\u5728\u8be5\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff01");
            fscCheckTempPO.setObjId(Long.valueOf(fscOrderId));
            fscCheckTempPO.setOrderNo(fscOrderItemBO.getOrderCode());
            fscCheckTempPO.setSkuName(fscOrderItemBO.getSkuName());
            fscCheckTempPO.setCreateTime(new Date().toString());
            fscCheckTempPOList.add(fscCheckTempPO);
        }
        FscTaxCodePO taxCodePO = new FscTaxCodePO();
        taxCodePO.setTaxCodeList(taxCodeList);
        List fscTaxCodePOList = this.fscTaxCodeMapper.getList(taxCodePO);
        HashMap<Long, ArrayList<BigDecimal>> taxCodeAndTax = new HashMap<Long, ArrayList<BigDecimal>>();
        if (!CollectionUtils.isEmpty((Collection)fscTaxCodePOList)) {
            for (FscTaxCodePO fscTaxCodePO : fscTaxCodePOList) {
                ArrayList<BigDecimal> bigDecimals = (ArrayList<BigDecimal>)taxCodeAndTax.get(fscTaxCodePO.getTaxCode());
                if (CollectionUtils.isEmpty((Collection)bigDecimals)) {
                    bigDecimals = new ArrayList<BigDecimal>();
                }
                bigDecimals.add(fscTaxCodePO.getTax().stripTrailingZeros());
                taxCodeAndTax.put(fscTaxCodePO.getTaxCode(), bigDecimals);
            }
        }
        fscOrderItemBOS.forEach(e -> {
            FscCheckTempPO fscCheckTempPO = null;
            List sorTax = null;
            if (StringUtils.isNotBlank((CharSequence)e.getTaxCode())) {
                sorTax = (List)taxCodeAndTax.get(Long.valueOf(e.getTaxCode()));
                if (CollectionUtils.isEmpty((Collection)sorTax)) {
                    fscCheckTempPO = new FscCheckTempPO();
                    fscCheckTempPO.setType("2");
                    fscCheckTempPO.setReason("\u4e0d\u5b58\u5728\u8be5\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff01");
                } else if (!sorTax.contains(e.getTaxRate().multiply(new BigDecimal(100)).stripTrailingZeros())) {
                    fscCheckTempPO = new FscCheckTempPO();
                    fscCheckTempPO.setType("3");
                    fscCheckTempPO.setReason("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u548c\u7a0e\u7387\u4e0d\u5339\u914d\uff01");
                }
                if (fscCheckTempPO != null) {
                    fscCheckTempPO.setObjId(Long.valueOf(fscOrderId));
                    fscCheckTempPO.setOrderNo(e.getOrderCode());
                    fscCheckTempPO.setSkuName(e.getSkuName());
                    fscCheckTempPO.setTaxCode(Long.valueOf(e.getTaxCode()));
                    fscCheckTempPO.setTax(e.getTaxRate());
                    fscCheckTempPO.setCreateTime(new Date().toString());
                    fscCheckTempPOList.add(fscCheckTempPO);
                }
            }
        });
        if (!CollectionUtils.isEmpty(fscCheckTempPOList)) {
            this.fscCheckTempMapper.insertBatch(fscCheckTempPOList);
            return fscOrderId;
        }
        return null;
    }

    private void dealSupplierStart(FscBillOrderUpdateBusiReqBO reqBO, FscOrderPO orderPO, Map<String, Object> paramMap) {
        if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE) && orderPO.getSupplierId().equals(this.operationSupId)) {
            if (reqBO.getIsprofess().equals(FscConstants.FscOrderMakeType.OPERTION.toString())) {
                paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_APPROVAL);
                reqBO.setStartFlowFlag(true);
            } else {
                paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_NOT_CHECK);
            }
        } else {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_NOT_CHECK);
        }
    }

    private void checkTemp(FscBillOrderUpdateBusiReqBO reqBO, FscOrderItemPO fscOrderItemPO, List<FscCheckTempPO> list, FscOrderPO fscOrderPO) {
        if ("1".equals(reqBO.getIsprofess())) {
            FscCheckTempPO po;
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemPO.getProductDescription()) > 90) {
                po = new FscCheckTempPO();
                po.setObjNo(fscOrderPO.getOrderNo());
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(fscOrderItemPO.getOrderId() + "");
                po.setOrderNo(fscOrderItemPO.getOrderCode());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                list.add(po);
            }
            if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSpecificationsModel())) {
                po = new FscCheckTempPO();
                po.setObjNo(fscOrderPO.getOrderNo());
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(fscOrderItemPO.getOrderId() + "");
                po.setOrderNo(fscOrderItemPO.getOrderCode());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("1");
                po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                list.add(po);
            }
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemPO.getSpecificationsModel()) > 40) {
                po = new FscCheckTempPO();
                po.setObjNo(fscOrderPO.getOrderNo());
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(fscOrderItemPO.getOrderId() + "");
                po.setOrderNo(fscOrderItemPO.getOrderCode());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                list.add(po);
            }
            this.fscCheckTempMapper.deleteByObjId(reqBO.getFscOrderId());
        }
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long fscOrderId, Integer curStatus, FscOrderPO order, FscBillOrderUpdateBusiRspBO rspBO) {
        this.fscOrderMapper.deleteOrderSendTemp(fscOrderId);
        FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        fscSendTemp.setFscOrderId(fscOrderId);
        fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
        fscSendTemp.setYcDeptName(reqBO.getDeptName());
        fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
        fscSendTemp.setYcPersonName(reqBO.getPersonName());
        fscSendTemp.setBuynerNo(order.getBuynerNo());
        fscSendTemp.setBuynerName(order.getBuynerName());
        log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
        this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.invokeUacTask(reqBO, fscOrderId);
        if (!CollectionUtils.isEmpty((Collection)uacNoTaskAuditCreateRspBO.getApprovalInNotice())) {
            List approvalInNotice = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uacNoTaskAuditCreateRspBO.getApprovalInNotice()), FscUacApproveEntrustBO.class);
            FscNoTaskAuditOrderAuditNoticeBO noticeBO = new FscNoTaskAuditOrderAuditNoticeBO();
            noticeBO.setOrderId(fscOrderId);
            noticeBO.setApprovalInNotice(approvalInNotice);
            if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                rspBO.setAuditNoticeList(new ArrayList<FscNoTaskAuditOrderAuditNoticeBO>());
            }
            rspBO.getAuditNoticeList().add(noticeBO);
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(fscOrderId);
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setSignApplyTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                String orderTypeStr = order.getOrderType() == 2 && order.getTradeMode() != null && order.getTradeMode() == 2 && order.getOrderSource() == 3 && order.getSettlePlatform() != null && order.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(order.getOrderType() + "");
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(order.getOrderNo() + "" + "\u9500\u552e\u7ed3\u7b97_" + "_" + orderTypeStr + "_" + order.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9500\u552e\u7ed3\u7b97\u5355" + order.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
        fscOrderPO.setSendApplyTime(new Date());
        fscOrderPO.setSendUserId(reqBO.getUserId());
        fscOrderPO.setSendUserName(reqBO.getName());
        fscOrderPO.setOperatorId(reqBO.getUserId());
        fscOrderPO.setOperatorName(reqBO.getName());
        String operationNo = String.valueOf(reqBO.getOrgId());
        String[] org = this.proOrg.split(",");
        String[] pur = reqBO.getOrgPath().split("-");
        block0: for (String pro : org) {
            for (String t : pur) {
                if (!pro.equals(t)) continue;
                operationNo = pro;
                continue block0;
            }
        }
        fscOrderPO.setOperationNo(operationNo);
        this.fscOrderMapper.updateById(fscOrderPO);
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN) && !FscConstants.FscInvoiceOrderState.DRAFT.equals(curStatus)) {
            this.dealWorkFlow(order);
        }
    }

    private UacNoTaskAuditCreateRspBO invokeUacTask(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long l) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setOrgTreeId(reqBO.getOrgPath());
        auditCreateReqBO.setMenuId("M001007");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(l);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(l.toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
        try {
            this.taskTodoWaitService.syncNotifyAccountWaitDone(l);
        }
        catch (Exception e) {
            log.error("dealUpdate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
        return uacNoTaskAuditCreateRspBO;
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    public void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscBillOrderUpdateBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode(), reqBO.getOrderSource()));
            } else if (FscInvoiceValueTypeEnum.ELECTRONIC.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId, String orderSource) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) ? spec : (!org.springframework.util.StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!"2".equals(orderSource) && !org.springframework.util.StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }
}

