/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscContractPlanItemBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.bo.FscPayRefundShouldBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRefundPayRelationPo;
import com.tydic.fsc.po.FscPayClaimRefundDetailPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillPayRefundCreateBusiServiceImpl
implements FscBillPayRefundCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u4fee\u6539";
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Value(value="${fsc.main.pro.org:1000000087,1000000089}")
    private String proOrg;
    @Value(value="${OPER_ORG_ID:436}")
    private String operationOrgId;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @Override
    public FscBillPayRefundCreateBusiRspBO dealPayRefundCreate(FscBillPayRefundCreateBusiReqBO reqBO) {
        ArrayList<FscPayClaimRefundPO> fscPayClaimRefundList;
        this.checkRefundNo(reqBO.getRefundNo());
        FscOrderRefundPO refundPO = this.buildRefundPayInfo(reqBO);
        ArrayList<FscPayShouldRefundPO> fscPayShouldRefundList = new ArrayList<FscPayShouldRefundPO>();
        List<FscPayRefundDetailPO> fscPayRefundDetailList = this.assembleRefundDetail(refundPO, reqBO, fscPayShouldRefundList);
        if (reqBO.getTradeMode() == 1) {
            if ("0".equals(reqBO.getIsprofess())) {
                refundPO.setRefundStatus(FscConstants.RefundPayOrderState.REFUNDING);
                refundPO.setExt1(reqBO.getAgentAccount());
                this.buildOperation(reqBO, refundPO);
                refundPO.setOperatorId(reqBO.getUserId());
                refundPO.setOperatorName(reqBO.getName());
            } else {
                refundPO.setRefundStatus(FscConstants.RefundPayOrderState.TO_COMFIR);
            }
        } else if (reqBO.getTradeMode() == 2) {
            if (this.operationSupId.equals(reqBO.getPayeeId().toString())) {
                refundPO.setRefundStatus(FscConstants.RefundPayOrderState.TO_COMFIR);
                refundPO.setExt1(reqBO.getAgentAccount());
                this.buildOperation(reqBO, refundPO);
                refundPO.setOperatorId(reqBO.getUserId());
                refundPO.setOperatorName(reqBO.getName());
            } else if (reqBO.getOperationType() != null && reqBO.getOperationType() == 1) {
                refundPO.setRefundStatus(FscConstants.RefundPayOrderState.REFUNDING);
            } else {
                refundPO.setRefundStatus(FscConstants.RefundPayOrderState.DRAFT);
            }
        }
        if (FscConstants.RefundUserType.OPERATION.equals(reqBO.getUserType()) || FscConstants.FscTradeMode.TRADE_MODEL.equals(reqBO.getTradeMode())) {
            refundPO.setIsPushUnify(FscConstants.IsPushUnify.UN_PUSH);
        }
        this.fscOrderRefundMapper.insert(refundPO);
        int count = this.fscPayRefundDetailMapper.insertBatch(fscPayRefundDetailList);
        if (count != fscPayRefundDetailList.size()) {
            throw new FscBusinessException("190000", "\u6dfb\u52a0\u9000\u6b3e\u660e\u7ec6\u5931\u8d25");
        }
        count = this.fscPayShouldRefundMapper.updatePayingAmountBatch(fscPayShouldRefundList);
        if (count != fscPayShouldRefundList.size()) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u4ed8\u5355\u4fe1\u606f\u5931\u8d25");
        }
        if (FscConstants.RefundUserType.PURCHASE.equals(reqBO.getUserType()) && FscConstants.FscTradeMode.TRADE_MODEL.equals(reqBO.getTradeMode()) || FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(reqBO.getTradeMode()) && this.operationSupId.equals(reqBO.getPayeeId().toString())) {
            fscPayClaimRefundList = JSON.parseArray((String)JSONObject.toJSONString(reqBO.getFscPayClaimRefundBOS()), FscPayClaimRefundPO.class);
            ArrayList<FscOrderRefundPayRelationPo> payRelationList = new ArrayList<FscOrderRefundPayRelationPo>();
            if (!CollectionUtils.isEmpty(fscPayClaimRefundList)) {
                ArrayList<FscPayClaimRefundDetailPO> fscPayClaimRefundDetailPOS = new ArrayList<FscPayClaimRefundDetailPO>();
                for (FscPayClaimRefundPO fscPayClaimRefundPO : fscPayClaimRefundList) {
                    fscPayClaimRefundPO.setRefundId(refundPO.getRefundId());
                    fscPayClaimRefundPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    FscOrderRefundPayRelationPo payRelationPo = new FscOrderRefundPayRelationPo();
                    payRelationPo.setId(fscPayClaimRefundPO.getPayRelationId());
                    payRelationPo.setRefundAmt(fscPayClaimRefundPO.getRefundAmt());
                    payRelationList.add(payRelationPo);
                    BigDecimal refundAmt = fscPayClaimRefundPO.getRefundAmt();
                    for (FscClaimDetailPO fscClaimDetailPO : fscPayClaimRefundPO.getClaimDetailList()) {
                        FscPayClaimRefundDetailPO fscPayClaimRefundDetailPO = new FscPayClaimRefundDetailPO();
                        fscPayClaimRefundDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscPayClaimRefundDetailPO.setClaimRefundId(fscPayClaimRefundPO.getId());
                        fscPayClaimRefundDetailPO.setClaimDetailId(fscClaimDetailPO.getClaimDetailId());
                        fscPayClaimRefundDetailPO.setRefundId(refundPO.getRefundId());
                        fscPayClaimRefundDetailPO.setClaimAmt(fscClaimDetailPO.getClaimAmt());
                        if (refundAmt.compareTo(new BigDecimal(0)) > 0) {
                            BigDecimal claimRefundAmt = fscClaimDetailPO.getRefundAmt();
                            if (refundAmt.compareTo(claimRefundAmt) > 0) {
                                fscPayClaimRefundDetailPO.setRefundAmt(claimRefundAmt);
                                refundAmt = refundAmt.subtract(claimRefundAmt);
                            } else {
                                fscPayClaimRefundDetailPO.setRefundAmt(refundAmt);
                                refundAmt = BigDecimal.ZERO;
                            }
                        } else {
                            fscPayClaimRefundDetailPO.setRefundAmt(BigDecimal.ZERO);
                        }
                        fscPayClaimRefundDetailPOS.add(fscPayClaimRefundDetailPO);
                    }
                }
                count = this.fscPayClaimRefundMapper.insertBatch(fscPayClaimRefundList);
                if (count != fscPayClaimRefundList.size()) {
                    throw new FscBusinessException("190000", "\u5173\u8054\u8ba4\u9886\u4fe1\u606f\u5931\u8d25");
                }
                count = this.fscPayClaimRefundDetailMapper.insertBatch(fscPayClaimRefundDetailPOS);
                if (count != fscPayClaimRefundDetailPOS.size()) {
                    throw new FscBusinessException("190000", "\u5173\u8054\u8ba4\u9886\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
                }
                if (FscConstants.RefundType.REFUND_INVOICE.equals(refundPO.getRefundReasonType())) {
                    Long againstId = this.fscOrderRefundMapper.queryRefundIdByRefundId(refundPO.getRefundId());
                    FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
                    fscClaimDetailPO.setRefundId(refundPO.getRefundId());
                    fscClaimDetailPO.setAgainstId(againstId);
                    count = this.fscClaimDetailMapper.updateRefundAmtByRefundIdChange(fscClaimDetailPO);
                } else {
                    count = this.fscClaimDetailMapper.updateRefundAmtByRefundId(refundPO.getRefundId());
                }
                if (count <= 0) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u6536\u6b3e\u8ba4\u9886\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
                }
            }
            if (!CollectionUtils.isEmpty(payRelationList) && (count = this.fscOrderRefundPayRelationMapper.updateRefundAmountBatch(payRelationList)) != fscPayClaimRefundList.size()) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
            }
            if (FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus())) {
                this.dealStartApproval(reqBO, refundPO);
                this.occupyFundsPlan(reqBO);
            }
        } else if (FscConstants.RefundUserType.OPERATION.equals(reqBO.getUserType()) || FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(reqBO.getTradeMode())) {
            fscPayClaimRefundList = new ArrayList<FscPayClaimRefundPO>();
            FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = new FscOrderRefundPayRelationPo();
            fscOrderRefundPayRelationPo.setRefundShouldPayId(reqBO.getFscRefundShouldPayBOS().get(0).getRefundShouldPayId());
            List relationList = this.fscOrderRefundPayRelationMapper.getList(fscOrderRefundPayRelationPo);
            if (CollectionUtils.isEmpty((Collection)relationList)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u9000\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            }
            BigDecimal refundAmt = reqBO.getRefundAmount();
            for (FscOrderRefundPayRelationPo po : relationList) {
                FscPayClaimRefundPO fscPayClaimRefundPO = new FscPayClaimRefundPO();
                fscPayClaimRefundPO.setRefundId(refundPO.getRefundId());
                fscPayClaimRefundPO.setOrderId(po.getOrderId());
                fscPayClaimRefundPO.setOrderCode(po.getOrderNo());
                fscPayClaimRefundPO.setPayRelationId(po.getId());
                BigDecimal refundAmount = po.getRefundAmount().subtract(po.getPayingAmount()).subtract(po.getRefundedAmount());
                if (refundAmount.compareTo(refundAmt) >= 0) {
                    fscPayClaimRefundPO.setRefundAmt(refundAmt);
                    fscPayClaimRefundList.add(fscPayClaimRefundPO);
                    break;
                }
                fscPayClaimRefundPO.setRefundAmt(refundAmount);
                refundAmt = refundAmt.subtract(refundAmount);
                fscPayClaimRefundList.add(fscPayClaimRefundPO);
            }
            if ((count = this.fscPayClaimRefundMapper.insertBatch(fscPayClaimRefundList)) != fscPayClaimRefundList.size()) {
                throw new FscBusinessException("190000", "\u5173\u8054\u8ba4\u9886\u4fe1\u606f\u5931\u8d25");
            }
            ArrayList<FscOrderRefundPayRelationPo> payRelationList = new ArrayList<FscOrderRefundPayRelationPo>();
            for (FscPayClaimRefundPO po : fscPayClaimRefundList) {
                FscOrderRefundPayRelationPo payRelationPo = new FscOrderRefundPayRelationPo();
                payRelationPo.setId(po.getPayRelationId());
                payRelationPo.setRefundAmt(po.getRefundAmt());
                payRelationList.add(payRelationPo);
            }
            count = this.fscOrderRefundPayRelationMapper.updateRefundAmountBatch(payRelationList);
            if (count != fscPayClaimRefundList.size()) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
            }
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(refundPO.getRefundId());
        fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
        this.fscAttachmentMapper.deleteBy(fscAttachmentPO);
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setFscOrderId(refundPO.getRefundId());
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentPO.setCreateTime(new Date());
                attachmentPO.setCreateUser(reqBO.getName());
                attachmentPO.setFormatType(attachmentBO.getFormatType());
                attachmentPO.setFileSize(attachmentBO.getFileSize());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId())) {
            this.saveFinanceInfo(reqBO, refundPO, fscPayRefundDetailList.get(0));
        }
        if (reqBO.getOperationType() != null && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
            this.dealWorkFlow(refundPO);
        }
        FscBillPayRefundCreateBusiRspBO rspBO = new FscBillPayRefundCreateBusiRspBO();
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkRefundNo(String refundNo) {
        int count = this.fscOrderRefundMapper.checkRefundNo(refundNo);
        if (count > 0) {
            throw new FscBusinessException("190000", "\u9000\u7968\u5355\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
        }
    }

    private void saveFinanceInfo(FscBillPayRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO, FscPayRefundDetailPO refundDetailPO) {
        FscRefundFinancePO financePO = new FscRefundFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setRefundId(refundPO.getRefundId());
        financePO.setCreateTime(new Date());
        financePO.setCreateUserId(reqBO.getUserId());
        financePO.setCreateUserName(reqBO.getName());
        financePO.setCreateUserAccount(reqBO.getUserName());
        int count = this.fscRefundFinanceMapper.insert(financePO);
        if (count != 1) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<FscFinanceRefundItemPO> refundItemList = new ArrayList<FscFinanceRefundItemPO>(reqBO.getFinanceItemList().size());
        if (!CollectionUtils.isEmpty(reqBO.getFinanceItemList())) {
            HashMap<Long, FscFinancePayItemPO> itemMap = new HashMap<Long, FscFinancePayItemPO>();
            for (FscFinanceRefundItemBO itemBO : reqBO.getFinanceItemList()) {
                FscFinanceRefundItemPO itemPO = new FscFinanceRefundItemPO();
                BeanUtils.copyProperties((Object)itemBO, (Object)itemPO);
                itemPO.setRefundId(refundPO.getRefundId());
                itemPO.setFinanceRefundItemId(Long.valueOf(Sequence.getInstance().nextId()));
                itemPO.setRefundShouldPayId(refundDetailPO.getRefundShouldPayId());
                itemPO.setRefundDetailId(refundDetailPO.getRefundDetailId());
                itemPO.setPayOrderId(itemBO.getFscOrderId());
                refundItemList.add(itemPO);
                FscFinancePayItemPO payItemPO = (FscFinancePayItemPO)itemMap.get(itemBO.getPayItemId());
                if (payItemPO == null) {
                    payItemPO = new FscFinancePayItemPO();
                    payItemPO.setFinancePayItemId(itemBO.getPayItemId());
                    payItemPO.setRefundAmt(itemBO.getRefundAmt());
                    payItemPO.setRefundAmtLocal(itemBO.getRefundAmtLocal());
                } else {
                    payItemPO.setRefundAmt(payItemPO.getRefundAmt().add(itemBO.getRefundAmt()));
                    payItemPO.setRefundAmtLocal(payItemPO.getRefundAmtLocal().add(itemBO.getRefundAmtLocal()));
                }
                itemMap.put(itemBO.getPayItemId(), payItemPO);
            }
            ArrayList<FscFinancePayItemPO> updateItemList = new ArrayList<FscFinancePayItemPO>();
            for (Long key : itemMap.keySet()) {
                updateItemList.add((FscFinancePayItemPO)itemMap.get(key));
            }
            count = this.fscFinancePayItemMapper.updateRefundingAmtBatch(updateItemList);
            if (count != updateItemList.size()) {
                throw new FscBusinessException("190000", "\u5360\u7528\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
            }
            count = this.fscFinanceRefundItemMapper.insertBatch(refundItemList);
            if (count != refundItemList.size()) {
                throw new FscBusinessException("190000", "\u5b58\u50a8\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!");
            }
        }
    }

    private void dealStartApproval(FscBillPayRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setOrgTreeId(reqBO.getOrgPath());
        auditCreateReqBO.setMenuId("M001011");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_PAY);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u9000\u6b3e\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_PAY);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u9000\u6b3e\u5355\u5ba1\u6279\u6d41\uff01");
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(refundPO.getRefundId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel("\u4ed8\u6b3e\u7533\u8bf7\u5355_");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + refundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscOrderRefundMapper.updateById(updatePo);
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus())) {
            paramMap.put("startFlag", 1);
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private FscOrderRefundPO buildRefundPayInfo(FscBillPayRefundCreateBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundNo(reqBO.getRefundNo());
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setAgentUserId(reqBO.getAgentUserId());
        refundPO.setAgentUserName(reqBO.getAgentUserName());
        refundPO.setAuditStatus(FscConstants.AuditStatus.SAVE);
        refundPO.setRefundDate(reqBO.getRefundDate());
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setRefundAmount(reqBO.getRefundAmount());
        refundPO.setCreateTime(new Date());
        refundPO.setCreateUserId(reqBO.getUserId());
        refundPO.setCreateUserName(reqBO.getName());
        refundPO.setPushStatus(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setBillStatus(FscConstants.RefundBillStatus.EFFECTIVE);
        if (reqBO.getEngineeringFlag() != null && reqBO.getEngineeringFlag() == 1) {
            refundPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_SERVICE_REFUND);
            refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.ENGINEERING_REFUND_PAY.getDescr());
        } else {
            refundPO.setOrderFlow(FscConstants.OrderFlow.REFUND_PAY);
            refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.REFUND_PAY.getDescr());
        }
        refundPO.setAccountBranch(reqBO.getAccountBranch());
        refundPO.setBankAccount(reqBO.getBankAccount());
        refundPO.setCustomerName(reqBO.getCustomerName());
        refundPO.setUserType(reqBO.getUserType());
        Long refundId = reqBO.getRefundId();
        if (refundId == null) {
            refundId = Sequence.getInstance().nextId();
            refundPO.setRefundId(refundId);
        }
        reqBO.setRefundId(refundId);
        return refundPO;
    }

    private List<FscPayRefundDetailPO> assembleRefundDetail(FscOrderRefundPO refundPO, FscBillPayRefundCreateBusiReqBO reqBO, List<FscPayShouldRefundPO> fscPayShouldRefundList) {
        ArrayList<FscPayRefundDetailPO> fscPayRefundDetailList = new ArrayList<FscPayRefundDetailPO>();
        List<FscPayRefundShouldBO> fscRefundShouldPayBOS = reqBO.getFscRefundShouldPayBOS();
        List refundShouldPayIdList = fscRefundShouldPayBOS.stream().map(FscPayRefundShouldBO::getRefundShouldPayId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(refundShouldPayIdList)) {
            throw new FscBusinessException("190000", "\u5e94\u9000\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List shouldRefundList = this.fscPayShouldRefundMapper.queryByIds(refundShouldPayIdList);
        if (CollectionUtils.isEmpty((Collection)shouldRefundList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u9000\u5355\u4e3a\u7a7a");
        }
        Map shouldRefundMap = shouldRefundList.stream().collect(Collectors.toMap(FscPayShouldRefundPO::getRefundShouldPayId, Function.identity()));
        for (FscPayRefundShouldBO fscPayRefundShouldBO : reqBO.getFscRefundShouldPayBOS()) {
            FscPayShouldRefundPO fscPayShouldRefundPO = (FscPayShouldRefundPO)shouldRefundMap.get(fscPayRefundShouldBO.getRefundShouldPayId());
            BigDecimal toPayAmt = fscPayShouldRefundPO.getRefundAmount().subtract(fscPayShouldRefundPO.getPayingAmount()).subtract(fscPayShouldRefundPO.getPaidAmount());
            if (toPayAmt.compareTo(fscPayRefundShouldBO.getRefundAmt()) < 0) {
                throw new FscBusinessException("190000", "\u60a8\u7684\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u60a8\u7684\u53ef\u9000\u6b3e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\u3002");
            }
            FscPayRefundDetailPO fscPayRefundDetailPO = new FscPayRefundDetailPO();
            fscPayRefundDetailPO.setRefundDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayRefundDetailPO.setRefundId(refundPO.getRefundId());
            fscPayRefundDetailPO.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
            fscPayRefundDetailPO.setOrderCode(fscPayShouldRefundPO.getOrderCode());
            fscPayRefundDetailPO.setOrderId(fscPayShouldRefundPO.getOrderId());
            fscPayRefundDetailPO.setFscOrderId(fscPayShouldRefundPO.getFscOrderId());
            fscPayRefundDetailPO.setFscOrderNo(fscPayShouldRefundPO.getFscOrderNo());
            fscPayRefundDetailPO.setPaidAmt(fscPayShouldRefundPO.getTotalPaidAmount());
            fscPayRefundDetailPO.setBuynerNo(fscPayShouldRefundPO.getBuynerNo());
            fscPayRefundDetailPO.setBuynerName(fscPayShouldRefundPO.getBuynerName());
            fscPayRefundDetailPO.setOperatorId(fscPayShouldRefundPO.getOperatorId());
            fscPayRefundDetailPO.setOperatorName(fscPayShouldRefundPO.getOperatorName());
            fscPayRefundDetailPO.setOperatorDeptId(fscPayShouldRefundPO.getOperatorDeptId());
            fscPayRefundDetailPO.setOperatorDeptName(fscPayShouldRefundPO.getOperatorDeptName());
            fscPayRefundDetailPO.setCreateTime(new Date());
            fscPayRefundDetailPO.setCreateUserId(reqBO.getUserId());
            fscPayRefundDetailPO.setCreateUserName(reqBO.getName());
            fscPayRefundDetailPO.setRefundAmt(fscPayRefundShouldBO.getRefundAmt());
            if (!StringUtils.isEmpty((Object)fscPayRefundShouldBO.getClaimType())) {
                fscPayRefundDetailPO.setClaimType(fscPayRefundShouldBO.getClaimType());
            }
            fscPayRefundDetailPO.setClaimAmt(fscPayRefundShouldBO.getClaimAmt());
            if (fscPayRefundDetailPO.getClaimAmt() == null) {
                fscPayRefundDetailPO.setClaimAmt(BigDecimal.ZERO);
            }
            fscPayRefundDetailPO.setNotRefundAmt(fscPayRefundShouldBO.getNotRefundAmt());
            fscPayRefundDetailList.add(fscPayRefundDetailPO);
            fscPayShouldRefundPO.setPayingAmount(fscPayRefundShouldBO.getRefundAmt());
            fscPayShouldRefundList.add(fscPayShouldRefundPO);
            reqBO.setTradeMode(fscPayShouldRefundPO.getTradeMode());
            reqBO.setPayeeId(fscPayShouldRefundPO.getPayeeId());
            refundPO.setTradeMode(fscPayShouldRefundPO.getTradeMode());
            FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
            fscOrderExtPO.setFscOrderId(fscPayShouldRefundPO.getPayOrderId());
            fscOrderExtPO.setUnifyPushStatus(FscConstants.FscPushStatus.SUCCESS);
            List extPOList = this.fscOrderExtMapper.getList(fscOrderExtPO);
            if (!CollectionUtils.isEmpty((Collection)extPOList)) {
                refundPO.setIsPushUnify(FscConstants.IsPushUnify.PUSH);
            } else {
                refundPO.setIsPushUnify(FscConstants.IsPushUnify.UN_PUSH);
            }
            refundPO.setBuildAction(fscPayShouldRefundPO.getGenerateType());
        }
        FscPayShouldRefundPO fscPayShouldRefundPO = (FscPayShouldRefundPO)shouldRefundList.get(0);
        refundPO.setPayerId(fscPayShouldRefundPO.getPayerId());
        refundPO.setPayerName(fscPayShouldRefundPO.getPayerName());
        refundPO.setPayeeId(fscPayShouldRefundPO.getPayeeId());
        refundPO.setPayeeName(fscPayShouldRefundPO.getPayeeName());
        refundPO.setSupplierId(fscPayShouldRefundPO.getSupplierId());
        refundPO.setSupplierName(fscPayShouldRefundPO.getSupplierName());
        refundPO.setOrderType(fscPayShouldRefundPO.getOrderType());
        refundPO.setOrderSource(fscPayShouldRefundPO.getOrderSource());
        refundPO.setBuynerNo(fscPayShouldRefundPO.getBuynerNo());
        refundPO.setBuynerName(fscPayShouldRefundPO.getBuynerName());
        refundPO.setSettlePlatform(((FscPayShouldRefundPO)shouldRefundList.get(0)).getSettlePlatform());
        reqBO.setPayeeName(refundPO.getPayeeName());
        return fscPayRefundDetailList;
    }

    private void buildOperation(FscBillPayRefundCreateBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        String[] proOrgList;
        Long operationId = null;
        for (String orgId : proOrgList = this.proOrg.split(",")) {
            if (!reqBO.getOrgPath().contains(orgId)) continue;
            operationId = Long.valueOf(orgId);
            break;
        }
        fscOrderRefundPO.setOperationId(operationId);
        if (operationId != null) {
            Map orgMap;
            UmcDycEnterpriseOrgBO umcDycEnterpriseOrgBO;
            UmcEnterpriseOrgNameListQryAbilityReqBO quryOrgNameReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            List<Object> orgIds = Collections.singletonList(operationId);
            quryOrgNameReqBO.setOrgIdList(orgIds);
            UmcEnterpriseOrgNameListQryAbilityRspBO quryOrgNameRspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(quryOrgNameReqBO);
            if (quryOrgNameRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)quryOrgNameRspBO.getOrgMap()) && (umcDycEnterpriseOrgBO = (UmcDycEnterpriseOrgBO)(orgMap = quryOrgNameRspBO.getOrgMap()).get(operationId)) != null) {
                fscOrderRefundPO.setOperationName(umcDycEnterpriseOrgBO.getOrgName());
            }
        }
    }

    private void occupyFundsPlan(FscBillPayRefundCreateBusiReqBO reqBO) {
        ArrayList<FscPlanPayItemPo> insertList = new ArrayList<FscPlanPayItemPo>();
        for (FscContractPlanItemBO planItemBO : reqBO.getPlanItemBOs()) {
            FscPlanPayItemPo fscPlanPayItemPo = new FscPlanPayItemPo();
            fscPlanPayItemPo.setFscOrderId(reqBO.getRefundId());
            fscPlanPayItemPo.setShouldPayId(reqBO.getFscRefundShouldPayBOS().get(0).getRefundShouldPayId());
            fscPlanPayItemPo.setContractCapitalPlanId(planItemBO.getContractCapitalPlanId());
            fscPlanPayItemPo.setContractNum(planItemBO.getContractNum());
            fscPlanPayItemPo.setOccAmount(planItemBO.getOccAmount());
            fscPlanPayItemPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPlanPayItemPo.setType(Integer.valueOf(2));
            insertList.add(fscPlanPayItemPo);
        }
        int i = this.fscPlanPayItemMapper.insertBatch(insertList);
        if (i < 1) {
            throw new BusinessException("8888", "\u63d2\u5165\u8d44\u91d1\u8ba1\u5212\u5173\u8054\u8868\u5931\u8d25");
        }
        List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(reqBO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        FscBillDealPushLogAbilityReqBO logReqBO = new FscBillDealPushLogAbilityReqBO();
        logReqBO.setPushStatus(Integer.valueOf(0));
        logReqBO.setObjectId(reqBO.getRefundId());
        logReqBO.setCreateTime(new Date());
        logReqBO.setType(FscConstants.FscPushType.FSC_NEW_OCCUPY_PLAN);
        try {
            QryUnifySettleTokenAbilityReqBO qryUnifySettleTokenReqBO = new QryUnifySettleTokenAbilityReqBO();
            qryUnifySettleTokenReqBO.setUserId(reqBO.getAgentAccount());
            QryUnifySettleTokenAbilityRspBO qryUnifySettleTokenAbilityRspBO = this.fscUnifySettleTokenAbilityService.qryToken(qryUnifySettleTokenReqBO);
            if (!qryUnifySettleTokenAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(qryUnifySettleTokenAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + qryUnifySettleTokenAbilityRspBO.getMsg());
            }
            logReqBO.setObjectNo(reqBO.getRefundNo());
            FscUnifySettleFundingPlanReqBO planReqBO = new FscUnifySettleFundingPlanReqBO();
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (FscOperateCapitalPlanPO x : list) {
                JSONObject bo = new JSONObject();
                bo.put("period", (Object)x.getPeriod());
                bo.put("itemId", (Object)x.getItemId());
                bo.put("itemName", (Object)x.getItemName());
                bo.put("controlMode", (Object)x.getControlMode());
                bo.put("exeType", (Object)"ZY");
                bo.put("planAmount", (Object)x.getPlanAmount());
                bo.put("amount", (Object)x.getUseAmount());
                bo.put("fromSource", (Object)"EBAY");
                bo.put("contractNum", (Object)x.getContractNum());
                if ("BILL".equals(x.getControlMode())) {
                    bo.put("billId", (Object)reqBO.getRefundId());
                    bo.put("billNum", (Object)reqBO.getRefundNo());
                }
                bo.put("recOrgName", (Object)reqBO.getPayeeName());
                bo.put("fromBillId", (Object)(reqBO.getRefundId() + ""));
                bo.put("fromBillLineId", (Object)x.getId());
                bo.put("deptId", (Object)x.getDeptId());
                bo.put("deptName", (Object)x.getDeptName());
                bo.put("orgId", (Object)(x.getOrgId() != null ? x.getOrgId() : this.operationOrgId));
                bo.put("billType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "HTJS"));
                bo.put("fromBillType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "FK"));
                jsonArray.add((Object)bo);
            }
            jsonObject.put("head", (Object)jsonArray);
            JSONArray jsonArray1 = new JSONArray();
            jsonArray1.add((Object)jsonObject);
            logReqBO.setPushData(jsonArray1.toJSONString());
            logReqBO.setObjData(jsonArray1.toJSONString());
            planReqBO.setJsonObject(jsonArray1);
            planReqBO.setToken(qryUnifySettleTokenAbilityRspBO.getData());
            FscUnifySettleFundingPlanRspBO fundingPlanRspBO = this.fscUnifySettleRelatedInterfacesAtomService.occupyFundsEabyUpdateState(planReqBO);
            logReqBO.setPushParseData(fundingPlanRspBO.getPushParseData());
            logReqBO.setRespData(fundingPlanRspBO.getRespData());
            logReqBO.setRespParseData(fundingPlanRspBO.getRespParseData());
            if (!"0000".equals(fundingPlanRspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u5360\u7528/\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u5931\u8d25\uff1a" + fundingPlanRspBO.getRespData());
            }
            logReqBO.setPushStatus(Integer.valueOf(1));
        }
        catch (Exception e) {
            this.fscBillAddPushLogAbilityService.savePushLog(logReqBO);
            throw new FscBusinessException("190000", e.getMessage());
        }
        this.fscBillAddPushLogAbilityService.savePushLog(logReqBO);
    }
}

