/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillSyncTongYiStatusBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSyncTongYiStatusBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSyncTongYiStatusBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSettleRefundShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillSyncTongYiStatusBusiServiceImpl
implements FscBillSyncTongYiStatusBusiService {
    private static final Logger log = LogManager.getLogger(FscBillSyncTongYiStatusBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscSettleRefundShouldPayCreateAtomService fscSettleRefundShouldPayCreateAtomService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;

    @Override
    public FscBillSyncTongYiStatusBusiRspBO dealSyncTongYiStatus(FscBillSyncTongYiStatusBusiReqBO reqBO) {
        FscBillSyncTongYiStatusBusiRspBO rspBO = new FscBillSyncTongYiStatusBusiRspBO();
        if (reqBO.getOrderType() != null && reqBO.getOrderType() == 2) {
            this.dealRefundStatus(reqBO);
        } else {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            fscOrderPO.setOrderNo(reqBO.getOrderNo());
            FscOrderPO orderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (orderPO == null) {
                return this.dealChargeInfo(reqBO);
            }
            if (FscConstants.OrderFlow.INVOICE.equals(orderPO.getOrderFlow()) && FscConstants.SettlePlatform.YES.equals(orderPO.getSettlePlatform())) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setOrderId(orderPO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(orderPO.getOrderState());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                if (FscConstants.FscInvoiceOrderState.TY_RECALL.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
                } else if (FscConstants.FscInvoiceOrderState.TY_BUSI_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
                } else if (FscConstants.FscInvoiceOrderState.TY_BUSI_AUDIT_PASS.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                } else if (FscConstants.FscInvoiceOrderState.TY_FINA_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
                } else if (FscConstants.FscInvoiceOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                }
                if (!CollectionUtils.isEmpty(paramMap)) {
                    fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                }
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u7ed3\u7b97\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u7ed3\u7b97\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
                if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
                if (!reqBO.getOrderStatus().equals(fscOrderStatusFlowAtomRspBO.getNewStatus().toString())) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u72b6\u6001\u4e0e\u6d41\u7a0b\u72b6\u6001\u4e0d\u5bf9\u5e94");
                }
                if (FscConstants.FscInvoiceOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                    FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(reqBO.getOrderId());
                    if (signTemp == null) {
                        throw new FscBusinessException("193011", "\u53d1\u7968\u7b7e\u6536\u7533\u8bf7\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                    }
                    FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO = new FscBillOrderInvoiceSignBusiReqBO();
                    this.dealOrderCheck(fscBillOrderInvoiceSignBusiReqBO, orderPO);
                    if (fscBillOrderInvoiceSignBusiReqBO.getCreateShouldPayFlag().booleanValue()) {
                        this.createShouldPay(fscBillOrderInvoiceSignBusiReqBO.getFscShouldPayBOS(), signTemp, orderPO);
                    }
                    this.syncOrderStatus(reqBO.getOrderId());
                }
            } else if (FscConstants.OrderFlow.INVOICE.equals(orderPO.getOrderFlow()) && FscConstants.SettlePlatform.YES_Y.equals(orderPO.getSettlePlatform())) {
                FscOrderPO fsc = new FscOrderPO();
                fsc.setFscOrderId(orderPO.getFscOrderId());
                fsc.setPostingStatus("1");
                fsc.setPostingDate(reqBO.getPostingDate() == null ? new Date() : reqBO.getPostingDate());
                fsc.setUpdateTime(new Date());
                fsc.setUpdateTimeEnd(new Date());
                fsc.setPostingDate(new Date());
                this.fscOrderMapper.updateById(fsc);
            } else if (FscConstants.OrderFlow.PAY.equals(orderPO.getOrderFlow()) && FscConstants.SettlePlatform.YES.equals(orderPO.getSettlePlatform())) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setOrderId(orderPO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(orderPO.getOrderState());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                if (FscConstants.FscPayOrderState.TY_RECALL.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
                } else if (FscConstants.FscPayOrderState.TY_BUSI_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
                } else if (FscConstants.FscPayOrderState.TY_BUSI_AUDIT_PASS.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                } else if (FscConstants.FscPayOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                } else if (FscConstants.FscPayOrderState.TY_PAIED.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("payResult", FscConstants.TyPayFlowPayResult.PASS);
                } else if (FscConstants.FscPayOrderState.TY_PAY_FAIL.toString().equals(reqBO.getOrderStatus())) {
                    paramMap.put("payResult", FscConstants.TyPayFlowPayResult.FAIL);
                }
                if (!CollectionUtils.isEmpty(paramMap)) {
                    fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                }
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
                if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
                if (!reqBO.getOrderStatus().equals(fscOrderStatusFlowAtomRspBO.getNewStatus().toString())) {
                    throw new FscBusinessException("190000", "\u66f4\u65b0\u72b6\u6001\u4e0e\u6d41\u7a0b\u72b6\u6001\u4e0d\u5bf9\u5e94");
                }
            } else if (FscConstants.OrderFlow.PAY.equals(orderPO.getOrderFlow()) && FscConstants.SettlePlatform.YES_Y.equals(orderPO.getSettlePlatform())) {
                FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
                fscDealPaySuccessAtomReqBO.setPayFscOrderId(Arrays.asList(orderPO.getFscOrderId()));
                fscDealPaySuccessAtomReqBO.setPayTime(new Date());
                this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
                FscOrderPO fsc = new FscOrderPO();
                fsc.setFscOrderId(orderPO.getFscOrderId());
                fsc.setPostingStatus("1");
                fsc.setPostingDate(reqBO.getPostingDate() == null ? new Date() : reqBO.getPostingDate());
                fsc.setOrderState(Integer.valueOf(1008));
                fsc.setUpdateTime(new Date());
                fsc.setUpdateTimeEnd(new Date());
                fsc.setPostingDate(new Date());
                this.fscOrderMapper.updateById(fsc);
            } else {
                throw new FscBusinessException("190000", "\u6b64\u5355\u636e\u4e0d\u662f\u7ed3\u7b97\u6216\u4ed8\u6b3e\u5355\u3001\u6216\u5355\u636e\u672a\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0");
            }
            rspBO.setTradeMode(orderPO.getTradeMode());
            rspBO.setSettlePlatform(orderPO.getSettlePlatform());
        }
        this.saveLog(reqBO.getOrderId(), reqBO.getOrderNo(), JSON.toJSONString((Object)reqBO));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRefundStatus(FscBillSyncTongYiStatusBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getOrderId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u6839\u636e\u5355\u636eid" + reqBO.getOrderId() + "\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f\uff01");
        }
        if (refundPO.getOrderFlow().equals(FscConstants.OrderFlow.REFUND_INVOICE)) {
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO;
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            if (FscConstants.FscInvoiceOrderState.TY_RECALL.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
            } else if (FscConstants.FscInvoiceOrderState.TY_BUSI_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
            } else if (FscConstants.FscInvoiceOrderState.TY_BUSI_AUDIT_PASS.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
            } else if (FscConstants.FscInvoiceOrderState.TY_FINA_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
            } else if (FscConstants.FscInvoiceOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
                this.syncOrderStatus(refundPO);
            }
            if (!CollectionUtils.isEmpty(paramMap)) {
                fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            }
            if (!"0000".equals((fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO)).getRespCode())) {
                throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
            if (!reqBO.getOrderStatus().equals(fscOrderStatusFlowAtomRspBO.getNewStatus().toString())) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u72b6\u6001\u4e0e\u6d41\u7a0b\u72b6\u6001\u4e0d\u5bf9\u5e94");
            }
            if (FscConstants.FscInvoiceOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                this.dealCreateRefundShouldPay(reqBO, refundPO);
            }
        } else {
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            if (FscConstants.FscPayOrderState.TY_RECALL.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.RECALL);
            } else if (FscConstants.FscPayOrderState.TY_BUSI_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
            } else if (FscConstants.FscPayOrderState.TY_BUSI_AUDIT_PASS.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
            } else if (FscConstants.FscPayOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
            } else if (FscConstants.FscPayOrderState.TY_PAIED.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("payResult", FscConstants.AuditResultFlagKey.REFUSE);
            } else if (FscConstants.FscPayOrderState.TY_PAY_FAIL.toString().equals(reqBO.getOrderStatus())) {
                paramMap.put("payResult", FscConstants.TyPayFlowPayResult.FAIL);
            }
            if (!CollectionUtils.isEmpty(paramMap)) {
                fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            }
            log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
            log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u5355\u72b6\u6001\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
            if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
            if (!reqBO.getOrderStatus().equals(fscOrderStatusFlowAtomRspBO.getNewStatus().toString())) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u72b6\u6001\u4e0e\u6d41\u7a0b\u72b6\u6001\u4e0d\u5bf9\u5e94");
            }
            refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(reqBO.getOrderId());
            if (FscConstants.FscPayOrderState.TY_BUSI_AUDIT_REJECT.toString().equals(reqBO.getOrderStatus())) {
                refundPO.setPushUnifyStatus(FscConstants.FscPushStatus.BACK);
                this.fscOrderRefundMapper.updateById(refundPO);
            } else if (FscConstants.FscPayOrderState.TY_POSTING_PASS.toString().equals(reqBO.getOrderStatus())) {
                refundPO.setBillStatus(FscConstants.RefundBillStatus.AGAINST);
                this.fscOrderRefundMapper.updateById(refundPO);
            }
        }
    }

    private void dealCreateRefundShouldPay(FscBillSyncTongYiStatusBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        FscSettleRefundShouldPayCreateAtomReqBO atomReqBO = (FscSettleRefundShouldPayCreateAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscSettleRefundShouldPayCreateAtomReqBO.class);
        atomReqBO.setOrderRefundPO(refundPO);
        FscSettleRefundShouldPayCreateAtomRspBO atomRspBO = this.fscSettleRefundShouldPayCreateAtomService.createSettleRefundShouldPay(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private void saveLog(Long objectId, String objectNo, String pushData) {
        FscPurchasePushLogPo purchasePushLogPo = new FscPurchasePushLogPo();
        purchasePushLogPo.setObjectId(objectId);
        purchasePushLogPo.setObjectNo(objectNo);
        purchasePushLogPo.setCreateTime(new Date());
        purchasePushLogPo.setType(FscConstants.FscPurchasePushType.ORDER_STATE_BACK);
        purchasePushLogPo.setPushData(pushData);
        purchasePushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        this.fscPurchasePushLogMapper.insert(purchasePushLogPo);
    }

    private void dealOrderCheck(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap();
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscAcceptOrderListQueryAtomRspBO.getOrderCodeList(), fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscSaleOrderListQueryAtomRspBO.getOrderCodeList(), fscSaleOrderListQueryAtomRspBO.getOrderOperList());
        }
    }

    private void dealAccountRule(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Set<String> orderCodeList, Set<String> orderOperList) {
        if (fscOrderPO.getSettleType() != null && fscOrderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            return;
        }
        String billDateMax = this.fscInvoiceMapper.setInvoiceBillDate(fscOrderPO.getFscOrderId());
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            Optional<FscOrderInfoBO> max = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime));
            if (!max.isPresent()) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            FscOrderInfoBO fscOrderInfoBO = max.get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            log.debug("++++++++++fscOrderInfoBO:{}", (Object)JSON.toJSONString((Object)fscOrderInfoBO));
            if ((fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER) || fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) && fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfoBO.setPayBreakScale(fscOrderInfoBO.getProPayBreakScale());
                fscOrderInfoBO.setModelContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderInfoBO.setModelContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
                fscOrderInfoBO.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
                fscOrderInfoBO.setPayRule(fscOrderInfoBO.getProPayRule());
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setSettlePlatform(Integer.valueOf(Objects.isNull(fscOrderPO.getSettlePlatform()) ? 0 : fscOrderPO.getSettlePlatform()));
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource(), billDateMax, fscOrderPO.getReceiveType()));
                fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setInvoiceNo(signTemp.getInvoiceNo());
                fscShouldPayBO.setBillDate(billDateMax);
                fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                fscShouldPayBO.setOperatorDeptId(Convert.toStr((Object)fscOrderPO.getOperatorDeptId()));
                fscShouldPayBO.setOperatorDeptName(fscOrderPO.getOperatorDeptName());
                fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
                if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                    FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
                    fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
                    List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
                    if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
                        fscShouldPayBO.setProContractId(((FscOrderRelationPO)relationPOList.get(0)).getProContractId());
                        fscShouldPayBO.setProContractName(((FscOrderRelationPO)relationPOList.get(0)).getProContractName());
                        fscShouldPayBO.setProContractNo(((FscOrderRelationPO)relationPOList.get(0)).getProContractNo());
                        fscShouldPayBO.setProContractType(((FscOrderRelationPO)relationPOList.get(0)).getProContractType());
                        fscShouldPayBO.setProContractSource(((FscOrderRelationPO)relationPOList.get(0)).getProContractSource());
                    }
                }
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(true);
            }
        } else if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(fscOrderPO.getPayType())) {
            Optional<FscOrderInfoBO> max = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime));
            if (!max.isPresent()) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            FscOrderInfoBO fscOrderInfoBO = max.get();
            if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayList(fscOrderInfoBO.getProPayList());
            }
            boolean flag = false;
            ArrayList<FscPhasePayListBO> payListBOS = new ArrayList<FscPhasePayListBO>();
            if (CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                return;
            }
            for (FscPhasePayListBO payListBO : fscOrderInfoBO.getPayList()) {
                if (payListBO.getPayNode() != 4 && payListBO.getPayNode() != 5 || payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) <= 0) continue;
                payListBOS.add(payListBO);
                flag = true;
            }
            if (flag) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                for (FscPhasePayListBO fscPhasePayListBO : payListBOS) {
                    FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                    fscShouldPayBO.setSettlePlatform(Integer.valueOf(Objects.isNull(fscOrderPO.getSettlePlatform()) ? 0 : fscOrderPO.getSettlePlatform()));
                    fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                    fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                    fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                    fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                    fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                    fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge().multiply(fscPhasePayListBO.getNodePayRatio()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                    fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                    fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                    fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                    fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                    fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                    fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                    fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                    fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                    fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                    fscShouldPayBO.setShouldPayDate(this.calShouldPayDateNew(fscPhasePayListBO.getNodePayCycle(), billDateMax));
                    fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                    FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscOrderPO.getFscOrderId());
                    fscShouldPayBO.setInvoiceNo(signTemp.getInvoiceNo());
                    fscShouldPayBO.setBillDate(billDateMax);
                    fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                    fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                    fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                    fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                    fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                    fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                    fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                    fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                    fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                    fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                    fscShouldPayBO.setShouldPayMethod(fscPhasePayListBO.getPayType());
                    if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
                        fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
                        List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
                        if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
                            fscShouldPayBO.setProContractId(((FscOrderRelationPO)relationPOList.get(0)).getProContractId());
                            fscShouldPayBO.setProContractName(((FscOrderRelationPO)relationPOList.get(0)).getProContractName());
                            fscShouldPayBO.setProContractNo(((FscOrderRelationPO)relationPOList.get(0)).getProContractNo());
                            fscShouldPayBO.setProContractType(((FscOrderRelationPO)relationPOList.get(0)).getProContractType());
                            fscShouldPayBO.setProContractSource(((FscOrderRelationPO)relationPOList.get(0)).getProContractSource());
                        }
                    }
                    fscShouldPayBOS.add(fscShouldPayBO);
                }
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private Date calShouldPayDateNew(String nodePayCycle, String billDateMax) {
        Integer payDays = 0;
        payDays = StringUtils.isEmpty((CharSequence)nodePayCycle) || nodePayCycle.equals("null") ? Integer.valueOf(0) : Integer.valueOf(nodePayCycle);
        Calendar now = Calendar.getInstance();
        if (StringUtils.isNotBlank((CharSequence)billDateMax)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        now.add(5, payDays);
        return now.getTime();
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource, String billDateMax, Integer receiveType) {
        Calendar now = Calendar.getInstance();
        Boolean flag = FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource) && FscConstants.FscOrderReceiveType.OPERATION.equals(receiveType);
        if (StringUtils.isNotBlank((CharSequence)billDateMax) && !flag.booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscOrderPO signTemp, FscOrderPO fscOrderPO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            for (FscShouldPayBO fscShouldPayBO : fscShouldPayBOS) {
                fscShouldPayBO.setInvoiceNo(fscOrderPO.getInvoiceNo());
            }
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(signTemp.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(signTemp.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(signTemp.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(signTemp.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(signTemp.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(signTemp.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(signTemp.getOrgName());
            List acceptOrderCodes = this.fscShouldPayMapper.selectAcceptOrderCode(signTemp.getFscOrderId());
            String acceptOrderCode = String.join((CharSequence)",", acceptOrderCodes);
            for (FscShouldPayBO bo : fscShouldPayBOS) {
                bo.setAcceptOrderCode(acceptOrderCode);
            }
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private FscBillSyncTongYiStatusBusiRspBO dealChargeInfo(FscBillSyncTongYiStatusBusiReqBO reqBO) {
        FscAccountChargePO chargePO = new FscAccountChargePO();
        chargePO.setAdvanceDepositNo(reqBO.getOrderNo());
        chargePO.setChargeId(reqBO.getOrderId());
        chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
        if (chargePO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f");
        }
        FscBillSyncTongYiStatusBusiRspBO rspBO = new FscBillSyncTongYiStatusBusiRspBO();
        if (reqBO.getOrderStatus().equals(FscConstants.FscPayOrderState.TY_POSTING_PASS.toString())) {
            chargePO.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
            this.fscAccountChargeMapper.updateAuditStatusById(chargePO);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void syncOrderStatus(FscOrderRefundPO refundPO) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setRefundId(refundPO.getRefundId());
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.REFUND);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        FscUocOrderRelUpdateAtomRspBO fscUocOrderRelUpdateAtomRspBO = this.fscUocOrderRelUpdateAtomService.dealRefundUpdate(fscUocOrderRelUpdateAtomReqBO);
        if (!fscUocOrderRelUpdateAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscUocOrderRelUpdateAtomRspBO.getRespCode(), "\u91ca\u653e\u8ba2\u5355\u5931\u8d25\uff1a" + fscUocOrderRelUpdateAtomRspBO.getRespDesc());
        }
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.SIGN);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

