/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.busi.api.FscPayClaimListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayClaimListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayClaimListQueryBusiRspBO;
import com.tydic.fsc.bo.FscPayClaimBO;
import com.tydic.fsc.bo.FscPayClaimDetailBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscPayClaimDetailMapper;
import com.tydic.fsc.dao.FscPayClaimMapper;
import com.tydic.fsc.enums.FscClaimPushStatusEnum;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscPayRecvTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscPayClaimDetailPO;
import com.tydic.fsc.po.FscPayClaimPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPayClaimListQueryBusiServiceImpl
implements FscPayClaimListQueryBusiService {
    @Autowired
    private FscPayClaimMapper fscPayClaimMapper;
    @Autowired
    private FscPayClaimDetailMapper fscPayClaimDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscPayClaimListQueryBusiRspBO qryPayClaimList(FscPayClaimListQueryBusiReqBO reqBO) {
        List claimIdList;
        Object claimDetailList;
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscPayClaimPO fscPayClaimPO = new FscPayClaimPO();
        fscPayClaimPO = (FscPayClaimPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscPayClaimPO.class);
        if (reqBO.getWebSource() != null && reqBO.getWebSource() == 1) {
            ArrayList<String> claimStatusList = new ArrayList<String>();
            claimStatusList.add(FscClaimStatusEnum.NOT_CLAIM.getCode());
            claimStatusList.add(FscClaimStatusEnum.PART_CLAIM.getCode());
            fscPayClaimPO.setPayStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscPayClaimPO.setClaimStatusList(claimStatusList);
        }
        fscPayClaimPO.setExcludePayStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        fscPayClaimPO.setHandleUserId(reqBO.getClaimUserId());
        fscPayClaimPO.setHandleDeptId(reqBO.getClaimDeptId());
        if (reqBO.getOnlyMemType() != null && reqBO.getOnlyMemType() == 1) {
            fscPayClaimPO.setClaimType(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode());
        } else {
            fscPayClaimPO.setExClaimType(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode());
        }
        List listPage = this.fscPayClaimMapper.getListPage(fscPayClaimPO, page);
        HashMap<Long, List<FscPayClaimDetailPO>> detailPOMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)listPage) && CollectionUtils.isNotEmpty((Collection)(claimDetailList = this.fscPayClaimDetailMapper.queryByClaimIdList(claimIdList = listPage.stream().map(FscPayClaimPO::getClaimId).collect(Collectors.toList()))))) {
            detailPOMap = claimDetailList.stream().collect(Collectors.groupingBy(FscPayClaimDetailPO::getClaimId));
        }
        LinkedList<FscPayClaimBO> rows = new LinkedList<FscPayClaimBO>();
        for (FscPayClaimPO payClaimPo : listPage) {
            FscPayClaimBO fscPayClaimBo = new FscPayClaimBO();
            BeanUtils.copyProperties((Object)payClaimPo, (Object)fscPayClaimBo);
            this.transform(fscPayClaimBo);
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            fscAttachmentPo.setObjId(payClaimPo.getClaimId());
            fscPayClaimBo.setAttachmentList(this.fscAttachmentMapper.getExtensionList(fscAttachmentPo));
            fscPayClaimBo.setClaimAmount(fscPayClaimBo.getPayAmt().subtract(fscPayClaimBo.getNoClaimAmt()));
            fscPayClaimBo.setClaimDetailList(this.transDetailInfo(fscPayClaimBo, detailPOMap));
            rows.add(fscPayClaimBo);
        }
        FscPayClaimListQueryBusiRspBO rspBO = new FscPayClaimListQueryBusiRspBO();
        rspBO.setRows(rows);
        if (reqBO.getOnlyMemType() != null && reqBO.getOnlyMemType() == 1) {
            rspBO.setPayAmt(this.fscPayClaimMapper.selectMemPayAmt());
            rspBO.setNoClaimAmt(this.fscPayClaimMapper.selectMemNoClaimAmt());
        } else {
            rspBO.setPayAmt(this.fscPayClaimMapper.selectPayAmt(reqBO.getBusiOrgId()));
            rspBO.setNoClaimAmt(this.fscPayClaimMapper.selectNoClaimAmt(reqBO.getBusiOrgId()));
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void transform(FscPayClaimBO fscPayClaimBo) {
        if (!StringUtils.isEmpty((Object)fscPayClaimBo.getPayType())) {
            fscPayClaimBo.setPayTypeStr(FscPayRecvTypeEnum.getCodeDesc((String)fscPayClaimBo.getPayType()));
        }
        if (!StringUtils.isEmpty((Object)fscPayClaimBo.getClaimStatus())) {
            fscPayClaimBo.setClaimStatusStr(FscClaimStatusEnum.getCodeDsc((String)fscPayClaimBo.getClaimStatus()));
        }
        if (!StringUtils.isEmpty((Object)fscPayClaimBo.getPayStatus())) {
            fscPayClaimBo.setPayStatusStr(FscClaimRecvStatusEnum.getCodeDesc((String)fscPayClaimBo.getPayStatus()));
        }
    }

    private List<FscPayClaimDetailBO> transDetailInfo(FscPayClaimBO fscPayClaimBo, Map<Long, List<FscPayClaimDetailPO>> detailPOMap) {
        List<FscPayClaimDetailPO> detailPOList = detailPOMap.get(fscPayClaimBo.getClaimId());
        ArrayList<FscPayClaimDetailBO> detailBOList = new ArrayList<FscPayClaimDetailBO>();
        if (CollectionUtils.isNotEmpty(detailPOList)) {
            detailPOList.forEach(e -> {
                FscPayClaimDetailBO fscClaimDetailBO = new FscPayClaimDetailBO();
                BeanUtils.copyProperties((Object)e, (Object)fscClaimDetailBO);
                fscClaimDetailBO.setPushStatusStr(FscClaimPushStatusEnum.getCodeDesc((Integer)e.getPushStatus()));
                fscClaimDetailBO.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)e.getSysSource()));
                FscClaimTypeEnum instance = FscClaimTypeEnum.getInstance((String)fscClaimDetailBO.getClaimType());
                if (instance != null) {
                    fscClaimDetailBO.setClaimTypeStr(instance.getCodeDesc());
                }
                if (FscSystemSourceEnum.YC.getCode().equals(fscClaimDetailBO.getSysSource())) {
                    fscClaimDetailBO.setClaimAmtForYC(fscClaimDetailBO.getClaimAmt());
                } else {
                    fscClaimDetailBO.setClaimAmtForYG(fscClaimDetailBO.getClaimAmt());
                }
                detailBOList.add(fscClaimDetailBO);
            });
        }
        return detailBOList;
    }
}

