/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.busi.api.FscTracfficInvoiceAuditBusiService;
import com.tydic.fsc.bill.busi.bo.FscTracfficInvoiceAuditBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscTracfficInvoiceAuditBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscTracfficInvoiceAuditCancelBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscTracfficInvoiceAuditCancelBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.UocApprovalLogBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.dao.UocApprovalLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscTracfficInvoiceAuditBusiServiceImpl
implements FscTracfficInvoiceAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscTracfficInvoiceAuditBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Value(value="${fsc.saleSettl.approval.taxAccounting:6240}")
    private String taxAccounting;
    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;

    @Override
    public FscTracfficInvoiceAuditBusiRspBO dealTracfficInvoiceAudit(FscTracfficInvoiceAuditBusiReqBO reqBO) {
        Integer count;
        FscTracfficInvoiceAuditBusiRspBO rspBO = new FscTracfficInvoiceAuditBusiRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO == null) {
            throw new FscBusinessException("198888", "\u65e0\u6548\u7684\u7ed3\u7b97\u5355id");
        }
        if (!FscConstants.FscInvoiceOrderState.AUDITING.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191124", "\u7ed3\u7b97\u5355\u4e0d\u5904\u4e8e\u5ba1\u6279\u4e2d\u72b6\u6001,\u5ba1\u6279\u5931\u8d25\uff01");
        }
        if (!reqBO.getIsSelfApproval().booleanValue() && ((count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList(), reqBO.getUserId())) == 0 || CollectionUtils.isEmpty((Collection)reqBO.getStationsList()))) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO, variablesMap);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getOrderId());
        orderPO.setSendOperTime(new Date());
        orderPO.setSendOperId(reqBO.getUserId().toString() + ",");
        orderPO.setSendOperName(reqBO.getName());
        if (finish.booleanValue()) {
            rspBO.setFinish(true);
            if (Integer.valueOf(0).equals(reqBO.getAuditResult())) {
                rspBO.setSendFlag(true);
                orderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_PASS);
                orderPO.setSendState(Integer.valueOf(1002));
            } else {
                orderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_REJECT);
                orderPO.setSendState(Integer.valueOf(1003));
            }
        } else {
            FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
            taskPo.setFscOrderId(reqBO.getOrderId());
            List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
            if (CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38");
            }
            log.info("\u672a\u5ba1\u6838\u7684\u5c97\u4f4d\u4fe1\u606f\u6253\u5370\uff1a" + JSON.toJSON((Object)pendAuditPostIdList));
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            orderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            if (orderPO.getSendStation().contains(this.taxAccounting)) {
                reqBO.setAuditAdvice("\u540c\u610f");
                DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(this.taxAccounting));
                DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                    UserBO userBO = (UserBO)dycStationOrgSelectUserNameRspBO.getUserList().get(0);
                    reqBO.setName(userBO.getName());
                    reqBO.setOrgName(userBO.getOrgName());
                    reqBO.setUserId(userBO.getUserId());
                }
                reqBO.setIsSelfApproval(true);
                rspBO = this.dealTracfficInvoiceAudit(reqBO);
            }
        }
        this.fscOrderMapper.updateById(orderPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscTracfficInvoiceAuditCancelBusiRspBO dealTracfficInvoiceAuditCancel(FscTracfficInvoiceAuditCancelBusiReqBO reqBO) {
        FscTracfficInvoiceAuditCancelBusiRspBO rspBO = new FscTracfficInvoiceAuditCancelBusiRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO == null) {
            throw new FscBusinessException("198888", "\u65e0\u6548\u7684\u7ed3\u7b97\u5355id");
        }
        if (!FscConstants.FscInvoiceOrderState.AUDITING.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191124", "\u7ed3\u7b97\u5355\u4e0d\u5904\u4e8e\u5ba1\u6279\u4e2d\u72b6\u6001,\u64a4\u56de\u5931\u8d25\uff01");
        }
        Integer haveAuditNum = this.fscOrderMapper.getHaveAuditNum(reqBO.getOrderId());
        if (haveAuditNum > 0) {
            throw new FscBusinessException("191124", "\u7ed3\u7b97\u5355\u5df2\u7ecf\u88ab\u4eba\u5ba1\u6279\u8fc7,\u64a4\u56de\u5931\u8d25\uff01");
        }
        this.cancelAudit(reqBO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getOrderId());
        orderPO.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
        orderPO.setSendState(Integer.valueOf(999));
        this.fscOrderMapper.updateById(orderPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void cancelAudit(FscTracfficInvoiceAuditCancelBusiReqBO reqBO) {
        UacNoTaskAuditCancelReqBO taskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
        taskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
        taskAuditCancelReqBO.setCancelReason("\u6d41\u91cf\u8d39\u5ba1\u6279\u64a4\u56de");
        taskAuditCancelReqBO.setObjId(reqBO.getOrderId().toString());
        taskAuditCancelReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        taskAuditCancelReqBO.setSaveLog(Boolean.valueOf(true));
        taskAuditCancelReqBO.setOperName(reqBO.getName());
        UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(taskAuditCancelReqBO);
        if (!"0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
            throw new FscBusinessException("193108", uacNoTaskAuditCancelRspBO.getRespDesc());
        }
        UocApprovalLogBO logBO = new UocApprovalLogBO();
        logBO.setOrderId(reqBO.getOrderId());
        List approvalLogPOList = this.uocApprovalLogMapper.getApprovalList(logBO);
        if (!CollectionUtils.isEmpty((Collection)approvalLogPOList) && approvalLogPOList.size() > 1) {
            UocApprovalLogPO uocApprovalLogPO = (UocApprovalLogPO)approvalLogPOList.get(approvalLogPOList.size() - 2);
            try {
                if (Objects.nonNull(reqBO.getOrderId()) && Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                    TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                    todoFscWaitAbilityReqBO.setCenterCode("settle");
                    todoFscWaitAbilityReqBO.setBusiCode("1100");
                    todoFscWaitAbilityReqBO.setBusiName("\u5e73\u53f0\u6d41\u91cf\u8d39\u7ed3\u7b97\u5355");
                    todoFscWaitAbilityReqBO.setObjId(reqBO.getOrderId());
                    todoFscWaitAbilityReqBO.setOperatorType("2");
                    todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                    this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
                }
            }
            catch (Exception e) {
                log.error("dealOrderApproval error:{}", (Throwable)e);
            }
        }
    }

    private void dealFlowStart(FscTracfficInvoiceAuditBusiReqBO reqBO, Boolean throughFlag) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        if (!throughFlag.booleanValue()) {
            paramMap.put("skipFlag", "3");
        }
        fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.TRACFFIC_FEE);
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscTracfficInvoiceAuditBusiReqBO reqBO, Map<String, Object> variablesMap) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getOrderId());
        }
        catch (Exception e) {
            log.error("getApprovalResult get stationId error:{}", (Throwable)e);
        }
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        auditReqBO.setStepId(stepId);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (!CollectionUtils.isEmpty(variablesMap)) {
            auditReqBO.setVariables(variablesMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        try {
            if (Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                todoFscWaitAbilityReqBO.setCenterCode("settle");
                todoFscWaitAbilityReqBO.setBusiCode("1100");
                todoFscWaitAbilityReqBO.setBusiName("\u5e73\u53f0\u6d41\u91cf\u8d39\u7ed3\u7b97\u5355");
                todoFscWaitAbilityReqBO.setObjId(reqBO.getOrderId());
                todoFscWaitAbilityReqBO.setOperatorType("1");
                todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("getApprovalResult error:{}", (Throwable)e);
        }
        return auditRspBO;
    }
}

