/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.enums.FscOperatorTypeEnum;
import com.tydic.fsc.bill.atom.api.finance.FscSyncContractSettlementDetailAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringInvoiceCreateBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceCreateBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderItemTempMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderItemTempPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscEngineeringInvoiceCreateBusiServiceImpl
implements FscEngineeringInvoiceCreateBusiService {
    private static final Logger log = LogManager.getLogger(FscEngineeringInvoiceCreateBusiServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderItemTempMapper fscOrderItemTempMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Resource
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscSyncContractSettlementDetailAtomService fscSyncContractSettlementDetailAtomService;

    @Override
    public FscEngineeringInvoiceCreateBusiRspBO dealEngineeringInvoiceCreate(FscEngineeringInvoiceCreateBusiReqBO reqBO) {
        boolean updateFlag = Boolean.FALSE;
        FscOrderPO queryOrderPO = new FscOrderPO();
        queryOrderPO.setFscOrderId(reqBO.getFscOrderId());
        queryOrderPO = this.fscOrderMapper.getModelBy(queryOrderPO);
        if (Objects.nonNull(queryOrderPO)) {
            updateFlag = Boolean.TRUE;
        }
        if (updateFlag) {
            FscOrderRelationPO deleteRelationPO = new FscOrderRelationPO();
            deleteRelationPO.setFscOrderId(reqBO.getFscOrderId());
            this.fscOrderRelationMapper.deleteBy(deleteRelationPO);
            FscOrderItemPO deleteItemPO = new FscOrderItemPO();
            deleteItemPO.setFscOrderId(reqBO.getFscOrderId());
            this.fscOrderItemMapper.deleteBy(deleteItemPO);
            FscAttachmentPO deleteAttachPO = new FscAttachmentPO();
            deleteAttachPO.setFscOrderId(reqBO.getFscOrderId());
            this.fscAttachmentMapper.deleteBy(deleteAttachPO);
            FscOrderInvoicePO deleteInvoicePO = new FscOrderInvoicePO();
            deleteInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            this.fscOrderInvoiceMapper.deleteBy(deleteInvoicePO);
        }
        FscOrderItemTempPO fscOrderItemTempPO = new FscOrderItemTempPO();
        fscOrderItemTempPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemTempPOList = this.fscOrderItemTempMapper.getList(fscOrderItemTempPO);
        FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
        fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList) || CollectionUtils.isEmpty((Collection)fscOrderItemTempPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5f00\u7968\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        List checkList = fscOrderItemTempPOList.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getContractSettleState()) || StringUtils.isBlank((CharSequence)e.getContractSettleDesc()) || Objects.isNull(e.getAmt()) || Objects.isNull(e.getContractShouldPayDate()) || Objects.isNull(e.getTaxRate())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkList)) {
            throw new FscBusinessException("190000", ((FscOrderItemTempPO)checkList.get(0)).getContractNo() + "\u4e0b\u7ed3\u7b97\u660e\u7ec6\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
        fscAttachmentTempPO.setFscOrderId(reqBO.getFscOrderId());
        List fscAttachmentTempPOList = this.fscAttachmentTempMapper.getList(fscAttachmentTempPO);
        BigDecimal totalCharge = fscOrderItemTempPOList.stream().map(FscOrderItemTempPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        reqBO.setTotalCharge(totalCharge);
        FscOrderPO orderPo = this.buildFscOrderInfo(reqBO, updateFlag);
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePO.setBillOperId(String.valueOf(reqBO.getUserId()));
        fscOrderInvoicePO.setBillOperName(reqBO.getName());
        fscOrderInvoicePO.setBillTime(new Date());
        fscOrderInvoicePO.setBillTimeStart(new Date());
        FscOrderFinancePO fscOrderFinancePO = (FscOrderFinancePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderFinancePO.class);
        if (!updateFlag) {
            fscOrderFinancePO.setCreateUserId(reqBO.getUserName());
            fscOrderFinancePO.setCreateUserName(reqBO.getName());
            fscOrderFinancePO.setCreateTime(new Date());
        }
        fscOrderFinancePO.setUpdateUserId(reqBO.getUserName());
        fscOrderFinancePO.setUpdateUserName(reqBO.getName());
        fscOrderFinancePO.setUpdateTime(new Date());
        fscOrderFinancePO.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
        fscOrderFinancePO.setFinanceUserId(StringUtils.isNotBlank((CharSequence)reqBO.getFinanceUserId()) ? reqBO.getFinanceUserId() : reqBO.getUserName());
        fscOrderFinancePO.setFinanceUserName(StringUtils.isNotBlank((CharSequence)reqBO.getFinanceUserId()) ? reqBO.getFinanceUserName() : reqBO.getName());
        fscOrderFinancePO.setExt1(reqBO.getSupplierErpNo());
        fscOrderFinancePO.setExt3(reqBO.getBuynerErpNo());
        if (updateFlag) {
            this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
            this.fscOrderMapper.updateById(orderPo);
        } else {
            this.fscOrderFinanceMapper.insert(fscOrderFinancePO);
            this.fscOrderMapper.insert(orderPo);
        }
        this.fscOrderRelationMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscOrderRelationTempPOList), FscOrderRelationPO.class));
        this.fscOrderItemMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscOrderItemTempPOList), FscOrderItemPO.class));
        this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentTempPOList)) {
            this.fscAttachmentMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentTempPOList), FscAttachmentPO.class));
        }
        if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(Collections.singletonList(reqBO.getFscOrderId()));
            fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
            this.fscOrderMapper.dealSave(fscOrderPO);
        } else {
            FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
            fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getFscOrderId());
            fscOrderStatusStartAtomReqBO.setOrderFlow(FscOrderFlowEnum.ENGINEERING_INVOICE.getCode());
            fscOrderStatusStartAtomReqBO.setOperId(reqBO.getUserName());
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
            }
            FscSyncContractSettlementDetailAtomReqBO atomReqBO = new FscSyncContractSettlementDetailAtomReqBO();
            atomReqBO.setFscOrderId(reqBO.getFscOrderId());
            atomReqBO.setOperatorType(FscOperatorTypeEnum.ADD.getCode());
            atomReqBO.setUserId(reqBO.getUserId());
            FscSyncContractSettlementDetailAtomRspBO atomRspBO = this.fscSyncContractSettlementDetailAtomService.syncContractSettlementDetail(atomReqBO);
            if (Objects.nonNull((Object)atomRspBO) && !"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("8888", atomRspBO.getRespDesc());
            }
        }
        FscEngineeringInvoiceCreateBusiRspBO rspBO = new FscEngineeringInvoiceCreateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscOrderPO buildFscOrderInfo(FscEngineeringInvoiceCreateBusiReqBO reqBO, boolean updateFlag) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setMakeType(FscConstants.FscOrderMakeType.SUPPLIER);
        fscOrderPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        fscOrderPO.setOrderFlow(FscOrderFlowEnum.ENGINEERING_INVOICE.getCode());
        fscOrderPO.setOrderFlowKey(FscOrderFlowProcKeyEnum.getInstance((String)fscOrderPO.getOrderFlow().toString()).getDescr());
        fscOrderPO.setPayerId(reqBO.getBuynerId());
        fscOrderPO.setPayerName(reqBO.getBuynerName());
        fscOrderPO.setPurchaserId(reqBO.getPurchaserId());
        fscOrderPO.setPurchaserName(reqBO.getPurchaserName());
        fscOrderPO.setPayeeId(reqBO.getSupplierId());
        fscOrderPO.setPayeeName(reqBO.getSupplierName());
        fscOrderPO.setSupplierId(reqBO.getSupplierId());
        fscOrderPO.setSupplierName(reqBO.getSupplierName());
        fscOrderPO.setTotalCharge(reqBO.getTotalCharge());
        fscOrderPO.setBuynerNo(reqBO.getBuynerNo());
        fscOrderPO.setBuynerName(reqBO.getBuynerName());
        fscOrderPO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        if (!updateFlag) {
            fscOrderPO.setCreateTime(new Date());
            fscOrderPO.setCreateOperId(reqBO.getUserId());
            fscOrderPO.setCreateOperName(reqBO.getName());
            fscOrderPO.setCreateOperNo(reqBO.getUserName());
            fscOrderPO.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPO.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPO.setCreateOrgId(reqBO.getOrgId());
            fscOrderPO.setCreateOrgName(reqBO.getOrgName());
            List<String> serial = this.getSerial(FscBillInvoiceSerial.ENGINEERING_CONTRACT_NO.getCode(), 1);
            fscOrderPO.setOrderNo(serial.get(0));
        }
        fscOrderPO.setUpdateTime(new Date());
        fscOrderPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        fscOrderPO.setUpdateOperName(reqBO.getUserName());
        fscOrderPO.setOrderType(FscOrderTypeEnum.ENGINEERING_INVOICE.getCode());
        fscOrderPO.setTradeMode(FscConstants.FscBusiModel.MATCHING);
        return fscOrderPO;
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u751f\u6210\u7ed3\u7b97\u5355\u7f16\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }
}

