/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscAddFinanceWriteOffAbilityService;
import com.tydic.fsc.bill.ability.bo.FscAddFinanceWriteOffReqBo;
import com.tydic.fsc.bill.ability.bo.FscAddFinanceWriteOffReqBoDetails;
import com.tydic.fsc.bill.ability.bo.FscAddFinanceWriteOffRspBo;
import com.tydic.fsc.bill.busi.api.FscAddFinanceWriteOffBusiService;
import com.tydic.fsc.bill.busi.bo.FscAddFinanceWriteOffBusiReqBo;
import com.tydic.fsc.bill.busi.bo.finance.FscAddFinanceWriteOffBusiRspBo;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustDetailPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscAddFinanceWriteOffAbilityService"})
public class FscAddFinanceWriteOffAbilityServiceImpl
implements FscAddFinanceWriteOffAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAddFinanceWriteOffAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscAddFinanceWriteOffBusiService fscAddFinanceWriteOffBusiService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;

    @PostMapping(value={"dealFinanceWriteOff"})
    public FscAddFinanceWriteOffRspBo dealFinanceWriteOff(@RequestBody FscAddFinanceWriteOffReqBo reqBo) {
        FscOrderPO fscOrderPO = this.validParam(reqBo);
        FscAddFinanceWriteOffBusiReqBo busiReqBo = (FscAddFinanceWriteOffBusiReqBo)((Object)JUtil.js((Object)reqBo, FscAddFinanceWriteOffBusiReqBo.class));
        FscAddFinanceWriteOffBusiRspBo busiRspBo = this.fscAddFinanceWriteOffBusiService.dealFinanceWriteOff(busiReqBo);
        if ("0000".equals(busiRspBo.getRespCode())) {
            this.toSendText(busiReqBo, fscOrderPO);
            if (!CollectionUtils.isEmpty(busiRspBo.getAuditNoticeList())) {
                FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
                abilityReqBO.setApproveEntrustType(Integer.valueOf(FscConstants.FinanceWriteOffType.ADD.equals(reqBo.getBillType()) ? 5 : 6));
                abilityReqBO.setAuditNoticeList(busiRspBo.getAuditNoticeList());
                this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
            }
            try {
                FscPushEngTodoAbilityServiceReqBO todoAbilityServiceReqBO = new FscPushEngTodoAbilityServiceReqBO();
                todoAbilityServiceReqBO.setBusiCode(FscConstants.FinanceWriteOffType.ADD.equals(reqBo.getBillType()) ? "1206" : "1207");
                todoAbilityServiceReqBO.setBusiName(FscConstants.FinanceWriteOffType.ADD.equals(reqBo.getBillType()) ? "\u8865\u6838\u9500\u5ba1\u6279" : "\u64a4\u9500\u6838\u9500\u5ba1\u6279");
                todoAbilityServiceReqBO.setObjId(busiReqBo.getAdjustId());
                todoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT);
                this.taskTodoWaitService.dealEngPushTodoHandler(todoAbilityServiceReqBO);
            }
            catch (Exception e) {
                log.error("dealFinanceWriteOff|\u53d1\u9001\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
            }
            FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
            syncReqBO.setFscOrderId(reqBo.getFscOrderId());
            this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        }
        FscAddFinanceWriteOffRspBo rspBo = new FscAddFinanceWriteOffRspBo();
        rspBo.setRespDesc(busiRspBo.getRespDesc());
        rspBo.setRespCode(busiRspBo.getRespCode());
        return rspBo;
    }

    private void toSendText(FscAddFinanceWriteOffBusiReqBo reqBo, FscOrderPO fscOrderPO) {
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String orderTypeStr = (String)orderTypeMap.get(String.valueOf(fscOrderPO.getOrderType()));
        if (FscConstants.OrderFlow.ENGINEERING_INVOICE.equals(fscOrderPO.getOrderFlow())) {
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setFscOrderId(reqBo.getFscOrderId());
            List poList = this.fscOrderRelationMapper.getList(orderRelationPO);
            if (CollectionUtils.isEmpty((Collection)poList) || null == ((FscOrderRelationPO)poList.get(0)).getBusinessType()) {
                log.info("\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u5931\u8d25");
                return;
            }
            Integer businessType = ((FscOrderRelationPO)poList.get(0)).getBusinessType();
            Map engTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_BUSINESS_TYPE");
            orderTypeStr = (String)engTypeMap.get(businessType.toString());
        }
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(reqBo.getAdjustId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        String billType = FscConstants.FinanceWriteOffType.ADD.equals(reqBo.getBillType()) ? "\u8865\u6838\u9500\u7533\u8bf7\u5355" : "\u64a4\u9500\u6838\u9500\u7533\u8bf7\u5355";
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)fscApprovalTaskQueryBOList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBo.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + billType + "_" + orderTypeStr + "\u6b3e_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684" + billType + fscOrderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("dealFinanceWriteOff|\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private FscOrderPO validParam(FscAddFinanceWriteOffReqBo reqBo) {
        if (null == reqBo) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBo.getDetails())) {
            throw new FscBusinessException("191000", "\u6838\u9500\u660e\u7ec6[details]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getWriteOffAmt() || reqBo.getWriteOffAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new FscBusinessException("191000", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a0");
        }
        if (null == reqBo.getBillType()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[billType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal cancelAmt = BigDecimal.ZERO;
        if (null != reqBo.getAdjustId()) {
            FscFinanceWriteOffAdjustPO adjustPO = new FscFinanceWriteOffAdjustPO();
            adjustPO.setAdjustId(reqBo.getAdjustId());
            adjustPO = this.fscFinanceWriteOffAdjustMapper.getModelBy(adjustPO);
            cancelAmt = adjustPO.getWriteOffAmt();
        }
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(reqBo.getFscOrderId());
        orderPo = this.fscOrderMapper.getModelBy(orderPo);
        if (FscConstants.OrderFlow.ENGINEERING_INVOICE.equals(orderPo.getOrderFlow())) {
            FscOrderRefundPO refundPO = new FscOrderRefundPO();
            refundPO.setFscOrderId(reqBo.getFscOrderId());
            List list = this.fscOrderRefundMapper.getList(refundPO);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.forEach(e -> {
                    if (FscConstants.RefundInvoiceStatus.DELETE.equals(e.getRefundStatus()) || FscConstants.RefundInvoiceStatus.CANCEL.equals(e.getRefundStatus())) {
                        throw new FscBusinessException("190000", "\u5b58\u5728\u5728\u9014\u9000\u7968\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u6838\u9500\u6d41\u7a0b\uff01");
                    }
                });
            }
        }
        if (FscConstants.FinanceWriteOffType.ADD.equals(reqBo.getBillType())) {
            List payItemIds = reqBo.getDetails().stream().map(FscAddFinanceWriteOffReqBoDetails::getOrderPayDetailId).collect(Collectors.toList());
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setOrderIdList(payItemIds);
            fscOrderPO = FscConstants.OrderFlow.ENGINEERING_INVOICE.equals(orderPo.getOrderFlow()) ? this.fscOrderMapper.qryPurPrePayEg(fscOrderPO) : this.fscOrderMapper.qryPurPrePay(fscOrderPO);
            if (null == fscOrderPO) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u7ed3\u7b97\u5355\u9884\u4ed8\u6838\u9500\u4fe1\u606f\u5f02\u5e38");
            }
            if (fscOrderPO.getPurWriteOffAmount().subtract(cancelAmt).compareTo(reqBo.getPaidWriteOffAmount()) != 0) {
                throw new FscBusinessException("190000", "\u8ba2\u5355\u6838\u9500\u91d1\u989d\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
            }
            BigDecimal purWriteOffAmountOld = fscOrderPO.getPurWriteOffAmount();
            BigDecimal purWriteOffAmountNew = purWriteOffAmountOld.add(reqBo.getWriteOffAmt()).subtract(cancelAmt);
            if (purWriteOffAmountNew.compareTo(reqBo.getPaidAmount()) > 0) {
                throw new FscBusinessException("190000", "\u603b\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d" + purWriteOffAmountNew);
            }
        } else {
            List cancelDetailsId = reqBo.getDetails().stream().map(FscAddFinanceWriteOffReqBoDetails::getCancelAdjustDetailId).collect(Collectors.toList());
            FscFinanceWriteOffPO writeOffPO = new FscFinanceWriteOffPO();
            writeOffPO.setWriteOffIds(cancelDetailsId);
            List writeOffPOList = this.fscFinanceWriteOffMapper.getList(writeOffPO);
            if (CollectionUtil.isEmpty((Collection)writeOffPOList)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u6838\u9500\u5355\u5931\u8d25" + cancelDetailsId);
            }
            BigDecimal amt = BigDecimal.ZERO;
            for (FscFinanceWriteOffPO offPO : writeOffPOList) {
                if (Integer.valueOf(2).equals(offPO.getCancelStatus())) {
                    throw new FscBusinessException("190000", "\u5f53\u524d\u6838\u9500\u5355\u72b6\u6001\u4e0d\u652f\u6301\u64a4\u6838\u9500" + offPO);
                }
                if (Integer.valueOf(1).equals(offPO.getCancelStatus()) && null == reqBo.getAdjustId()) {
                    throw new FscBusinessException("190000", "\u5f53\u524d\u6838\u9500\u5355\u72b6\u6001\u4e0d\u652f\u6301\u64a4\u6838\u9500{}" + offPO.getWriteOffId());
                }
                if (Integer.valueOf(1).equals(offPO.getCancelStatus()) && null != reqBo.getAdjustId()) {
                    FscFinanceWriteOffAdjustDetailPO adjustDetailPO = new FscFinanceWriteOffAdjustDetailPO();
                    adjustDetailPO.setAdjustId(reqBo.getAdjustId());
                    adjustDetailPO.setCancelAdjustDetailId(offPO.getWriteOffId());
                    adjustDetailPO = this.fscFinanceWriteOffAdjustDetailMapper.getModelBy(adjustDetailPO);
                    if (adjustDetailPO == null) {
                        throw new FscBusinessException("190000", "\u5f53\u524d\u6838\u9500\u5355\u5df2\u5728\u6838\u9500\u4e2d{}" + offPO.getWriteOffId());
                    }
                }
                amt = amt.add(offPO.getWriteOffAmt());
            }
            if (reqBo.getWriteOffAmt().compareTo(amt) != 0) {
                throw new FscBusinessException("190000", "\u64a4\u9500\u91d1\u989d\u4e0d\u7b49\u4e8e\u6838\u9500\u91d1\u989d:" + amt);
            }
        }
        return orderPo;
    }
}

