/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignApprovalAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApprovalAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApprovalAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignApprovalBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApprovalBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApprovalBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscPushContractApproveAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyInvoiceCopyBillAbilityService;
import com.tydic.fsc.common.ability.api.FscPushUnifyPayBillAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcSignAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyInvoiceBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncPushYcSignAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignApprovalAbilityService"})
public class FscBillOrderInvoiceSignApprovalAbilityServiceImpl
implements FscBillOrderInvoiceSignApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignApprovalAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscBillOrderInvoiceSignApprovalBusiService fscBillOrderInvoiceSignApprovalBusiService;
    @Autowired
    private FscSyncPushYcSignAbilityService fscSyncPushYcSignAbilityService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TOPIC:FSC_SIGN_BACK_FILL_INVOICE_TOPIC}")
    private String fscSignBackFillInvoiceTopic;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TAG:FSC_SIGN_BACK_FILL_INVOICE_TAG}")
    private String fscSignBackFillInvoiceTag;
    @Resource(name="fscSignBackFillInvoiceMqServiceProvider")
    private ProxyMessageProducer fscSignBackFillInvoiceMqServiceProvider;
    @Autowired
    private FscPushUnifyInvoiceCopyBillAbilityService fscPushUnifyInvoiceCopyBillAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPushUnifyPayBillAbilityService fscPushUnifyPayBillAbilityService;
    private static final Integer IN = 1;
    private static final Integer OUT = 2;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRefundPayItemMapper fscRefundPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscPushContractApproveAbilityService fscPushContractApproveAbilityService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSignApproval"})
    public FscBillOrderInvoiceSignApprovalAbilityRspBO dealOrderInvoiceSignApproval(@RequestBody FscBillOrderInvoiceSignApprovalAbilityReqBO reqBO) {
        FscBillOrderInvoiceSignApprovalAbilityRspBO abilityRspBO = new FscBillOrderInvoiceSignApprovalAbilityRspBO();
        this.val(reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        FscPushUnifyInvoiceBillAbilityReqBO reqBO2 = new FscPushUnifyInvoiceBillAbilityReqBO();
        reqBO2.setType("1");
        String errorInfo = "";
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            if (reqBO.getOrderId() != null) {
                FscBillOrderInvoiceSignApprovalBusiRspBO rspBO = this.signBusi(reqBO);
                errorInfo = rspBO.getResult();
                this.sendMq(reqBO.getOrderId());
                if (rspBO.getAuditResult().booleanValue() && rspBO.getFinish().booleanValue()) {
                    this.sendPushMq(reqBO.getOrderId());
                }
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(reqBO.getOrderId());
                fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
                reqBO2.setFscOrderId(reqBO.getOrderId());
                reqBO2.setIsPayPushNYC(rspBO.getIsPayPushNYC());
                reqBO2.setFscPayOrderId(rspBO.getFscPayOrderId());
                try {
                    if (fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 && Objects.nonNull(rspBO.getTradeMode()) && rspBO.getTradeMode() == 2 && rspBO.getAuditResult().booleanValue() && rspBO.getFinish().booleanValue()) {
                        this.fscPushUnifyInvoiceCopyBillAbilityService.dealPushUnifyInvoiceBillCopy(reqBO2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (Long orderId : reqBO.getOrderIds()) {
                reqBO.setOrderId(orderId);
                FscBillOrderInvoiceSignApprovalBusiRspBO rspBO = this.signBusi(reqBO);
                errorInfo = errorInfo + rspBO.getResult();
                this.sendMq(orderId);
                if (rspBO.getAuditResult().booleanValue() && rspBO.getFinish().booleanValue()) {
                    this.sendPushMq(reqBO.getOrderId());
                }
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(orderId);
                fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
                reqBO2.setFscOrderId(orderId);
                reqBO2.setIsPayPushNYC(rspBO.getIsPayPushNYC());
                reqBO2.setFscPayOrderId(rspBO.getFscPayOrderId());
                try {
                    if (fscOrderPO.getSettlePlatform() == null || fscOrderPO.getSettlePlatform() != 2 || !Objects.nonNull(rspBO.getTradeMode()) || rspBO.getTradeMode() != 2 || !rspBO.getAuditResult().booleanValue() || !rspBO.getFinish().booleanValue()) continue;
                    this.fscPushUnifyInvoiceCopyBillAbilityService.dealPushUnifyInvoiceBillCopy(reqBO2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errorInfo)) {
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(errorInfo);
            return abilityRspBO;
        }
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        return abilityRspBO;
    }

    private FscBillOrderInvoiceSignApprovalBusiRspBO signBusi(FscBillOrderInvoiceSignApprovalAbilityReqBO reqBO) {
        String result = "";
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (fscOrderPO.getSignStation() == null) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u5ba1\u6279\u6743\u9650\u5f02\u5e38");
        }
        if (FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform()) && FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191124", "\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u7684\u5355\u636e\u8bf7\u5728\u8d22\u52a1\u5171\u4eab\u5ba1\u6279\u83dc\u5355\u8fdb\u884c\u5ba1\u6279\uff01");
        }
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList(), reqBO.getUserId());
        if (count == 0 || CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        if (!FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO = (FscBillOrderInvoiceSignApprovalBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignApprovalBusiReqBO.class));
        fscBillOrderInvoiceSignApprovalBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.dealOrderCheck(fscBillOrderInvoiceSignApprovalBusiReqBO, fscOrderPO);
        }
        BigDecimal payAmount = BigDecimal.ZERO;
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setSettleId(reqBO.getOrderId());
        List list = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            FscOrderPO settltFscOrderPO = new FscOrderPO();
            settltFscOrderPO.setFscOrderId(((FscOrderPayItemPO)list.get(0)).getFscOrderId());
            settltFscOrderPO = this.fscOrderMapper.getModelBy(settltFscOrderPO);
            payAmount = settltFscOrderPO.getTotalCharge();
        }
        fscBillOrderInvoiceSignApprovalBusiReqBO.setPayAmount(payAmount);
        FscBillOrderInvoiceSignApprovalBusiRspBO fscBillOrderInvoiceSignApprovalBusiRspBO = this.fscBillOrderInvoiceSignApprovalBusiService.invoiceSignApproval(fscBillOrderInvoiceSignApprovalBusiReqBO);
        if (!"0000".equals(fscBillOrderInvoiceSignApprovalBusiRspBO.getRespCode())) {
            result = result + ERROR_MSG_TITLE_BEGIN + fscOrderPO.getOrderNo() + "\u5ba1\u6279\u5931\u8d25\uff0c" + fscBillOrderInvoiceSignApprovalBusiRspBO.getRespDesc() + ";";
        }
        if ("0000".equals(fscBillOrderInvoiceSignApprovalBusiRspBO.getRespCode()) && !fscBillOrderInvoiceSignApprovalBusiRspBO.getFinish().booleanValue()) {
            this.syncSendNotice(reqBO.getOrderId(), reqBO.getUserId());
        }
        if (!CollectionUtils.isEmpty(fscBillOrderInvoiceSignApprovalBusiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            abilityReqBO.setApproveEntrustType(Integer.valueOf(2));
            abilityReqBO.setAuditNoticeList(fscBillOrderInvoiceSignApprovalBusiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
        }
        if ("0000".equals(fscBillOrderInvoiceSignApprovalBusiRspBO.getRespCode()) && fscBillOrderInvoiceSignApprovalBusiRspBO.getFinish().booleanValue()) {
            log.info("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3-------");
            CompletableFuture.runAsync(() -> {
                try {
                    FscPushContractAbilityReqBO fscPushContractAbilityReqBO = new FscPushContractAbilityReqBO();
                    fscPushContractAbilityReqBO.setFscOrderId(reqBO.getOrderId());
                    FscPushContractAbilityRspBO abilityRspBO = this.fscPushContractApproveAbilityService.pushContract(fscPushContractAbilityReqBO);
                    if (Objects.nonNull(abilityRspBO) && "0000".equals(abilityRspBO.getRespCode())) {
                        log.error("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + abilityRspBO.getRespDesc());
                    }
                }
                catch (Exception exception) {
                    log.error("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + exception);
                }
            });
        }
        fscBillOrderInvoiceSignApprovalBusiRspBO.setResult(result);
        fscBillOrderInvoiceSignApprovalBusiRspBO.setTradeMode(fscOrderPO.getTradeMode());
        return fscBillOrderInvoiceSignApprovalBusiRspBO;
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(TOTAL_AMOUNT_EX_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, TOTAL_AMOUNT_EX_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(TAX_AMOUNT_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, TAX_AMOUNT_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.ITEM.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
                errorMsg.append(seq);
                errorMsg.append("\u3001\u8fdb\u9879\u53d1\u7968\u660e\u7ec6\u603b\u8ba1\u6709" + invoiceCmpResultBO.getPoolCmpResultNum() + "\u9879\u65e0\u6cd5\u5339\u914d\uff1b<br>");
                ++seq;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscBillOrderInvoiceSignApprovalAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId() && CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long orderId) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(orderId);
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        JSONObject object = new JSONObject();
        object.put("fscOrderId", (Object)orderId);
        ProxySendResult proxySendResult = this.fscSignBackFillInvoiceMqServiceProvider.send(new ProxyMessage(this.fscSignBackFillInvoiceTopic, this.fscSignBackFillInvoiceTag, JSONObject.toJSONString((Object)object)));
    }

    private void sendPushMq(Long orderId) {
        FscSyncPushYcSignAbilityReqBO syncPushYcSignAbilityReqBO = new FscSyncPushYcSignAbilityReqBO();
        syncPushYcSignAbilityReqBO.setFscOrderId(orderId);
        this.fscSyncPushYcSignAbilityService.syncPushYcSign(syncPushYcSignAbilityReqBO);
    }

    private void dealAccountRule(FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Set<String> orderCodeList, Set<String> orderOperList) {
        Optional<FscOrderInfoBO> max;
        if (fscOrderPO.getSettleType() != null && fscOrderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            return;
        }
        String billDateMax = this.fscInvoiceMapper.setInvoiceBillDate(fscOrderPO.getFscOrderId());
        if (fscOrderPO.getRefundId() != null) {
            fscBillOrderInvoiceSignApprovalBusiReqBO.setOrderCodeList(orderCodeList);
            fscBillOrderInvoiceSignApprovalBusiReqBO.setOrderOperList(orderOperList);
            FscOrderRefundPO refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(fscOrderPO.getRefundId());
            refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
            if (refundPO.getToPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                // empty if block
            }
            return;
        }
        String funcAccountId = null;
        String funcAccountName = null;
        FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
        fscOrderExtPO.setFscOrderId(fscOrderPO.getFscOrderId());
        FscOrderExtPO modelBy = this.fscOrderExtMapper.getModelBy(fscOrderExtPO);
        if (modelBy != null) {
            funcAccountId = modelBy.getFuncAccountId();
            funcAccountName = modelBy.getFuncAccountName();
        }
        if (!(max = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime))).isPresent()) {
            throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
        }
        FscOrderInfoBO fscOrderInfoBO = max.get();
        if (null == fscOrderInfoBO) {
            throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            if ((fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER) || fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) && fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfoBO.setPayBreakScale(fscOrderInfoBO.getProPayBreakScale());
                fscOrderInfoBO.setModelContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderInfoBO.setModelContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
                fscOrderInfoBO.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
                fscOrderInfoBO.setPayRule(fscOrderInfoBO.getProPayRule());
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = this.buildShouldPayInfo(fscOrderPO, fscOrderInfoBO, billDateMax);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                if (fscOrderPO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD)) {
                    fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource(), billDateMax, fscOrderPO.getReceiveType()));
                }
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
                fscShouldPayBO.setFuncAccountId(funcAccountId);
                fscShouldPayBO.setFuncAccountName(funcAccountName);
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignApprovalBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignApprovalBusiReqBO.setCreateShouldPayFlag(true);
            }
        } else if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(fscOrderPO.getPayType())) {
            if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayList(fscOrderInfoBO.getProPayList());
            }
            boolean flag = false;
            ArrayList<FscPhasePayListBO> payListBOS = new ArrayList<FscPhasePayListBO>();
            if (CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                return;
            }
            for (FscPhasePayListBO payListBO : fscOrderInfoBO.getPayList()) {
                if (payListBO.getPayNode() != 4 || payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) <= 0) continue;
                payListBOS.add(payListBO);
                flag = true;
            }
            if (flag) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                for (FscPhasePayListBO fscPhasePayListBO : payListBOS) {
                    FscShouldPayBO fscShouldPayBO = this.buildShouldPayInfo(fscOrderPO, fscOrderInfoBO, billDateMax);
                    fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge().multiply(fscPhasePayListBO.getNodePayRatio()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                    fscShouldPayBO.setShouldPayDate(this.calShouldPayDateNew(fscPhasePayListBO.getNodePayCycle(), billDateMax));
                    fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                    fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                    fscShouldPayBO.setShouldPayMethod(fscPhasePayListBO.getPayType());
                    fscShouldPayBO.setPayConfId(fscPhasePayListBO.getId());
                    fscShouldPayBO.setNodePayRatio(fscPhasePayListBO.getNodePayRatio());
                    fscShouldPayBO.setFuncAccountId(funcAccountId);
                    fscShouldPayBO.setFuncAccountName(funcAccountName);
                    fscShouldPayBOS.add(fscShouldPayBO);
                }
                fscBillOrderInvoiceSignApprovalBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignApprovalBusiReqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private FscShouldPayBO buildShouldPayInfo(FscOrderPO fscOrderPO, FscOrderInfoBO fscOrderInfoBO, String billDateMax) {
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        fscShouldPayBO.setPayType(fscOrderPO.getPayType());
        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
        fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
        fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
        fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
        fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
        fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
        fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
        fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
        fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
        fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
        fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
        fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
        fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
        fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
        fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
        fscShouldPayBO.setSettlePlatform(fscOrderPO.getSettlePlatform());
        FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setInvoiceNo(signTemp.getInvoiceNo());
        fscShouldPayBO.setBillDate(billDateMax);
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
            fscShouldPayBO.setProContractSource(((FscOrderRelationPO)relationPOList.get(0)).getProContractSource());
            fscShouldPayBO.setProContractId(((FscOrderRelationPO)relationPOList.get(0)).getProContractId());
            fscShouldPayBO.setProContractNo(((FscOrderRelationPO)relationPOList.get(0)).getProContractNo());
            fscShouldPayBO.setProContractName(((FscOrderRelationPO)relationPOList.get(0)).getProContractName());
            fscShouldPayBO.setProContractType(((FscOrderRelationPO)relationPOList.get(0)).getProContractType());
        }
        return fscShouldPayBO;
    }

    private void createReopenShouldPay(FscOrderPO fscOrderPO, FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, Set<String> orderCodeList, Set<String> orderOperList, String billDateMax) {
        List shouldPayPOList = this.fscShouldPayMapper.getReopenShouldPay(fscOrderPO.getRefundId());
        FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscOrderPO.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
            for (FscShouldPayPO shouldPayPO : shouldPayPOList) {
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                BeanUtils.copyProperties((Object)shouldPayPO, (Object)fscShouldPayBO);
                fscShouldPayBO.setShouldPayAmount(shouldPayPO.getRefundAmount());
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                fscShouldPayBO.setShouldPayMethod(shouldPayPO.getPayMethod());
                fscShouldPayBO.setInvoiceNo(signTemp.getInvoiceNo());
                fscShouldPayBO.setBillDate(billDateMax);
                fscShouldPayBOS.add(fscShouldPayBO);
            }
            fscBillOrderInvoiceSignApprovalBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscBillOrderInvoiceSignApprovalBusiReqBO.setCreateShouldPayFlag(true);
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource, String billDateMax, Integer receiveType) {
        Calendar now = Calendar.getInstance();
        Boolean flag = FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource) && FscConstants.FscOrderReceiveType.OPERATION.equals(receiveType);
        if (StringUtils.isNotBlank((CharSequence)billDateMax) && !flag.booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private Date calShouldPayDateNew(String nodePayCycle, String billDateMax) {
        Integer payDays = 0;
        payDays = StringUtils.isEmpty((CharSequence)nodePayCycle) || nodePayCycle.equals("null") ? Integer.valueOf(0) : Integer.valueOf(nodePayCycle);
        Calendar now = Calendar.getInstance();
        if (StringUtils.isNotBlank((CharSequence)billDateMax)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        now.add(5, payDays);
        return now.getTime();
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        Boolean categoryFlag = FscConstants.FscInvoiceCategory.FULL.equals(invoiceCmpResultBO.getInvoiceCategory());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
    }

    private void dealStockFlag(FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscBillOrderInvoiceSignApprovalBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignApprovalBusiReqBO.setStockFlag(IN);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            fscBillOrderInvoiceSignApprovalBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignApprovalBusiReqBO.setStockFlag(OUT);
        }
    }

    private void dealOrderCheck(FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap();
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignApprovalBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscAcceptOrderListQueryAtomRspBO.getOrderCodeList(), fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignApprovalBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscSaleOrderListQueryAtomRspBO.getOrderCodeList(), fscSaleOrderListQueryAtomRspBO.getOrderOperList());
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            this.checkProSign(fscOrderInfoBoMap);
        }
    }

    private void checkProSign(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap) {
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfoBO) -> fscOrderInfoBO.getFscRelInfoBos().forEach(fscProFscRelInfoBo -> {
            if (FscConstants.FscRelType.PRO_INVOICE.equals(fscProFscRelInfoBo.getRelType()) && !FscConstants.FscRelStatus.SIGN.equals(fscProFscRelInfoBo.getRelState())) {
                throw new FscBusinessException("191019", "\u4e0a\u6e38\u7ed3\u7b97\u5355\u53d1\u7968\u672a\u7b7e\u6536\uff0c\u4e0b\u6e38\u4e0d\u5141\u8bb8\u7b7e\u6536");
            }
        }));
    }

    private void syncSendNotice(Long fscOrderId, Long userId) {
        FscSyncSendNotificationReqBO reqBO = new FscSyncSendNotificationReqBO();
        reqBO.setUserId(userId);
        reqBO.setObjId(fscOrderId);
        reqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.PUR_WAIT_AUDIT);
        this.fscSyncSendNotificationService.syncSendNotification(reqBO);
    }
}

